/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.ErrorEstimate;
import visad.Real;
import visad.RealType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryRealType;
import visad.data.visad.object.BinaryUnit;

public class BinaryReal
implements BinaryObject {
    public static final int computeBytes(Unit unit, ErrorEstimate errorEstimate) {
        return 18 + (unit == null ? 0 : 5) + (errorEstimate == null ? 0 : 5) + 1;
    }

    public static final Real read(BinaryReader binaryReader) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getErrorEstimateCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        BinaryObjectCache binaryObjectCache3 = binaryReader.getUnitCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        RealType realType = (RealType)binaryObjectCache2.get(n);
        double d = dataInput.readDouble();
        Unit unit = null;
        ErrorEstimate errorEstimate = null;
        boolean bl = true;
        while (bl) {
            byte by;
            try {
                by = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (by) {
                case 30: {
                    int n2 = dataInput.readInt();
                    unit = (Unit)binaryObjectCache3.get(n2);
                    break;
                }
                case 31: {
                    int n3 = dataInput.readInt();
                    errorEstimate = (ErrorEstimate)binaryObjectCache.get(n3);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown Real directive " + by);
                }
            }
        }
        return new Real(realType, d, unit, errorEstimate);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, RealType realType, Unit unit, ErrorEstimate errorEstimate, Real real, Object object) throws IOException {
        BinaryRealType.write(binaryWriter, realType, BinaryObject.SAVE_DATA);
        if (unit != null) {
            BinaryUnit.write(binaryWriter, unit, BinaryObject.SAVE_DATA);
        }
        if (errorEstimate != null) {
            BinaryErrorEstimate.write(binaryWriter, errorEstimate, BinaryObject.SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter binaryWriter, RealType realType, double d, Unit unit, ErrorEstimate errorEstimate, Real real, Object object) throws IOException {
        BinaryReal.writeDependentData(binaryWriter, realType, unit, errorEstimate, real, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        int n = BinaryRealType.write(binaryWriter, realType, object);
        int n2 = -1;
        if (unit != null) {
            n2 = BinaryUnit.write(binaryWriter, unit, object);
        }
        int n3 = -1;
        if (errorEstimate != null) {
            n3 = BinaryErrorEstimate.write(binaryWriter, errorEstimate, object);
        }
        int n4 = BinaryReal.computeBytes(unit, errorEstimate);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeByte(3);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeDouble(d);
        if (n2 >= 0) {
            dataOutputStream.writeByte(30);
            dataOutputStream.writeInt(n2);
        }
        if (n3 >= 0) {
            dataOutputStream.writeByte(31);
            dataOutputStream.writeInt(n3);
        }
        dataOutputStream.writeByte(80);
    }
}

