/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.MathType;
import visad.ProductSet;
import visad.SampledSet;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySampledSet;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryProductSet
implements BinaryObject {
    private static /* synthetic */ Class class$Lvisad$ProductSet;

    public static final int computeBytes(SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) {
        int n = BinaryUnit.computeBytes(unitArray);
        int n2 = BinaryErrorEstimate.computeBytes(errorEstimateArray);
        return 10 + BinarySampledSet.computeBytes(sampledSetArray) + (coordinateSystem == null ? 0 : 5) + (n == 0 ? 0 : n + 1) + (n2 == 0 ? 0 : n2 + 1) + 1;
    }

    public static final ProductSet read(BinaryReader binaryReader) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        SetType setType = (SetType)binaryObjectCache2.get(n);
        SampledSet[] sampledSetArray = null;
        CoordinateSystem coordinateSystem = null;
        Unit[] unitArray = null;
        ErrorEstimate[] errorEstimateArray = null;
        boolean bl = true;
        while (bl) {
            byte by;
            try {
                by = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (by) {
                case 11: {
                    sampledSetArray = BinarySampledSet.readList(binaryReader);
                    break;
                }
                case 32: {
                    int n2 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n2);
                    break;
                }
                case 40: {
                    unitArray = BinaryUnit.readList(binaryReader);
                    break;
                }
                case 41: {
                    errorEstimateArray = BinaryErrorEstimate.readList(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown ProductSet directive " + by);
                }
            }
        }
        if (setType == null) {
            throw new IOException("No SetType found for ProductSet");
        }
        if (sampledSetArray == null) {
            throw new IOException("No sets found for ProductSet");
        }
        return new ProductSet((MathType)setType, sampledSetArray, coordinateSystem, unitArray, errorEstimateArray);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, SetType setType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, ProductSet productSet, Object object) throws IOException {
        if (!(productSet.getClass().equals(class$Lvisad$ProductSet != null ? class$Lvisad$ProductSet : (class$Lvisad$ProductSet = BinaryProductSet.class$("visad.ProductSet"))) || productSet instanceof ProductSet && productSet instanceof Saveable)) {
            return;
        }
        Object object2 = object == BinaryObject.SAVE_DEPEND_BIG ? object : BinaryObject.SAVE_DEPEND;
        BinarySetType.write(binaryWriter, setType, productSet, BinaryObject.SAVE_DATA);
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (unitArray != null) {
            BinaryUnit.writeList(binaryWriter, unitArray, BinaryObject.SAVE_DATA);
        }
        if (errorEstimateArray != null) {
            BinaryErrorEstimate.writeList(binaryWriter, errorEstimateArray, BinaryObject.SAVE_DATA);
        }
        if (sampledSetArray != null) {
            int n = 0;
            while (n < sampledSetArray.length) {
                BinaryGeneric.write(binaryWriter, sampledSetArray[n], object2);
                ++n;
            }
        }
    }

    public static final void write(BinaryWriter binaryWriter, SetType setType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, ProductSet productSet, Object object) throws IOException {
        BinaryProductSet.writeDependentData(binaryWriter, setType, sampledSetArray, coordinateSystem, unitArray, errorEstimateArray, productSet, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(productSet.getClass().equals(class$Lvisad$ProductSet != null ? class$Lvisad$ProductSet : (class$Lvisad$ProductSet = BinaryProductSet.class$("visad.ProductSet"))) || productSet instanceof ProductSet && productSet instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, productSet, object);
            return;
        }
        int n = binaryWriter.getTypeCache().getIndex(setType);
        if (n < 0) {
            throw new IOException("SetType " + setType + " not cached");
        }
        int n2 = -1;
        if (coordinateSystem != null && (n2 = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        int[] nArray = null;
        if (unitArray != null) {
            nArray = BinaryUnit.lookupList(binaryWriter.getUnitCache(), unitArray);
        }
        int[] nArray2 = null;
        if (errorEstimateArray != null) {
            nArray2 = BinaryErrorEstimate.lookupList(binaryWriter.getErrorEstimateCache(), errorEstimateArray);
        }
        int n3 = BinaryProductSet.computeBytes(sampledSetArray, coordinateSystem, unitArray, errorEstimateArray);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeByte(38);
        dataOutputStream.writeInt(n);
        BinarySampledSet.writeList(binaryWriter, sampledSetArray, object);
        if (n2 >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n2);
        }
        if (nArray != null) {
            dataOutputStream.writeByte(40);
            BinaryIntegerArray.write(binaryWriter, nArray, object);
        }
        if (nArray2 != null) {
            dataOutputStream.writeByte(41);
            BinaryIntegerArray.write(binaryWriter, nArray2, object);
        }
        dataOutputStream.writeByte(80);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

