/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.IOException;
import visad.FunctionType;
import visad.MathType;
import visad.ScalarType;
import visad.SetType;
import visad.TupleType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryFunctionType;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryQuantity;
import visad.data.visad.object.BinaryRealTupleType;
import visad.data.visad.object.BinaryRealType;
import visad.data.visad.object.BinaryScalarType;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryTextType;
import visad.data.visad.object.BinaryTupleType;

public class BinaryMathType
implements BinaryObject {
    public static final MathType read(BinaryReader binaryReader) throws IOException, VisADException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        byte by = dataInput.readByte();
        switch (by) {
            case 1: {
                return BinaryFunctionType.read(binaryReader, n2);
            }
            case 7: {
                return BinaryQuantity.read(binaryReader, n2);
            }
            case 3: {
                return BinaryRealTupleType.read(binaryReader, n2);
            }
            case 2: {
                return BinaryRealType.read(binaryReader, n2);
            }
            case 4: {
                return BinarySetType.read(binaryReader, n2);
            }
            case 5: {
                return BinaryTextType.read(binaryReader, n2);
            }
            case 6: {
                return BinaryTupleType.read(binaryReader, n2, n - 5);
            }
        }
        throw new VisADException("Unknown Math type " + by);
    }

    public static final MathType[] readList(BinaryReader binaryReader, int n) throws IOException, VisADException {
        if (n < 1) {
            throw new IOException("Corrupted file (bad MathType list length)");
        }
        BinaryObjectCache binaryObjectCache = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        MathType[] mathTypeArray = new MathType[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readInt();
            mathTypeArray[n2] = (MathType)binaryObjectCache.get(n3);
            ++n2;
        }
        return mathTypeArray;
    }

    public static final int write(BinaryWriter binaryWriter, MathType mathType, Object object) throws IOException {
        int n;
        if (mathType instanceof FunctionType) {
            n = BinaryFunctionType.write(binaryWriter, (FunctionType)mathType, object);
        } else if (mathType instanceof ScalarType) {
            n = BinaryScalarType.write(binaryWriter, (ScalarType)mathType, object);
        } else if (mathType instanceof SetType) {
            n = BinarySetType.write(binaryWriter, (SetType)mathType, null, object);
        } else if (mathType instanceof TupleType) {
            n = BinaryTupleType.write(binaryWriter, (TupleType)mathType, object);
        } else {
            BinaryObjectCache binaryObjectCache = binaryWriter.getTypeCache();
            n = binaryObjectCache.getIndex(mathType);
            if (n < 0) {
                n = binaryObjectCache.add(mathType);
                if (n < 0) {
                    throw new IOException("Couldn't cache MathType " + mathType);
                }
                BinarySerializedObject.write(binaryWriter, (byte)6, mathType, object);
            }
        }
        return n;
    }
}

