/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.List1DSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryFloatArray;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryList1DSet
implements BinaryObject {
    private static /* synthetic */ Class class$Lvisad$List1DSet;

    public static final int computeBytes(float[] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray) {
        int n = BinaryUnit.computeBytes(unitArray);
        return 11 + BinaryFloatArray.computeBytes(fArray) + (coordinateSystem == null ? 0 : 5) + (n == 0 ? 0 : n + 1) + 1;
    }

    public static final List1DSet read(BinaryReader binaryReader) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        MathType mathType = (MathType)binaryObjectCache2.get(n);
        float[] fArray = null;
        CoordinateSystem coordinateSystem = null;
        Unit[] unitArray = null;
        boolean bl = true;
        while (bl) {
            byte by;
            try {
                by = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (by) {
                case 4: {
                    fArray = BinaryFloatArray.read(binaryReader);
                    break;
                }
                case 32: {
                    int n2 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n2);
                    break;
                }
                case 40: {
                    unitArray = BinaryUnit.readList(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown List1DSet directive " + by);
                }
            }
        }
        if (mathType == null) {
            throw new IOException("No MathType found for List1DSet");
        }
        if (fArray == null) {
            throw new IOException("No list found for List1DSet");
        }
        return new List1DSet(fArray, mathType, coordinateSystem, unitArray);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, SetType setType, CoordinateSystem coordinateSystem, Unit[] unitArray, List1DSet list1DSet, Object object) throws IOException {
        if (!(list1DSet.getClass().equals(class$Lvisad$List1DSet != null ? class$Lvisad$List1DSet : (class$Lvisad$List1DSet = BinaryList1DSet.class$("visad.List1DSet"))) || list1DSet instanceof List1DSet && list1DSet instanceof Saveable)) {
            return;
        }
        BinarySetType.write(binaryWriter, setType, list1DSet, BinaryObject.SAVE_DATA);
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (unitArray != null) {
            BinaryUnit.writeList(binaryWriter, unitArray, BinaryObject.SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter binaryWriter, SetType setType, float[] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, List1DSet list1DSet, Object object) throws IOException {
        BinaryList1DSet.writeDependentData(binaryWriter, setType, coordinateSystem, unitArray, list1DSet, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(list1DSet.getClass().equals(class$Lvisad$List1DSet != null ? class$Lvisad$List1DSet : (class$Lvisad$List1DSet = BinaryList1DSet.class$("visad.List1DSet"))) || list1DSet instanceof List1DSet && list1DSet instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, list1DSet, object);
            return;
        }
        if (fArray == null) {
            throw new IOException("Null List1DSet list");
        }
        int n = binaryWriter.getTypeCache().getIndex(setType);
        if (n < 0) {
            throw new IOException("SetType " + setType + " not cached");
        }
        int n2 = -1;
        if (coordinateSystem != null && (n2 = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        int[] nArray = null;
        if (unitArray != null) {
            nArray = BinaryUnit.lookupList(binaryWriter.getUnitCache(), unitArray);
        }
        int n3 = BinaryList1DSet.computeBytes(fArray, coordinateSystem, unitArray);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeByte(34);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeByte(4);
        BinaryFloatArray.write(binaryWriter, fArray, object);
        if (n2 >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n2);
        }
        if (nArray != null) {
            dataOutputStream.writeByte(40);
            BinaryIntegerArray.write(binaryWriter, nArray, object);
        }
        dataOutputStream.writeByte(80);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

