/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDoubleArray;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryLinearSet
implements BinaryObject {
    public static final int computeBytes(boolean bl, double[] dArray, double[] dArray2, int[] nArray, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) {
        int n;
        int n2;
        int n3;
        if (bl) {
            n3 = 1 + BinaryDoubleArray.computeBytes(dArray) + 1 + BinaryDoubleArray.computeBytes(dArray2) + 1 + BinaryIntegerArray.computeBytes(nArray);
        } else {
            n3 = 5;
            n2 = 0;
            while (n2 < linear1DSetArray.length) {
                n = BinaryGeneric.computeBytes(linear1DSetArray[n2]);
                if (n < 0) {
                    return -1;
                }
                n3 += n;
                ++n2;
            }
        }
        n2 = BinaryUnit.computeBytes(unitArray);
        n = BinaryErrorEstimate.computeBytes(errorEstimateArray);
        return 10 + n3 + (coordinateSystem == null ? 0 : 5) + (n2 == 0 ? 0 : n2 + 1) + (n == 0 ? 0 : n + 1) + 1;
    }

    public static boolean hasMatchedTypes(SetType setType, Linear1DSet[] linear1DSetArray) {
        if (linear1DSetArray == null) {
            return true;
        }
        MathType[] mathTypeArray = setType.getDomain().getComponents();
        if (mathTypeArray == null || mathTypeArray.length != linear1DSetArray.length) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < mathTypeArray.length) {
            if (!mathTypeArray[n].equals(linear1DSetArray[n].getType())) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    private static final Linear1DSet[] readLinear1DSets(BinaryReader binaryReader) throws IOException, VisADException {
        DataInput dataInput = binaryReader.getInput();
        Linear1DSet[] linear1DSetArray = new Linear1DSet[dataInput.readInt()];
        int n = 0;
        while (n < linear1DSetArray.length) {
            linear1DSetArray[n] = (Linear1DSet)BinaryGeneric.read(binaryReader);
            ++n;
        }
        return linear1DSetArray;
    }

    public static final GriddedSet read(BinaryReader binaryReader, byte by) throws IOException, VisADException {
        int n;
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n2 = dataInput.readInt();
        SetType setType = (SetType)binaryObjectCache2.get(n2);
        double[] dArray = null;
        double[] dArray2 = null;
        int[] nArray = null;
        CoordinateSystem coordinateSystem = null;
        Unit[] unitArray = null;
        ErrorEstimate[] errorEstimateArray = null;
        Linear1DSet[] linear1DSetArray = null;
        boolean bl = true;
        while (bl) {
            try {
                n = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (n) {
                case 1: {
                    dArray = BinaryDoubleArray.read(binaryReader);
                    break;
                }
                case 2: {
                    dArray2 = BinaryDoubleArray.read(binaryReader);
                    break;
                }
                case 3: {
                    nArray = BinaryIntegerArray.read(binaryReader);
                    break;
                }
                case 13: {
                    linear1DSetArray = BinaryLinearSet.readLinear1DSets(binaryReader);
                    break;
                }
                case 32: {
                    int n3 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n3);
                    break;
                }
                case 40: {
                    unitArray = BinaryUnit.readList(binaryReader);
                    break;
                }
                case 41: {
                    errorEstimateArray = BinaryErrorEstimate.readList(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown LinearSet directive " + n);
                }
            }
        }
        if (setType == null) {
            throw new IOException("No SetType found for LinearSet");
        }
        if (linear1DSetArray != null) {
            if (dArray != null) {
                throw new IOException("Both components and firsts found for LinearSet");
            }
            if (dArray2 != null) {
                throw new IOException("Both components and lasts found for LinearSet");
            }
            if (nArray != null) {
                throw new IOException("Both components and lengths found for LinearSet");
            }
            switch (by) {
                case 50: {
                    throw new IOException("Components specified for Linear1DSet");
                }
                case 51: {
                    return new Linear2DSet((MathType)setType, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
                }
                case 52: {
                    return new Linear3DSet((MathType)setType, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
                }
                case 53: {
                    return new LinearNDSet((MathType)setType, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
                }
                case 54: {
                    return new LinearLatLonSet((MathType)setType, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
                }
            }
            throw new IOException("Unknown LinearSet type " + by);
        }
        if (dArray == null) {
            throw new IOException("No firsts found for LinearSet");
        }
        if (dArray2 == null) {
            throw new IOException("No lasts found for LinearSet");
        }
        if (nArray == null) {
            throw new IOException("No lengths found for LinearSet");
        }
        switch (by) {
            case 50: {
                n = 1;
                break;
            }
            case 51: {
                n = 2;
                break;
            }
            case 52: {
                n = 3;
                break;
            }
            case 54: {
                n = 2;
                break;
            }
            default: {
                n = -1;
                break;
            }
        }
        if (n > 0 && dArray.length != n) {
            throw new VisADException("Expected " + n + " first value" + (n > 1 ? "s" : "") + ", not " + dArray.length);
        }
        if (n > 0 && dArray2.length != n) {
            throw new VisADException("Expected " + n + " last value" + (n > 1 ? "s" : "") + ", not " + dArray2.length);
        }
        if (n > 0 && nArray.length != n) {
            throw new VisADException("Expected " + n + " length" + (n > 1 ? "s" : "") + ", not " + nArray.length);
        }
        switch (by) {
            case 50: {
                return new Linear1DSet((MathType)setType, dArray[0], dArray2[0], nArray[0], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 51: {
                return new Linear2DSet(setType, dArray[0], dArray2[0], nArray[0], dArray[1], dArray2[1], nArray[1], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 52: {
                return new Linear3DSet(setType, dArray[0], dArray2[0], nArray[0], dArray[1], dArray2[1], nArray[1], dArray[2], dArray2[2], nArray[2], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 53: {
                return new LinearNDSet((MathType)setType, dArray, dArray2, nArray, coordinateSystem, unitArray, errorEstimateArray);
            }
            case 54: {
                return new LinearLatLonSet(setType, dArray[0], dArray2[0], nArray[0], dArray[1], dArray2[1], nArray[1], coordinateSystem, unitArray, errorEstimateArray);
            }
        }
        throw new IOException("Unknown LinearSet type " + by);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, SetType setType, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, GriddedSet griddedSet, Class clazz, Object object) throws IOException {
        if (!(griddedSet.getClass().equals(clazz) || griddedSet instanceof LinearSet && griddedSet instanceof Saveable)) {
            return;
        }
        Object object2 = object == BinaryObject.SAVE_DEPEND_BIG ? object : BinaryObject.SAVE_DEPEND;
        BinarySetType.write(binaryWriter, setType, griddedSet, BinaryObject.SAVE_DATA);
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (unitArray != null) {
            BinaryUnit.writeList(binaryWriter, unitArray, BinaryObject.SAVE_DATA);
        }
        if (errorEstimateArray != null) {
            BinaryErrorEstimate.writeList(binaryWriter, errorEstimateArray, BinaryObject.SAVE_DATA);
        }
        if (linear1DSetArray != null) {
            int n = 0;
            while (n < linear1DSetArray.length) {
                BinaryGeneric.write(binaryWriter, linear1DSetArray[n], object2);
                ++n;
            }
        }
    }

    public static final void write(BinaryWriter binaryWriter, SetType setType, double[] dArray, double[] dArray2, int[] nArray, Linear1DSet[] linear1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, GriddedSet griddedSet, Class clazz, byte by, Object object) throws IOException {
        int n;
        BinaryLinearSet.writeDependentData(binaryWriter, setType, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray, griddedSet, clazz, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(griddedSet.getClass().equals(clazz) || griddedSet instanceof LinearSet && griddedSet instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, griddedSet, object);
            return;
        }
        boolean bl = BinaryLinearSet.hasMatchedTypes(setType, linear1DSetArray);
        int n2 = griddedSet.getDimension();
        if (!bl) {
            if (by == 50) {
                throw new IOException("Components specified for Linear1DSet");
            }
            if (linear1DSetArray.length != n2) {
                throw new IOException("Expected " + n2 + " LinearSet component" + (n2 > 1 ? "s" : "") + ", not " + linear1DSetArray.length);
            }
        } else {
            if (dArray == null) {
                throw new IOException("Null " + clazz.getName() + " firsts");
            }
            if (dArray2 == null) {
                throw new IOException("Null " + clazz.getName() + " lasts");
            }
            if (nArray == null) {
                throw new IOException("Null " + clazz.getName() + " lengths");
            }
            if (dArray.length != n2) {
                throw new IOException("Expected " + n2 + " LinearSet first value" + (n2 > 1 ? "s" : "") + ", not " + dArray.length);
            }
            if (dArray2.length != n2) {
                throw new IOException("Expected " + n2 + " LinearSet last value" + (n2 > 1 ? "s" : "") + ", not " + dArray2.length);
            }
            if (nArray.length != n2) {
                throw new IOException("Expected " + n2 + " LinearSet length" + (n2 > 1 ? "s" : "") + ", not " + nArray.length);
            }
        }
        if ((n = binaryWriter.getTypeCache().getIndex(setType)) < 0) {
            throw new IOException("SetType " + setType + " not cached");
        }
        int n3 = -1;
        if (coordinateSystem != null && (n3 = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        int[] nArray2 = null;
        if (unitArray != null) {
            nArray2 = BinaryUnit.lookupList(binaryWriter.getUnitCache(), unitArray);
        }
        int[] nArray3 = null;
        if (errorEstimateArray != null) {
            nArray3 = BinaryErrorEstimate.lookupList(binaryWriter.getErrorEstimateCache(), errorEstimateArray);
        }
        int n4 = BinaryLinearSet.computeBytes(bl, dArray, dArray2, nArray, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeInt(n);
        if (bl) {
            dataOutputStream.writeByte(1);
            BinaryDoubleArray.write(binaryWriter, dArray, object);
            dataOutputStream.writeByte(2);
            BinaryDoubleArray.write(binaryWriter, dArray2, object);
            dataOutputStream.writeByte(3);
            BinaryIntegerArray.write(binaryWriter, nArray, object);
        } else {
            dataOutputStream.writeByte(13);
            dataOutputStream.writeInt(linear1DSetArray.length);
            int n5 = 0;
            while (n5 < linear1DSetArray.length) {
                BinaryGeneric.write(binaryWriter, linear1DSetArray[n5], object);
                ++n5;
            }
        }
        if (n3 >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n3);
        }
        if (nArray2 != null) {
            dataOutputStream.writeByte(40);
            BinaryIntegerArray.write(binaryWriter, nArray2, object);
        }
        if (nArray3 != null) {
            dataOutputStream.writeByte(41);
            BinaryIntegerArray.write(binaryWriter, nArray3, object);
        }
        dataOutputStream.writeByte(80);
    }
}

