/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.Delaunay;
import visad.ErrorEstimate;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDelaunay;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryFloatMatrix;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryIrregularSet
implements BinaryObject {
    public static final int computeBytes(float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay) {
        int n = BinaryUnit.computeBytes(unitArray);
        int n2 = BinaryErrorEstimate.computeBytes(errorEstimateArray);
        return 11 + BinaryFloatMatrix.computeBytes(fArray) + (coordinateSystem == null ? 0 : 5) + (n == 0 ? 0 : n + 1) + (n2 == 0 ? 0 : n2 + 1) + (delaunay == null ? 0 : BinaryDelaunay.computeBytes(delaunay)) + 1;
    }

    public static final IrregularSet read(BinaryReader binaryReader, byte by) throws IOException, VisADException {
        int n;
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n2 = dataInput.readInt();
        SetType setType = (SetType)binaryObjectCache2.get(n2);
        float[][] fArray = null;
        CoordinateSystem coordinateSystem = null;
        Unit[] unitArray = null;
        ErrorEstimate[] errorEstimateArray = null;
        Delaunay delaunay = null;
        boolean bl = true;
        while (bl) {
            try {
                n = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (n) {
                case 6: {
                    fArray = BinaryFloatMatrix.read(binaryReader);
                    break;
                }
                case 32: {
                    int n3 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n3);
                    break;
                }
                case 40: {
                    unitArray = BinaryUnit.readList(binaryReader);
                    break;
                }
                case 41: {
                    errorEstimateArray = BinaryErrorEstimate.readList(binaryReader);
                    break;
                }
                case 21: {
                    delaunay = (Delaunay)BinarySerializedObject.read(dataInput);
                    break;
                }
                case 60: {
                    delaunay = BinaryDelaunay.read(dataInput);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown IrregularSet directive " + n);
                }
            }
        }
        if (setType == null) {
            throw new IOException("No SetType found for IrregularSet");
        }
        switch (by) {
            case 40: {
                n = 1;
                break;
            }
            case 41: {
                n = 2;
                break;
            }
            case 42: {
                n = 3;
                break;
            }
            case 39: {
                n = -1;
                break;
            }
            default: {
                throw new IOException("Unknown IrregularSet type " + by);
            }
        }
        if (n > 0 && fArray.length != n) {
            throw new VisADException("Expected " + n + "D sample array, not " + fArray.length + "D");
        }
        if (by == 40 && delaunay != null) {
            System.err.println("Delaunay ignored for Irregular1DSet");
        }
        switch (by) {
            case 40: {
                return new Irregular1DSet((MathType)setType, fArray, coordinateSystem, unitArray, errorEstimateArray);
            }
            case 41: {
                return new Irregular2DSet(setType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay);
            }
            case 42: {
                return new Irregular3DSet(setType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay);
            }
            case 39: {
                return new IrregularSet(setType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay);
            }
        }
        throw new IOException("Unknown IrregularSet type " + by);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, SetType setType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, IrregularSet irregularSet, Class clazz, Object object) throws IOException {
        if (!(irregularSet.getClass().equals(clazz) || irregularSet instanceof IrregularSet && irregularSet instanceof Saveable)) {
            return;
        }
        BinarySetType.write(binaryWriter, setType, irregularSet, BinaryObject.SAVE_DATA);
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (unitArray != null) {
            BinaryUnit.writeList(binaryWriter, unitArray, BinaryObject.SAVE_DATA);
        }
        if (errorEstimateArray != null) {
            BinaryErrorEstimate.writeList(binaryWriter, errorEstimateArray, BinaryObject.SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter binaryWriter, SetType setType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, IrregularSet irregularSet, Class clazz, byte by, Object object) throws IOException {
        int n;
        BinaryIrregularSet.writeDependentData(binaryWriter, setType, coordinateSystem, unitArray, errorEstimateArray, irregularSet, clazz, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(irregularSet.getClass().equals(clazz) || irregularSet instanceof IrregularSet && irregularSet instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, irregularSet, object);
            return;
        }
        if (fArray == null) {
            throw new IOException("Null " + clazz.getName() + " samples");
        }
        switch (by) {
            case 40: {
                n = 1;
                break;
            }
            case 41: {
                n = 2;
                break;
            }
            case 42: {
                n = 3;
                break;
            }
            case 39: {
                n = -1;
                break;
            }
            default: {
                throw new IOException("Invalid type " + by);
            }
        }
        if (n > 0 && fArray.length != n) {
            throw new IOException("Expected " + n + " sample list" + (n > 1 ? "s" : "") + ", not " + fArray.length);
        }
        int n2 = binaryWriter.getTypeCache().getIndex(setType);
        if (n2 < 0) {
            throw new IOException("SetType " + setType + " not cached");
        }
        int n3 = -1;
        if (coordinateSystem != null && (n3 = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        int[] nArray = null;
        if (unitArray != null) {
            nArray = BinaryUnit.lookupList(binaryWriter.getUnitCache(), unitArray);
        }
        int[] nArray2 = null;
        if (errorEstimateArray != null) {
            nArray2 = BinaryErrorEstimate.lookupList(binaryWriter.getErrorEstimateCache(), errorEstimateArray);
        }
        int n4 = BinaryIrregularSet.computeBytes(fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeByte(6);
        BinaryFloatMatrix.write(binaryWriter, fArray, object);
        if (n3 >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n3);
        }
        if (nArray != null) {
            dataOutputStream.writeByte(40);
            BinaryIntegerArray.write(binaryWriter, nArray, object);
        }
        if (nArray2 != null) {
            dataOutputStream.writeByte(41);
            BinaryIntegerArray.write(binaryWriter, nArray2, object);
        }
        if (delaunay != null) {
            BinaryDelaunay.write(binaryWriter, delaunay, object);
        }
        dataOutputStream.writeByte(80);
    }
}

