/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.IntegerSet;
import visad.Linear1DSet;
import visad.LinearSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryIntegerSet
implements BinaryObject {
    public static final int computeBytes(boolean bl, int[] nArray, Integer1DSet[] integer1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) {
        int n;
        int n2;
        int n3;
        if (bl) {
            n3 = 1 + BinaryIntegerArray.computeBytes(nArray);
        } else {
            n3 = 5;
            n2 = 0;
            while (n2 < integer1DSetArray.length) {
                n = BinaryGeneric.computeBytes(integer1DSetArray[n2]);
                if (n < 0) {
                    n3 = -1;
                    break;
                }
                n3 += n;
                ++n2;
            }
        }
        if (n3 < 0) {
            return n3;
        }
        n2 = BinaryUnit.computeBytes(unitArray);
        n = BinaryErrorEstimate.computeBytes(errorEstimateArray);
        return 10 + n3 + (coordinateSystem == null ? 0 : 5) + (n2 == 0 ? 0 : n2 + 1) + (n == 0 ? 0 : n + 1) + 1;
    }

    public static final Integer1DSet[] getComponents(LinearSet linearSet) {
        int n = ((GriddedSet)((Object)linearSet)).getDimension();
        Integer1DSet[] integer1DSetArray = new Integer1DSet[n];
        int n2 = 0;
        while (n2 < n) {
            Linear1DSet linear1DSet = linearSet.getLinear1DComponent(n2);
            if (linear1DSet instanceof Integer1DSet) {
                integer1DSetArray[n2] = (Integer1DSet)linear1DSet;
            } else if (linear1DSet.getFirst() == 0.0) {
                try {
                    integer1DSetArray[n2] = new Integer1DSet(linear1DSet.getType(), linear1DSet.getLength(), linear1DSet.getCoordinateSystem(), linear1DSet.getSetUnits(), linear1DSet.getSetErrors());
                }
                catch (VisADException visADException) {
                    return null;
                }
            } else {
                System.err.println("Ignoring comp#" + n2 + ": " + linear1DSet);
                integer1DSetArray[n2] = null;
            }
            ++n2;
        }
        return integer1DSetArray;
    }

    public static boolean hasMatchedTypes(SetType setType, Integer1DSet[] integer1DSetArray) {
        if (integer1DSetArray == null) {
            return true;
        }
        MathType[] mathTypeArray = setType.getDomain().getComponents();
        if (mathTypeArray == null || mathTypeArray.length != integer1DSetArray.length) {
            return false;
        }
        boolean bl = true;
        int n = 0;
        while (n < mathTypeArray.length) {
            if (!mathTypeArray[n].equals(integer1DSetArray[n].getType())) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    private static final Integer1DSet[] readInteger1DSets(BinaryReader binaryReader) throws IOException, VisADException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        Integer1DSet[] integer1DSetArray = new Integer1DSet[n];
        int n2 = 0;
        while (n2 < n) {
            integer1DSetArray[n2] = (Integer1DSet)BinaryGeneric.read(binaryReader);
            ++n2;
        }
        return integer1DSetArray;
    }

    public static final GriddedSet read(BinaryReader binaryReader, byte by) throws IOException, VisADException {
        int n;
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n2 = dataInput.readInt();
        SetType setType = (SetType)binaryObjectCache2.get(n2);
        int[] nArray = null;
        CoordinateSystem coordinateSystem = null;
        Unit[] unitArray = null;
        ErrorEstimate[] errorEstimateArray = null;
        Integer1DSet[] integer1DSetArray = null;
        boolean bl = true;
        while (bl) {
            try {
                n = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (n) {
                case 3: {
                    nArray = BinaryIntegerArray.read(binaryReader);
                    break;
                }
                case 14: {
                    integer1DSetArray = BinaryIntegerSet.readInteger1DSets(binaryReader);
                    break;
                }
                case 32: {
                    int n3 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n3);
                    break;
                }
                case 40: {
                    unitArray = BinaryUnit.readList(binaryReader);
                    break;
                }
                case 41: {
                    errorEstimateArray = BinaryErrorEstimate.readList(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown IntegerSet directive " + n);
                }
            }
        }
        if (setType == null) {
            throw new IOException("No SetType found for IntegerSet");
        }
        if (integer1DSetArray != null) {
            if (nArray != null) {
                throw new IOException("Both components and lengths found for IntegerSet");
            }
            switch (by) {
                case 55: {
                    throw new IOException("Components specified for Integer1DSet");
                }
                case 56: {
                    return new Integer2DSet((MathType)setType, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
                }
                case 57: {
                    return new Integer3DSet((MathType)setType, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
                }
                case 58: {
                    return new IntegerNDSet((MathType)setType, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
                }
            }
            throw new IOException("Unknown IntegerSet type " + by);
        }
        if (nArray == null) {
            throw new IOException("No lengths found for IntegerSet");
        }
        switch (by) {
            case 55: {
                n = 1;
                break;
            }
            case 56: {
                n = 2;
                break;
            }
            case 57: {
                n = 3;
                break;
            }
            default: {
                n = -1;
                break;
            }
        }
        if (n > 0 && nArray.length != n) {
            throw new VisADException("Expected " + n + " length" + (n > 1 ? "s" : "") + ", not " + nArray.length);
        }
        switch (by) {
            case 55: {
                return new Integer1DSet(setType, nArray[0], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 56: {
                return new Integer2DSet((MathType)setType, nArray[0], nArray[1], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 57: {
                return new Integer3DSet((MathType)setType, nArray[0], nArray[1], nArray[2], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 58: {
                return new IntegerNDSet((MathType)setType, nArray, coordinateSystem, unitArray, errorEstimateArray);
            }
        }
        throw new IOException("Unknown IntegerSet type " + by);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, SetType setType, Integer1DSet[] integer1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, GriddedSet griddedSet, Class clazz, Object object) throws IOException {
        if (!(griddedSet.getClass().equals(clazz) || griddedSet instanceof IntegerSet && griddedSet instanceof Saveable)) {
            return;
        }
        Object object2 = object == BinaryObject.SAVE_DEPEND_BIG ? object : BinaryObject.SAVE_DEPEND;
        BinarySetType.write(binaryWriter, setType, griddedSet, BinaryObject.SAVE_DATA);
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (unitArray != null) {
            BinaryUnit.writeList(binaryWriter, unitArray, BinaryObject.SAVE_DATA);
        }
        if (errorEstimateArray != null) {
            BinaryErrorEstimate.writeList(binaryWriter, errorEstimateArray, BinaryObject.SAVE_DATA);
        }
        if (integer1DSetArray != null) {
            int n = 0;
            while (n < integer1DSetArray.length) {
                BinaryGeneric.write(binaryWriter, integer1DSetArray[n], object2);
                ++n;
            }
        }
    }

    public static final void write(BinaryWriter binaryWriter, SetType setType, int[] nArray, Integer1DSet[] integer1DSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, GriddedSet griddedSet, Class clazz, byte by, Object object) throws IOException {
        int n;
        BinaryIntegerSet.writeDependentData(binaryWriter, setType, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray, griddedSet, clazz, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(griddedSet.getClass().equals(clazz) || griddedSet instanceof IntegerSet && griddedSet instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, griddedSet, object);
            return;
        }
        boolean bl = BinaryIntegerSet.hasMatchedTypes(setType, integer1DSetArray);
        int n2 = griddedSet.getDimension();
        if (!bl) {
            if (by == 55) {
                throw new IOException("Components specified for Integer1DSet");
            }
            if (integer1DSetArray.length != n2) {
                throw new IOException("Expected " + n2 + " IntegerSet component" + (n2 > 1 ? "s" : "") + ", not " + integer1DSetArray.length);
            }
        } else {
            if (nArray == null) {
                throw new IOException("Null " + clazz.getName() + " lengths");
            }
            if (nArray.length != n2) {
                throw new IOException("Expected " + n2 + " IntegerSet length" + (n2 > 1 ? "s" : "") + ", not " + nArray.length);
            }
        }
        if ((n = binaryWriter.getTypeCache().getIndex(setType)) < 0) {
            throw new IOException("SetType " + setType + " not cached");
        }
        int n3 = -1;
        if (coordinateSystem != null && (n3 = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        int[] nArray2 = null;
        if (unitArray != null) {
            nArray2 = BinaryUnit.lookupList(binaryWriter.getUnitCache(), unitArray);
        }
        int[] nArray3 = null;
        if (errorEstimateArray != null) {
            nArray3 = BinaryErrorEstimate.lookupList(binaryWriter.getErrorEstimateCache(), errorEstimateArray);
        }
        int n4 = BinaryIntegerSet.computeBytes(bl, nArray, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeInt(n);
        if (bl) {
            dataOutputStream.writeByte(3);
            BinaryIntegerArray.write(binaryWriter, nArray, object);
        } else {
            dataOutputStream.writeByte(14);
            dataOutputStream.writeInt(integer1DSetArray.length);
            int n5 = 0;
            while (n5 < integer1DSetArray.length) {
                BinaryGeneric.write(binaryWriter, integer1DSetArray[n5], object);
                ++n5;
            }
        }
        if (n3 >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n3);
        }
        if (nArray2 != null) {
            dataOutputStream.writeByte(40);
            BinaryIntegerArray.write(binaryWriter, nArray2, object);
        }
        if (nArray3 != null) {
            dataOutputStream.writeByte(41);
            BinaryIntegerArray.write(binaryWriter, nArray3, object);
        }
        dataOutputStream.writeByte(80);
    }
}

