/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryIntegerArray
implements BinaryObject {
    public static final int computeBytes(int[] nArray) {
        return nArray == null ? 0 : 4 + nArray.length * 4;
    }

    public static final int computeBytes(Object[] objectArray) {
        if (objectArray != null) {
            boolean bl = true;
            int n = 0;
            while (n < objectArray.length) {
                if (objectArray[n] != null) {
                    bl = false;
                    break;
                }
                ++n;
            }
            if (bl) {
                objectArray = null;
            }
        }
        return objectArray == null ? 0 : 4 + objectArray.length * 4;
    }

    public static final int[] read(BinaryReader binaryReader) throws IOException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 1) {
            throw new IOException("Corrupted file (bad double array length " + n + ")");
        }
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = dataInput.readInt();
            ++n2;
        }
        return nArray;
    }

    public static final void write(BinaryWriter binaryWriter, int[] nArray, Object object) throws IOException {
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeInt(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            dataOutputStream.writeInt(nArray[n]);
            ++n;
        }
    }
}

