/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.ErrorEstimate;
import visad.Gridded1DSet;
import visad.Gridded2DSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.MathType;
import visad.SetType;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryFloatMatrix;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySetType;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryGriddedSet
implements BinaryObject {
    public static final int computeBytes(float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray) {
        int n = BinaryUnit.computeBytes(unitArray);
        int n2 = BinaryErrorEstimate.computeBytes(errorEstimateArray);
        return 11 + BinaryFloatMatrix.computeBytes(fArray) + 1 + BinaryIntegerArray.computeBytes(nArray) + (coordinateSystem == null ? 0 : 5) + (n == 0 ? 0 : n + 1) + (n2 == 0 ? 0 : n2 + 1) + 1;
    }

    public static final GriddedSet read(BinaryReader binaryReader, byte by) throws IOException, VisADException {
        int n;
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n2 = dataInput.readInt();
        SetType setType = (SetType)binaryObjectCache2.get(n2);
        float[][] fArray = null;
        int[] nArray = null;
        CoordinateSystem coordinateSystem = null;
        Unit[] unitArray = null;
        ErrorEstimate[] errorEstimateArray = null;
        boolean bl = true;
        while (bl) {
            try {
                n = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            switch (n) {
                case 6: {
                    fArray = BinaryFloatMatrix.read(binaryReader);
                    break;
                }
                case 3: {
                    nArray = BinaryIntegerArray.read(binaryReader);
                    break;
                }
                case 32: {
                    int n3 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n3);
                    break;
                }
                case 40: {
                    unitArray = BinaryUnit.readList(binaryReader);
                    break;
                }
                case 41: {
                    errorEstimateArray = BinaryErrorEstimate.readList(binaryReader);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown GriddedSet directive " + n);
                }
            }
        }
        if (setType == null) {
            throw new IOException("No SetType found for GriddedSet");
        }
        if (nArray == null) {
            throw new IOException("No lengths found for GriddedSet");
        }
        switch (by) {
            case 44: {
                n = 1;
                break;
            }
            case 45: {
                n = 2;
                break;
            }
            case 46: {
                n = 3;
                break;
            }
            case 43: {
                n = -1;
                break;
            }
            default: {
                throw new IOException("Unknown GriddedSet type " + by);
            }
        }
        if (fArray != null && n > 0 && fArray.length != n) {
            throw new VisADException("Expected " + n + "D sample array, not " + fArray.length + "D");
        }
        switch (by) {
            case 44: {
                return new Gridded1DSet((MathType)setType, fArray, nArray[0], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 45: {
                if (nArray.length == 1) {
                    return new Gridded2DSet((MathType)setType, fArray, nArray[0], coordinateSystem, unitArray, errorEstimateArray);
                }
                return new Gridded2DSet((MathType)setType, fArray, nArray[0], nArray[1], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 46: {
                if (nArray.length == 1) {
                    return new Gridded3DSet((MathType)setType, fArray, nArray[0], coordinateSystem, unitArray, errorEstimateArray);
                }
                if (nArray.length == 2) {
                    return new Gridded3DSet((MathType)setType, fArray, nArray[0], nArray[1], coordinateSystem, unitArray, errorEstimateArray);
                }
                return new Gridded3DSet((MathType)setType, fArray, nArray[0], nArray[1], nArray[2], coordinateSystem, unitArray, errorEstimateArray);
            }
            case 43: {
                return new GriddedSet(setType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray);
            }
        }
        throw new IOException("Unknown GriddedSet type " + by);
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, SetType setType, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, GriddedSet griddedSet, Class clazz, Object object) throws IOException {
        if (!(griddedSet.getClass().equals(clazz) || griddedSet instanceof GriddedSet && griddedSet instanceof Saveable)) {
            return;
        }
        BinarySetType.write(binaryWriter, setType, griddedSet, BinaryObject.SAVE_DATA);
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (unitArray != null) {
            BinaryUnit.writeList(binaryWriter, unitArray, BinaryObject.SAVE_DATA);
        }
        if (errorEstimateArray != null) {
            BinaryErrorEstimate.writeList(binaryWriter, errorEstimateArray, BinaryObject.SAVE_DATA);
        }
    }

    public static final void write(BinaryWriter binaryWriter, SetType setType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, GriddedSet griddedSet, Class clazz, byte by, Object object) throws IOException {
        int n;
        BinaryGriddedSet.writeDependentData(binaryWriter, setType, coordinateSystem, unitArray, errorEstimateArray, griddedSet, clazz, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(griddedSet.getClass().equals(clazz) || griddedSet instanceof GriddedSet && griddedSet instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, griddedSet, object);
            return;
        }
        if (nArray == null) {
            throw new IOException("Null " + clazz.getName() + " lengths");
        }
        switch (by) {
            case 44: {
                n = 1;
                break;
            }
            case 45: {
                n = 2;
                break;
            }
            case 46: {
                n = 3;
                break;
            }
            case 43: {
                n = -1;
                break;
            }
            default: {
                throw new IOException("Invalid type " + by);
            }
        }
        if (fArray != null && n > 0 && fArray.length != n) {
            throw new IOException("Expected " + n + " sample list" + (n > 1 ? "s" : "") + ", not " + fArray.length);
        }
        int n2 = binaryWriter.getTypeCache().getIndex(setType);
        if (n2 < 0) {
            throw new IOException("SetType " + setType + " not cached");
        }
        int n3 = -1;
        if (coordinateSystem != null && (n3 = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        int[] nArray2 = null;
        if (unitArray != null) {
            nArray2 = BinaryUnit.lookupList(binaryWriter.getUnitCache(), unitArray);
        }
        int[] nArray3 = null;
        if (errorEstimateArray != null) {
            nArray3 = BinaryErrorEstimate.lookupList(binaryWriter.getErrorEstimateCache(), errorEstimateArray);
        }
        int n4 = BinaryGriddedSet.computeBytes(fArray, nArray, coordinateSystem, unitArray, errorEstimateArray);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n4);
        dataOutputStream.writeByte(by);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeByte(6);
        BinaryFloatMatrix.write(binaryWriter, fArray, object);
        dataOutputStream.writeByte(3);
        BinaryIntegerArray.write(binaryWriter, nArray, object);
        if (n3 >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n3);
        }
        if (nArray2 != null) {
            dataOutputStream.writeByte(40);
            BinaryIntegerArray.write(binaryWriter, nArray2, object);
        }
        if (nArray3 != null) {
            dataOutputStream.writeByte(41);
            BinaryIntegerArray.write(binaryWriter, nArray3, object);
        }
        dataOutputStream.writeByte(80);
    }
}

