/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.FunctionType;
import visad.MathType;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryObject;

public class BinaryFunctionType
implements BinaryObject {
    public static final int computeBytes(FunctionType functionType) {
        return 14;
    }

    public static final FunctionType read(BinaryReader binaryReader, int n) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n2 = dataInput.readInt();
        MathType mathType = (MathType)binaryObjectCache.get(n2);
        int n3 = dataInput.readInt();
        MathType mathType2 = (MathType)binaryObjectCache.get(n3);
        byte by = dataInput.readByte();
        if (by != 80) {
            throw new IOException("Corrupted file (no TupleType end-marker)");
        }
        FunctionType functionType = new FunctionType(mathType, mathType2);
        binaryObjectCache.add(n, functionType);
        return functionType;
    }

    public static final int write(BinaryWriter binaryWriter, FunctionType functionType, Object object) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryWriter.getTypeCache();
        int n = binaryObjectCache.getIndex(functionType);
        if (n < 0) {
            n = binaryObjectCache.add(functionType);
            if (n < 0) {
                throw new IOException("Couldn't cache FunctionType " + functionType);
            }
            int n2 = BinaryMathType.write(binaryWriter, functionType.getDomain(), object);
            int n3 = BinaryMathType.write(binaryWriter, functionType.getRange(), object);
            int n4 = BinaryFunctionType.computeBytes(functionType);
            DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
            dataOutputStream.writeByte(5);
            dataOutputStream.writeInt(n4);
            dataOutputStream.writeInt(n);
            dataOutputStream.writeByte(1);
            dataOutputStream.writeInt(n2);
            dataOutputStream.writeInt(n3);
            dataOutputStream.writeByte(80);
        }
        return n;
    }
}

