/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryFloatMatrix
implements BinaryObject {
    public static final int computeBytes(float[][] fArray) {
        if (fArray == null) {
            return 4;
        }
        int n = 4;
        int n2 = 0;
        while (n2 < fArray.length) {
            n += 4 + fArray[n2].length * 4;
            ++n2;
        }
        return n;
    }

    public static final float[][] read(BinaryReader binaryReader) throws IOException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 0) {
            return null;
        }
        float[][] fArray = new float[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readInt();
            fArray[n2] = new float[n3];
            int n4 = 0;
            while (n4 < n3) {
                fArray[n2][n4] = dataInput.readFloat();
                ++n4;
            }
            ++n2;
        }
        return fArray;
    }

    public static final void write(BinaryWriter binaryWriter, float[][] fArray, Object object) throws IOException {
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        if (fArray == null) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(fArray.length);
            int n = 0;
            while (n < fArray.length) {
                int n2 = fArray[n].length;
                dataOutputStream.writeInt(n2);
                int n3 = 0;
                while (n3 < n2) {
                    dataOutputStream.writeFloat(fArray[n][n3]);
                    ++n3;
                }
                ++n;
            }
        }
    }
}

