/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryFloatArray
implements BinaryObject {
    public static final int computeBytes(float[] fArray) {
        return fArray == null ? 0 : 4 + fArray.length * 4;
    }

    public static final float[] read(BinaryReader binaryReader) throws IOException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 1) {
            throw new IOException("Corrupted file (bad float array length " + n + ")");
        }
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = dataInput.readFloat();
            ++n2;
        }
        return fArray;
    }

    public static final void write(BinaryWriter binaryWriter, float[] fArray, Object object) throws IOException {
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeInt(fArray.length);
        int n = 0;
        while (n < fArray.length) {
            dataOutputStream.writeFloat(fArray[n]);
            ++n;
        }
    }
}

