/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.Data;
import visad.FlatField;
import visad.FunctionType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.CacheStrategy;
import visad.data.FileFlatField;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.Saveable;
import visad.data.visad.object.BinaryAccessor;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryDataArray;
import visad.data.visad.object.BinaryDoubleMatrix;
import visad.data.visad.object.BinaryFunctionType;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryUnit;
import visad.data.visad.object.BinaryUnknown;

public class BinaryFlatField
implements BinaryObject {
    private static CacheStrategy strategy = new CacheStrategy();
    private static /* synthetic */ Class class$Lvisad$FlatField;
    private static /* synthetic */ Class class$Lvisad$data$FileFlatField;

    public static final int computeBytes(Set set, CoordinateSystem coordinateSystem, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray, FlatField flatField) {
        int n;
        int n2;
        int n3 = 0;
        if (!flatField.isMissing()) {
            n2 = flatField.getRangeDimension();
            n = flatField.getLength();
            if (n2 > 0 && n > 0) {
                n3 = 4 + n2 * (4 + n * 8);
            }
        }
        if (setArray == null) {
            n2 = 0;
        } else {
            n2 = 5;
            n = 0;
            while (n < setArray.length) {
                int n4 = BinaryGeneric.computeBytes(setArray[n]);
                if (n4 < 0) {
                    return -1;
                }
                n2 += n4;
                ++n;
            }
        }
        n = BinaryUnit.computeBytes(unitArray);
        return 10 + (set == null ? 0 : 1 + BinaryGeneric.computeBytes(set)) + n3 + (coordinateSystem == null ? 0 : 5) + (coordinateSystemArray == null ? 0 : 1 + BinaryCoordinateSystem.computeBytes(coordinateSystemArray)) + n2 + (n == 0 ? 0 : 1 + n) + 1;
    }

    private static FileFlatField createFileFlatField(BinaryReader binaryReader, int n) throws IOException, VisADException {
        long l = binaryReader.getFilePointer();
        BinaryObjectCache binaryObjectCache = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        int n2 = dataInput.readInt();
        FunctionType functionType = (FunctionType)binaryObjectCache.get(n2);
        binaryReader.seek(l + (long)n);
        return new FileFlatField(new BinaryAccessor(binaryReader, l, functionType), strategy);
    }

    private static final Set[] readSetArray(BinaryReader binaryReader) throws IOException, VisADException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        Set[] setArray = new Set[n];
        int n2 = 0;
        while (n2 < setArray.length) {
            setArray[n2] = (Set)BinaryGeneric.read(binaryReader);
            ++n2;
        }
        return setArray;
    }

    public static final FlatField read(BinaryReader binaryReader, int n, boolean bl) throws IOException, VisADException {
        if (bl) {
            return BinaryFlatField.createFileFlatField(binaryReader, n);
        }
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getTypeCache();
        DataInput dataInput = binaryReader.getInput();
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        l8 = System.currentTimeMillis();
        int n2 = dataInput.readInt();
        FunctionType functionType = (FunctionType)binaryObjectCache2.get(n2);
        Set set = null;
        Data[] dataArray = null;
        CoordinateSystem coordinateSystem = null;
        CoordinateSystem[] coordinateSystemArray = null;
        Set[] setArray = null;
        Unit[] unitArray = null;
        double[][] dArray = null;
        boolean bl2 = true;
        while (bl2) {
            byte by;
            try {
                by = dataInput.readByte();
            }
            catch (EOFException eOFException) {
                return null;
            }
            long l9 = System.currentTimeMillis();
            switch (by) {
                case 12: {
                    set = (Set)BinaryGeneric.read(binaryReader);
                    break;
                }
                case 8: {
                    dataArray = BinaryDataArray.read(binaryReader);
                    break;
                }
                case 7: {
                    dArray = BinaryDoubleMatrix.read(binaryReader);
                    break;
                }
                case 32: {
                    int n3 = dataInput.readInt();
                    coordinateSystem = (CoordinateSystem)binaryObjectCache.get(n3);
                    break;
                }
                case 50: {
                    coordinateSystemArray = BinaryCoordinateSystem.readList(binaryReader);
                    break;
                }
                case 15: {
                    setArray = BinaryFlatField.readSetArray(binaryReader);
                    break;
                }
                case 40: {
                    unitArray = BinaryUnit.readList(binaryReader);
                    break;
                }
                case 80: {
                    bl2 = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown FlatField directive " + by);
                }
            }
        }
        if (functionType == null) {
            throw new IOException("No FunctionType found for FlatField");
        }
        long l10 = System.currentTimeMillis();
        FlatField flatField = new FlatField(functionType, set, coordinateSystemArray, setArray, unitArray);
        long l11 = System.currentTimeMillis() - l10;
        l10 = System.currentTimeMillis();
        if (dArray != null) {
            flatField.setSamples(0, dArray);
        } else if (dataArray != null) {
            int n4 = dataArray.length;
            int n5 = 0;
            while (n5 < n4) {
                flatField.setSample(n5, dataArray[n5]);
                ++n5;
            }
        }
        long l12 = System.currentTimeMillis() - l10;
        l10 = System.currentTimeMillis();
        if (dArray != null) {
            flatField.setSamples(dArray, false);
        }
        long l13 = System.currentTimeMillis() - l10;
        return flatField;
    }

    public static final void writeDependentData(BinaryWriter binaryWriter, FunctionType functionType, Set set, CoordinateSystem coordinateSystem, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray, FlatField flatField, Object object) throws IOException {
        if (!(flatField.getClass().equals(class$Lvisad$FlatField != null ? class$Lvisad$FlatField : (class$Lvisad$FlatField = BinaryFlatField.class$("visad.FlatField"))) || flatField.getClass().equals(class$Lvisad$data$FileFlatField != null ? class$Lvisad$data$FileFlatField : (class$Lvisad$data$FileFlatField = BinaryFlatField.class$("visad.data.FileFlatField"))) || flatField instanceof FlatField && flatField instanceof Saveable)) {
            return;
        }
        Object object2 = object == BinaryObject.SAVE_DEPEND_BIG ? object : BinaryObject.SAVE_DEPEND;
        BinaryFunctionType.write(binaryWriter, functionType, BinaryObject.SAVE_DATA);
        if (coordinateSystem != null) {
            BinaryCoordinateSystem.write(binaryWriter, coordinateSystem, BinaryObject.SAVE_DATA);
        }
        if (coordinateSystemArray != null) {
            BinaryCoordinateSystem.writeList(binaryWriter, coordinateSystemArray, BinaryObject.SAVE_DATA);
        }
        if (unitArray != null) {
            BinaryUnit.writeList(binaryWriter, unitArray, BinaryObject.SAVE_DATA);
        }
        if (set != null) {
            BinaryGeneric.write(binaryWriter, set, object2);
        }
        if (setArray != null) {
            int n = 0;
            while (n < setArray.length) {
                BinaryGeneric.write(binaryWriter, setArray[n], object2);
                ++n;
            }
        }
    }

    public static final void write(BinaryWriter binaryWriter, FunctionType functionType, Set set, CoordinateSystem coordinateSystem, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray, FlatField flatField, Object object) throws IOException {
        BinaryFlatField.writeDependentData(binaryWriter, functionType, set, coordinateSystem, coordinateSystemArray, setArray, unitArray, flatField, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        if (!(flatField.getClass().equals(class$Lvisad$FlatField != null ? class$Lvisad$FlatField : (class$Lvisad$FlatField = BinaryFlatField.class$("visad.FlatField"))) || flatField.getClass().equals(class$Lvisad$data$FileFlatField != null ? class$Lvisad$data$FileFlatField : (class$Lvisad$data$FileFlatField = BinaryFlatField.class$("visad.data.FileFlatField"))) || flatField instanceof FlatField && flatField instanceof Saveable)) {
            BinaryUnknown.write(binaryWriter, flatField, object);
            return;
        }
        int n = binaryWriter.getTypeCache().getIndex(functionType);
        if (n < 0) {
            throw new IOException("FunctionType " + functionType + " not cached");
        }
        int n2 = -1;
        if (coordinateSystem != null && (n2 = binaryWriter.getCoordinateSystemCache().getIndex(coordinateSystem)) < 0) {
            throw new IOException("CoordinateSystem " + coordinateSystem + " not cached");
        }
        int[] nArray = null;
        if (coordinateSystemArray != null) {
            nArray = BinaryCoordinateSystem.lookupList(binaryWriter.getCoordinateSystemCache(), coordinateSystemArray);
        }
        int[] nArray2 = null;
        if (unitArray != null) {
            nArray2 = BinaryUnit.lookupList(binaryWriter.getUnitCache(), unitArray);
        }
        int n3 = BinaryFlatField.computeBytes(set, coordinateSystem, coordinateSystemArray, setArray, unitArray, flatField);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeByte(21);
        dataOutputStream.writeInt(n);
        if (set != null) {
            dataOutputStream.writeByte(12);
            BinaryGeneric.write(binaryWriter, set, object);
        }
        if (flatField.isMissing() || flatField.getLength() <= 0) {
            double[][] dArray;
            try {
                dArray = flatField.unpackValues();
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                dArray = null;
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
                dArray = null;
            }
            if (dArray != null) {
                dataOutputStream.writeByte(7);
                BinaryDoubleMatrix.write(binaryWriter, dArray, object);
            }
        }
        if (n2 >= 0) {
            dataOutputStream.writeByte(32);
            dataOutputStream.writeInt(n2);
        }
        if (nArray != null) {
            dataOutputStream.writeByte(50);
            BinaryIntegerArray.write(binaryWriter, nArray, object);
        }
        if (setArray != null) {
            dataOutputStream.writeByte(15);
            dataOutputStream.writeInt(setArray.length);
            int n4 = 0;
            while (n4 < setArray.length) {
                BinaryGeneric.write(binaryWriter, setArray[n4], object);
                ++n4;
            }
        }
        if (nArray2 != null) {
            dataOutputStream.writeByte(40);
            BinaryIntegerArray.write(binaryWriter, nArray2, object);
        }
        dataOutputStream.writeByte(80);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

