/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.ErrorEstimate;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryUnit;

public class BinaryErrorEstimate
implements BinaryObject {
    public static final int computeBytes(int n) {
        return 28 + (n < 0 ? 0 : 5) + 1;
    }

    public static final int computeBytes(ErrorEstimate[] errorEstimateArray) {
        return BinaryIntegerArray.computeBytes(errorEstimateArray);
    }

    public static final int[] lookupList(BinaryObjectCache binaryObjectCache, ErrorEstimate[] errorEstimateArray) {
        boolean bl = true;
        int n = 0;
        while (n < errorEstimateArray.length) {
            if (errorEstimateArray[n] != null) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return null;
        }
        int[] nArray = new int[errorEstimateArray.length];
        int n2 = 0;
        while (n2 < errorEstimateArray.length) {
            nArray[n2] = errorEstimateArray[n2] == null ? -1 : binaryObjectCache.getIndex(errorEstimateArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public static final ErrorEstimate read(BinaryReader binaryReader) throws IOException, VisADException {
        BinaryObjectCache binaryObjectCache = binaryReader.getErrorEstimateCache();
        BinaryObjectCache binaryObjectCache2 = binaryReader.getUnitCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        double d = dataInput.readDouble();
        double d2 = dataInput.readDouble();
        long l = dataInput.readLong();
        Unit unit = null;
        boolean bl = true;
        while (bl) {
            byte by = dataInput.readByte();
            switch (by) {
                case 30: {
                    int n3 = dataInput.readInt();
                    unit = (Unit)binaryObjectCache2.get(n3);
                    break;
                }
                case 80: {
                    bl = false;
                    break;
                }
                default: {
                    throw new IOException("Unknown ErrorEstimate directive " + by);
                }
            }
        }
        ErrorEstimate errorEstimate = new ErrorEstimate(d, d2, l, unit);
        binaryObjectCache.add(n2, errorEstimate);
        return errorEstimate;
    }

    public static final ErrorEstimate[] readList(BinaryReader binaryReader) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryReader.getErrorEstimateCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 1) {
            throw new IOException("Corrupted file (bad ErrorEstimate array length " + n + ")");
        }
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readInt();
            errorEstimateArray[n2] = n3 < 0 ? null : (ErrorEstimate)binaryObjectCache.get(n3);
            ++n2;
        }
        return errorEstimateArray;
    }

    public static final int write(BinaryWriter binaryWriter, ErrorEstimate errorEstimate, Object object) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryWriter.getErrorEstimateCache();
        int n = binaryObjectCache.getIndex(errorEstimate);
        if (n >= 0) {
            return n;
        }
        n = binaryObjectCache.add(errorEstimate);
        if (n < 0) {
            throw new IOException("Couldn't cache ErrorEstimate " + errorEstimate);
        }
        double d = errorEstimate.getErrorValue();
        double d2 = errorEstimate.getMean();
        long l = errorEstimate.getNumberNotMissing();
        Unit unit = errorEstimate.getUnit();
        int n2 = -1;
        if (unit != null) {
            n2 = BinaryUnit.write(binaryWriter, unit, object);
        }
        int n3 = BinaryErrorEstimate.computeBytes(n2);
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeByte(4);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeDouble(d);
        dataOutputStream.writeDouble(d2);
        dataOutputStream.writeLong(l);
        if (n2 >= 0) {
            dataOutputStream.writeByte(30);
            dataOutputStream.writeInt(n2);
        }
        dataOutputStream.writeByte(80);
        return n;
    }

    public static final int[] writeList(BinaryWriter binaryWriter, ErrorEstimate[] errorEstimateArray, Object object) throws IOException {
        boolean bl = true;
        int n = 0;
        while (n < errorEstimateArray.length) {
            if (errorEstimateArray[n] != null) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return null;
        }
        int[] nArray = new int[errorEstimateArray.length];
        int n2 = 0;
        while (n2 < errorEstimateArray.length) {
            nArray[n2] = errorEstimateArray[n2] == null ? -1 : BinaryErrorEstimate.write(binaryWriter, errorEstimateArray[n2], object);
            ++n2;
        }
        return nArray;
    }
}

