/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryDoubleMatrix
implements BinaryObject {
    public static final int computeBytes(double[][] dArray) {
        if (dArray == null) {
            return 4;
        }
        int n = 4;
        int n2 = 0;
        while (n2 < dArray.length) {
            n += 4 + dArray[n2].length * 8;
            ++n2;
        }
        return n;
    }

    public static final double[][] read(BinaryReader binaryReader) throws IOException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 0) {
            return null;
        }
        double[][] dArray = new double[n][];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readInt();
            dArray[n2] = new double[n3];
            int n4 = 0;
            while (n4 < n3) {
                dArray[n2][n4] = dataInput.readDouble();
                ++n4;
            }
            ++n2;
        }
        return dArray;
    }

    public static final void write(BinaryWriter binaryWriter, double[][] dArray, Object object) throws IOException {
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        if (dArray == null) {
            dataOutputStream.writeInt(-1);
        } else {
            dataOutputStream.writeInt(dArray.length);
            int n = 0;
            while (n < dArray.length) {
                int n2 = dArray[n].length;
                dataOutputStream.writeInt(n2);
                int n3 = 0;
                while (n3 < n2) {
                    dataOutputStream.writeDouble(dArray[n][n3]);
                    ++n3;
                }
                ++n;
            }
        }
    }
}

