/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryDoubleArray
implements BinaryObject {
    public static final int computeBytes(double[] dArray) {
        return dArray == null ? 0 : 4 + dArray.length * 8;
    }

    public static final double[] read(BinaryReader binaryReader) throws IOException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 1) {
            throw new IOException("Corrupted file (bad double array length " + n + ")");
        }
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = dataInput.readDouble();
            ++n2;
        }
        return dArray;
    }

    public static final void write(BinaryWriter binaryWriter, double[] dArray, Object object) throws IOException {
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeInt(dArray.length);
        int n = 0;
        while (n < dArray.length) {
            dataOutputStream.writeDouble(dArray[n]);
            ++n;
        }
    }
}

