/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryGeneric;
import visad.data.visad.object.BinaryObject;

public class BinaryDataArray
implements BinaryObject {
    public static final int computeBytes(Data[] dataArray) {
        int n = 4;
        int n2 = 0;
        while (n2 < dataArray.length) {
            n += BinaryGeneric.computeBytes((DataImpl)dataArray[n2]);
            ++n2;
        }
        return n;
    }

    public static final Data[] read(BinaryReader binaryReader) throws IOException, VisADException {
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 1) {
            throw new IOException("Corrupted file (bad Data array length " + n + ")");
        }
        long l = 0L;
        Data[] dataArray = new Data[n];
        int n2 = 0;
        while (n2 < n) {
            dataArray[n2] = BinaryGeneric.read(binaryReader);
            ++n2;
        }
        return dataArray;
    }

    private static final void writeDependentData(BinaryWriter binaryWriter, Data[] dataArray, Object object) throws IOException {
        if (object != BinaryObject.SAVE_DEPEND_BIG) {
            object = BinaryObject.SAVE_DEPEND;
        }
        if (dataArray != null) {
            int n = 0;
            while (n < dataArray.length) {
                BinaryGeneric.write(binaryWriter, (DataImpl)dataArray[n], object);
                ++n;
            }
        }
    }

    public static final void write(BinaryWriter binaryWriter, Data[] dataArray, Object object) throws IOException {
        BinaryDataArray.writeDependentData(binaryWriter, dataArray, object);
        if (object == BinaryObject.SAVE_DEPEND || object == BinaryObject.SAVE_DEPEND_BIG) {
            return;
        }
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        dataOutputStream.writeInt(dataArray.length);
        int n = 0;
        while (n < dataArray.length) {
            BinaryGeneric.write(binaryWriter, (DataImpl)dataArray[n], object);
            ++n;
        }
    }
}

