/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import visad.CoordinateSystem;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryIntegerArray;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinarySerializedObject;

public class BinaryCoordinateSystem
implements BinaryObject {
    public static final int computeBytes(CoordinateSystem coordinateSystem) {
        try {
            return BinaryCoordinateSystem.computeBytes(BinarySerializedObject.getBytes(coordinateSystem));
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    private static final int computeBytes(byte[] byArray) {
        return 5 + byArray.length + 1;
    }

    public static final int computeBytes(CoordinateSystem[] coordinateSystemArray) {
        return BinaryIntegerArray.computeBytes(coordinateSystemArray);
    }

    public static final int[] lookupList(BinaryObjectCache binaryObjectCache, CoordinateSystem[] coordinateSystemArray) {
        boolean bl = true;
        int n = 0;
        while (n < coordinateSystemArray.length) {
            if (coordinateSystemArray[n] != null) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return null;
        }
        int[] nArray = new int[coordinateSystemArray.length];
        int n2 = 0;
        while (n2 < coordinateSystemArray.length) {
            nArray[n2] = coordinateSystemArray[n2] == null ? -1 : binaryObjectCache.getIndex(coordinateSystemArray[n2]);
            ++n2;
        }
        return nArray;
    }

    public static final CoordinateSystem read(BinaryReader binaryReader) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        int n2 = dataInput.readInt();
        byte by = dataInput.readByte();
        if (by != 20) {
            throw new IOException("Corrupted file (no CoordinateSystem serial marker)");
        }
        CoordinateSystem coordinateSystem = (CoordinateSystem)BinarySerializedObject.read(dataInput, n - 6 + 1);
        binaryObjectCache.add(n2, coordinateSystem);
        return coordinateSystem;
    }

    public static final CoordinateSystem[] readList(BinaryReader binaryReader) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryReader.getCoordinateSystemCache();
        DataInput dataInput = binaryReader.getInput();
        int n = dataInput.readInt();
        if (n < 1) {
            throw new IOException("Corrupted file (bad CoordinateSystem array length " + n + ")");
        }
        CoordinateSystem[] coordinateSystemArray = new CoordinateSystem[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = dataInput.readInt();
            coordinateSystemArray[n2] = (CoordinateSystem)binaryObjectCache.get(n3);
            ++n2;
        }
        return coordinateSystemArray;
    }

    public static final int write(BinaryWriter binaryWriter, CoordinateSystem coordinateSystem, Object object) throws IOException {
        BinaryObjectCache binaryObjectCache = binaryWriter.getCoordinateSystemCache();
        int n = binaryObjectCache.getIndex(coordinateSystem);
        if (n >= 0) {
            return n;
        }
        n = binaryObjectCache.add(coordinateSystem);
        if (n < 0) {
            throw new IOException("Couldn't cache CoordinateSystem " + coordinateSystem);
        }
        DataOutputStream dataOutputStream = binaryWriter.getOutputStream();
        byte[] byArray = BinarySerializedObject.getBytes(coordinateSystem);
        int n2 = BinaryCoordinateSystem.computeBytes(byArray);
        dataOutputStream.writeByte(1);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeByte(20);
        dataOutputStream.write(byArray);
        dataOutputStream.writeByte(80);
        return n;
    }

    public static final int[] writeList(BinaryWriter binaryWriter, CoordinateSystem[] coordinateSystemArray, Object object) throws IOException {
        boolean bl = true;
        int n = 0;
        while (n < coordinateSystemArray.length) {
            if (coordinateSystemArray[n] != null) {
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            return null;
        }
        int[] nArray = new int[coordinateSystemArray.length];
        int n2 = 0;
        while (n2 < coordinateSystemArray.length) {
            nArray[n2] = coordinateSystemArray[n2] == null ? -1 : BinaryCoordinateSystem.write(binaryWriter, coordinateSystemArray[n2], object);
            ++n2;
        }
        return nArray;
    }
}

