/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;

public class VisADForm
extends Form
implements FormFileInformer {
    private static int num = 0;
    private boolean allowBinary = false;

    public boolean isThisType(String string) {
        return string.endsWith(".vad") || string.endsWith(".VAD");
    }

    public boolean isThisType(byte[] byArray) {
        return BinaryReader.isMagic(byArray);
    }

    public String[] getDefaultSuffixes() {
        String[] stringArray = new String[]{"vad"};
        return stringArray;
    }

    public synchronized void add(String string, Data data, boolean bl) throws BadFormException {
        throw new BadFormException("VisADForm.add");
    }

    public synchronized FormNode getForms(Data data) {
        return null;
    }

    public synchronized DataImpl open(String string) throws BadFormException, IOException, VisADException {
        IOException iOException = null;
        VisADException visADException = null;
        try {
            return this.readData(new BinaryReader(string));
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        catch (VisADException visADException2) {
            visADException = visADException2;
        }
        try {
            return this.readSerial(new FileInputStream(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (iOException != null) {
                throw iOException;
            }
            if (visADException != null) {
                throw visADException;
            }
            throw new BadFormException("Could not read file \"" + string + "\": " + classNotFoundException.getMessage());
        }
        catch (IOException iOException3) {
            if (iOException != null) {
                throw iOException;
            }
            if (visADException != null) {
                throw visADException;
            }
            throw iOException3;
        }
    }

    public synchronized DataImpl open(URL uRL) throws BadFormException, IOException, VisADException {
        IOException iOException = null;
        VisADException visADException = null;
        try {
            return this.readData(new BinaryReader(uRL.openStream()));
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        catch (VisADException visADException2) {
            visADException = visADException2;
        }
        try {
            return this.readSerial(uRL.openStream());
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (iOException != null) {
                throw iOException;
            }
            if (visADException != null) {
                throw visADException;
            }
            throw new BadFormException("Could not read URL " + uRL + ": " + classNotFoundException.getMessage());
        }
        catch (IOException iOException3) {
            if (iOException != null) {
                throw iOException;
            }
            if (visADException != null) {
                throw visADException;
            }
            throw iOException3;
        }
    }

    DataImpl readData(BinaryReader binaryReader) throws IOException, VisADException {
        DataImpl dataImpl = binaryReader.getData();
        try {
            binaryReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return dataImpl;
    }

    DataImpl readSerial(InputStream inputStream) throws ClassNotFoundException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        ObjectInputStream objectInputStream = new ObjectInputStream(bufferedInputStream);
        return (DataImpl)objectInputStream.readObject();
    }

    private synchronized void saveBinary(String string, Data data, boolean bl, boolean bl2) throws BadFormException, IOException, RemoteException, VisADException {
        File file = new File(string);
        if (!bl && file.exists()) {
            throw new IllegalArgumentException("File \"" + string + "\" exists");
        }
        BinaryWriter binaryWriter = new BinaryWriter(file);
        binaryWriter.save((DataImpl)data, bl2);
        binaryWriter.close();
    }

    private synchronized void saveSerial(String string, Data data, boolean bl) throws BadFormException, IOException, RemoteException, VisADException {
        Object object;
        FileOutputStream fileOutputStream = null;
        if (bl) {
            fileOutputStream = new FileOutputStream(string);
        } else {
            object = new File(string);
            if (((File)object).exists()) {
                throw new BadFormException("VisADSerialForm.save(" + string + "): exists");
            }
            fileOutputStream = new FileOutputStream((File)object);
        }
        object = new BufferedOutputStream(fileOutputStream);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)object);
        DataImpl dataImpl = data.local();
        objectOutputStream.writeObject(dataImpl);
        objectOutputStream.flush();
        fileOutputStream.close();
    }

    public void save(String string, Data data, boolean bl) throws BadFormException, IOException, RemoteException, VisADException {
        this.save(string, data, bl, false);
    }

    public synchronized void save(String string, Data data, boolean bl, boolean bl2) throws BadFormException, IOException, RemoteException, VisADException {
        if (this.allowBinary) {
            this.saveBinary(string, data, bl, bl2);
        } else {
            this.saveSerial(string, data, bl);
        }
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray == null || stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("to convert a file to a VisAD binary file, run:");
            System.out.println("  java visad.data.visad.VisADForm in_file out_file");
            System.out.println("to test read a binary or serial VisAD file, run:");
            System.out.println("or  'java visad.data.visad.VisADForm in_file'");
        } else if (stringArray.length == 1) {
            VisADForm visADForm = new VisADForm();
            if (stringArray[0].startsWith("http://")) {
                URL uRL = new URL(stringArray[0]);
                visADForm.open(uRL);
            } else {
                visADForm.open(stringArray[0]);
            }
        } else if (stringArray.length == 2) {
            DefaultFamily defaultFamily = new DefaultFamily("loader");
            DataImpl dataImpl = defaultFamily.open(stringArray[0]);
            defaultFamily = null;
            VisADForm visADForm = new VisADForm();
            visADForm.save(stringArray[1], dataImpl, true);
        }
        System.exit(0);
    }

    public VisADForm(boolean bl) {
        this();
        this.allowBinary = bl;
    }

    public VisADForm() {
        super("VisADForm" + num++);
    }
}

