/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.visad.FakeData;
import visad.data.visad.VisADForm;

public class TestBinary {
    private static final String OUTPUT_SUBDIRECTORY = "tstout";
    private String progName;
    private boolean allowBinary;
    private boolean verbose;
    private String[] files;

    private int getSerializedSize(Object object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            return 0;
        }
        return byteArrayOutputStream.size();
    }

    public void initArgs() {
        this.verbose = false;
        this.allowBinary = false;
        this.files = null;
    }

    private boolean makeSubdirectory(String string) {
        File file = new File(string);
        if (file.isDirectory()) {
            return true;
        }
        if (file.exists()) {
            System.err.println(this.progName + ": Subdirectory \"" + string + "\" exists but is not a directory");
            return false;
        }
        return file.mkdir();
    }

    public boolean processArgs(String[] stringArray) {
        boolean bl = false;
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        int n2 = string.lastIndexOf(36);
        if (n2 > n) {
            n = n2;
        }
        this.progName = string.substring(n == -1 ? 0 : n + 1);
        ArrayList<String> arrayList = null;
        int n3 = 0;
        while (stringArray != null && n3 < stringArray.length) {
            if (stringArray[n3].length() > 0 && stringArray[n3].charAt(0) == '-') {
                char c = stringArray[n3].charAt(1);
                switch (c) {
                    case 'a': {
                        this.allowBinary = true;
                        break;
                    }
                    case 'v': {
                        this.verbose = true;
                        break;
                    }
                    default: {
                        System.err.println(this.progName + ": Unknown option \"-" + c + "\"");
                        bl = true;
                        break;
                    }
                }
            } else {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(stringArray[n3]);
            }
            ++n3;
        }
        if (bl) {
            System.err.println("Usage: " + this.getClass().getName() + " [-a(llowBinary)]" + " [-v(erbose)]" + "");
        }
        if (arrayList != null) {
            this.files = new String[arrayList.size()];
            n3 = 0;
            while (n3 < this.files.length) {
                this.files[n3] = (String)arrayList.get(n3);
                ++n3;
            }
            arrayList.clear();
        }
        return !bl;
    }

    private boolean writeData(Form form, DataImpl dataImpl, int n) {
        DataImpl dataImpl2;
        String string = OUTPUT_SUBDIRECTORY + File.separatorChar + "binary" + n + ".vad";
        if (this.verbose) {
            System.out.println("Writing " + dataImpl.getClass().getName() + " to " + string);
        }
        try {
            form.save(string, dataImpl, true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            new File(string).delete();
            return false;
        }
        if (this.verbose) {
            System.out.println("Reading " + dataImpl.getClass().getName());
        }
        try {
            dataImpl2 = form.open(string);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
        if (dataImpl2 == null) {
            System.err.println("Got null Data while reading " + dataImpl);
            return false;
        }
        if (!dataImpl.equals(dataImpl2)) {
            System.err.println("MISMATCH");
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        try {
            new TestBinary(stringArray);
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        System.exit(0);
    }

    public TestBinary(String[] stringArray) throws VisADException {
        this.initArgs();
        if (!this.processArgs(stringArray)) {
            System.err.println("Exiting...");
            System.exit(1);
        }
        DefaultFamily defaultFamily = new DefaultFamily("DefaultFamily");
        VisADForm visADForm = new VisADForm(this.allowBinary);
        if (!this.makeSubdirectory(OUTPUT_SUBDIRECTORY)) {
            throw new VisADException("Couldn't create test subdirectory \"tstout\"");
        }
        boolean bl = true;
        if (this.files != null) {
            int n = 0;
            while (n < this.files.length) {
                block11: {
                    DataImpl dataImpl;
                    try {
                        dataImpl = defaultFamily.open(this.files[n]);
                    }
                    catch (BadFormException badFormException) {
                        System.err.println("Couldn't read " + this.files[n] + ": " + badFormException.getMessage());
                        bl = false;
                        break block11;
                    }
                    System.out.println(this.files[n]);
                    bl &= this.writeData(visADForm, dataImpl, n);
                    if (this.verbose) {
                        System.out.println("-- ");
                    }
                }
                ++n;
            }
        } else {
            DataImpl[] dataImplArray = new FakeData().getList();
            int n = 0;
            while (n < dataImplArray.length) {
                bl &= this.writeData(visADForm, dataImplArray[n], n);
                if (this.verbose) {
                    System.out.println("-- ");
                }
                ++n;
            }
        }
        if (bl) {
            System.out.println("All tests succeeded!");
        }
    }
}

