/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.rmi.RemoteException;
import java.util.ArrayList;
import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DelaunayFast;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.List1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.Scalar;
import visad.ScaledUnit;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.visad.FakeCoordinateSystem;

class FakeData {
    private Unit foot = new ScaledUnit(0.3048, SI.meter, "foot");
    private Unit pound = new ScaledUnit(2.204622, SI.kilogram, "pound");
    private RealType meHgt;
    private RealType meWgt;
    private RealType enHgt = RealType.getRealType("EnglishHeight", this.foot, null);
    private RealType enWgt = RealType.getRealType("EnglishWeight", this.pound, null);
    private FakeCoordinateSystem cSys1D;
    private FakeCoordinateSystem cSys2D;
    private FakeCoordinateSystem cSys3D;
    private Unit[] enUnits1D;
    private Unit[] enUnits2D;
    private Unit[] enUnits3D;
    private RealTupleType tuple1D;
    private RealTupleType tuple2D;
    private RealTupleType tuple3D;

    private void fakeFunctions(ArrayList arrayList) {
        try {
            FunctionType functionType = new FunctionType(RealType.Time, this.enHgt);
            Integer1DSet integer1DSet = new Integer1DSet((MathType)RealType.Time, 15);
            arrayList.add(new FieldImpl(functionType, integer1DSet));
            arrayList.add(new FlatField(functionType, integer1DSet));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Function");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeGriddedSets(ArrayList arrayList) {
        float[][] fArray = new float[][]{{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f}};
        int[] nArray = new int[]{10};
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot)};
        try {
            arrayList.add(new GriddedSet(RealType.Altitude, fArray, nArray));
            arrayList.add(new GriddedSet(this.tuple1D, fArray, nArray, this.cSys1D, this.enUnits1D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build GriddedSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        this.fakeGridded1DSets(arrayList);
        this.fakeGridded2DSets(arrayList);
        this.fakeGridded3DSets(arrayList);
        this.fakeGriddedNDSets(arrayList);
    }

    private void fakeGridded1DSets(ArrayList arrayList) {
        float[][] fArray = new float[][]{{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f}};
        double[][] dArray = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0}};
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot)};
        try {
            arrayList.add(new Gridded1DSet((MathType)RealType.Altitude, fArray, fArray[0].length));
            arrayList.add(new Gridded1DSet((MathType)this.tuple1D, fArray, fArray[0].length, (CoordinateSystem)this.cSys1D, this.enUnits1D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Gridded1DSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Gridded1DDoubleSet((MathType)RealType.Altitude, fArray, fArray[0].length));
            arrayList.add(new Gridded1DDoubleSet((MathType)this.tuple1D, fArray, fArray[0].length, (CoordinateSystem)this.cSys1D, this.enUnits1D, errorEstimateArray));
            arrayList.add(new Gridded1DDoubleSet((MathType)RealType.Altitude, dArray, dArray[0].length));
            arrayList.add(new Gridded1DDoubleSet((MathType)this.tuple1D, dArray, dArray[0].length, (CoordinateSystem)this.cSys1D, this.enUnits1D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Gridded1DDoubleSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Linear1DSet(-1.23, 4.56, 10));
            arrayList.add(new Linear1DSet((MathType)RealType.TimeInterval, 1.35, 7.9, 11));
            arrayList.add(new Linear1DSet((MathType)this.tuple1D, 3.21, 6.66, 5, this.cSys1D, this.enUnits1D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Linear1DSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Integer1DSet(15));
            arrayList.add(new Integer1DSet((MathType)RealType.TimeInterval, 7));
            arrayList.add(new Integer1DSet(this.tuple1D, 5, this.cSys1D, this.enUnits1D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Integer1DSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeGridded2DSets(ArrayList arrayList) {
        Linear1DSet[] linear1DSetArray;
        float[][] fArray = new float[][]{{0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f, 1.1f, 1.2f}, {0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f, 1.1f, 1.2f}};
        double[][] dArray = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0}, {11.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0}};
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot), new ErrorEstimate(0.56, 7.8, this.pound)};
        try {
            linear1DSetArray = new Linear1DSet[]{new Linear1DSet(1.0, 4.0, 3), new Linear1DSet(5.0, 8.0, 4)};
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Linear1DSet arguments for 2D set tests");
            visADException.printStackTrace();
            linear1DSetArray = null;
        }
        try {
            arrayList.add(new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, fArray, fArray[0].length));
            arrayList.add(new Gridded2DSet((MathType)this.tuple2D, fArray, fArray[0].length, (CoordinateSystem)this.cSys2D, this.enUnits2D, errorEstimateArray));
            arrayList.add(new Gridded2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, fArray, 3, 4));
            arrayList.add(new Gridded2DSet((MathType)this.tuple2D, fArray, 3, 4, this.cSys2D, this.enUnits2D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Gridded2DSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Gridded2DDoubleSet((MathType)RealTupleType.SpatialCartesian2DTuple, fArray, fArray[0].length));
            arrayList.add(new Gridded2DDoubleSet((MathType)this.tuple2D, fArray, fArray[0].length, (CoordinateSystem)this.cSys2D, this.enUnits2D, errorEstimateArray));
            arrayList.add(new Gridded2DDoubleSet((MathType)RealTupleType.SpatialCartesian2DTuple, fArray, 3, 4));
            arrayList.add(new Gridded2DDoubleSet((MathType)this.tuple2D, fArray, 3, 4, (CoordinateSystem)this.cSys2D, this.enUnits2D, errorEstimateArray));
            arrayList.add(new Gridded2DDoubleSet((MathType)RealTupleType.SpatialCartesian2DTuple, dArray, dArray[0].length));
            arrayList.add(new Gridded2DDoubleSet((MathType)this.tuple2D, dArray, dArray[0].length, (CoordinateSystem)this.cSys2D, this.enUnits2D, errorEstimateArray));
            arrayList.add(new Gridded2DDoubleSet((MathType)RealTupleType.SpatialCartesian2DTuple, dArray, 4, 3));
            arrayList.add(new Gridded2DDoubleSet((MathType)this.tuple2D, dArray, 4, 3, (CoordinateSystem)this.cSys2D, this.enUnits2D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Gridded2DDoubleSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Linear2DSet(-1.23, 4.56, 5, 7.89, 12.34, 5));
            arrayList.add(new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, 1.0, 5.0, 5, 1.0, 8.0, 8));
            arrayList.add(new Linear2DSet(this.tuple2D, 3.0, 9.0, 3, 3.0, 7.0, 4, this.cSys2D, this.enUnits2D, errorEstimateArray));
            if (linear1DSetArray != null) {
                arrayList.add(new Linear2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, linear1DSetArray));
                arrayList.add(new Linear2DSet((MathType)this.tuple2D, linear1DSetArray, (CoordinateSystem)this.cSys2D, this.enUnits2D, errorEstimateArray));
            }
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Linear2DSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Integer2DSet(5, 3));
            arrayList.add(new Integer2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, 7, 2));
            arrayList.add(new Integer2DSet((MathType)this.tuple2D, 5, 4, (CoordinateSystem)this.cSys2D, this.enUnits2D, errorEstimateArray));
            Integer1DSet[] integer1DSetArray = new Integer1DSet[]{new Integer1DSet(5), new Integer1DSet(4)};
            arrayList.add(new Integer2DSet((MathType)RealTupleType.SpatialCartesian2DTuple, integer1DSetArray));
            arrayList.add(new Integer2DSet((MathType)this.tuple2D, integer1DSetArray, (CoordinateSystem)this.cSys2D, this.enUnits2D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Integer2DSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new LinearLatLonSet((MathType)RealTupleType.SpatialEarth2DTuple, 4.0, 6.0, 5, 1.23, 4.56, 5));
            if (linear1DSetArray != null) {
                arrayList.add(new LinearLatLonSet((MathType)RealTupleType.SpatialEarth2DTuple, linear1DSetArray));
            }
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build LinearLatLonSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeGridded3DSets(ArrayList arrayList) {
        Linear1DSet[] linear1DSetArray;
        float[][] fArray = new float[][]{{0.1f, 0.2f, 0.3f, 0.4f, 0.5f, 0.6f, 0.7f, 0.8f, 0.9f, 1.0f, 1.1f, 1.2f}, {0.31f, 0.32f, 0.33f, 0.34f, 0.35f, 0.36f, 0.37f, 0.38f, 0.39f, 0.4f, 0.41f, 0.42f}, {0.2f, 0.4f, 0.6f, 0.8f, 1.0f, 1.2f, 1.4f, 1.6f, 1.8f, 2.0f, 2.2f, 2.4f}};
        double[][] dArray = new double[][]{{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0}, {11.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0, 0.0}, {4.0, 4.5, 5.0, 5.5, 6.0, 6.5, 7.0, 7.5, 8.0, 8.5, 9.0, 9.5}};
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot), new ErrorEstimate(0.56, 7.8, this.pound), new ErrorEstimate(0.9, 0.9, (Unit)SI.second)};
        try {
            linear1DSetArray = new Linear1DSet[]{new Linear1DSet(1.0, 4.0, 3), new Linear1DSet(5.0, 8.0, 4), new Linear1DSet(9.0, 123.4, 5)};
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Linear1DSet arguments for 3D set tests");
            visADException.printStackTrace();
            linear1DSetArray = null;
        }
        try {
            arrayList.add(new Gridded3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, fArray, fArray[0].length));
            arrayList.add(new Gridded3DSet((MathType)this.tuple3D, fArray, fArray[0].length, (CoordinateSystem)this.cSys3D, this.enUnits3D, errorEstimateArray));
            arrayList.add(new Gridded3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, fArray, 3, 4));
            arrayList.add(new Gridded3DSet((MathType)this.tuple3D, fArray, 3, 4, this.cSys3D, this.enUnits3D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Gridded3DSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Gridded3DDoubleSet((MathType)RealTupleType.SpatialCartesian3DTuple, fArray, fArray[0].length));
            arrayList.add(new Gridded3DDoubleSet((MathType)this.tuple3D, fArray, fArray[0].length, (CoordinateSystem)this.cSys3D, this.enUnits3D, errorEstimateArray));
            arrayList.add(new Gridded3DDoubleSet((MathType)RealTupleType.SpatialCartesian3DTuple, fArray, 3, 4));
            arrayList.add(new Gridded3DDoubleSet((MathType)this.tuple3D, fArray, 3, 4, (CoordinateSystem)this.cSys3D, this.enUnits3D, errorEstimateArray));
            arrayList.add(new Gridded3DDoubleSet((MathType)RealTupleType.SpatialCartesian3DTuple, dArray, dArray[0].length));
            arrayList.add(new Gridded3DDoubleSet((MathType)this.tuple3D, dArray, dArray[0].length, (CoordinateSystem)this.cSys3D, this.enUnits3D, errorEstimateArray));
            arrayList.add(new Gridded3DDoubleSet((MathType)RealTupleType.SpatialCartesian3DTuple, dArray, 4, 3));
            arrayList.add(new Gridded3DDoubleSet((MathType)this.tuple3D, dArray, 4, 3, (CoordinateSystem)this.cSys3D, this.enUnits3D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Gridded3DDoubleSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Linear3DSet(-1.23, 4.56, 5, 7.89, 12.34, 5, 6.7, 8.9, 5));
            arrayList.add(new Linear3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, 1.0, 5.0, 4, 1.0, 7.0, 7, 1.0, 9.0, 4));
            arrayList.add(new Linear3DSet(this.tuple3D, 3.0, 9.0, 3, 3.0, 7.0, 4, 3.0, 5.0, 5, this.cSys3D, this.enUnits3D, errorEstimateArray));
            if (linear1DSetArray != null) {
                arrayList.add(new Linear3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, linear1DSetArray));
                arrayList.add(new Linear3DSet((MathType)this.tuple3D, linear1DSetArray, (CoordinateSystem)this.cSys3D, this.enUnits3D, errorEstimateArray));
            }
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Linear3DSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Integer3DSet(5, 3, 1));
            arrayList.add(new Integer3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, 7, 2, 4));
            arrayList.add(new Integer3DSet((MathType)this.tuple3D, 5, 4, 3, (CoordinateSystem)this.cSys3D, this.enUnits3D, errorEstimateArray));
            Integer1DSet[] integer1DSetArray = new Integer1DSet[]{new Integer1DSet(5), new Integer1DSet(4), new Integer1DSet(3)};
            arrayList.add(new Integer3DSet((MathType)RealTupleType.SpatialCartesian3DTuple, integer1DSetArray));
            arrayList.add(new Integer3DSet((MathType)this.tuple3D, integer1DSetArray, (CoordinateSystem)this.cSys3D, this.enUnits3D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Integer3DSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeGriddedNDSets(ArrayList arrayList) {
        Linear1DSet[] linear1DSetArray;
        RealTupleType realTupleType;
        FakeCoordinateSystem fakeCoordinateSystem;
        RealTupleType realTupleType2;
        Unit[] unitArray = new Unit[]{this.foot, this.pound, SI.second, CommonUnit.degree, CommonUnit.degree};
        RealType[] realTypeArray = new RealType[]{this.meHgt, this.meWgt, RealType.Time, RealType.Latitude, RealType.Longitude};
        try {
            realTupleType2 = new RealTupleType(realTypeArray);
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build temporary 5D tuple type");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            fakeCoordinateSystem = new FakeCoordinateSystem(realTupleType2, unitArray);
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build 5D coordinate system");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            realTupleType = new RealTupleType(realTypeArray, (CoordinateSystem)fakeCoordinateSystem, null);
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build 5D tuple type");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        double[] dArray = new double[]{1.0, 0.0, 2.0, 123.0, 42.0};
        double[] dArray2 = new double[]{2.0, 100.0, 16.0, 246.0, 49.0};
        int[] nArray = new int[]{3, 2, 3, 2, 3};
        ErrorEstimate[] errorEstimateArray = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot), new ErrorEstimate(0.56, 7.8, this.pound), new ErrorEstimate(0.9, 0.9, (Unit)SI.second), new ErrorEstimate(3.14, 1.59, CommonUnit.degree), new ErrorEstimate(5.2, 8.0, CommonUnit.degree)};
        try {
            linear1DSetArray = new Linear1DSet[]{new Linear1DSet(1.0, 2.0, 3), new Linear1DSet(0.0, 100.0, 2), new Linear1DSet(2.0, 16.4, 3), new Linear1DSet(123.0, 246.0, 2), new Linear1DSet(42.0, 49.0, 3)};
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Linear1DSet arguments for ND set tests");
            visADException.printStackTrace();
            linear1DSetArray = null;
        }
        try {
            arrayList.add(new LinearNDSet((MathType)realTupleType, dArray, dArray2, nArray));
            arrayList.add(new LinearNDSet((MathType)realTupleType, dArray, dArray2, nArray, fakeCoordinateSystem, unitArray, errorEstimateArray));
            arrayList.add(new LinearNDSet((MathType)realTupleType, linear1DSetArray));
            arrayList.add(new LinearNDSet((MathType)realTupleType, linear1DSetArray, (CoordinateSystem)fakeCoordinateSystem, unitArray, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build LinearNDSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
    }

    private void fakeIrregularSets(ArrayList arrayList) {
        ErrorEstimate[] errorEstimateArray;
        float[][] fArray;
        DelaunayFast delaunayFast;
        try {
            delaunayFast = new DelaunayFast(new float[][]{{1.0f, 2.0f, 3.0f}, {1.0f, 2.0f, 3.0f}});
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build DelaunayFast");
            visADException.printStackTrace();
            delaunayFast = null;
        }
        try {
            fArray = new float[][]{{1.23f, 4.56f, 7.89f}};
            errorEstimateArray = new ErrorEstimate[]{new ErrorEstimate(1.23, 0.04, this.foot)};
            arrayList.add(new IrregularSet((MathType)RealType.Altitude, fArray));
            arrayList.add(new IrregularSet(RealType.XAxis, fArray, delaunayFast));
            arrayList.add(new IrregularSet(this.tuple1D, fArray, 1, this.cSys1D, this.enUnits1D, errorEstimateArray, delaunayFast));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build IrregularSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new Irregular1DSet((MathType)RealTupleType.Time1DTuple, fArray));
            arrayList.add(new Irregular1DSet((MathType)this.tuple1D, fArray, (CoordinateSystem)this.cSys1D, this.enUnits1D, errorEstimateArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Irregular1DSet");
            visADException.printStackTrace();
            System.exit(1);
        }
        try {
            fArray = new float[][]{{1.23f, 4.56f, 7.89f}, {9.87f, 6.54f, 3.21f}};
            errorEstimateArray = new ErrorEstimate[]{new ErrorEstimate(4.56, 0.05, this.foot), new ErrorEstimate(7.89, 0.67, this.pound)};
            arrayList.add(new Irregular2DSet((MathType)RealTupleType.LatitudeLongitudeTuple, fArray));
            arrayList.add(new Irregular2DSet(this.tuple2D, fArray, this.cSys2D, this.enUnits2D, errorEstimateArray, delaunayFast));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Irregular2DSet");
            visADException.printStackTrace();
            System.exit(1);
        }
        try {
            fArray = new float[][]{{1.23f, 4.56f, 7.89f}, {9.87f, 6.54f, 3.21f}, {5.43f, 2.19f, 8.76f}};
            errorEstimateArray = new ErrorEstimate[]{new ErrorEstimate(4.56, 0.05, this.foot), new ErrorEstimate(7.89, 0.67, this.pound), new ErrorEstimate(1.23, 1.23, (Unit)SI.second)};
            arrayList.add(new Irregular3DSet((MathType)RealTupleType.SpatialEarth3DTuple, fArray));
            arrayList.add(new Irregular3DSet(this.tuple3D, fArray, this.cSys3D, this.enUnits3D, errorEstimateArray, delaunayFast));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Irregular3DSet");
            visADException.printStackTrace();
            System.exit(1);
        }
    }

    private void fakeSampledSets(ArrayList arrayList) {
        UnionSet unionSet;
        Linear1DSet linear1DSet;
        Real[] realArray;
        try {
            realArray = new Real[]{new Real(0.123), new Real(1.234)};
            arrayList.add(new SingletonSet(new RealTuple(realArray)));
            realArray = new Real[]{new Real(RealType.Time, 6.66), new Real(RealType.Time, 9.99, SI.second)};
            arrayList.add(new SingletonSet(new RealTuple(realArray)));
        }
        catch (RemoteException remoteException) {
            System.err.println("Couldn't build SingletonSet");
            remoteException.printStackTrace();
            System.exit(1);
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build SingletonSet");
            visADException.printStackTrace();
            System.exit(1);
        }
        try {
            realArray = new Integer1DSet(10);
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Integer1DSet for UnionSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            linear1DSet = new Linear1DSet(-15.0, 15.0, 10);
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build Linear1DSet for UnionSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        SampledSet[] sampledSetArray = new SampledSet[]{realArray, linear1DSet};
        try {
            arrayList.add(new UnionSet(sampledSetArray));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build UnionSet");
            visADException.printStackTrace();
            System.exit(1);
        }
        sampledSetArray = new SampledSet[2];
        int[] nArray = new int[]{3};
        try {
            sampledSetArray[0] = new GriddedSet(RealType.TimeInterval, new float[][]{{0.0f, 1.0f, 2.0f}}, nArray);
            sampledSetArray[1] = new GriddedSet(RealType.TimeInterval, new float[][]{{6.0f, 5.0f, 4.0f}}, nArray);
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build GriddedSets for ProductSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            unionSet = new UnionSet(sampledSetArray);
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build second UnionSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        arrayList.add(unionSet);
        try {
            arrayList.add(unionSet.product(sampledSetArray[0]));
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't get product of UnionSet");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        this.fakeGriddedSets(arrayList);
        this.fakeIrregularSets(arrayList);
    }

    private void fakeSets(ArrayList arrayList) {
        RealTupleType realTupleType;
        try {
            realTupleType = new RealTupleType(new RealType[]{this.meHgt}, (CoordinateSystem)this.cSys1D, null);
        }
        catch (VisADException visADException) {
            System.err.println("Couldn't build RealTupleType for height!");
            visADException.printStackTrace();
            System.exit(1);
            return;
        }
        try {
            arrayList.add(new DoubleSet(RealType.Time));
            arrayList.add(new FloatSet(realTupleType, this.cSys1D, null));
            arrayList.add(new FloatSet(realTupleType, this.cSys1D, new Unit[]{SI.meter}));
            arrayList.add(new FloatSet(RealType.XAxis));
            arrayList.add(new FloatSet(realTupleType, this.cSys1D, null));
            arrayList.add(new FloatSet(realTupleType, this.cSys1D, new Unit[]{SI.meter}));
            arrayList.add(new List1DSet(new float[]{1.1f, 2.2f, 3.3f}, realTupleType, this.cSys1D, null));
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        this.fakeSampledSets(arrayList);
    }

    private void fakeTuples(ArrayList arrayList) {
        TextType textType;
        try {
            textType = new TextType("Note");
        }
        catch (VisADException visADException) {
            textType = TextType.Generic;
        }
        MathType[] mathTypeArray = new MathType[]{RealType.Latitude, RealType.Longitude, textType};
        try {
            arrayList.add(new Tuple(new TupleType(mathTypeArray), new Data[]{new Real(RealType.Latitude, -60.0), new Real(RealType.Longitude, 60.0), new Text(textType, "Some text")}));
        }
        catch (RemoteException remoteException) {
        }
        catch (VisADException visADException) {
            // empty catch block
        }
        try {
            Real[] realArray = new Real[]{new Real(this.meHgt, 4.56), new Real(this.meWgt, 1.23)};
            arrayList.add(new RealTuple(this.tuple2D, realArray, this.cSys2D));
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
    }

    DataImpl[] getList() {
        ArrayList<Scalar> arrayList = new ArrayList<Scalar>();
        arrayList.add(new Text("g>a\"r&b<a'ge"));
        try {
            arrayList.add(new Text(new TextType("'Ru&de=>Ty<pe\"")));
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        arrayList.add(new Real(RealType.XAxis, 123.456));
        try {
            arrayList.add(new Real(RealType.Altitude, 123.456, (Unit)SI.meter, 43.21));
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        try {
            arrayList.add(new Real(RealType.TimeInterval, Double.NaN, (Unit)SI.second, 43.21));
        }
        catch (VisADException visADException) {
            visADException.printStackTrace();
        }
        this.fakeTuples(arrayList);
        this.fakeSets(arrayList);
        this.fakeFunctions(arrayList);
        DataImpl[] dataImplArray = new DataImpl[arrayList.size()];
        int n = 0;
        while (n < dataImplArray.length) {
            dataImplArray[n] = (DataImpl)arrayList.get(n);
            ++n;
        }
        return dataImplArray;
    }

    FakeData() throws VisADException {
        this.meHgt = RealType.getRealType("MetricHeight", (Unit)SI.meter, null);
        this.meWgt = RealType.getRealType("MetricWeight", (Unit)SI.kilogram, null);
        this.enUnits1D = new Unit[]{this.foot};
        this.cSys1D = new FakeCoordinateSystem(new RealTupleType(this.meHgt), this.enUnits1D);
        this.tuple1D = new RealTupleType(this.meHgt, (CoordinateSystem)this.cSys1D, null);
        this.enUnits2D = new Unit[]{this.foot, this.pound};
        this.cSys2D = new FakeCoordinateSystem(new RealTupleType(this.meHgt, this.meWgt), this.enUnits2D);
        this.tuple2D = new RealTupleType(this.meHgt, this.meWgt, this.cSys2D, null);
        this.enUnits3D = new Unit[]{this.foot, this.pound, SI.second};
        this.cSys3D = new FakeCoordinateSystem(new RealTupleType(this.meHgt, this.meWgt, RealType.Time), this.enUnits3D);
        this.tuple3D = new RealTupleType(this.meHgt, this.meWgt, RealType.Time, this.cSys3D, null);
    }
}

