/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Delaunay;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.List1DSet;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.BaseDataProcessor;
import visad.data.DataWriter;
import visad.data.visad.BinaryFile;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.object.BinaryFieldImpl;
import visad.data.visad.object.BinaryFlatField;
import visad.data.visad.object.BinaryGriddedDoubleSet;
import visad.data.visad.object.BinaryGriddedSet;
import visad.data.visad.object.BinaryIntegerSet;
import visad.data.visad.object.BinaryIrregularSet;
import visad.data.visad.object.BinaryLinearSet;
import visad.data.visad.object.BinaryList1DSet;
import visad.data.visad.object.BinaryObject;
import visad.data.visad.object.BinaryProductSet;
import visad.data.visad.object.BinaryReal;
import visad.data.visad.object.BinaryRealTuple;
import visad.data.visad.object.BinarySimpleSet;
import visad.data.visad.object.BinarySingletonSet;
import visad.data.visad.object.BinaryText;
import visad.data.visad.object.BinaryTuple;
import visad.data.visad.object.BinaryUnionSet;
import visad.data.visad.object.BinaryUnknown;

public class BinaryWriter
extends BaseDataProcessor
implements BinaryFile,
DataWriter {
    private boolean initialized;
    private DataOutputStream file;
    private BinaryObjectCache unitCache;
    private BinaryObjectCache errorCache;
    private BinaryObjectCache cSysCache;
    private BinaryObjectCache typeCache;
    private static /* synthetic */ Class class$Lvisad$DoubleSet;
    private static /* synthetic */ Class class$Lvisad$FloatSet;
    private static /* synthetic */ Class class$Lvisad$Gridded1DDoubleSet;
    private static /* synthetic */ Class class$Lvisad$Gridded2DDoubleSet;
    private static /* synthetic */ Class class$Lvisad$Gridded3DDoubleSet;
    private static /* synthetic */ Class class$Lvisad$Gridded1DSet;
    private static /* synthetic */ Class class$Lvisad$Gridded2DSet;
    private static /* synthetic */ Class class$Lvisad$Gridded3DSet;
    private static /* synthetic */ Class class$Lvisad$GriddedSet;
    private static /* synthetic */ Class class$Lvisad$Integer1DSet;
    private static /* synthetic */ Class class$Lvisad$Integer2DSet;
    private static /* synthetic */ Class class$Lvisad$Integer3DSet;
    private static /* synthetic */ Class class$Lvisad$IntegerNDSet;
    private static /* synthetic */ Class class$Lvisad$Irregular1DSet;
    private static /* synthetic */ Class class$Lvisad$Irregular2DSet;
    private static /* synthetic */ Class class$Lvisad$Irregular3DSet;
    private static /* synthetic */ Class class$Lvisad$IrregularSet;
    private static /* synthetic */ Class class$Lvisad$Linear1DSet;
    private static /* synthetic */ Class class$Lvisad$Linear2DSet;
    private static /* synthetic */ Class class$Lvisad$Linear3DSet;
    private static /* synthetic */ Class class$Lvisad$LinearLatLonSet;
    private static /* synthetic */ Class class$Lvisad$LinearNDSet;

    public void close() throws IOException {
        this.file.close();
        this.file = null;
    }

    public void flush() throws IOException {
        if (this.file == null) {
            throw new IOException("No active file");
        }
        this.file.flush();
    }

    public final BinaryObjectCache getCoordinateSystemCache() {
        return this.cSysCache;
    }

    public final BinaryObjectCache getErrorEstimateCache() {
        return this.errorCache;
    }

    public final DataOutputStream getOutputStream() {
        return this.file;
    }

    public final BinaryObjectCache getTypeCache() {
        return this.typeCache;
    }

    public final BinaryObjectCache getUnitCache() {
        return this.unitCache;
    }

    private final void initVars() {
        if (!this.initialized) {
            this.file = null;
        }
        this.unitCache = new BinaryObjectCache();
        this.errorCache = new BinaryObjectCache();
        this.cSysCache = new BinaryObjectCache();
        this.typeCache = new BinaryObjectCache();
    }

    public void processDoubleSet(SetType setType, CoordinateSystem coordinateSystem, Unit[] unitArray, DoubleSet doubleSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (doubleSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinarySimpleSet.write(this, setType, coordinateSystem, unitArray, doubleSet, class$Lvisad$DoubleSet != null ? class$Lvisad$DoubleSet : (class$Lvisad$DoubleSet = BinaryWriter.class$("visad.DoubleSet")), (byte)32, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + doubleSet.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processFieldImpl(FunctionType functionType, Set set, FieldImpl fieldImpl, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (fieldImpl == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryFieldImpl.write(this, functionType, set, fieldImpl, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + fieldImpl.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processFlatField(FunctionType functionType, Set set, CoordinateSystem coordinateSystem, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray, FlatField flatField, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (flatField == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryFlatField.write(this, functionType, set, coordinateSystem, coordinateSystemArray, setArray, unitArray, flatField, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + flatField.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processFloatSet(SetType setType, CoordinateSystem coordinateSystem, Unit[] unitArray, FloatSet floatSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (floatSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinarySimpleSet.write(this, setType, coordinateSystem, unitArray, floatSet, class$Lvisad$FloatSet != null ? class$Lvisad$FloatSet : (class$Lvisad$FloatSet = BinaryWriter.class$("visad.FloatSet")), (byte)33, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + floatSet.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processGridded1DDoubleSet(SetType setType, double[][] dArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded1DDoubleSet gridded1DDoubleSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (gridded1DDoubleSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedDoubleSet.write(this, setType, dArray, nArray, coordinateSystem, unitArray, errorEstimateArray, gridded1DDoubleSet, class$Lvisad$Gridded1DDoubleSet != null ? class$Lvisad$Gridded1DDoubleSet : (class$Lvisad$Gridded1DDoubleSet = BinaryWriter.class$("visad.Gridded1DDoubleSet")), (byte)47, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Gridded1DDoubleSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processGridded2DDoubleSet(SetType setType, double[][] dArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded2DDoubleSet gridded2DDoubleSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (gridded2DDoubleSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedDoubleSet.write(this, setType, dArray, nArray, coordinateSystem, unitArray, errorEstimateArray, gridded2DDoubleSet, class$Lvisad$Gridded2DDoubleSet != null ? class$Lvisad$Gridded2DDoubleSet : (class$Lvisad$Gridded2DDoubleSet = BinaryWriter.class$("visad.Gridded2DDoubleSet")), (byte)48, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Gridded2DDoubleSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processGridded3DDoubleSet(SetType setType, double[][] dArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded3DDoubleSet gridded3DDoubleSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (gridded3DDoubleSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedDoubleSet.write(this, setType, dArray, nArray, coordinateSystem, unitArray, errorEstimateArray, gridded3DDoubleSet, class$Lvisad$Gridded3DDoubleSet != null ? class$Lvisad$Gridded3DDoubleSet : (class$Lvisad$Gridded3DDoubleSet = BinaryWriter.class$("visad.Gridded3DDoubleSet")), (byte)49, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Gridded3DDoubleSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processGridded1DSet(SetType setType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded1DSet gridded1DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (gridded1DSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedSet.write(this, setType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, gridded1DSet, class$Lvisad$Gridded1DSet != null ? class$Lvisad$Gridded1DSet : (class$Lvisad$Gridded1DSet = BinaryWriter.class$("visad.Gridded1DSet")), (byte)44, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Gridded1DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processGridded2DSet(SetType setType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded2DSet gridded2DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (gridded2DSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedSet.write(this, setType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, gridded2DSet, class$Lvisad$Gridded2DSet != null ? class$Lvisad$Gridded2DSet : (class$Lvisad$Gridded2DSet = BinaryWriter.class$("visad.Gridded2DSet")), (byte)45, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Gridded2DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processGridded3DSet(SetType setType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded3DSet gridded3DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (gridded3DSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedSet.write(this, setType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, gridded3DSet, class$Lvisad$Gridded3DSet != null ? class$Lvisad$Gridded3DSet : (class$Lvisad$Gridded3DSet = BinaryWriter.class$("visad.Gridded3DSet")), (byte)46, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Gridded3DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processGriddedSet(SetType setType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, GriddedSet griddedSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (griddedSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryGriddedSet.write(this, setType, fArray, nArray, coordinateSystem, unitArray, errorEstimateArray, griddedSet, class$Lvisad$GriddedSet != null ? class$Lvisad$GriddedSet : (class$Lvisad$GriddedSet = BinaryWriter.class$("visad.GriddedSet")), (byte)43, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write GriddedSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processInteger1DSet(SetType setType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Integer1DSet integer1DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (integer1DSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryIntegerSet.write(this, setType, nArray, null, coordinateSystem, unitArray, errorEstimateArray, integer1DSet, class$Lvisad$Integer1DSet != null ? class$Lvisad$Integer1DSet : (class$Lvisad$Integer1DSet = BinaryWriter.class$("visad.Integer1DSet")), (byte)55, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Integer1DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processInteger2DSet(SetType setType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Integer2DSet integer2DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (integer2DSet == null) {
            throw new VisADException("Null data object");
        }
        Integer1DSet[] integer1DSetArray = BinaryIntegerSet.getComponents(integer2DSet);
        try {
            BinaryIntegerSet.write(this, setType, nArray, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray, integer2DSet, class$Lvisad$Integer2DSet != null ? class$Lvisad$Integer2DSet : (class$Lvisad$Integer2DSet = BinaryWriter.class$("visad.Integer2DSet")), (byte)56, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Integer2DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processInteger3DSet(SetType setType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Integer3DSet integer3DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (integer3DSet == null) {
            throw new VisADException("Null data object");
        }
        Integer1DSet[] integer1DSetArray = BinaryIntegerSet.getComponents(integer3DSet);
        try {
            BinaryIntegerSet.write(this, setType, nArray, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray, integer3DSet, class$Lvisad$Integer3DSet != null ? class$Lvisad$Integer3DSet : (class$Lvisad$Integer3DSet = BinaryWriter.class$("visad.Integer3DSet")), (byte)57, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Integer3DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processIntegerNDSet(SetType setType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, IntegerNDSet integerNDSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (integerNDSet == null) {
            throw new VisADException("Null data object");
        }
        Integer1DSet[] integer1DSetArray = BinaryIntegerSet.getComponents(integerNDSet);
        try {
            BinaryIntegerSet.write(this, setType, nArray, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray, integerNDSet, class$Lvisad$IntegerNDSet != null ? class$Lvisad$IntegerNDSet : (class$Lvisad$IntegerNDSet = BinaryWriter.class$("visad.IntegerNDSet")), (byte)58, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write IntegerNDSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processIrregular1DSet(SetType setType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Irregular1DSet irregular1DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (irregular1DSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryIrregularSet.write(this, setType, fArray, coordinateSystem, unitArray, errorEstimateArray, null, irregular1DSet, class$Lvisad$Irregular1DSet != null ? class$Lvisad$Irregular1DSet : (class$Lvisad$Irregular1DSet = BinaryWriter.class$("visad.Irregular1DSet")), (byte)40, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Irregular1DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processIrregular2DSet(SetType setType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, Irregular2DSet irregular2DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (irregular2DSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryIrregularSet.write(this, setType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay, irregular2DSet, class$Lvisad$Irregular2DSet != null ? class$Lvisad$Irregular2DSet : (class$Lvisad$Irregular2DSet = BinaryWriter.class$("visad.Irregular2DSet")), (byte)41, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Irregular2DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processIrregular3DSet(SetType setType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, Irregular3DSet irregular3DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (irregular3DSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryIrregularSet.write(this, setType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay, irregular3DSet, class$Lvisad$Irregular3DSet != null ? class$Lvisad$Irregular3DSet : (class$Lvisad$Irregular3DSet = BinaryWriter.class$("visad.Irregular3DSet")), (byte)42, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Irregular3DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processIrregularSet(SetType setType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, IrregularSet irregularSet, Object object) throws VisADException {
        try {
            BinaryIrregularSet.write(this, setType, fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay, irregularSet, class$Lvisad$IrregularSet != null ? class$Lvisad$IrregularSet : (class$Lvisad$IrregularSet = BinaryWriter.class$("visad.IrregularSet")), (byte)39, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write IrregularSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processLinear1DSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Linear1DSet linear1DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (linear1DSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryLinearSet.write(this, setType, dArray, dArray2, nArray, null, coordinateSystem, unitArray, errorEstimateArray, linear1DSet, class$Lvisad$Linear1DSet != null ? class$Lvisad$Linear1DSet : (class$Lvisad$Linear1DSet = BinaryWriter.class$("visad.Linear1DSet")), (byte)50, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Linear1DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processLinear2DSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Linear2DSet linear2DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (linear2DSet == null) {
            throw new VisADException("Null data object");
        }
        Linear1DSet[] linear1DSetArray = new Linear1DSet[2];
        int n = 0;
        while (n < linear1DSetArray.length) {
            linear1DSetArray[n] = linear2DSet.getLinear1DComponent(n);
            ++n;
        }
        try {
            BinaryLinearSet.write(this, setType, dArray, dArray2, nArray, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray, linear2DSet, class$Lvisad$Linear2DSet != null ? class$Lvisad$Linear2DSet : (class$Lvisad$Linear2DSet = BinaryWriter.class$("visad.Linear2DSet")), (byte)51, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Linear2DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processLinear3DSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Linear3DSet linear3DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (linear3DSet == null) {
            throw new VisADException("Null data object");
        }
        Linear1DSet[] linear1DSetArray = new Linear1DSet[3];
        int n = 0;
        while (n < linear1DSetArray.length) {
            linear1DSetArray[n] = linear3DSet.getLinear1DComponent(n);
            ++n;
        }
        try {
            BinaryLinearSet.write(this, setType, dArray, dArray2, nArray, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray, linear3DSet, class$Lvisad$Linear3DSet != null ? class$Lvisad$Linear3DSet : (class$Lvisad$Linear3DSet = BinaryWriter.class$("visad.Linear3DSet")), (byte)52, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Linear3DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processLinearLatLonSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, LinearLatLonSet linearLatLonSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (linearLatLonSet == null) {
            throw new VisADException("Null data object");
        }
        Linear1DSet[] linear1DSetArray = new Linear1DSet[2];
        int n = 0;
        while (n < linear1DSetArray.length) {
            linear1DSetArray[n] = linearLatLonSet.getLinear1DComponent(n);
            ++n;
        }
        try {
            BinaryLinearSet.write(this, setType, dArray, dArray2, nArray, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray, linearLatLonSet, class$Lvisad$LinearLatLonSet != null ? class$Lvisad$LinearLatLonSet : (class$Lvisad$LinearLatLonSet = BinaryWriter.class$("visad.LinearLatLonSet")), (byte)54, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write LinearLatLonSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processLinearNDSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, LinearNDSet linearNDSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (linearNDSet == null) {
            throw new VisADException("Null data object");
        }
        Linear1DSet[] linear1DSetArray = new Linear1DSet[linearNDSet.getDimension()];
        int n = 0;
        while (n < linear1DSetArray.length) {
            linear1DSetArray[n] = linearNDSet.getLinear1DComponent(n);
            ++n;
        }
        try {
            BinaryLinearSet.write(this, setType, dArray, dArray2, nArray, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray, linearNDSet, class$Lvisad$LinearNDSet != null ? class$Lvisad$LinearNDSet : (class$Lvisad$LinearNDSet = BinaryWriter.class$("visad.LinearNDSet")), (byte)53, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write LinearNDSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processList1DSet(SetType setType, float[] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, List1DSet list1DSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (list1DSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryList1DSet.write(this, setType, fArray, coordinateSystem, unitArray, list1DSet, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write List1DSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processProductSet(SetType setType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, ProductSet productSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (productSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryProductSet.write(this, setType, sampledSetArray, coordinateSystem, unitArray, errorEstimateArray, productSet, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + productSet.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processReal(RealType realType, double d, Unit unit, ErrorEstimate errorEstimate, Real real, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        try {
            BinaryReal.write(this, realType, d, unit, errorEstimate, real, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + real.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processRealTuple(RealTupleType realTupleType, Real[] realArray, CoordinateSystem coordinateSystem, RealTuple realTuple, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (realTuple == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryRealTuple.write(this, realTupleType, realArray, coordinateSystem, realTuple, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + realTuple.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processSampledSet(SetType setType, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, SampledSet sampledSet, Object object) throws VisADException {
        try {
            BinaryUnknown.write(this, sampledSet, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write SampledSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processSimpleSet(SetType setType, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, SimpleSet simpleSet, Object object) throws VisADException {
        try {
            BinaryUnknown.write(this, simpleSet, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write SimpleSet object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processSingletonSet(RealTuple realTuple, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, SingletonSet singletonSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (singletonSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinarySingletonSet.write(this, realTuple, coordinateSystem, unitArray, errorEstimateArray, singletonSet, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + singletonSet.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processText(TextType textType, String string, boolean bl, Text text, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        try {
            BinaryText.write(this, textType, string, bl, text, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + text.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processTuple(TupleType tupleType, Data[] dataArray, Tuple tuple, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (tuple == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryTuple.write(this, tupleType, dataArray, tuple, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + tuple.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processUnionSet(SetType setType, SampledSet[] sampledSetArray, UnionSet unionSet, Object object) throws VisADException {
        if (this.file == null) {
            throw new VisADException("No active file");
        }
        if (unionSet == null) {
            throw new VisADException("Null data object");
        }
        try {
            BinaryUnionSet.write(this, setType, sampledSetArray, unionSet, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write " + unionSet.getClass().getName() + ": " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void processUnknownData(DataImpl dataImpl, Object object) throws VisADException {
        try {
            BinaryUnknown.write(this, dataImpl, object);
        }
        catch (IOException iOException) {
            throw new VisADException("Couldn't write Data object: " + iOException.getClass().getName() + ": " + iOException.getMessage());
        }
    }

    public void save(DataImpl dataImpl) throws VisADException {
        this.save(dataImpl, false);
    }

    public void save(DataImpl dataImpl, boolean bl) throws VisADException {
        Object object = bl ? BinaryObject.SAVE_DEPEND_BIG : BinaryObject.SAVE_DEPEND;
        this.process(dataImpl, object);
        this.process(dataImpl, BinaryObject.SAVE_DATA);
    }

    public void setFile(String string) throws IOException {
        this.setFile(new File(string));
    }

    public void setFile(File file) throws IOException {
        this.setOutputStream(new FileOutputStream(file));
    }

    public void setOutputStream(OutputStream outputStream) throws IOException {
        if (this.file != null) {
            this.file.flush();
            this.file.close();
            this.file = null;
        }
        this.initVars();
        if (outputStream == null) {
            throw new IOException("Null OutputStream");
        }
        this.file = new DataOutputStream(new BufferedOutputStream(outputStream));
        this.file.writeBytes("VisADBin");
        this.file.writeInt(1);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public BinaryWriter() {
        this.file = null;
    }

    public BinaryWriter(String string) throws IOException {
        this(new File(string));
    }

    public BinaryWriter(File file) throws IOException {
        this(new BufferedOutputStream(new FileOutputStream(file)));
    }

    public BinaryWriter(OutputStream outputStream) throws IOException {
        this.setOutputStream(outputStream);
    }
}

