/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.Delaunay;
import visad.DoubleSet;
import visad.ErrorEstimate;
import visad.FieldImpl;
import visad.FlatField;
import visad.FloatSet;
import visad.FunctionType;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Gridded2DDoubleSet;
import visad.Gridded2DSet;
import visad.Gridded3DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Integer3DSet;
import visad.IntegerNDSet;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.IrregularSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.List1DSet;
import visad.ProductSet;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.SetType;
import visad.SimpleSet;
import visad.SingletonSet;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.UnionSet;
import visad.Unit;
import visad.VisADException;
import visad.data.BaseDataProcessor;
import visad.data.visad.object.BinaryFieldImpl;
import visad.data.visad.object.BinaryFlatField;
import visad.data.visad.object.BinaryGriddedDoubleSet;
import visad.data.visad.object.BinaryGriddedSet;
import visad.data.visad.object.BinaryIntegerSet;
import visad.data.visad.object.BinaryIrregularSet;
import visad.data.visad.object.BinaryLinearSet;
import visad.data.visad.object.BinaryList1DSet;
import visad.data.visad.object.BinaryProductSet;
import visad.data.visad.object.BinaryReal;
import visad.data.visad.object.BinaryRealTuple;
import visad.data.visad.object.BinarySimpleSet;
import visad.data.visad.object.BinarySingletonSet;
import visad.data.visad.object.BinarySize;
import visad.data.visad.object.BinaryText;
import visad.data.visad.object.BinaryTuple;
import visad.data.visad.object.BinaryUnionSet;
import visad.data.visad.object.BinaryUnknown;

public class BinarySizer
extends BaseDataProcessor {
    private BinarySize size = new BinarySize();

    public final int getSize() {
        return this.size.get();
    }

    public void processDoubleSet(SetType setType, CoordinateSystem coordinateSystem, Unit[] unitArray, DoubleSet doubleSet, Object object) throws VisADException {
        int n = BinarySimpleSet.computeBytes(coordinateSystem, unitArray);
        this.size.add(n);
    }

    public void processFieldImpl(FunctionType functionType, Set set, FieldImpl fieldImpl, Object object) throws VisADException {
        int n = BinaryFieldImpl.computeBytes(fieldImpl);
        this.size.add(n);
    }

    public void processFlatField(FunctionType functionType, Set set, CoordinateSystem coordinateSystem, CoordinateSystem[] coordinateSystemArray, Set[] setArray, Unit[] unitArray, FlatField flatField, Object object) throws VisADException {
        int n = BinaryFlatField.computeBytes(set, coordinateSystem, coordinateSystemArray, setArray, unitArray, flatField);
        this.size.add(n);
    }

    public void processFloatSet(SetType setType, CoordinateSystem coordinateSystem, Unit[] unitArray, FloatSet floatSet, Object object) throws VisADException {
        int n = BinarySimpleSet.computeBytes(coordinateSystem, unitArray);
        this.size.add(n);
    }

    public void processGridded1DDoubleSet(SetType setType, double[][] dArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded1DDoubleSet gridded1DDoubleSet, Object object) throws VisADException {
        int n = BinaryGriddedDoubleSet.computeBytes(dArray, nArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processGridded2DDoubleSet(SetType setType, double[][] dArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded2DDoubleSet gridded2DDoubleSet, Object object) throws VisADException {
        int n = BinaryGriddedDoubleSet.computeBytes(dArray, nArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processGridded3DDoubleSet(SetType setType, double[][] dArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded3DDoubleSet gridded3DDoubleSet, Object object) throws VisADException {
        int n = BinaryGriddedDoubleSet.computeBytes(dArray, nArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processGridded1DSet(SetType setType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded1DSet gridded1DSet, Object object) throws VisADException {
        int n = BinaryGriddedSet.computeBytes(fArray, nArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processGridded2DSet(SetType setType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded2DSet gridded2DSet, Object object) throws VisADException {
        int n = BinaryGriddedSet.computeBytes(fArray, nArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processGridded3DSet(SetType setType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Gridded3DSet gridded3DSet, Object object) throws VisADException {
        int n = BinaryGriddedSet.computeBytes(fArray, nArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processGriddedSet(SetType setType, float[][] fArray, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, GriddedSet griddedSet, Object object) throws VisADException {
        int n = BinaryGriddedSet.computeBytes(fArray, nArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processInteger1DSet(SetType setType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Integer1DSet integer1DSet, Object object) throws VisADException {
        int n = BinaryIntegerSet.computeBytes(true, nArray, null, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processInteger2DSet(SetType setType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Integer2DSet integer2DSet, Object object) throws VisADException {
        Integer1DSet[] integer1DSetArray = BinaryIntegerSet.getComponents(integer2DSet);
        boolean bl = BinaryIntegerSet.hasMatchedTypes(setType, integer1DSetArray);
        int n = BinaryIntegerSet.computeBytes(bl, nArray, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processInteger3DSet(SetType setType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Integer3DSet integer3DSet, Object object) throws VisADException {
        Integer1DSet[] integer1DSetArray = BinaryIntegerSet.getComponents(integer3DSet);
        boolean bl = BinaryIntegerSet.hasMatchedTypes(setType, integer1DSetArray);
        int n = BinaryIntegerSet.computeBytes(bl, nArray, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processIntegerNDSet(SetType setType, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, IntegerNDSet integerNDSet, Object object) throws VisADException {
        Integer1DSet[] integer1DSetArray = BinaryIntegerSet.getComponents(integerNDSet);
        boolean bl = BinaryIntegerSet.hasMatchedTypes(setType, integer1DSetArray);
        int n = BinaryIntegerSet.computeBytes(bl, nArray, integer1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processIrregular1DSet(SetType setType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Irregular1DSet irregular1DSet, Object object) throws VisADException {
        int n = BinaryIrregularSet.computeBytes(fArray, coordinateSystem, unitArray, errorEstimateArray, null);
        this.size.add(n);
    }

    public void processIrregular2DSet(SetType setType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, Irregular2DSet irregular2DSet, Object object) throws VisADException {
        int n = BinaryIrregularSet.computeBytes(fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay);
        this.size.add(n);
    }

    public void processIrregular3DSet(SetType setType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, Irregular3DSet irregular3DSet, Object object) throws VisADException {
        int n = BinaryIrregularSet.computeBytes(fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay);
        this.size.add(n);
    }

    public void processIrregularSet(SetType setType, float[][] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Delaunay delaunay, IrregularSet irregularSet, Object object) throws VisADException {
        int n = BinaryIrregularSet.computeBytes(fArray, coordinateSystem, unitArray, errorEstimateArray, delaunay);
        this.size.add(n);
    }

    public void processLinear1DSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Linear1DSet linear1DSet, Object object) throws VisADException {
        int n = BinaryLinearSet.computeBytes(true, dArray, dArray2, nArray, null, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processLinear2DSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Linear2DSet linear2DSet, Object object) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[2];
        boolean bl = false;
        while (bl < linear1DSetArray.length) {
            linear1DSetArray[bl] = linear2DSet.getLinear1DComponent(bl ? 1 : 0);
            bl += 1;
        }
        bl = BinaryLinearSet.hasMatchedTypes(setType, linear1DSetArray);
        int n = BinaryLinearSet.computeBytes(bl, dArray, dArray2, nArray, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processLinear3DSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, Linear3DSet linear3DSet, Object object) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[3];
        boolean bl = false;
        while (bl < linear1DSetArray.length) {
            linear1DSetArray[bl] = linear3DSet.getLinear1DComponent(bl ? 1 : 0);
            bl += 1;
        }
        bl = BinaryLinearSet.hasMatchedTypes(setType, linear1DSetArray);
        int n = BinaryLinearSet.computeBytes(bl, dArray, dArray2, nArray, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processLinearLatLonSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, LinearLatLonSet linearLatLonSet, Object object) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[2];
        boolean bl = false;
        while (bl < linear1DSetArray.length) {
            linear1DSetArray[bl] = linearLatLonSet.getLinear1DComponent(bl ? 1 : 0);
            bl += 1;
        }
        bl = BinaryLinearSet.hasMatchedTypes(setType, linear1DSetArray);
        int n = BinaryLinearSet.computeBytes(bl, dArray, dArray2, nArray, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processLinearNDSet(SetType setType, double[] dArray, double[] dArray2, int[] nArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, LinearNDSet linearNDSet, Object object) throws VisADException {
        Linear1DSet[] linear1DSetArray = new Linear1DSet[linearNDSet.getDimension()];
        boolean bl = false;
        while (bl < linear1DSetArray.length) {
            linear1DSetArray[bl] = linearNDSet.getLinear1DComponent(bl ? 1 : 0);
            bl += 1;
        }
        bl = BinaryLinearSet.hasMatchedTypes(setType, linear1DSetArray);
        int n = BinaryLinearSet.computeBytes(bl, dArray, dArray2, nArray, linear1DSetArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processList1DSet(SetType setType, float[] fArray, CoordinateSystem coordinateSystem, Unit[] unitArray, List1DSet list1DSet, Object object) throws VisADException {
        int n = BinaryList1DSet.computeBytes(fArray, coordinateSystem, unitArray);
        this.size.add(n);
    }

    public void processProductSet(SetType setType, SampledSet[] sampledSetArray, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, ProductSet productSet, Object object) throws VisADException {
        int n = BinaryProductSet.computeBytes(sampledSetArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processReal(RealType realType, double d, Unit unit, ErrorEstimate errorEstimate, Real real, Object object) throws VisADException {
        int n = BinaryReal.computeBytes(unit, errorEstimate);
        this.size.add(n);
    }

    public void processRealTuple(RealTupleType realTupleType, Real[] realArray, CoordinateSystem coordinateSystem, RealTuple realTuple, Object object) throws VisADException {
        boolean bl = BinaryRealTuple.isTrivialTuple(realTupleType, realArray);
        int n = BinaryRealTuple.computeBytes(realArray, coordinateSystem, bl);
        this.size.add(n);
    }

    public void processSampledSet(SetType setType, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, SampledSet sampledSet, Object object) throws VisADException {
        throw new UnimplementedException();
    }

    public void processSimpleSet(SetType setType, int n, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, SimpleSet simpleSet, Object object) throws VisADException {
        int n2 = BinarySimpleSet.computeBytes(coordinateSystem, unitArray);
        this.size.add(n2);
    }

    public void processSingletonSet(RealTuple realTuple, CoordinateSystem coordinateSystem, Unit[] unitArray, ErrorEstimate[] errorEstimateArray, SingletonSet singletonSet, Object object) throws VisADException {
        RealTupleType realTupleType = (RealTupleType)realTuple.getType();
        Real[] realArray = BinarySingletonSet.getSampleReals(realTuple);
        int n = BinarySingletonSet.computeBytes(realTupleType, realArray, coordinateSystem, unitArray, errorEstimateArray);
        this.size.add(n);
    }

    public void processText(TextType textType, String string, boolean bl, Text text, Object object) throws VisADException {
        int n = BinaryText.computeBytes(string);
        this.size.add(n);
    }

    public void processTuple(TupleType tupleType, Data[] dataArray, Tuple tuple, Object object) throws VisADException {
        int n = BinaryTuple.computeBytes(dataArray);
        this.size.add(n);
    }

    public void processUnionSet(SetType setType, SampledSet[] sampledSetArray, UnionSet unionSet, Object object) throws VisADException {
        int n = BinaryUnionSet.computeBytes(sampledSetArray);
        this.size.add(n);
    }

    public void processUnknownData(DataImpl dataImpl, Object object) throws VisADException {
        int n = BinaryUnknown.computeBytes(dataImpl);
        this.size.add(n);
    }

    public final void reset() {
        this.size.reset();
    }

    public final void setSize(int n) {
        this.size.set(n);
    }
}

