/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import ucar.netcdf.RandomAccessFile;
import visad.DataImpl;
import visad.VisADException;
import visad.data.visad.BinaryFile;
import visad.data.visad.BinaryObjectCache;
import visad.data.visad.object.BinaryCoordinateSystem;
import visad.data.visad.object.BinaryErrorEstimate;
import visad.data.visad.object.BinaryFieldImpl;
import visad.data.visad.object.BinaryFlatField;
import visad.data.visad.object.BinaryGriddedDoubleSet;
import visad.data.visad.object.BinaryGriddedSet;
import visad.data.visad.object.BinaryIntegerSet;
import visad.data.visad.object.BinaryIrregularSet;
import visad.data.visad.object.BinaryLinearSet;
import visad.data.visad.object.BinaryList1DSet;
import visad.data.visad.object.BinaryMathType;
import visad.data.visad.object.BinaryProductSet;
import visad.data.visad.object.BinaryReal;
import visad.data.visad.object.BinaryRealTuple;
import visad.data.visad.object.BinarySerializedObject;
import visad.data.visad.object.BinarySimpleSet;
import visad.data.visad.object.BinarySingletonSet;
import visad.data.visad.object.BinaryText;
import visad.data.visad.object.BinaryTuple;
import visad.data.visad.object.BinaryUnionSet;
import visad.data.visad.object.BinaryUnit;

public class BinaryReader
implements BinaryFile {
    private DataInput file;
    private boolean isRandom;
    private int version;
    private BinaryObjectCache unitCache;
    private BinaryObjectCache errorCache;
    private BinaryObjectCache cSysCache;
    private BinaryObjectCache typeCache;

    private int checkMagic(DataInput dataInput) throws IOException {
        int n = BinaryReader.readMagic(dataInput);
        if (n < 1) {
            throw new IOException("File is not in VisAD binary format");
        }
        if (n > 1) {
            throw new IOException("Don't understand VisAD Binary format version " + n);
        }
        return n;
    }

    public void close() throws IOException {
        if (this.file instanceof InputStream) {
            ((InputStream)((Object)this.file)).close();
        } else if (this.file instanceof java.io.RandomAccessFile) {
            ((java.io.RandomAccessFile)this.file).close();
        } else if (this.file instanceof RandomAccessFile) {
            ((RandomAccessFile)this.file).close();
        } else {
            throw new IOException("Unknown file class \"" + this.file.getClass().getName() + "\"");
        }
    }

    public DataImpl getData() throws IOException, VisADException {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        l7 = System.currentTimeMillis();
        DataImpl dataImpl = null;
        while (dataImpl == null) {
            byte by;
            try {
                by = this.file.readByte();
            }
            catch (EOFException eOFException) {
                break;
            }
            long l8 = System.currentTimeMillis();
            switch (by) {
                case 1: {
                    BinaryCoordinateSystem.read(this);
                    break;
                }
                case 2: {
                    dataImpl = this.readData();
                    break;
                }
                case 3: {
                    dataImpl = (DataImpl)BinarySerializedObject.read(this.file);
                    break;
                }
                case 4: {
                    BinaryErrorEstimate.read(this);
                    break;
                }
                case 5: {
                    BinaryMathType.read(this);
                    break;
                }
                case 7: {
                    BinaryUnit.read(this);
                    break;
                }
                default: {
                    throw new IOException("Unknown directive " + by);
                }
            }
        }
        return dataImpl;
    }

    public final BinaryObjectCache getCoordinateSystemCache() {
        return this.cSysCache;
    }

    public final BinaryObjectCache getErrorEstimateCache() {
        return this.errorCache;
    }

    public final long getFilePointer() throws IOException {
        if (this.file instanceof java.io.RandomAccessFile) {
            return ((java.io.RandomAccessFile)this.file).getFilePointer();
        }
        if (this.file instanceof RandomAccessFile) {
            return ((RandomAccessFile)this.file).getFilePointer();
        }
        return -1L;
    }

    public final DataInput getInput() {
        return this.file;
    }

    public final BinaryObjectCache getTypeCache() {
        return this.typeCache;
    }

    public final BinaryObjectCache getUnitCache() {
        return this.unitCache;
    }

    public static boolean isMagic(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            return BinaryReader.readMagic(dataInputStream) <= 1;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public final boolean isRandom() {
        return this.isRandom;
    }

    public DataImpl readData() throws IOException, VisADException {
        DataImpl dataImpl;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        long l10 = 0L;
        long l11 = 0L;
        long l12 = 0L;
        long l13 = 0L;
        long l14 = 0L;
        long l15 = 0L;
        long l16 = 0L;
        long l17 = 0L;
        long l18 = 0L;
        long l19 = 0L;
        long l20 = 0L;
        long l21 = 0L;
        long l22 = 0L;
        long l23 = 0L;
        long l24 = 0L;
        long l25 = 0L;
        long l26 = 0L;
        long l27 = 0L;
        long l28 = 0L;
        long l29 = 0L;
        long l30 = 0L;
        long l31 = 0L;
        long l32 = 0L;
        long l33 = 0L;
        l5 = System.currentTimeMillis();
        int n = this.file.readInt();
        byte by = this.file.readByte();
        long l34 = System.currentTimeMillis();
        switch (by) {
            case 32: {
                dataImpl = BinarySimpleSet.read(this, by);
                break;
            }
            case 20: {
                dataImpl = BinaryFieldImpl.read(this);
                break;
            }
            case 21: {
                dataImpl = BinaryFlatField.read(this, n - 6, this.isRandom());
                break;
            }
            case 33: {
                dataImpl = BinarySimpleSet.read(this, by);
                break;
            }
            case 47: {
                dataImpl = BinaryGriddedDoubleSet.read(this, by);
                break;
            }
            case 48: {
                dataImpl = BinaryGriddedDoubleSet.read(this, by);
                break;
            }
            case 49: {
                dataImpl = BinaryGriddedDoubleSet.read(this, by);
                break;
            }
            case 43: {
                dataImpl = BinaryGriddedSet.read(this, by);
                break;
            }
            case 44: {
                dataImpl = BinaryGriddedSet.read(this, by);
                break;
            }
            case 45: {
                dataImpl = BinaryGriddedSet.read(this, by);
                break;
            }
            case 46: {
                dataImpl = BinaryGriddedSet.read(this, by);
                break;
            }
            case 55: {
                dataImpl = BinaryIntegerSet.read(this, by);
                break;
            }
            case 56: {
                dataImpl = BinaryIntegerSet.read(this, by);
                break;
            }
            case 57: {
                dataImpl = BinaryIntegerSet.read(this, by);
                break;
            }
            case 58: {
                dataImpl = BinaryIntegerSet.read(this, by);
                break;
            }
            case 40: {
                dataImpl = BinaryIrregularSet.read(this, by);
                break;
            }
            case 41: {
                dataImpl = BinaryIrregularSet.read(this, by);
                break;
            }
            case 42: {
                dataImpl = BinaryIrregularSet.read(this, by);
                break;
            }
            case 39: {
                dataImpl = BinaryIrregularSet.read(this, by);
                break;
            }
            case 50: {
                dataImpl = BinaryLinearSet.read(this, by);
                break;
            }
            case 51: {
                dataImpl = BinaryLinearSet.read(this, by);
                break;
            }
            case 52: {
                dataImpl = BinaryLinearSet.read(this, by);
                break;
            }
            case 53: {
                dataImpl = BinaryLinearSet.read(this, by);
                break;
            }
            case 54: {
                dataImpl = BinaryLinearSet.read(this, by);
                break;
            }
            case 34: {
                dataImpl = BinaryList1DSet.read(this);
                break;
            }
            case 60: {
                dataImpl = null;
                break;
            }
            case 38: {
                dataImpl = BinaryProductSet.read(this);
                break;
            }
            case 3: {
                dataImpl = BinaryReal.read(this);
                break;
            }
            case 11: {
                dataImpl = BinaryRealTuple.read(this);
                break;
            }
            case 36: {
                dataImpl = BinarySingletonSet.read(this);
                break;
            }
            case 2: {
                dataImpl = BinaryText.read(this);
                break;
            }
            case 10: {
                dataImpl = BinaryTuple.read(this);
                break;
            }
            case 37: {
                dataImpl = BinaryUnionSet.read(this);
                break;
            }
            default: {
                throw new IOException("Unknown Data type " + by);
            }
        }
        return dataImpl;
    }

    private static final int readMagic(DataInput dataInput) throws IOException {
        byte[] byArray = "VisADBin".getBytes();
        try {
            int n = 0;
            while (n < byArray.length) {
                if (dataInput.readByte() != byArray[n]) {
                    return -1;
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            return -1;
        }
        try {
            return dataInput.readInt();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public final void seek(long l) throws IOException {
        if (this.file instanceof java.io.RandomAccessFile) {
            ((java.io.RandomAccessFile)this.file).seek(l);
        } else if (this.file instanceof RandomAccessFile) {
            ((RandomAccessFile)this.file).seek(l);
        } else {
            throw new IOException("Seek not supported for " + this.file.getClass().getName());
        }
    }

    public BinaryReader(String string) throws IOException {
        this(new File(string));
    }

    public BinaryReader(File file) throws IOException {
        this(new FileInputStream(file));
    }

    public BinaryReader(InputStream inputStream) throws IOException {
        this.file = new DataInputStream(new BufferedInputStream(inputStream));
        this.isRandom = false;
        this.version = this.checkMagic(this.file);
        this.unitCache = new BinaryObjectCache();
        this.errorCache = new BinaryObjectCache();
        this.cSysCache = new BinaryObjectCache();
        this.typeCache = new BinaryObjectCache();
    }

    public BinaryReader(java.io.RandomAccessFile randomAccessFile) throws IOException {
        this.file = randomAccessFile;
        this.isRandom = true;
        this.version = this.checkMagic(this.file);
        this.unitCache = new BinaryObjectCache();
        this.errorCache = new BinaryObjectCache();
        this.cSysCache = new BinaryObjectCache();
        this.typeCache = new BinaryObjectCache();
    }

    public BinaryReader(RandomAccessFile randomAccessFile) throws IOException {
        this.file = randomAccessFile;
        this.isRandom = true;
        this.version = this.checkMagic(this.file);
        this.unitCache = new BinaryObjectCache();
        this.errorCache = new BinaryObjectCache();
        this.cSysCache = new BinaryObjectCache();
        this.typeCache = new BinaryObjectCache();
    }
}

