/*
 * Decompiled with CFR 0.152.
 */
package visad.data.vis5d;

import visad.CommonUnit;
import visad.CoordinateSystem;
import visad.Gridded1DSet;
import visad.IdentityCoordinateSystem;
import visad.Linear1DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public class Vis5DVerticalSystem {
    private static int counter = 0;
    private final int vert_sys;
    private int n_levels;
    private double[] vert_args;
    Unit vert_unit = null;
    SampledSet vertSet;
    RealType vert_type;
    CoordinateSystem vert_cs;
    RealTupleType reference;

    private RealType makeRealType(String string, Unit unit) throws VisADException {
        RealType realType = null;
        realType = RealType.getRealType(string, unit);
        if (realType == null && (realType = RealType.getRealType(string + "_" + counter++, unit)) == null) {
            throw new VisADException("Unable to create a unique RealType named " + string + " with unit " + unit);
        }
        return realType;
    }

    public Vis5DVerticalSystem(int n, int n2, double[] dArray) throws VisADException {
        this.vert_sys = n;
        this.vert_args = dArray;
        this.n_levels = n2;
        switch (n) {
            case 0: {
                this.vert_unit = CommonUnit.promiscuous;
                this.vert_type = this.makeRealType("Height", this.vert_unit);
                this.reference = new RealTupleType(RealType.Generic);
                this.vert_cs = new IdentityCoordinateSystem(this.reference);
                break;
            }
            case 1: 
            case 2: {
                try {
                    this.vert_unit = Parser.parse("km");
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this.vert_type = this.makeRealType("Height", this.vert_unit);
                this.reference = new RealTupleType(RealType.Altitude);
                this.vert_cs = new IdentityCoordinateSystem(this.reference);
                break;
            }
            case 3: {
                try {
                    this.vert_unit = Parser.parse("mbar");
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                this.vert_type = this.makeRealType("Pressure", this.vert_unit);
                this.reference = new RealTupleType(RealType.Altitude);
                this.vert_cs = new Vis5DVerticalCoordinateSystem();
                break;
            }
            default: {
                throw new VisADException("vert_sys unknown");
            }
        }
        switch (n) {
            case 0: 
            case 1: {
                double d = dArray[0];
                double d2 = d + dArray[1] * (double)(n2 - 1);
                this.vertSet = new Linear1DSet((MathType)this.vert_type, d, d2, n2, null, new Unit[]{this.vert_unit}, null);
                break;
            }
            case 2: {
                double[][] dArray2 = new double[1][n2];
                System.arraycopy(dArray, 0, dArray2[0], 0, n2);
                this.vertSet = new Gridded1DSet((MathType)this.vert_type, Set.doubleToFloat(dArray2), n2, null, new Unit[]{this.vert_unit}, null);
                break;
            }
            case 3: {
                double[][] dArray3 = new double[1][n2];
                System.arraycopy(dArray, 0, dArray3[0], 0, n2);
                int n3 = 0;
                while (n3 < n2) {
                    double[] dArray4 = dArray3[0];
                    int n4 = n3++;
                    dArray4[n4] = dArray4[n4] * 1000.0;
                }
                dArray3 = this.vert_cs.fromReference(dArray3);
                this.vertSet = new Gridded1DSet((MathType)this.vert_type, Set.doubleToFloat(dArray3), n2, null, new Unit[]{this.vert_unit}, null);
                break;
            }
            default: {
                throw new VisADException("vert_sys unknown");
            }
        }
    }

    public static class Vis5DVerticalCoordinateSystem
    extends CoordinateSystem {
        private static final double DEFAULT_LOG_SCALE = 1012.5;
        private static final double DEFAULT_LOG_EXP = -7.2;
        private static Unit[] csUnits;

        public double[][] toReference(double[][] dArray) throws VisADException {
            int n = dArray[0].length;
            double[][] dArray2 = new double[1][n];
            int n2 = 0;
            while (n2 < n) {
                dArray2[0][n2] = -7.2 * Math.log(dArray[0][n2] / 1012.5) * 1000.0;
                ++n2;
            }
            return dArray2;
        }

        public double[][] fromReference(double[][] dArray) throws VisADException {
            int n = dArray[0].length;
            double[][] dArray2 = new double[1][n];
            int n2 = 0;
            while (n2 < n) {
                dArray2[0][n2] = 1012.5 * Math.exp(dArray[0][n2] / 1000.0 / -7.2);
                ++n2;
            }
            return dArray2;
        }

        public boolean equals(Object object) {
            return object instanceof Vis5DVerticalCoordinateSystem;
        }

        public Vis5DVerticalCoordinateSystem() throws VisADException {
            super(new RealTupleType(RealType.Altitude), csUnits);
        }

        static {
            try {
                csUnits = new Unit[]{Parser.parse("mbar")};
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
    }
}

