/*
 * Decompiled with CFR 0.152.
 */
package visad.data.vis5d;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import visad.AnimationControl;
import visad.CachingCoordinateSystem;
import visad.CartesianProductCoordinateSystem;
import visad.CellImpl;
import visad.ContourControl;
import visad.CoordinateSystem;
import visad.Data;
import visad.DataImpl;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Gridded1DDoubleSet;
import visad.Gridded3DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.Integer2DSet;
import visad.Linear1DSet;
import visad.Linear3DSet;
import visad.MathType;
import visad.OffsetUnit;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.data.units.UnitParser;
import visad.data.vis5d.V5DStruct;
import visad.data.vis5d.Vis5DAdaptedForm;
import visad.data.vis5d.Vis5DCoordinateSystem;
import visad.data.vis5d.Vis5DFile;
import visad.data.vis5d.Vis5DVerticalSystem;
import visad.java3d.DisplayImplJ3D;
import visad.jmet.DumpType;
import visad.util.VisADSlider;

public class Vis5DForm
extends Form
implements FormFileInformer {
    private static int num = 0;
    private static boolean loaded = false;
    public static int WIDTH = 800;
    public static int HEIGHT = 600;
    private final int MAXVARS;
    private final int MAXTIMES;
    private final int MAXROWS;
    private final int MAXCOLUMNS;
    private final int MAXLEVELS;
    private final int MAXPROJARGS;
    private final int MAXVERTARGS;

    public boolean isThisType(String string) {
        return string.endsWith(".v5d");
    }

    public boolean isThisType(byte[] byArray) {
        String string = new String(byArray, 0, 3);
        return string.equals("V5D");
    }

    public String[] getDefaultSuffixes() {
        String[] stringArray = new String[]{"v5d"};
        return stringArray;
    }

    public synchronized void save(String string, Data data, boolean bl) throws BadFormException, IOException, RemoteException, VisADException {
        throw new UnimplementedException("Vis5DForm.save");
    }

    public synchronized void add(String string, Data data, boolean bl) throws BadFormException {
        throw new BadFormException("Vis5DForm.add");
    }

    public synchronized DataImpl open(String string) throws BadFormException, IOException, VisADException {
        int n;
        int n2;
        Object object;
        MathType[] mathTypeArray;
        Object object2;
        int n3;
        int n4;
        Vis5DFile[][] vis5DFileArray;
        Serializable serializable;
        Object object3;
        if (string == null) {
            throw new BadFormException("Vis5DForm.open: null name String");
        }
        byte[] byArray = string.getBytes();
        int[] nArray = new int[5];
        int[] nArray2 = new int[1];
        String[] stringArray = new String[30];
        String[] stringArray2 = new String[30];
        int[] nArray3 = new int[30];
        int[] nArray4 = new int[1];
        float[] fArray = new float[101];
        double[] dArray = new double[400];
        float[] fArray2 = new float[100];
        V5DStruct v5DStruct = V5DStruct.v5d_open(byArray, byArray.length, nArray, nArray3, stringArray, stringArray2, nArray2, fArray2, nArray4, fArray, dArray);
        if (nArray[0] < 1) {
            throw new BadFormException("Vis5DForm.open: bad file");
        }
        int n5 = nArray[0];
        int n6 = nArray[1];
        int n7 = nArray[2];
        int n8 = nArray[3];
        int n9 = nArray[4];
        RealType realType = RealType.Time;
        RealType realType2 = RealType.getRealType("row");
        RealType realType3 = RealType.getRealType("col");
        RealType[] realTypeArray = new RealType[n9];
        int n10 = 0;
        while (n10 < n9) {
            object3 = stringArray2[n10];
            serializable = null;
            if (object3 != null) {
                try {
                    serializable = Parser.parse((String)object3);
                }
                catch (ParseException parseException) {
                    System.out.println(parseException.getMessage());
                }
            }
            realTypeArray[n10] = RealType.getRealType(stringArray[n10], serializable);
            if (realTypeArray[n10] == null) {
                realTypeArray[n10] = RealType.getRealType("var" + n10);
            }
            ++n10;
        }
        double[][] dArray2 = Set.floatToDouble(new float[][]{fArray2});
        object3 = Set.floatToDouble(new float[][]{fArray});
        serializable = new Vis5DCoordinateSystem(nArray2[0], dArray2[0], n5, n6);
        Vis5DVerticalSystem vis5DVerticalSystem = null;
        Hashtable<Integer, Object> hashtable = new Hashtable<Integer, Object>();
        int n11 = 0;
        while (n11 < n9) {
            hashtable.put(new Integer(nArray3[n11]), new Object());
            ++n11;
        }
        n11 = hashtable.size();
        if (n11 > 2) {
            throw new BadFormException("more than two variable groups by n_levels");
        }
        if (n11 == 0) {
            throw new BadFormException("n_var_groups == 0");
        }
        RealType[][] realTypeArray2 = new RealType[n11][];
        RealType[] realTypeArray3 = new RealType[n9];
        int[][] nArray5 = new int[n11][];
        int[] nArray6 = new int[n9];
        int[] nArray7 = new int[n11];
        Enumeration enumeration = hashtable.keys();
        int n12 = 0;
        while (n12 < n11) {
            vis5DFileArray = (Vis5DFile[][])enumeration.nextElement();
            n4 = 0;
            n3 = 0;
            while (n3 < n9) {
                if (nArray3[n3] == vis5DFileArray.intValue()) {
                    realTypeArray3[n4] = realTypeArray[n3];
                    nArray6[n4] = n3;
                    ++n4;
                }
                ++n3;
            }
            realTypeArray2[n12] = new RealType[n4];
            System.arraycopy(realTypeArray3, 0, realTypeArray2[n12], 0, n4);
            nArray5[n12] = new int[n4];
            System.arraycopy(nArray6, 0, nArray5[n12], 0, n4);
            nArray7[n12] = vis5DFileArray.intValue();
            ++n12;
        }
        FunctionType[][] functionTypeArray = new FunctionType[n11][];
        vis5DFileArray = new Vis5DFile[n11][];
        n4 = 0;
        n3 = 0;
        while (n3 < n11) {
            int n13;
            GriddedSet griddedSet;
            RealTupleType realTupleType;
            MathType mathType;
            object2 = realTypeArray2[n3];
            mathTypeArray = (MathType[])nArray5[n3];
            n7 = nArray7[n3];
            if (n7 > 1) {
                vis5DVerticalSystem = new Vis5DVerticalSystem(nArray4[0], n7, (double[])object3[0]);
                mathType = vis5DVerticalSystem.vert_type;
                CachingCoordinateSystem cachingCoordinateSystem = new CachingCoordinateSystem(new CartesianProductCoordinateSystem(new CoordinateSystem[]{serializable, vis5DVerticalSystem.vert_cs}));
                realTupleType = new RealTupleType(new RealType[]{realType2, realType3, mathType}, (CoordinateSystem)cachingCoordinateSystem, null);
                SampledSet sampledSet = vis5DVerticalSystem.vertSet;
                if (sampledSet instanceof Linear1DSet) {
                    griddedSet = new Linear3DSet((MathType)realTupleType, new Linear1DSet[]{new Integer1DSet((MathType)realType2, n5), new Integer1DSet((MathType)realType3, n6), (Linear1DSet)sampledSet}, null, new Unit[]{null, null, vis5DVerticalSystem.vert_unit}, null);
                } else {
                    float[][] fArray3 = sampledSet.getSamples();
                    object = new float[3][n5 * n6 * n7];
                    int n14 = 0;
                    n2 = 0;
                    while (n2 < n7) {
                        int n15 = 0;
                        while (n15 < n6) {
                            n = 0;
                            while (n < n5) {
                                object[0][n14] = (float)n;
                                object[1][n14] = (float)n15;
                                object[2][n14] = fArray3[0][n2];
                                ++n14;
                                ++n;
                            }
                            ++n15;
                        }
                        ++n2;
                    }
                    griddedSet = new Gridded3DSet((MathType)realTupleType, (float[][])object, n5, n6, n7, null, new Unit[]{null, null, vis5DVerticalSystem.vert_unit}, null);
                }
                functionTypeArray[n3] = new FunctionType[((RealType[])object2).length];
                vis5DFileArray[n3] = new Vis5DFile[((RealType[])object2).length];
                n13 = n5 * n6 * n7;
                int n16 = 0;
                while (n16 < ((RealType[])object2).length) {
                    functionTypeArray[n3][n16] = new FunctionType(realTupleType, object2[n16]);
                    vis5DFileArray[n3][n16] = new Vis5DFile(string, v5DStruct, griddedSet, functionTypeArray[n3][n16], new RealType[]{object2[n16]}, new int[]{(int)mathTypeArray[n16]}, n13);
                    ++n16;
                }
                n4 += functionTypeArray[n3].length;
            } else {
                realTupleType = new RealTupleType(new RealType[]{realType2, realType3}, (CoordinateSystem)new CachingCoordinateSystem((CoordinateSystem)serializable), null);
                griddedSet = new Integer2DSet((MathType)realTupleType, n5, n6);
                functionTypeArray[n3] = new FunctionType[1];
                vis5DFileArray[n3] = new Vis5DFile[1];
                mathType = new RealTupleType((RealType[])object2);
                functionTypeArray[n3][0] = new FunctionType(realTupleType, mathType);
                n13 = n5 * n6 * n7;
                vis5DFileArray[n3][0] = new Vis5DFile(string, v5DStruct, griddedSet, functionTypeArray[n3][0], (RealType[])object2, (int[])mathTypeArray, n13);
                n4 += functionTypeArray[n3].length;
            }
            ++n3;
        }
        RealTupleType realTupleType = new RealTupleType(realType);
        mathTypeArray = new MathType[n4];
        int n17 = 0;
        int n18 = 0;
        while (n18 < functionTypeArray.length) {
            int n19 = 0;
            while (n19 < functionTypeArray[n18].length) {
                mathTypeArray[n17++] = functionTypeArray[n18][n19];
                ++n19;
            }
            ++n18;
        }
        object2 = mathTypeArray.length == 1 ? mathTypeArray[0] : new TupleType(mathTypeArray);
        FunctionType functionType = new FunctionType(realTupleType, (MathType)object2);
        double[][] dArray3 = new double[1][n8];
        int n20 = 0;
        while (n20 < n8) {
            dArray3[0][n20] = dArray[n20];
            ++n20;
        }
        OffsetUnit offsetUnit = new OffsetUnit(UnitParser.encodeTimestamp(1900, 1, 1, 0, 0, 0.0f, 0), SI.second);
        Gridded1DDoubleSet gridded1DDoubleSet = new Gridded1DDoubleSet((MathType)realType, dArray3, n8, null, new Unit[]{offsetUnit}, null);
        object = new FieldImpl(functionType, gridded1DDoubleSet);
        n2 = 0;
        while (n2 < n8) {
            DataImpl dataImpl;
            if (mathTypeArray.length == 1) {
                dataImpl = this.getFlatField(vis5DFileArray[0][0], n2);
            } else {
                Data[] dataArray = new DataImpl[mathTypeArray.length];
                n17 = 0;
                n = 0;
                while (n < vis5DFileArray.length) {
                    int n21 = 0;
                    while (n21 < vis5DFileArray[n].length) {
                        dataArray[n17++] = this.getFlatField(vis5DFileArray[n][n21], n2);
                        ++n21;
                    }
                    ++n;
                }
                dataImpl = new Tuple(dataArray, false);
            }
            ((FieldImpl)object).setSample(n2, (Data)dataImpl, false);
            ++n2;
        }
        return object;
    }

    public FlatField getFlatField(Vis5DFile vis5DFile, int n) throws VisADException, IOException, BadFormException {
        return Vis5DForm.makeFlatField(vis5DFile, n);
    }

    public static FlatField makeFlatField(Vis5DFile vis5DFile, int n) throws VisADException, IOException, BadFormException {
        int n2 = vis5DFile.nvars;
        int n3 = vis5DFile.grid_size;
        FunctionType functionType = vis5DFile.grid_type;
        Set set = vis5DFile.space_set;
        V5DStruct v5DStruct = vis5DFile.vv;
        RealType[] realTypeArray = vis5DFile.vars;
        int[] nArray = vis5DFile.vars_indexes;
        float[][] fArray = new float[n2][n3];
        Linear1DSet[] linear1DSetArray = new Linear1DSet[n2];
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            int n6;
            int n7;
            int n8;
            float[] fArray2 = new float[2];
            v5DStruct.v5d_read(n, nArray[n4], fArray2, fArray[n4]);
            if ((double)fArray2[0] >= 9.9E29 && (double)fArray2[1] <= -9.9E29) {
                linear1DSetArray[n4] = new Linear1DSet(0.0, 1.0, 255);
            } else {
                if (fArray2[0] > fArray2[1]) {
                    throw new BadFormException("Vis5DForm.open: bad read " + realTypeArray[n4].getName());
                }
                linear1DSetArray[n4] = new Linear1DSet(fArray2[0], fArray2[1], 255);
            }
            float[] fArray3 = new float[n3];
            int[] nArray2 = ((GriddedSet)set).getLengths();
            if (nArray2.length == 2) {
                n8 = 0;
                n7 = 0;
                while (n7 < nArray2[1]) {
                    n6 = (n7 + 1) * nArray2[0] - 1;
                    n5 = 0;
                    while (n5 < nArray2[0]) {
                        fArray3[n8++] = fArray[n4][n6--];
                        ++n5;
                    }
                    ++n7;
                }
            } else if (nArray2.length == 3) {
                n8 = 0;
                n7 = 0;
                while (n7 < nArray2[2]) {
                    n6 = 0;
                    while (n6 < nArray2[1]) {
                        n5 = (n6 + 1) * nArray2[0] - 1 + nArray2[0] * nArray2[1] * n7;
                        int n9 = 0;
                        while (n9 < nArray2[0]) {
                            fArray3[n8++] = fArray[n4][n5--];
                            ++n9;
                        }
                        ++n6;
                    }
                    ++n7;
                }
            }
            System.arraycopy(fArray3, 0, fArray[n4], 0, n3);
            fArray3 = null;
            n8 = 0;
            while (n8 < n3) {
                if ((double)fArray[n4][n8] > 5.0E34) {
                    fArray[n4][n8] = Float.NaN;
                }
                ++n8;
            }
            ++n4;
        }
        FlatField flatField = new FlatField(functionType, set);
        flatField.setSamples(fArray, false);
        return flatField;
    }

    public synchronized DataImpl open(URL uRL) throws BadFormException, VisADException, IOException {
        throw new UnimplementedException("Vis5DForm.open(URL url)");
    }

    public synchronized FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        int n;
        Object object;
        Object object2;
        if (stringArray == null || stringArray.length < 1) {
            System.out.println("run 'java visad.data.vis5d.Vis5DForm file.v5d'");
        }
        Vis5DAdaptedForm vis5DAdaptedForm = new Vis5DAdaptedForm();
        FieldImpl fieldImpl = null;
        try {
            fieldImpl = (FieldImpl)vis5DAdaptedForm.open(stringArray[0]);
            DumpType.dumpMathType(fieldImpl.getType());
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
        if (fieldImpl == null) {
            System.out.println("bad Vis5D file read");
            return;
        }
        FunctionType functionType = (FunctionType)fieldImpl.getType();
        FieldImpl fieldImpl2 = functionType.getRange() instanceof TupleType ? fieldImpl : fieldImpl;
        FunctionType functionType2 = (FunctionType)fieldImpl2.getType();
        System.out.println(functionType2);
        DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("vis5d_ref");
        dataReferenceImpl.setData(fieldImpl2);
        JFrame jFrame = new JFrame("Vis5D");
        WindowAdapter windowAdapter = new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        jFrame.addWindowListener(windowAdapter);
        ((Component)jFrame).setSize(WIDTH, HEIGHT);
        ((Component)jFrame).setCursor(Cursor.getPredefinedCursor(0));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setLocation(dimension.width / 2 - WIDTH / 2, dimension.height / 2 - HEIGHT / 2);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setAlignmentY(0.0f);
        jPanel.setAlignmentX(0.0f);
        jFrame.getContentPane().add(jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentY(0.0f);
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
        jPanel2.add(new JLabel("Simple Vis5D File Viewer using VisAD - See:"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  http://www.ssec.wisc.edu/~billh/visad.html"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("for more information about VisAD."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Space Science and Engineering Center"));
        jPanel2.add(new JLabel("University of Wisconsin - Madison"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Move sliders to adjust iso-surface levels"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Click Animate button to toggle animation"));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("Rotate scenes with left mouse button."));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  "));
        jPanel2.add(new JLabel("  "));
        JPanel jPanel3 = new JPanel();
        jPanel3.setName("GoesRetrieval Sliders");
        jPanel3.setFont(new Font("Dialog", 0, 12));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.setAlignmentY(0.0f);
        jPanel3.setAlignmentX(0.0f);
        jPanel2.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jPanel4.setAlignmentY(0.0f);
        jPanel4.setAlignmentX(0.0f);
        jPanel.add(jPanel4);
        DisplayImplJ3D displayImplJ3D = new DisplayImplJ3D("image display");
        GraphicsModeControl graphicsModeControl = ((DisplayImpl)displayImplJ3D).getGraphicsModeControl();
        graphicsModeControl.setScaleEnable(true);
        jPanel4.add(displayImplJ3D.getComponent());
        RealType realType = (RealType)functionType2.getDomain().getComponent(0);
        ScalarMap scalarMap = new ScalarMap(realType, Display.Animation);
        displayImplJ3D.addMap(scalarMap);
        AnimationControl animationControl = (AnimationControl)((Object)scalarMap.getControl());
        displayImplJ3D.addMap(new ScalarMap(RealType.Latitude, Display.YAxis));
        displayImplJ3D.addMap(new ScalarMap(RealType.Longitude, Display.XAxis));
        displayImplJ3D.addMap(new ScalarMap(RealType.Altitude, Display.ZAxis));
        int n2 = 0;
        MathType mathType = functionType2.getRange();
        RealType[] realTypeArray = new RealType[200];
        if (mathType instanceof TupleType) {
            int n3 = 0;
            while (n3 < ((TupleType)mathType).getDimension()) {
                object2 = (FunctionType)((TupleType)mathType).getComponent(n3);
                object = ((FunctionType)object2).getRange();
                if (object instanceof TupleType) {
                    int n4 = ((TupleType)object).getDimension();
                    int n5 = 0;
                    while (n5 < n4) {
                        realTypeArray[n2++] = (RealType)((TupleType)object).getComponent(n5);
                        ++n5;
                    }
                } else {
                    realTypeArray[n2++] = (RealType)object;
                }
                ++n3;
            }
        } else {
            MathType mathType2 = ((FunctionType)mathType).getRange();
            if (mathType2 instanceof TupleType) {
                int n6 = ((TupleType)mathType2).getDimension();
                int n7 = 0;
                while (n7 < n6) {
                    realTypeArray[n2++] = (RealType)((TupleType)mathType2).getComponent(n7);
                    ++n7;
                }
            } else {
                realTypeArray[n2++] = (RealType)mathType2;
            }
        }
        int n8 = n2;
        object2 = new RealType[n8];
        object = new ScalarMap[n8];
        ContourControl[] contourControlArray = new ContourControl[n8];
        DataReferenceImpl[] dataReferenceImplArray = new DataReferenceImpl[n8];
        int n9 = 0;
        while (n9 < n8) {
            object2[n9] = realTypeArray[n9];
            object[n9] = new ScalarMap((ScalarType)object2[n9], Display.IsoContour);
            displayImplJ3D.addMap(object[n9]);
            contourControlArray[n9] = (ContourControl)object[n9].getControl();
            contourControlArray[n9].enableContours(false);
            dataReferenceImplArray[n9] = new DataReferenceImpl(((ScalarType)object2[n9]).getName() + "_ref");
            ++n9;
        }
        displayImplJ3D.addReference(dataReferenceImpl);
        n9 = 0;
        double[][] dArray = new double[n8][];
        block8: while (n9 == 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            n9 = 1;
            n = 0;
            while (n < n8) {
                dArray[n] = object[n].getRange();
                if (dArray[n][0] != dArray[n][0] || dArray[n][1] != dArray[n][1]) {
                    n9 = 0;
                    continue block8;
                }
                ++n;
            }
        }
        n = 0;
        while (n < n8) {
            double d = (dArray[n][1] - dArray[n][0]) / 255.0;
            int n10 = (int)(dArray[n][0] / d);
            int n11 = (int)(dArray[n][1] / d);
            dataReferenceImplArray[n].setData(new Real((RealType)object2[n], d * (double)n10));
            jPanel3.add(new VisADSlider(((ScalarType)object2[n]).getName(), n10, n11, n10, d, dataReferenceImplArray[n], (RealType)object2[n]));
            jPanel3.add(new JLabel("  "));
            Vis5DAdaptedForm vis5DAdaptedForm2 = vis5DAdaptedForm;
            if (vis5DAdaptedForm2 == null) {
                throw null;
            }
            ContourCell contourCell = vis5DAdaptedForm2.new ContourCell(contourControlArray[n], dataReferenceImplArray[n]);
            contourCell.addReference(dataReferenceImplArray[n]);
            ++n;
        }
        JToggleButton jToggleButton = new JToggleButton("Animate", false);
        jToggleButton.addChangeListener(new ChangeListener(jToggleButton, animationControl){
            private final /* synthetic */ JToggleButton val$button;
            private final /* synthetic */ AnimationControl val$animation_control;

            public void stateChanged(ChangeEvent changeEvent) {
                try {
                    boolean bl = this.val$button.getModel().isSelected();
                    this.val$animation_control.setOn(bl);
                }
                catch (VisADException visADException) {
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            {
                this.val$button = jToggleButton;
                this.val$animation_control = animationControl;
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        });
        jPanel3.add(jToggleButton);
        ((Component)jFrame).setVisible(true);
    }

    public Vis5DForm() {
        super("Vis5DForm" + num++);
        this.MAXVARS = 30;
        this.MAXTIMES = 400;
        this.MAXROWS = 300;
        this.MAXCOLUMNS = 300;
        this.MAXLEVELS = 100;
        this.MAXPROJARGS = 100;
        this.MAXVERTARGS = 101;
    }

    class ContourCell
    extends CellImpl {
        ContourControl control;
        DataReference ref;
        double value;

        public void doAction() throws VisADException, RemoteException {
            double d = ((Real)this.ref.getData()).getValue();
            if (d == d && d != this.value) {
                this.control.setSurfaceValue((float)((Real)this.ref.getData()).getValue());
                this.control.enableContours(true);
                this.value = d;
            }
        }

        ContourCell(ContourControl contourControl, DataReference dataReference) throws VisADException, RemoteException {
            this.control = contourControl;
            this.ref = dataReference;
            this.value = ((Real)this.ref.getData()).getValue();
        }
    }
}

