/*
 * Decompiled with CFR 0.152.
 */
package visad.data.vis5d;

import visad.CoordinateSystem;
import visad.RealTupleType;
import visad.Unit;
import visad.VisADException;

public class Vis5DCoordinateSystem
extends CoordinateSystem {
    private static final int PROJ_GENERIC = 0;
    private static final int PROJ_LINEAR = 1;
    private static final int PROJ_CYLINDRICAL = 20;
    private static final int PROJ_SPHERICAL = 21;
    private static final int PROJ_LAMBERT = 2;
    private static final int PROJ_STEREO = 3;
    private static final int PROJ_ROTATED = 4;
    private static final double RADIUS = 6371.23;
    private static final double WEST_POSITIVE = -1.0;
    private static Unit[] coordinate_system_units = new Unit[]{null, null};
    private int Projection;
    int REVERSE_POLES = 1;
    double NorthBound;
    double SouthBound;
    double WestBound;
    double EastBound;
    double RowInc;
    double ColInc;
    double Lat1;
    double Lat2;
    double PoleRow;
    double PoleCol;
    double CentralLat;
    double CentralLon;
    double CentralRow;
    double CentralCol;
    double Rotation;
    double Cone;
    double Hemisphere;
    double ConeFactor;
    double CosCentralLat;
    double SinCentralLat;
    double StereoScale;
    double InvScale;
    double CylinderScale;
    double Nr;
    double Nc;

    public double[][] toReference(double[][] dArray) throws VisADException {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        switch (this.Projection) {
            case 0: 
            case 1: 
            case 20: 
            case 21: {
                int n2 = 0;
                while (n2 < n) {
                    dArray2[0][n2] = this.NorthBound - (this.Nr - 1.0 - dArray[0][n2]) * (this.NorthBound - this.SouthBound) / (this.Nr - 1.0);
                    dArray2[1][n2] = this.WestBound - dArray[1][n2] * (this.WestBound - this.EastBound) / (this.Nc - 1.0);
                    double[] dArray3 = dArray2[1];
                    int n3 = n2++;
                    dArray3[n3] = dArray3[n3] * -1.0;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < n) {
                    double d;
                    double d2 = this.Hemisphere * (this.Nr - 1.0 - dArray[0][n4] - this.PoleRow) / this.ConeFactor;
                    double d3 = (this.PoleCol - dArray[1][n4]) / this.ConeFactor;
                    double d4 = d2 == 0.0 && d3 == 0.0 ? 0.0 : Math.atan2(d3, d2);
                    double d5 = d4 / this.Cone * 57.29577951308232 + this.CentralLon;
                    if (d5 > 180.0) {
                        d5 -= 360.0;
                    }
                    double d6 = (d = Math.sqrt(d2 * d2 + d3 * d3)) < 1.0E-4 ? 90.0 * this.Hemisphere : this.Hemisphere * (90.0 - 2.0 * Math.atan(Math.exp(Math.log(d) / this.Cone)) * 57.29577951308232);
                    dArray2[0][n4] = d6;
                    dArray2[1][n4] = -1.0 * d5;
                    ++n4;
                }
                break;
            }
            case 3: {
                int n5 = 0;
                while (n5 < n) {
                    double d;
                    double d7;
                    double d8 = this.CentralRow - (this.Nr - 1.0 - dArray[0][n5]) - 1.0;
                    double d9 = this.CentralCol - dArray[1][n5] - 1.0;
                    double d10 = d8 * d8 + d9 * d9;
                    if (d10 < 1.0E-20) {
                        d7 = this.CentralLat;
                        d = this.CentralLon;
                    } else {
                        d10 = Math.sqrt(d10);
                        double d11 = 2.0 * Math.atan(d10 * this.InvScale);
                        double d12 = Math.cos(d11);
                        double d13 = Math.sin(d11);
                        d7 = 57.29577951308232 * Math.asin(d12 * this.SinCentralLat + d8 * d13 * this.CosCentralLat / d10);
                        d = this.CentralLon + 57.29577951308232 * Math.atan2(d9 * d13, d10 * this.CosCentralLat * d12 - d8 * this.SinCentralLat * d13);
                        if (d < -180.0) {
                            d += 360.0;
                        } else if (d > 180.0) {
                            d -= 360.0;
                        }
                    }
                    dArray2[0][n5] = d7;
                    dArray2[1][n5] = -1.0 * d;
                    ++n5;
                }
                break;
            }
            case 4: {
                int n6 = 0;
                while (n6 < n) {
                    dArray2[0][n6] = this.NorthBound - (this.Nr - 1.0 - dArray[0][n6]) * (this.NorthBound - this.SouthBound) / (this.Nr - 1.0);
                    dArray2[1][n6] = this.WestBound - dArray[0][n6] * (this.WestBound - this.EastBound) / (this.Nc - 1.0);
                    ++n6;
                }
                Vis5DCoordinateSystem.pandg_back(dArray2, this.CentralLat, this.CentralLon, this.Rotation);
                break;
            }
            default: {
                throw new VisADException("projection unknown");
            }
        }
        return dArray2;
    }

    public double[][] fromReference(double[][] dArray) throws VisADException {
        int n = dArray[0].length;
        double[][] dArray2 = new double[2][n];
        switch (this.Projection) {
            case 0: 
            case 1: 
            case 20: 
            case 21: {
                int n2 = 0;
                while (n2 < n) {
                    dArray2[0][n2] = (this.NorthBound - dArray[0][n2]) / this.RowInc;
                    dArray2[0][n2] = this.Nr - 1.0 - dArray2[0][n2];
                    dArray2[1][n2] = (this.WestBound - dArray[1][n2] * -1.0) / this.ColInc;
                    ++n2;
                }
                break;
            }
            case 2: {
                int n3 = 0;
                while (n3 < n) {
                    double d;
                    double d2 = dArray[0][n3];
                    double d3 = dArray[1][n3] * -1.0;
                    double d4 = d3 - this.CentralLon;
                    d4 = d4 * this.Cone * (Math.PI / 180);
                    if (d2 < -85.0) {
                        d = 10000.0;
                    } else {
                        double d5 = (90.0 - this.Hemisphere * d2) * (Math.PI / 180) * 0.5;
                        d = this.ConeFactor * Math.pow(Math.tan(d5), this.Cone);
                    }
                    dArray2[0][n3] = this.PoleRow + d * Math.cos(d4);
                    dArray2[0][n3] = this.Nr - 1.0 - dArray2[0][n3];
                    dArray2[1][n3] = this.PoleCol - d * Math.sin(d4);
                    ++n3;
                }
                break;
            }
            case 3: {
                int n4 = 0;
                while (n4 < n) {
                    double d = dArray[0][n4];
                    double d6 = dArray[1][n4] * -1.0;
                    double d7 = Math.PI / 180 * d;
                    double d8 = Math.PI / 180 * (this.CentralLon - d6);
                    double d9 = Math.cos(d8);
                    double d10 = Math.cos(d7);
                    double d11 = this.StereoScale / (1.0 + this.SinCentralLat * Math.sin(d7) + this.CosCentralLat * d10 * d9);
                    dArray2[1][n4] = this.CentralCol - 1.0 + d11 * d10 * Math.sin(d8);
                    dArray2[0][n4] = this.CentralRow - 1.0 - d11 * (this.CosCentralLat * Math.sin(d7) - this.SinCentralLat * d10 * d9);
                    dArray2[0][n4] = this.Nr - 1.0 - dArray2[0][n4];
                    ++n4;
                }
                break;
            }
            case 4: {
                Vis5DCoordinateSystem.pandg_for(dArray, this.CentralLat, this.CentralLon, this.Rotation);
                int n5 = 0;
                while (n5 < n) {
                    dArray2[0][n5] = (this.NorthBound - dArray[0][n5]) / this.RowInc;
                    dArray2[0][n5] = this.Nr - 1.0 - dArray2[0][n5];
                    dArray2[1][n5] = (this.WestBound - dArray[1][n5]) / this.ColInc;
                    ++n5;
                }
                break;
            }
            default: {
                throw new VisADException("Projection unknown");
            }
        }
        return dArray2;
    }

    private static void pandg_back(double[][] dArray, double d, double d2, double d3) {
        int n = 0;
        while (n < dArray[0].length) {
            double d4 = Math.PI / 180 * dArray[0][n];
            double d5 = -Math.PI / 180 * dArray[1][n];
            double d6 = Math.asin(Math.cos(d4) * Math.cos(d5));
            double d7 = Math.atan2(Math.cos(d4) * Math.sin(d5), -Math.sin(d4));
            dArray[0][n] = 57.29577951308232 * Math.asin(Math.sin(d) * Math.sin(d6) - Math.cos(d) * Math.cos(d6) * Math.cos(d7 - d3));
            dArray[1][n] = -57.29577951308232 * (-d2 + Math.atan2(Math.cos(d6) * Math.sin(d7 - d3), Math.sin(d) * Math.cos(d6) * Math.cos(d7 - d3) + Math.cos(d) * Math.sin(d6)));
            double[] dArray2 = dArray[1];
            int n2 = n++;
            dArray2[n2] = dArray2[n2] * -1.0;
        }
    }

    private static void pandg_for(double[][] dArray, double d, double d2, double d3) {
        int n = 0;
        while (n < dArray[0].length) {
            double d4 = Math.PI / 180 * dArray[0][n];
            double d5 = -Math.PI / 180 * dArray[1][n] * -1.0;
            double d6 = Math.asin(Math.sin(d) * Math.sin(d4) + Math.cos(d) * Math.cos(d4) * Math.cos(d5 + d2));
            double d7 = d3 + Math.atan2(Math.cos(d4) * Math.sin(d5 + d2), Math.sin(d) * Math.cos(d4) * Math.cos(d5 + d2) - Math.cos(d) * Math.sin(d4));
            dArray[0][n] = 57.29577951308232 * Math.asin(-Math.cos(d6) * Math.cos(d7));
            dArray[1][n] = -57.29577951308232 * Math.atan2(Math.cos(d6) * Math.sin(d7), Math.sin(d6));
            ++n;
        }
    }

    private static boolean sign(double d) {
        return !(d < 0.0);
    }

    public boolean equals(Object object) {
        return object instanceof Vis5DCoordinateSystem;
    }

    public static void main(String[] stringArray) throws VisADException {
        int n = 3;
        double[] dArray = new double[]{90.0, 100.0, 50.0, 50.0, 100.0};
        Vis5DCoordinateSystem vis5DCoordinateSystem = new Vis5DCoordinateSystem(n, dArray, 100.0, 100.0);
        double[][] dArray2 = new double[][]{{89.0, 42.0, 60.0}, {-100.0, -100.0, -180.0}};
        double[][] dArray3 = vis5DCoordinateSystem.fromReference(dArray2);
        double[][] dArray4 = vis5DCoordinateSystem.toReference(dArray3);
        System.out.println(dArray4[0][0] + ", " + dArray4[1][0] + " : " + dArray4[0][2] + ", " + dArray4[1][2]);
        n = 2;
        double[] dArray5 = new double[]{60.0, 30.0, 0.0, 50.0, 100.0, 100.0};
        vis5DCoordinateSystem = new Vis5DCoordinateSystem(n, dArray5, 100.0, 100.0);
        double[][] dArray6 = new double[][]{{90.0, 40.0, 50.0}, {-100.0, -100.0, -180.0}};
        dArray3 = vis5DCoordinateSystem.fromReference(dArray6);
        dArray4 = vis5DCoordinateSystem.toReference(dArray3);
        System.out.println(dArray4[0][0] + ", " + dArray4[1][0] + " : " + dArray4[0][2] + ", " + dArray4[1][2]);
    }

    public Vis5DCoordinateSystem(int n, double[] dArray, double d, double d2) throws VisADException {
        super(RealTupleType.LatitudeLongitudeTuple, coordinate_system_units);
        this.Projection = n;
        this.Nr = d;
        this.Nc = d2;
        switch (n) {
            case 0: 
            case 1: 
            case 20: 
            case 21: {
                this.NorthBound = dArray[0];
                this.WestBound = dArray[1];
                this.RowInc = dArray[2];
                this.ColInc = dArray[3];
                break;
            }
            case 4: {
                this.NorthBound = dArray[0];
                this.WestBound = dArray[1];
                this.RowInc = dArray[2];
                this.ColInc = dArray[3];
                this.CentralLat = Math.PI / 180 * dArray[4];
                this.CentralLon = Math.PI / 180 * dArray[5];
                this.Rotation = Math.PI / 180 * dArray[6];
                break;
            }
            case 2: {
                this.Lat1 = dArray[0];
                this.Lat2 = dArray[1];
                this.PoleRow = dArray[2];
                this.PoleCol = dArray[3];
                this.CentralLon = dArray[4];
                this.ColInc = dArray[5];
                break;
            }
            case 3: {
                this.CentralLat = dArray[0];
                this.CentralLon = dArray[1];
                this.CentralRow = dArray[2];
                this.CentralCol = dArray[3];
                this.ColInc = dArray[4];
                break;
            }
            default: {
                throw new VisADException("Projection unknown");
            }
        }
        switch (n) {
            case 0: 
            case 1: {
                this.SouthBound = this.NorthBound - this.RowInc * (d - 1.0);
                this.EastBound = this.WestBound - this.ColInc * (d2 - 1.0);
                break;
            }
            case 2: {
                double d3;
                if (this.Lat1 == this.Lat2) {
                    d3 = this.Lat1 > 0.0 ? (90.0 - this.Lat1) * (Math.PI / 180) : (90.0 + this.Lat1) * (Math.PI / 180);
                    this.Cone = Math.cos(d3);
                    this.Hemisphere = 1.0;
                } else {
                    if (Vis5DCoordinateSystem.sign(this.Lat1) != Vis5DCoordinateSystem.sign(this.Lat2)) {
                        throw new VisADException("Error: standard latitudes must have the same sign.\n");
                    }
                    if (this.Lat1 < this.Lat2) {
                        throw new VisADException("Error: Lat1 must be >= Lat2\n");
                    }
                    this.Hemisphere = 1.0;
                    d3 = (90.0 - this.Lat1) * (Math.PI / 180);
                    double d4 = (90.0 - this.Lat2) * (Math.PI / 180);
                    double d5 = Math.log(Math.sin(d3)) - Math.log(Math.sin(d4));
                    double d6 = Math.log(Math.tan(d3 / 2.0)) - Math.log(Math.tan(d4 / 2.0));
                    this.Cone = d5 / d6;
                }
                this.ConeFactor = 6371.23 * Math.sin(d3) / (this.ColInc * this.Cone * Math.pow(Math.tan(d3 / 2.0), this.Cone));
                break;
            }
            case 3: {
                this.CosCentralLat = Math.cos(this.CentralLat * (Math.PI / 180));
                this.SinCentralLat = Math.sin(this.CentralLat * (Math.PI / 180));
                this.StereoScale = 12742.46 / this.ColInc;
                this.InvScale = 1.0 / this.StereoScale;
                break;
            }
            case 4: {
                this.SouthBound = this.NorthBound - this.RowInc * (d - 1.0);
                this.EastBound = this.WestBound - this.ColInc * (d2 - 1.0);
                break;
            }
            case 20: {
                this.CylinderScale = this.REVERSE_POLES == -1 ? 1.0 / (-1.0 * (-90.0 - this.NorthBound)) : 1.0 / (90.0 - this.SouthBound);
                this.SouthBound = this.NorthBound - this.RowInc * (d - 1.0);
                this.EastBound = this.WestBound - this.ColInc * (d2 - 1.0);
                break;
            }
            case 21: {
                this.SouthBound = this.NorthBound - this.RowInc * (d - 1.0);
                this.EastBound = this.WestBound - this.ColInc * (d2 - 1.0);
                break;
            }
        }
        if (n != 0) {
            if (this.SouthBound < -90.0) {
                throw new VisADException("SouthBound less than -90.0");
            }
            if (this.NorthBound < this.SouthBound) {
                throw new VisADException("NorthBound less than SouthBound");
            }
            if (90.0 < this.NorthBound) {
                throw new VisADException("NorthBound greater than 90.0");
            }
        }
    }
}

