/*
 * Decompiled with CFR 0.152.
 */
package visad.data.vis5d;

import java.io.IOException;
import java.io.RandomAccessFile;
import visad.data.BadFormException;

public class V5DStruct {
    private static final int MBS = 32;
    private static final String TOPOFILE = "EARTH.TOPO";
    private static final String WORLDFILE = "OUTLSUPW";
    private static final String USAFILE = "OUTLUSAM";
    private static final String TCL_STARTUP_FILE = "vis5d.tcl";
    private static final String FUNCTION_PATH = "userfuncs";
    private static final int ANIMRATE = 100;
    private static final double DEFAULT_LOG_SCALE = 1012.5;
    private static final double DEFAULT_LOG_EXP = -7.2;
    private static final boolean BIG_GFX = true;
    private static final int MAX_LABEL = 1000;
    private static final int MAX_FUNCS = 100;
    private static final int V5D_VERSION = 42;
    private static final float MISSING = Float.NaN;
    private static final int MAXVARS = 30;
    private static final int MAXTIMES = 400;
    private static final int MAXROWS = 400;
    private static final int MAXCOLUMNS = 400;
    private static final int MAXLEVELS = 100;
    private static final int MAXPROJARGS = 100;
    private static final int MAXVERTARGS = 101;
    private static final String FILE_VERSION = "4.3";
    public static final int TAG_ID = 1446331402;
    public static final int TAG_VERSION = 1000;
    public static final int TAG_NUMTIMES = 1001;
    public static final int TAG_NUMVARS = 1002;
    public static final int TAG_VARNAME = 1003;
    public static final int TAG_NR = 1004;
    public static final int TAG_NC = 1005;
    public static final int TAG_NL = 1006;
    public static final int TAG_NL_VAR = 1007;
    public static final int TAG_LOWLEV_VAR = 1008;
    public static final int TAG_TIME = 1010;
    public static final int TAG_DATE = 1011;
    public static final int TAG_MINVAL = 1012;
    public static final int TAG_MAXVAL = 1013;
    public static final int TAG_COMPRESS = 1014;
    public static final int TAG_UNITS = 1015;
    public static final int TAG_VERTICAL_SYSTEM = 2000;
    public static final int TAG_VERT_ARGS = 2100;
    public static final int TAG_BOTTOMBOUND = 2001;
    public static final int TAG_LEVINC = 2002;
    public static final int TAG_HEIGHT = 2003;
    public static final int TAG_PROJECTION = 3000;
    public static final int TAG_PROJ_ARGS = 3100;
    public static final int TAG_NORTHBOUND = 3001;
    public static final int TAG_WESTBOUND = 3002;
    public static final int TAG_ROWINC = 3003;
    public static final int TAG_COLINC = 3004;
    public static final int TAG_LAT1 = 3005;
    public static final int TAG_LAT2 = 3006;
    public static final int TAG_POLE_ROW = 3007;
    public static final int TAG_POLE_COL = 3008;
    public static final int TAG_CENTLON = 3009;
    public static final int TAG_CENTLAT = 3010;
    public static final int TAG_CENTROW = 3011;
    public static final int TAG_CENTCOL = 3012;
    public static final int TAG_ROTATION = 3013;
    public static final int TAG_END = 9999;
    private static boolean SIMPLE_COMPRESSION = false;
    private static boolean KLUDGE = false;
    private static boolean ORIGINAL = false;
    public int NumTimes;
    public int NumVars;
    public int Nr;
    public int Nc;
    public int[] Nl = new int[30];
    public int[] LowLev = new int[30];
    public char[][] VarName = new char[30][10];
    public char[][] Units = new char[30][20];
    public int[] TimeStamp = new int[400];
    public int[] DateStamp = new int[400];
    public float[] MinVal = new float[30];
    public float[] MaxVal = new float[30];
    public short[][] McFile = new short[400][30];
    public short[][] McGrid = new short[400][30];
    public int VerticalSystem = -1;
    public float[] VertArgs = new float[101];
    public int Projection = -1;
    public float[] ProjArgs = new float[100];
    public int CompressMode;
    public String FileVersion;
    private int FileFormat;
    private RandomAccessFile FileDesc;
    char Mode;
    int CurPos;
    int FirstGridPos;
    int[] GridSize = new int[30];
    int SumGridSizes;

    private static boolean IS_MISSING(float f) {
        return Float.isNaN(f) || (double)f >= 1.0E30;
    }

    public static V5DStruct v5d_open(byte[] byArray, int n, int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2, int[] nArray3, float[] fArray, int[] nArray4, float[] fArray2, double[] dArray) throws IOException, BadFormException {
        char[] cArray = new char[200];
        byte[] byArray2 = new byte[300];
        byte[] byArray3 = new byte[600];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = (char)byArray[n2];
            ++n2;
        }
        cArray[n] = '\u0000';
        V5DStruct v5DStruct = V5DStruct.v5dOpenFile(new String(cArray));
        if (v5DStruct != null) {
            int n3;
            nArray[0] = v5DStruct.Nr;
            nArray[1] = v5DStruct.Nc;
            nArray[3] = v5DStruct.NumTimes;
            nArray[4] = v5DStruct.NumVars;
            int n4 = 0;
            while (n4 < v5DStruct.NumVars) {
                n3 = 10 * n4;
                n2 = 0;
                while (n2 < 10) {
                    if (v5DStruct.VarName[n4][n2] == '\u0000' || n2 >= 9) {
                        byArray2[n3 + n2] = 0;
                        break;
                    }
                    byArray2[n3 + n2] = (byte)v5DStruct.VarName[n4][n2];
                    ++n2;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < v5DStruct.NumVars) {
                n3 = 20 * n4;
                n2 = 0;
                while (n2 < 20) {
                    if (v5DStruct.Units[n4][n2] == '\u0000' || n2 >= 19) {
                        byArray3[n3 + n2] = 0;
                        break;
                    }
                    byArray3[n3 + n2] = (byte)v5DStruct.Units[n4][n2];
                    ++n2;
                }
                ++n4;
            }
            n2 = 0;
            while (n2 < v5DStruct.NumVars) {
                n3 = 10 * n2;
                int n5 = 20 * n2;
                int n6 = n3;
                int n7 = n5;
                while (byArray2[n6] != 0) {
                    ++n6;
                }
                while (byArray3[n7] != 0) {
                    ++n7;
                }
                stringArray[n2] = new String(byArray2, n3, n6 - n3);
                stringArray2[n2] = new String(byArray3, n5, n7 - n5);
                ++n2;
            }
            int n8 = v5DStruct.Nl[0];
            n2 = 0;
            while (n2 < v5DStruct.NumVars) {
                ++n2;
            }
            nArray[2] = n8;
            n2 = 0;
            while (n2 < v5DStruct.NumVars) {
                nArray2[n2] = v5DStruct.Nl[n2];
                ++n2;
            }
            nArray4[0] = v5DStruct.VerticalSystem;
            int n9 = 0;
            while (n9 < n8) {
                fArray2[n9] = v5DStruct.VertArgs[n9];
                ++n9;
            }
            int n10 = V5DStruct.v5dYYDDDtoDays(v5DStruct.DateStamp[0]);
            int n11 = V5DStruct.v5dHHMMSStoSeconds(v5DStruct.TimeStamp[0]);
            n2 = 0;
            while (n2 < v5DStruct.NumTimes) {
                double d;
                int n12 = V5DStruct.v5dYYDDDtoDays(v5DStruct.DateStamp[n2]);
                int n13 = V5DStruct.v5dHHMMSStoSeconds(v5DStruct.TimeStamp[n2]);
                dArray[n2] = d = (double)n12 * 24.0 * 60.0 * 60.0 + (double)n13;
                ++n2;
            }
            nArray3[0] = v5DStruct.Projection;
            int n14 = 0;
            while (n14 < 100) {
                fArray[n14] = v5DStruct.ProjArgs[n14];
                ++n14;
            }
        } else {
            nArray[0] = -1;
        }
        return v5DStruct;
    }

    public void v5d_read(int n, int n2, float[] fArray, float[] fArray2) throws IOException, BadFormException {
        fArray[0] = this.MinVal[n2];
        fArray[1] = this.MaxVal[n2];
        boolean bl = this.v5dReadGrid(n, n2, fArray2);
        if (!bl) {
            fArray[0] = 1.0f;
            fArray[1] = -1.0f;
        }
    }

    public static int getUnsignedByte(byte n) {
        int n2 = n >= 0 ? n : n + 256;
        return n2;
    }

    public static int getUnsignedShort(byte by, byte by2) {
        int n = V5DStruct.getUnsignedByte(by);
        int n2 = V5DStruct.getUnsignedByte(by2);
        return 256 * n + n2;
    }

    public static int getUnsignedInt(byte by, byte by2, byte by3, byte by4) {
        int n = V5DStruct.getUnsignedByte(by);
        int n2 = V5DStruct.getUnsignedByte(by2);
        int n3 = V5DStruct.getUnsignedByte(by3);
        int n4 = V5DStruct.getUnsignedByte(by4);
        return 0x1000000 * n + 65536 * n2 + 256 * n3 + n4;
    }

    private static float pressure_to_height(float f) {
        return (float)(-7.2 * Math.log((double)f / 1012.5));
    }

    private static float height_to_pressure(float f) {
        return (float)(1012.5 * Math.exp((double)f / -7.2));
    }

    private static int copy_string2(char[] cArray, char[] cArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = cArray2[n2];
            ++n2;
        }
        n2 = n - 1;
        while (n2 >= 0) {
            if (cArray[n2] != ' ' && n2 != n - 1) break;
            cArray[n2] = '\u0000';
            --n2;
        }
        return new String(cArray).length();
    }

    private static int copy_string(char[] cArray, char[] cArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            if (cArray2[n2] == ' ' || n2 == n - 1) {
                cArray[n2] = '\u0000';
                break;
            }
            cArray[n2] = cArray2[n2];
            ++n2;
        }
        return n2;
    }

    private static int v5dYYDDDtoDays(int n) {
        int n2 = n / 1000;
        int n3 = n - 1000 * n2;
        if (n2 >= 1900) {
            n2 -= 1900;
        } else if (n2 < 50) {
            n2 += 100;
        }
        int n4 = 365 * n2 + (n2 - 1) / 4 - (n2 - 1) / 100 + (n2 + 299) / 400 + n3 - 1;
        return n4;
    }

    private static int v5dHHMMSStoSeconds(int n) {
        int n2 = n / 10000;
        int n3 = n / 100 % 100;
        int n4 = n % 100;
        return n4 + n3 * 60 + n2 * 60 * 60;
    }

    private static int v5dDaysToYYDDD(int n) {
        int n2 = 4 * n / 1461;
        int n3 = n - (365 * n2 + (n2 - 1) / 4);
        if (n2 > 99) {
            n2 -= 100;
        }
        int n4 = n2 * 1000 + n3;
        return n4;
    }

    private static int v5dSecondsToHHMMSS(int n) {
        int n2 = n / 3600;
        int n3 = n / 60 % 60;
        int n4 = n % 60;
        return n2 * 10000 + n3 * 100 + n4;
    }

    private static V5DStruct v5dOpenFile(String string) throws IOException, BadFormException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        if (randomAccessFile == null) {
            return null;
        }
        V5DStruct v5DStruct = new V5DStruct();
        v5DStruct.FileDesc = randomAccessFile;
        v5DStruct.Mode = (char)114;
        return v5DStruct.read_v5d_header() ? v5DStruct : null;
    }

    private static void compute_ga_gb(int n, int n2, int n3, float[] fArray, int n4, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) throws BadFormException {
        if (SIMPLE_COMPRESSION) {
            float f;
            float f2;
            float f3 = 1.0E30f;
            float f4 = -1.0E30f;
            int n5 = n * n2 * n3;
            boolean bl = true;
            int n6 = 0;
            while (n6 < n5) {
                if (!V5DStruct.IS_MISSING(fArray[n6])) {
                    if (fArray[n6] < f3) {
                        f3 = fArray[n6];
                    }
                    if (fArray[n6] > f4) {
                        f4 = fArray[n6];
                    }
                    bl = false;
                }
                ++n6;
            }
            if (bl) {
                f2 = 1.0f;
                f = 0.0f;
            } else {
                f2 = (float)((double)(f4 - f3) / 254.0);
                f = f3;
            }
            n6 = 0;
            while (n6 < n3) {
                fArray2[n6] = f2;
                fArray3[n6] = f;
                ++n6;
            }
            fArray4[0] = f3;
            fArray5[0] = f4;
        } else {
            float f;
            float f5 = -1.0E30f;
            float f6 = 1.0E30f;
            float[] fArray6 = new float[100];
            float[] fArray7 = new float[100];
            float[] fArray8 = new float[100];
            int n7 = n * n2;
            float f7 = 1.0E30f;
            float f8 = -1.0E30f;
            int n8 = 0;
            int n9 = 0;
            while (n9 < n3) {
                f = 1.0E30f;
                float f9 = -1.0E30f;
                int n10 = 0;
                while (n10 < n7) {
                    if (!V5DStruct.IS_MISSING(fArray[n8]) && fArray[n8] < f) {
                        f = fArray[n8];
                    }
                    if (!V5DStruct.IS_MISSING(fArray[n8]) && fArray[n8] > f9) {
                        f9 = fArray[n8];
                    }
                    ++n8;
                    ++n10;
                }
                if (f < f7) {
                    f7 = f;
                }
                if (f9 > f8) {
                    f8 = f9;
                }
                fArray6[n9] = f;
                fArray7[n9] = f9;
                ++n9;
            }
            if (KLUDGE) {
                int n11 = n7 * n3;
                f = (float)((double)(f8 - f7) / 100000.0);
                if (Math.abs(f7) < f && (double)f7 != 0.0 && n4 != 4) {
                    n8 = 0;
                    while (n8 < n11) {
                        if (!V5DStruct.IS_MISSING(fArray[n8]) && fArray[n8] < f) {
                            fArray[n8] = f;
                        }
                        ++n8;
                    }
                    f7 = f;
                    n9 = 0;
                    while (n9 < n3) {
                        if (Math.abs(fArray6[n9]) < f) {
                            fArray6[n9] = f;
                        }
                        if (Math.abs(fArray7[n9]) < f) {
                            fArray7[n9] = f;
                        }
                        ++n9;
                    }
                }
            }
            float f10 = 0.0f;
            n9 = 0;
            while (n9 < n3) {
                fArray8[n9] = fArray6[n9] >= 1.0E30f && fArray7[n9] <= -1.0E30f ? 0.0f : fArray7[n9] - fArray6[n9];
                if (fArray8[n9] > f10) {
                    f10 = fArray8[n9];
                }
                ++n9;
            }
            if ((double)f10 == 0.0) {
                if (f7 == f8) {
                    n9 = 0;
                    while (n9 < n3) {
                        fArray2[n9] = f7;
                        fArray3[n9] = 0.0f;
                        ++n9;
                    }
                } else {
                    n9 = 0;
                    while (n9 < n3) {
                        fArray2[n9] = fArray6[n9];
                        fArray3[n9] = 0.0f;
                        ++n9;
                    }
                }
            } else if (n4 == 1) {
                ORIGINAL = true;
                if (ORIGINAL) {
                    float f11 = f10 / 254.0f;
                    float f12 = f7;
                    n9 = 0;
                    while (n9 < n3) {
                        fArray2[n9] = f11;
                        fArray3[n9] = f12 + f11 * (float)((int)((fArray6[n9] - f12) / f11));
                        ++n9;
                    }
                } else {
                    n9 = 0;
                    while (n9 < n3) {
                        float f13 = (double)fArray8[n9] == 0.0 ? 1.0f : fArray8[n9] / 254.0f;
                        fArray2[n9] = f13;
                        fArray3[n9] = fArray6[n9];
                        ++n9;
                    }
                }
            } else if (n4 == 2) {
                float f14 = f10 / 65534.0f;
                float f15 = f7;
                n9 = 0;
                while (n9 < n3) {
                    fArray2[n9] = f14;
                    fArray3[n9] = f15 + f14 * (float)((int)((fArray6[n9] - f15) / f14));
                    ++n9;
                }
            } else {
                V5DStruct.V5Dassert(n4 == 4);
                n9 = 0;
                while (n9 < n3) {
                    fArray2[n9] = 1.0f;
                    fArray3[n9] = 0.0f;
                    ++n9;
                }
            }
            fArray4[0] = f7;
            fArray5[0] = f8;
        }
    }

    private void v5dDecompressGrid(int n, int n2, int n3, int n4, byte[] byArray, float[] fArray, float[] fArray2, float[] fArray3) {
        int n5 = n * n2;
        int n6 = n * n2 * n3;
        if (n4 == 1) {
            int n7 = 0;
            int n8 = 0;
            while (n8 < n3) {
                int n9;
                int n10;
                int n11;
                float f = fArray[n8];
                float f2 = fArray2[n8];
                float f3 = 0.0f;
                float f4 = 0.0f;
                if ((double)f > 1.0E-10) {
                    f3 = f2 / f;
                    n11 = (int)Math.floor(f3);
                    f3 -= (float)n11;
                    f4 = (float)((double)f * 1.0E-6);
                } else {
                    n11 = 1;
                }
                if (-254 <= n11 && n11 <= 0 && f3 < f4) {
                    n10 = 0;
                    while (n10 < n5) {
                        n9 = V5DStruct.getUnsignedByte(byArray[n7]);
                        if (n9 == 255) {
                            fArray3[n7] = Float.NaN;
                        } else {
                            fArray3[n7] = (float)n9 * f + f2;
                            if (Math.abs(fArray3[n7]) < f4) {
                                fArray3[n7] = f4;
                            }
                        }
                        ++n10;
                        ++n7;
                    }
                } else {
                    n10 = 0;
                    while (n10 < n5) {
                        n9 = V5DStruct.getUnsignedByte(byArray[n7]);
                        fArray3[n7] = n9 == 255 ? Float.NaN : (float)n9 * f + f2;
                        ++n10;
                        ++n7;
                    }
                }
                ++n8;
            }
        } else if (n4 == 2) {
            int n12 = 0;
            int n13 = 0;
            while (n13 < n3) {
                float f = fArray[n13];
                float f5 = fArray2[n13];
                int n14 = 0;
                while (n14 < n5) {
                    int n15 = V5DStruct.getUnsignedShort(byArray[2 * n12], byArray[2 * n12 + 1]);
                    fArray3[n12] = n15 == 65535 ? Float.NaN : (float)n15 * f + f5;
                    ++n14;
                    ++n12;
                }
                ++n13;
            }
        } else {
            int n16 = 0;
            while (n16 < n6) {
                int n17 = V5DStruct.getUnsignedInt(byArray[n16 * 4], byArray[n16 * 4 + 1], byArray[n16 * 4 + 2], byArray[n16 * 4 + 3]);
                fArray3[n16] = Float.intBitsToFloat(n17);
                ++n16;
            }
        }
    }

    private static final void V5Dassert(boolean bl) throws BadFormException {
        if (!bl) {
            throw new BadFormException("Warning: assert failed");
        }
    }

    private static int read_block(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (n2 == 1) {
            n3 = randomAccessFile.read(byArray, 0, n);
        } else if (n2 == 2) {
            n3 = randomAccessFile.read(byArray, 0, n * 2) / 2;
        } else if (n2 == 4) {
            n3 = randomAccessFile.read(byArray, 0, n * 4) / 4;
        } else {
            throw new IOException("Fatal error in read_block(): bad elsize (" + n2 + ")");
        }
        return n3;
    }

    private static int read_float4_array(RandomAccessFile randomAccessFile, float[] fArray, int n) throws IOException {
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = randomAccessFile.readFloat();
            ++n2;
        }
        return n;
    }

    private static void v5dCompressGrid(int n, int n2, int n3, int n4, float[] fArray, byte[] byArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5) throws BadFormException {
        int n5 = n * n2;
        int n6 = n * n2 * n3;
        V5DStruct.compute_ga_gb(n, n2, n3, fArray, n4, fArray2, fArray3, fArray4, fArray5);
        if (n4 == 1) {
            int n7 = 0;
            int n8 = 0;
            while (n8 < n3) {
                float f = fArray3[n8] - 1.0E-4f;
                float f2 = fArray2[n8] == 0.0f ? 1.0f : 1.0f / fArray2[n8];
                int n9 = 0;
                while (n9 < n5) {
                    byArray[n7] = V5DStruct.IS_MISSING(fArray[n7]) ? -1 : (byte)((fArray[n7] - f) * f2);
                    ++n9;
                    ++n7;
                }
                ++n8;
            }
        } else if (n4 == 2) {
            int n10 = 0;
            int n11 = 0;
            while (n11 < n3) {
                float f = fArray3[n11] - 1.0E-4f;
                float f3 = fArray2[n11] == 0.0f ? 1.0f : 1.0f / fArray2[n11];
                int n12 = 0;
                while (n12 < n5) {
                    if (V5DStruct.IS_MISSING(fArray[n10])) {
                        byArray[2 * n10] = -1;
                        byArray[2 * n10 + 1] = -1;
                    } else {
                        short s = (short)((fArray[n10] - f) * f3);
                        byArray[2 * n10] = (byte)(s / 256);
                        byArray[2 * n10 + 1] = (byte)(s % 256);
                    }
                    ++n12;
                    ++n10;
                }
                ++n11;
            }
        } else {
            System.arraycopy(byArray, 0, fArray, 0, n6 * 4);
        }
    }

    private static int write_block(RandomAccessFile randomAccessFile, byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 1) {
            randomAccessFile.write(byArray, 0, n);
        } else if (n2 == 2) {
            randomAccessFile.write(byArray, 0, n * 2);
        } else if (n2 == 4) {
            randomAccessFile.write(byArray, 0, n * 4);
        } else {
            throw new IOException("Fatal error in write_block(): bad elsize (" + n2 + ")");
        }
        return n;
    }

    int v5dSizeofGrid(int n, int n2) {
        return this.Nr * this.Nc * this.Nl[n2] * this.CompressMode;
    }

    int grid_position(int n, int n2) throws BadFormException {
        V5DStruct.V5Dassert(n >= 0);
        V5DStruct.V5Dassert(n2 >= 0);
        V5DStruct.V5Dassert(n < this.NumTimes);
        V5DStruct.V5Dassert(n2 < this.NumVars);
        int n3 = this.FirstGridPos + n * this.SumGridSizes;
        int n4 = 0;
        while (n4 < n2) {
            n3 += this.GridSize[n4];
            ++n4;
        }
        return n3;
    }

    boolean v5dVerifyStruct() {
        boolean bl = true;
        if (this.NumVars < 0) {
            System.err.println("Invalid number of variables: " + this.NumVars);
            bl = false;
        } else if (this.NumVars > 30) {
            System.err.println("Too many variables: " + this.NumVars + "  (Maximum is " + "30" + ")");
            bl = false;
        }
        int n = 0;
        while (n < this.NumVars) {
            if (this.VarName[n][0] == '\u0000') {
                System.err.println("Missing variable name: VarName[" + n + "]=\"\"");
                bl = false;
            }
            ++n;
        }
        if (this.NumTimes < 0) {
            System.err.println("Invalid number of timesteps: " + this.NumTimes);
            bl = false;
        } else if (this.NumTimes > 400) {
            System.err.println("Too many timesteps: " + this.NumTimes + "  (Maximum is " + "400" + ")");
            bl = false;
        }
        n = 1;
        while (n < this.NumTimes) {
            int n2 = V5DStruct.v5dYYDDDtoDays(this.DateStamp[n - 1]);
            int n3 = V5DStruct.v5dYYDDDtoDays(this.DateStamp[n]);
            int n4 = V5DStruct.v5dHHMMSStoSeconds(this.TimeStamp[n - 1]);
            int n5 = V5DStruct.v5dHHMMSStoSeconds(this.TimeStamp[n]);
            if (n3 < n2 || n3 == n2 && n5 <= n4) {
                int n6;
                int n7 = 1;
                if (n > 1 && (n6 = V5DStruct.v5dHHMMSStoSeconds(this.TimeStamp[n - 1]) - V5DStruct.v5dHHMMSStoSeconds(this.TimeStamp[n - 2]) + 86400 * (V5DStruct.v5dYYDDDtoDays(this.DateStamp[n - 1]) - V5DStruct.v5dYYDDDtoDays(this.DateStamp[n - 2]))) > 0) {
                    n7 = n6;
                }
                n5 = n4 + n7;
                n3 = n2;
                if (n5 >= 86400) {
                    n5 = 0;
                    ++n3;
                }
                this.DateStamp[n] = V5DStruct.v5dDaysToYYDDD(n3);
                this.TimeStamp[n] = V5DStruct.v5dSecondsToHHMMSS(n5);
            }
            ++n;
        }
        if (this.Nr < 2) {
            System.err.println("Too few rows: " + this.Nr + " (2 is minimum)");
            bl = false;
        } else if (this.Nr > 400) {
            System.err.println("Too many rows: " + this.Nr + " (" + "400" + " is maximum)");
            bl = false;
        }
        if (this.Nc < 2) {
            System.err.println("Too few columns: " + this.Nc + " (2 is minimum)");
            bl = false;
        } else if (this.Nc > 400) {
            System.err.println("Too many columns: " + this.Nc + " (" + "400" + " is maximum)");
            bl = false;
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 < this.NumVars) {
            if (this.LowLev[n9] < 0) {
                System.err.println("Low level cannot be negative for var " + this.VarName[n9] + ": " + this.LowLev[n9]);
                bl = false;
            }
            if (this.Nl[n9] < 1) {
                System.err.println("Too few levels for var " + this.VarName[n9] + ": " + this.Nl[n9] + " (1 is minimum)");
                bl = false;
            }
            if (this.Nl[n9] + this.LowLev[n9] > 100) {
                System.err.println("Too many levels for var " + this.VarName[n9] + ": " + (this.Nl[n9] + this.LowLev[n9]) + " (" + "100" + " is maximum)");
                bl = false;
            }
            if (this.Nl[n9] + this.LowLev[n9] > n8) {
                n8 = this.Nl[n9] + this.LowLev[n9];
            }
            ++n9;
        }
        if (this.CompressMode != 1 && this.CompressMode != 2 && this.CompressMode != 4) {
            System.err.println("Bad CompressMode: " + this.CompressMode + " (must be 1, 2 or 4)");
            bl = false;
        }
        block0 : switch (this.VerticalSystem) {
            case 0: 
            case 1: {
                if ((double)this.VertArgs[1] != 0.0) break;
                System.err.println("Vertical level increment is zero, must be non-zero");
                bl = false;
                break;
            }
            case 2: {
                n = 1;
                while (n < n8) {
                    if (this.VertArgs[n] <= this.VertArgs[n - 1]) {
                        System.err.println("Height[" + n + "]=" + this.VertArgs[n] + " <= Height[" + (n - 1) + "]=" + this.VertArgs[n - 1] + ", level heights must increase");
                        bl = false;
                        break block0;
                    }
                    ++n;
                }
                break;
            }
            case 3: {
                n = 1;
                while (n < n8) {
                    if (this.VertArgs[n] <= this.VertArgs[n - 1]) {
                        System.err.println("Pressure[" + n + "]=" + V5DStruct.height_to_pressure(this.VertArgs[n]) + " >= Pressure[" + (n - 1) + "]=" + V5DStruct.height_to_pressure(this.VertArgs[n - 1]) + ", level pressures must decrease");
                        bl = false;
                        break block0;
                    }
                    ++n;
                }
                break;
            }
            default: {
                System.err.println("VerticalSystem = " + this.VerticalSystem + ", must be in 0..3");
                bl = false;
            }
        }
        switch (this.Projection) {
            case 0: {
                if ((double)this.ProjArgs[2] == 0.0) {
                    System.err.println("Row Increment (ProjArgs[2]) can't be zero");
                    bl = false;
                }
                if ((double)this.ProjArgs[3] != 0.0) break;
                System.err.println("Column increment (ProjArgs[3]) can't be zero");
                bl = false;
                break;
            }
            case 1: {
                if ((double)this.ProjArgs[2] < 0.0) {
                    System.err.println("Row Increment (ProjArgs[2]) = " + this.ProjArgs[2] + "  (must be >=0.0)");
                    bl = false;
                }
                if (!((double)this.ProjArgs[3] <= 0.0)) break;
                System.err.println("Column Increment (ProjArgs[3]) = " + this.ProjArgs[3] + "  (must be >=0.0)");
                bl = false;
                break;
            }
            case 2: {
                if ((double)this.ProjArgs[0] < -90.0 || (double)this.ProjArgs[0] > 90.0) {
                    System.err.println("Lat1 (ProjArgs[0]) out of range: " + this.ProjArgs[0]);
                    bl = false;
                }
                if ((double)this.ProjArgs[1] < -90.0 || (double)this.ProjArgs[1] > 90.0) {
                    System.err.println("Lat2 (ProjArgs[1] out of range: " + this.ProjArgs[1]);
                    bl = false;
                }
                if (!((double)this.ProjArgs[5] <= 0.0)) break;
                System.err.println("ColInc (ProjArgs[5]) = " + this.ProjArgs[5] + "  (must be >=0.0)");
                bl = false;
                break;
            }
            case 3: {
                if ((double)this.ProjArgs[0] < -90.0 || (double)this.ProjArgs[0] > 90.0) {
                    System.err.println("Central Latitude (ProjArgs[0]) out of range: " + this.ProjArgs[0] + "  (must be in +/-90)");
                    bl = false;
                }
                if ((double)this.ProjArgs[1] < -180.0 || (double)this.ProjArgs[1] > 180.0) {
                    System.err.println("Central Longitude (ProjArgs[1]) out of range: " + this.ProjArgs[1] + "  (must be in +/-180)");
                    bl = false;
                }
                if (!(this.ProjArgs[4] < 0.0f)) break;
                System.err.println("Column spacing (ProjArgs[4]) = " + this.ProjArgs[4] + "  (must be positive)");
                bl = false;
                break;
            }
            case 4: {
                if ((double)this.ProjArgs[2] <= 0.0) {
                    System.err.println("Row Increment (ProjArgs[2]) = " + this.ProjArgs[2] + "  (must be >=0.0)");
                    bl = false;
                }
                if ((double)this.ProjArgs[3] <= 0.0) {
                    System.err.println("Column Increment = (ProjArgs[3]) " + this.ProjArgs[3] + "  (must be >=0.0)");
                    bl = false;
                }
                if ((double)this.ProjArgs[4] < -90.0 || (double)this.ProjArgs[4] > 90.0) {
                    System.err.println("Central Latitude (ProjArgs[4]) out of range: " + this.ProjArgs[4] + "  (must be in +/-90)");
                    bl = false;
                }
                if ((double)this.ProjArgs[5] < -180.0 || (double)this.ProjArgs[5] > 180.0) {
                    System.err.println("Central Longitude (ProjArgs[5]) out of range: " + this.ProjArgs[5] + "  (must be in +/-180)");
                    bl = false;
                }
                if (!((double)this.ProjArgs[6] < -180.0) && !((double)this.ProjArgs[6] > 180.0)) break;
                System.err.println("Central Longitude (ProjArgs[6]) out of range: " + this.ProjArgs[6] + "  (must be in +/-180)");
                bl = false;
                break;
            }
            default: {
                System.err.println("Projection = " + this.Projection + ", must be in 0..4");
                bl = false;
            }
        }
        return bl;
    }

    boolean v5dGetMcIDASgrid(int n, int n2, int[] nArray, int[] nArray2) {
        if (n < 0 || n >= this.NumTimes) {
            System.err.println("Bad time argument to v5dGetMcIDASgrid: " + n);
            return false;
        }
        if (n2 < 0 || n2 >= this.NumVars) {
            System.err.println("Bad var argument to v5dGetMcIDASgrid: " + n2);
            return false;
        }
        nArray[0] = this.McFile[n][n2];
        nArray2[0] = this.McGrid[n][n2];
        return true;
    }

    boolean v5dSetMcIDASgrid(int n, int n2, int n3, int n4) {
        if (n < 0 || n >= this.NumTimes) {
            System.err.println("Bad time argument to v5dSetMcIDASgrid: " + n);
            return false;
        }
        if (n2 < 0 || n2 >= this.NumVars) {
            System.err.println("Bad var argument to v5dSetMcIDASgrid: " + n2);
            return false;
        }
        this.McFile[n][n2] = (short)n3;
        this.McGrid[n][n2] = (short)n4;
        return true;
    }

    boolean read_comp_header() throws IOException {
        RandomAccessFile randomAccessFile = this.FileDesc;
        randomAccessFile.seek(0L);
        int n = randomAccessFile.readInt();
        if (n == -2139062144 || n == -2139062143) {
            int n2;
            int n3;
            int n4;
            if (n == -2139062144) {
                n4 = 300;
                n3 = 20;
            } else {
                n4 = 400;
                n3 = 30;
            }
            this.FirstGridPos = 48 + 8 * n4 + 4 * n3;
            this.NumTimes = randomAccessFile.readInt();
            this.NumVars = randomAccessFile.readInt();
            this.Nr = randomAccessFile.readInt();
            this.Nc = randomAccessFile.readInt();
            int n5 = randomAccessFile.readInt();
            int n6 = 0;
            while (n6 < this.NumVars) {
                this.Nl[n6] = n5;
                this.LowLev[n6] = 0;
                ++n6;
            }
            this.ProjArgs[0] = randomAccessFile.readFloat();
            this.ProjArgs[1] = randomAccessFile.readFloat();
            float f = randomAccessFile.readFloat();
            this.ProjArgs[2] = randomAccessFile.readFloat();
            this.ProjArgs[3] = randomAccessFile.readFloat();
            float f2 = randomAccessFile.readFloat();
            this.VerticalSystem = 1;
            this.VertArgs[0] = f - f2 * (float)(n5 - 1);
            this.VertArgs[1] = f2;
            n6 = 0;
            while (n6 < n4) {
                n2 = randomAccessFile.readInt();
                this.DateStamp[n6] = V5DStruct.v5dDaysToYYDDD(n2);
                ++n6;
            }
            n6 = 0;
            while (n6 < n4) {
                n2 = randomAccessFile.readInt();
                this.TimeStamp[n6] = V5DStruct.v5dSecondsToHHMMSS(n2);
                ++n6;
            }
            n6 = 0;
            while (n6 < n3) {
                char[] cArray = new char[4];
                int n7 = 0;
                while (n7 < 4) {
                    cArray[n7] = (char)randomAccessFile.readByte();
                    ++n7;
                }
                n2 = 3;
                while (n2 > 0) {
                    if (cArray[n2] != ' ' && cArray[n2] != '\u0000') break;
                    cArray[n2] = '\u0000';
                    --n2;
                }
                System.arraycopy(cArray, 0, this.VarName[n6], 0, 4);
                this.VarName[n6][4] = '\u0000';
                ++n6;
            }
            int n8 = (this.Nr * this.Nc * n5 + 3) / 4 * 4;
            n6 = 0;
            while (n6 < this.NumVars) {
                this.GridSize[n6] = 8 + n8;
                ++n6;
            }
            this.SumGridSizes = (8 + n8) * this.NumVars;
            n6 = 0;
            while (n6 < this.NumVars) {
                this.MinVal[n6] = 999999.9f;
                this.MaxVal[n6] = -999999.9f;
                ++n6;
            }
            int n9 = 0;
            while (n9 < this.NumTimes) {
                int n10 = 0;
                while (n10 < this.NumVars) {
                    float f3 = randomAccessFile.readFloat();
                    float f4 = randomAccessFile.readFloat();
                    randomAccessFile.skipBytes(n8);
                    float f5 = -(125.0f + f4) / f3;
                    float f6 = (125.0f - f4) / f3;
                    if (f5 < this.MinVal[n10]) {
                        this.MinVal[n10] = f5;
                    }
                    if (f6 > this.MaxVal[n10]) {
                        this.MaxVal[n10] = f6;
                    }
                    ++n10;
                }
                ++n9;
            }
        } else if (n == -2139062142 || n == -2139062141) {
            int n11;
            float f = 0.0f;
            int n12 = randomAccessFile.readInt();
            this.NumVars = randomAccessFile.readInt();
            this.NumTimes = randomAccessFile.readInt();
            this.Nr = randomAccessFile.readInt();
            this.Nc = randomAccessFile.readInt();
            int n13 = randomAccessFile.readInt();
            int n14 = 0;
            while (n14 < this.NumVars) {
                this.Nl[n14] = n13;
                ++n14;
            }
            this.ProjArgs[2] = randomAccessFile.readFloat();
            this.ProjArgs[3] = randomAccessFile.readFloat();
            this.VerticalSystem = 1;
            n14 = 0;
            while (n14 < n13) {
                this.VertArgs[n14] = randomAccessFile.readFloat();
                if (n14 == 1) {
                    f = this.VertArgs[1] - this.VertArgs[0];
                } else if (n14 > 1 && f != this.VertArgs[n14] - this.VertArgs[n14 - 1]) {
                    this.VerticalSystem = 2;
                }
                ++n14;
            }
            if (this.VerticalSystem == 1) {
                this.VertArgs[1] = f;
            }
            int n15 = 0;
            while (n15 < this.NumVars) {
                char[] cArray = new char[8];
                int n16 = 0;
                while (n16 < 8) {
                    cArray[n16] = (char)randomAccessFile.readByte();
                    ++n16;
                }
                n11 = 7;
                while (n11 > 0) {
                    if (cArray[n11] != ' ' && cArray[n11] != '\u0000') break;
                    cArray[n11] = '\u0000';
                    --n11;
                }
                System.arraycopy(cArray, 0, this.VarName[n15], 0, 8);
                this.VarName[n15][8] = '\u0000';
                ++n15;
            }
            n15 = 0;
            while (n15 < this.NumVars) {
                this.MinVal[n15] = randomAccessFile.readFloat();
                ++n15;
            }
            n15 = 0;
            while (n15 < this.NumVars) {
                this.MaxVal[n15] = randomAccessFile.readFloat();
                ++n15;
            }
            int n17 = 0;
            while (n17 < n12) {
                n11 = randomAccessFile.readInt();
                this.TimeStamp[n17] = V5DStruct.v5dSecondsToHHMMSS(n11);
                ++n17;
            }
            n17 = 0;
            while (n17 < n12) {
                n11 = randomAccessFile.readInt();
                this.DateStamp[n17] = V5DStruct.v5dDaysToYYDDD(n11);
                ++n17;
            }
            n17 = 0;
            while (n17 < n12) {
                float f7 = randomAccessFile.readFloat();
                if (n17 == 0) {
                    this.ProjArgs[0] = f7;
                }
                ++n17;
            }
            n17 = 0;
            while (n17 < n12) {
                float f8 = randomAccessFile.readFloat();
                if (n17 == 0) {
                    this.ProjArgs[1] = f8;
                }
                ++n17;
            }
            int n18 = n == -2139062142 ? n13 * 2 * 4 + (this.Nr * this.Nc * n13 + 3) / 4 * 4 : 8 + n13 * 2 * 4 + (this.Nr * this.Nc * n13 + 3) / 4 * 4;
            n14 = 0;
            while (n14 < this.NumVars) {
                this.GridSize[n14] = n18;
                ++n14;
            }
            this.SumGridSizes = n18 * this.NumVars;
            this.FirstGridPos = 36 + this.Nl[0] * 4 + this.NumVars * 16 + n12 * 16;
        }
        this.CompressMode = 1;
        this.Projection = 1;
        this.FileVersion = "";
        return true;
    }

    boolean read_comp_grid(int n, int n2, float[] fArray, float[] fArray2, byte[] byArray) throws IOException, BadFormException {
        int n3;
        int n4;
        RandomAccessFile randomAccessFile = this.FileDesc;
        long l = this.grid_position(n, n2);
        randomAccessFile.seek(l);
        if (this.FileFormat == -2139062141) {
            int n5 = randomAccessFile.readInt();
            int n6 = randomAccessFile.readInt();
            this.McFile[n][n2] = (short)n5;
            this.McGrid[n][n2] = (short)n6;
        }
        int n7 = this.Nl[n2];
        if (this.FileFormat == -2139062144 || this.FileFormat == -2139062143) {
            float f = randomAccessFile.readFloat();
            float f2 = randomAccessFile.readFloat();
            n4 = 0;
            while (n4 < n7) {
                if ((double)f == 0.0) {
                    fArray2[n4] = 0.0f;
                    fArray[n4] = 0.0f;
                } else {
                    fArray2[n4] = (f2 + 128.0f) / -f;
                    fArray[n4] = 1.0f / f;
                }
                ++n4;
            }
            n3 = 128;
        } else {
            V5DStruct.read_float4_array(randomAccessFile, fArray, this.Nl[n2]);
            V5DStruct.read_float4_array(randomAccessFile, fArray2, this.Nl[n2]);
            n4 = 0;
            while (n4 < n7) {
                if ((double)fArray[n4] == 0.0) {
                    fArray2[n4] = 0.0f;
                    fArray[n4] = 0.0f;
                } else {
                    fArray2[n4] = (fArray2[n4] + 128.0f) / -fArray[n4];
                    fArray[n4] = 1.0f / fArray[n4];
                }
                ++n4;
            }
            n3 = 128;
        }
        int n8 = this.Nr * this.Nc * this.Nl[n2];
        if (randomAccessFile.read(byArray, 0, n8) != n8) {
            return false;
        }
        n8 = this.Nr * this.Nc * this.Nl[n2];
        n4 = 0;
        while (n4 < n8) {
            int n9 = n4++;
            byArray[n9] = (byte)(byArray[n9] + n3);
        }
        return true;
    }

    boolean read_v5d_header() throws IOException, BadFormException {
        int n;
        boolean bl = false;
        RandomAccessFile randomAccessFile = this.FileDesc;
        int n2 = randomAccessFile.readInt();
        int n3 = randomAccessFile.readInt();
        if (n2 != 1446331402 || n3 != 0) {
            if (n2 >= -2139062144 && n2 <= -2139062141) {
                this.FileFormat = n2;
                return this.read_comp_header();
            }
            return false;
        }
        this.FileFormat = 0;
        this.CompressMode = 1;
        block38: while (!bl) {
            int n4 = randomAccessFile.readInt();
            int n5 = randomAccessFile.readInt();
            switch (n4) {
                case 1000: {
                    V5DStruct.V5Dassert(n5 == 10);
                    byte[] byArray = new byte[10];
                    randomAccessFile.read(byArray, 0, 10);
                    int n6 = 10;
                    int n7 = 0;
                    while (n7 < 10) {
                        if (byArray[n7] == 0) {
                            n6 = n7;
                            break;
                        }
                        ++n7;
                    }
                    this.FileVersion = new String(byArray, 0, n6);
                    if (this.FileVersion.compareTo(FILE_VERSION) <= 0) continue block38;
                    System.err.println("Warning: Trying to read a version " + this.FileVersion + " file, you should upgrade Vis5D.");
                    break;
                }
                case 1001: {
                    V5DStruct.V5Dassert(n5 == 4);
                    this.NumTimes = randomAccessFile.readInt();
                    break;
                }
                case 1002: {
                    V5DStruct.V5Dassert(n5 == 4);
                    this.NumVars = randomAccessFile.readInt();
                    break;
                }
                case 1003: {
                    V5DStruct.V5Dassert(n5 == 14);
                    n = randomAccessFile.readInt();
                    int n7 = 0;
                    while (n7 < 10) {
                        this.VarName[n][n7] = (char)randomAccessFile.readByte();
                        ++n7;
                    }
                    continue block38;
                }
                case 1004: {
                    V5DStruct.V5Dassert(n5 == 4);
                    this.Nr = randomAccessFile.readInt();
                    break;
                }
                case 1005: {
                    V5DStruct.V5Dassert(n5 == 4);
                    this.Nc = randomAccessFile.readInt();
                    break;
                }
                case 1006: {
                    V5DStruct.V5Dassert(n5 == 4);
                    int n8 = randomAccessFile.readInt();
                    int n9 = 0;
                    while (n9 < this.NumVars) {
                        this.Nl[n9] = n8;
                        ++n9;
                    }
                    continue block38;
                }
                case 1007: {
                    V5DStruct.V5Dassert(n5 == 8);
                    n = randomAccessFile.readInt();
                    this.Nl[n] = randomAccessFile.readInt();
                    break;
                }
                case 1008: {
                    V5DStruct.V5Dassert(n5 == 8);
                    n = randomAccessFile.readInt();
                    this.LowLev[n] = randomAccessFile.readInt();
                    break;
                }
                case 1010: {
                    V5DStruct.V5Dassert(n5 == 8);
                    int n10 = randomAccessFile.readInt();
                    this.TimeStamp[n10] = randomAccessFile.readInt();
                    break;
                }
                case 1011: {
                    V5DStruct.V5Dassert(n5 == 8);
                    int n10 = randomAccessFile.readInt();
                    this.DateStamp[n10] = randomAccessFile.readInt();
                    break;
                }
                case 1012: {
                    V5DStruct.V5Dassert(n5 == 8);
                    n = randomAccessFile.readInt();
                    this.MinVal[n] = randomAccessFile.readFloat();
                    break;
                }
                case 1013: {
                    V5DStruct.V5Dassert(n5 == 8);
                    n = randomAccessFile.readInt();
                    this.MaxVal[n] = randomAccessFile.readFloat();
                    break;
                }
                case 1014: {
                    V5DStruct.V5Dassert(n5 == 4);
                    this.CompressMode = randomAccessFile.readInt();
                    break;
                }
                case 1015: {
                    V5DStruct.V5Dassert(n5 == 24);
                    n = randomAccessFile.readInt();
                    int n7 = 0;
                    while (n7 < 20) {
                        this.Units[n][n7] = (char)randomAccessFile.readByte();
                        ++n7;
                    }
                    continue block38;
                }
                case 2000: {
                    V5DStruct.V5Dassert(n5 == 4);
                    this.VerticalSystem = randomAccessFile.readInt();
                    if (this.VerticalSystem >= 0 && this.VerticalSystem <= 3) continue block38;
                    System.err.println("Error: bad vertical coordinate system: " + this.VerticalSystem);
                    break;
                }
                case 2100: {
                    int n11 = randomAccessFile.readInt();
                    V5DStruct.V5Dassert(n11 <= 101);
                    int n7 = 0;
                    while (n7 < n11) {
                        this.VertArgs[n7] = randomAccessFile.readFloat();
                        ++n7;
                    }
                    V5DStruct.V5Dassert(n5 == n11 * 4 + 4);
                    break;
                }
                case 2003: {
                    V5DStruct.V5Dassert(n5 == 8);
                    int n12 = randomAccessFile.readInt();
                    this.VertArgs[n12] = randomAccessFile.readFloat();
                    break;
                }
                case 2001: {
                    V5DStruct.V5Dassert(n5 == 4);
                    this.VertArgs[0] = randomAccessFile.readFloat();
                    break;
                }
                case 2002: {
                    V5DStruct.V5Dassert(n5 == 4);
                    this.VertArgs[1] = randomAccessFile.readFloat();
                    break;
                }
                case 3000: {
                    V5DStruct.V5Dassert(n5 == 4);
                    this.Projection = randomAccessFile.readInt();
                    if (this.Projection >= 0 && this.Projection <= 4) continue block38;
                    System.err.println("Error while reading header, bad projection (" + this.Projection + ")");
                    return false;
                }
                case 3100: {
                    int n11 = randomAccessFile.readInt();
                    V5DStruct.V5Dassert(n11 <= 100);
                    int n7 = 0;
                    while (n7 < n11) {
                        this.ProjArgs[n7] = randomAccessFile.readFloat();
                        ++n7;
                    }
                    V5DStruct.V5Dassert(n5 == 4 * n11 + 4);
                    break;
                }
                case 3001: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 0 || this.Projection == 1 || this.Projection == 4) {
                        this.ProjArgs[0] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3002: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 0 || this.Projection == 1 || this.Projection == 4) {
                        this.ProjArgs[1] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3003: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 0 || this.Projection == 1 || this.Projection == 4) {
                        this.ProjArgs[2] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3004: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 0 || this.Projection == 1 || this.Projection == 4) {
                        this.ProjArgs[3] = randomAccessFile.readFloat();
                        break;
                    }
                    if (this.Projection == 2) {
                        this.ProjArgs[5] = randomAccessFile.readFloat();
                        break;
                    }
                    if (this.Projection == 3) {
                        this.ProjArgs[4] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3005: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[0] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3006: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[1] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3007: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[2] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3008: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[3] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3009: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[4] = randomAccessFile.readFloat();
                        break;
                    }
                    if (this.Projection == 3) {
                        this.ProjArgs[1] = randomAccessFile.readFloat();
                        break;
                    }
                    if (this.Projection == 4) {
                        this.ProjArgs[5] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3010: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 3) {
                        this.ProjArgs[0] = randomAccessFile.readFloat();
                        break;
                    }
                    if (this.Projection == 4) {
                        this.ProjArgs[4] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3011: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 3) {
                        this.ProjArgs[2] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3012: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 3) {
                        this.ProjArgs[3] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 3013: {
                    V5DStruct.V5Dassert(n5 == 4);
                    if (this.Projection == 4) {
                        this.ProjArgs[6] = randomAccessFile.readFloat();
                        break;
                    }
                    randomAccessFile.skipBytes(4);
                    break;
                }
                case 9999: {
                    bl = true;
                    randomAccessFile.skipBytes(n5);
                    break;
                }
                default: {
                    System.err.println("Unknown tag: " + n4 + "  length=" + n5);
                    randomAccessFile.skipBytes(n5);
                    break;
                }
            }
        }
        this.v5dVerifyStruct();
        this.FirstGridPos = (int)randomAccessFile.getFilePointer();
        this.SumGridSizes = 0;
        n = 0;
        while (n < this.NumVars) {
            this.GridSize[n] = 8 * this.Nl[n] + this.v5dSizeofGrid(0, n);
            this.SumGridSizes += this.GridSize[n];
            ++n;
        }
        return true;
    }

    boolean v5dReadCompressedGrid(int n, int n2, float[] fArray, float[] fArray2, byte[] byArray) throws IOException, BadFormException {
        boolean bl = false;
        if (n < 0 || n >= this.NumTimes) {
            throw new IOException("Error in v5dReadCompressedGrid: bad timestep argument (" + n + ")");
        }
        if (n2 < 0 || n2 >= this.NumVars) {
            throw new IOException("Error in v5dReadCompressedGrid: bad var argument (" + n2 + ")");
        }
        if (this.FileFormat != 0) {
            this.read_comp_grid(n, n2, fArray, fArray2, byArray);
        }
        int n3 = this.grid_position(n, n2);
        this.FileDesc.seek(n3);
        V5DStruct.read_float4_array(this.FileDesc, fArray, this.Nl[n2]);
        V5DStruct.read_float4_array(this.FileDesc, fArray2, this.Nl[n2]);
        int n4 = this.Nr * this.Nc * this.Nl[n2];
        if (this.CompressMode == 1) {
            bl = V5DStruct.read_block(this.FileDesc, byArray, n4, 1) == n4;
        } else if (this.CompressMode == 2) {
            bl = V5DStruct.read_block(this.FileDesc, byArray, n4, 2) == n4;
        } else if (this.CompressMode == 4) {
            boolean bl2 = bl = V5DStruct.read_block(this.FileDesc, byArray, n4, 4) == n4;
        }
        if (!bl) {
            System.err.println("Error in v5dReadCompressedGrid: read failed, bad file?");
        }
        return bl;
    }

    boolean v5dReadGrid(int n, int n2, float[] fArray) throws IOException, BadFormException {
        int n3;
        float[] fArray2 = new float[100];
        float[] fArray3 = new float[100];
        if (n < 0 || n >= this.NumTimes) {
            System.err.println("Error in v5dReadGrid: bad timestep argument (" + n + ")");
            return false;
        }
        if (n2 < 0 || n2 >= this.NumVars) {
            System.err.println("Error in v5dReadGrid: bad variable argument (" + n2 + ")");
            return false;
        }
        if (this.CompressMode == 1) {
            n3 = this.Nr * this.Nc * this.Nl[n2] * 1;
        } else if (this.CompressMode == 2) {
            n3 = this.Nr * this.Nc * this.Nl[n2] * 2;
        } else if (this.CompressMode == 4) {
            n3 = this.Nr * this.Nc * this.Nl[n2] * 4;
        } else {
            System.err.println("Error in v5dReadGrid: bad compression mode (" + this.CompressMode + ")");
            return false;
        }
        byte[] byArray = new byte[n3];
        if (!this.v5dReadCompressedGrid(n, n2, fArray2, fArray3, byArray)) {
            return false;
        }
        this.v5dDecompressGrid(this.Nr, this.Nc, this.Nl[n2], this.CompressMode, byArray, fArray2, fArray3, fArray);
        return true;
    }

    boolean write_tag(int n, int n2, boolean bl) throws IOException {
        if (!bl && this.CurPos + 8 + n2 > this.FirstGridPos) {
            System.err.println("Error: out of header space!");
            return false;
        }
        this.FileDesc.writeInt(n);
        this.FileDesc.writeInt(n2);
        this.CurPos += 8 + n2;
        return true;
    }

    boolean write_v5d_header() throws IOException {
        int n;
        if (this.FileFormat != 0) {
            System.err.println("Error: v5d library can't write comp5d format files.");
            return false;
        }
        RandomAccessFile randomAccessFile = this.FileDesc;
        if (!this.v5dVerifyStruct()) {
            return false;
        }
        boolean bl = this.FirstGridPos == 0;
        this.SumGridSizes = 0;
        int n2 = 0;
        while (n2 < this.NumVars) {
            this.GridSize[n2] = 8 * this.Nl[n2] + this.v5dSizeofGrid(0, n2);
            this.SumGridSizes += this.GridSize[n2];
            ++n2;
        }
        randomAccessFile.seek(0L);
        this.CurPos = 0;
        if (!this.write_tag(1446331402, 0, bl)) {
            return false;
        }
        if (!this.write_tag(1000, 10, bl)) {
            return false;
        }
        randomAccessFile.write(FILE_VERSION.getBytes(), 0, 10);
        if (!this.write_tag(1001, 4, bl)) {
            return false;
        }
        randomAccessFile.writeInt(this.NumTimes);
        if (!this.write_tag(1002, 4, bl)) {
            return false;
        }
        randomAccessFile.writeInt(this.NumVars);
        n2 = 0;
        while (n2 < this.NumVars) {
            if (!this.write_tag(1003, 14, bl)) {
                return false;
            }
            randomAccessFile.writeInt(n2);
            n = 0;
            while (n < 10) {
                randomAccessFile.writeByte((byte)this.VarName[n2][n]);
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.NumVars) {
            if (!this.write_tag(1015, 24, bl)) {
                return false;
            }
            randomAccessFile.writeInt(n2);
            n = 0;
            while (n < 20) {
                randomAccessFile.writeByte((byte)this.Units[n2][n]);
                ++n;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.NumTimes) {
            if (!this.write_tag(1010, 8, bl)) {
                return false;
            }
            randomAccessFile.writeInt(n3);
            randomAccessFile.writeInt(this.TimeStamp[n3]);
            if (!this.write_tag(1011, 8, bl)) {
                return false;
            }
            randomAccessFile.writeInt(n3);
            randomAccessFile.writeInt(this.DateStamp[n3]);
            ++n3;
        }
        if (!this.write_tag(1004, 4, bl)) {
            return false;
        }
        randomAccessFile.writeInt(this.Nr);
        if (!this.write_tag(1005, 4, bl)) {
            return false;
        }
        randomAccessFile.writeInt(this.Nc);
        int n4 = 0;
        n2 = 0;
        while (n2 < this.NumVars) {
            if (!this.write_tag(1007, 8, bl)) {
                return false;
            }
            randomAccessFile.writeInt(n2);
            randomAccessFile.writeInt(this.Nl[n2]);
            if (!this.write_tag(1008, 8, bl)) {
                return false;
            }
            randomAccessFile.writeInt(n2);
            randomAccessFile.writeInt(this.LowLev[n2]);
            if (this.Nl[n2] + this.LowLev[n2] > n4) {
                n4 = this.Nl[n2] + this.LowLev[n2];
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < this.NumVars) {
            if (!this.write_tag(1012, 8, bl)) {
                return false;
            }
            randomAccessFile.writeInt(n2);
            randomAccessFile.writeFloat(this.MinVal[n2]);
            if (!this.write_tag(1013, 8, bl)) {
                return false;
            }
            randomAccessFile.writeInt(n2);
            randomAccessFile.writeFloat(this.MaxVal[n2]);
            ++n2;
        }
        if (!this.write_tag(1014, 4, bl)) {
            return false;
        }
        randomAccessFile.writeInt(this.CompressMode);
        if (!this.write_tag(2000, 4, bl)) {
            return false;
        }
        randomAccessFile.writeInt(this.VerticalSystem);
        if (!this.write_tag(2100, 408, bl)) {
            return false;
        }
        randomAccessFile.writeInt(101);
        n = 0;
        while (n < 101) {
            randomAccessFile.writeFloat(this.VertArgs[n]);
            ++n;
        }
        if (!this.write_tag(3000, 4, bl)) {
            return false;
        }
        randomAccessFile.writeInt(this.Projection);
        if (!this.write_tag(3100, 404, bl)) {
            return false;
        }
        randomAccessFile.writeInt(100);
        n = 0;
        while (n < 100) {
            randomAccessFile.writeFloat(this.ProjArgs[n]);
            ++n;
        }
        if (bl) {
            if (!this.write_tag(9999, 10000, bl)) {
                return false;
            }
            randomAccessFile.skipBytes(10000);
            this.FirstGridPos = (int)randomAccessFile.getFilePointer();
        } else {
            int n5 = this.FirstGridPos - (int)randomAccessFile.getFilePointer();
            if (!this.write_tag(9999, n5 - 8, bl)) {
                return false;
            }
        }
        return true;
    }

    boolean v5dCreateFile(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        if (randomAccessFile == null) {
            System.err.println("Error in v5dCreateFile: open failed");
            this.FileDesc = null;
            this.Mode = '\u0000';
            return false;
        }
        this.FileDesc = randomAccessFile;
        this.Mode = (char)119;
        return this.write_v5d_header();
    }

    boolean v5dWriteCompressedGrid(int n, int n2, float[] fArray, float[] fArray2, byte[] byArray) throws IOException, BadFormException {
        if (this.Mode != 'w') {
            System.err.println("Error in v5dWriteCompressedGrid: file opened for reading, not writing.");
            return false;
        }
        if (n < 0 || n >= this.NumTimes) {
            System.err.println("Error in v5dWriteCompressedGrid: bad timestep argument (" + n + ")");
            return false;
        }
        if (n2 < 0 || n2 >= this.NumVars) {
            System.err.println("Error in v5dWriteCompressedGrid: bad variable argument (" + n2 + ")");
            return false;
        }
        int n3 = this.grid_position(n, n2);
        this.FileDesc.seek(n3);
        boolean bl = false;
        int n4 = 0;
        while (n4 < this.Nl[n2]) {
            this.FileDesc.writeFloat(fArray[n4]);
            ++n4;
        }
        n4 = 0;
        while (n4 < this.Nl[n2]) {
            this.FileDesc.writeFloat(fArray2[n4]);
            ++n4;
        }
        int n5 = this.Nr * this.Nc * this.Nl[n2];
        if (this.CompressMode == 1) {
            bl = V5DStruct.write_block(this.FileDesc, byArray, n5, 1) == n5;
        } else if (this.CompressMode == 2) {
            bl = V5DStruct.write_block(this.FileDesc, byArray, n5, 2) == n5;
        } else if (this.CompressMode == 4) {
            boolean bl2 = bl = V5DStruct.write_block(this.FileDesc, byArray, n5, 4) == n5;
        }
        if (!bl) {
            System.err.println("Error in v5dWrite[Compressed]Grid: write failed, disk full?");
        }
        return bl;
    }

    boolean v5dWriteGrid(int n, int n2, float[] fArray) throws IOException, BadFormException {
        int n3;
        float[] fArray2 = new float[100];
        float[] fArray3 = new float[100];
        if (this.Mode != 'w') {
            System.err.println("Error in v5dWriteGrid: file opened for reading, not writing.");
            return false;
        }
        if (n < 0 || n >= this.NumTimes) {
            System.err.println("Error in v5dWriteGrid: bad timestep argument (" + n + ")");
            return false;
        }
        if (n2 < 0 || n2 >= this.NumVars) {
            System.err.println("Error in v5dWriteGrid: bad variable argument (" + n2 + ")");
            return false;
        }
        if (this.CompressMode == 1) {
            n3 = this.Nr * this.Nc * this.Nl[n2] * 2;
        } else if (this.CompressMode == 2) {
            n3 = this.Nr * this.Nc * this.Nl[n2] * 2;
        } else if (this.CompressMode == 4) {
            n3 = this.Nr * this.Nc * this.Nl[n2] * 4;
        } else {
            System.err.println("Error in v5dWriteGrid: bad compression mode (" + this.CompressMode + ")");
            return false;
        }
        byte[] byArray = new byte[n3];
        float[] fArray4 = new float[1];
        float[] fArray5 = new float[1];
        V5DStruct.v5dCompressGrid(this.Nr, this.Nc, this.Nl[n2], this.CompressMode, fArray, byArray, fArray2, fArray3, fArray4, fArray5);
        float f = fArray4[0];
        float f2 = fArray5[0];
        if (f < this.MinVal[n2]) {
            this.MinVal[n2] = f;
        }
        if (f2 > this.MaxVal[n2]) {
            this.MaxVal[n2] = f2;
        }
        return this.v5dWriteCompressedGrid(n, n2, fArray2, fArray3, byArray);
    }

    boolean v5dCloseFile() throws IOException {
        boolean bl = true;
        if (this.Mode == 'w') {
            this.FileDesc.seek(0L);
            bl = this.write_v5d_header();
            this.FileDesc.seek(this.FileDesc.length());
            this.FileDesc.close();
        } else if (this.Mode == 'r') {
            this.FileDesc.close();
        } else {
            System.err.println("Error in v5dCloseFile: bad V5DStruct argument");
            return false;
        }
        this.FileDesc = null;
        this.Mode = '\u0000';
        return bl;
    }

    V5DStruct() {
        int n = 0;
        while (n < 30) {
            this.MinVal[n] = Float.NaN;
            this.MaxVal[n] = Float.NaN;
            ++n;
        }
        this.FileVersion = FILE_VERSION;
        this.CompressMode = 1;
        this.FileDesc = null;
    }
}

