/*
 * Decompiled with CFR 0.152.
 */
package visad.data.units;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import visad.BaseUnit;
import visad.DerivedUnit;
import visad.OffsetUnit;
import visad.SI;
import visad.ScaledUnit;
import visad.Unit;
import visad.data.units.UnitsDB;

public class UnitTable
implements UnitsDB,
Serializable {
    private final Hashtable nameMap;
    private final Hashtable symbolMap;
    private final SortedSet unitSet;

    public Unit get(String string) {
        Unit unit = null;
        if (string.length() == 0) {
            unit = new DerivedUnit();
        } else {
            unit = this.getBySymbol(string);
            if (unit == null) {
                unit = this.getByName(string);
            }
        }
        return unit;
    }

    protected Unit getByName(String string) {
        return (Unit)this.nameMap.get(string.toLowerCase());
    }

    protected Unit getBySymbol(String string) {
        return (Unit)this.symbolMap.get(string);
    }

    public void put(BaseUnit baseUnit) throws IllegalArgumentException {
        String string = baseUnit.unitName();
        this.putName(string, baseUnit);
        this.putName(this.makePlural(string), baseUnit);
        this.putSymbol(baseUnit.unitSymbol(), baseUnit);
    }

    protected String makePlural(String string) {
        char c;
        int n = string.length();
        char c2 = string.charAt(n - 1);
        String string2 = c2 != 'y' ? string + (c2 == 's' || c2 == 'x' || c2 == 'z' || string.endsWith("ch") ? "es" : "s") : (n == 1 ? string + "s" : ((c = string.charAt(n - 2)) == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' ? string + "s" : string.substring(0, n - 1) + "ies"));
        return string2;
    }

    public void putName(String string, Unit unit) {
        String[] stringArray;
        if (string == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".putName(String,Unit): <null> unit name");
        }
        if (unit == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".putName(String,Unit): <null> unit");
        }
        if ((string = string.toLowerCase()).indexOf(32) == -1 && string.indexOf(95) == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = string.replace('_', ' ');
            stringArray = stringArray3;
            stringArray3[1] = string.replace(' ', '_');
        }
        String[] stringArray4 = stringArray;
        int n = 0;
        while (n < stringArray4.length) {
            Unit unit2 = (Unit)this.nameMap.get(stringArray4[n]);
            if (unit2 != null && !unit2.equals(unit)) {
                throw new IllegalArgumentException("Attempt to replace unit \"" + unit2 + " with unit \"" + unit + "\"");
            }
            this.nameMap.put(stringArray4[n], unit);
            ++n;
        }
        this.unitSet.add(unit);
    }

    public void putSymbol(String string, Unit unit) {
        if (string == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".putName(String,Unit): <null> unit symbol");
        }
        if (unit == null) {
            throw new IllegalArgumentException(this.getClass().getName() + ".putName(String,Unit): <null> unit");
        }
        Unit unit2 = (Unit)this.symbolMap.get(string);
        if (unit2 != null && !unit2.equals(unit)) {
            throw new IllegalArgumentException("Attempt to replace unit \"" + unit2 + " with unit \"" + unit + "\"");
        }
        this.symbolMap.put(string, unit);
        this.unitSet.add(unit);
    }

    public Enumeration getNameEnumeration() {
        return this.nameMap.keys();
    }

    public Enumeration getSymbolEnumeration() {
        return this.symbolMap.keys();
    }

    public Enumeration getUnitEnumeration() {
        return new Enumeration(this){
            private final Iterator iter;
            private final /* synthetic */ UnitTable this$0;

            public boolean hasMoreElements() {
                return this.iter.hasNext();
            }

            public Object nextElement() {
                return this.iter.next();
            }
            {
                this.this$0 = unitTable;
                this.iter = UnitTable.access$0(this.this$0).iterator();
                this.constructor$0(unitTable);
            }

            private final void constructor$0(UnitTable unitTable) {
            }
        };
    }

    public String toString() {
        return this.nameMap.toString() + this.symbolMap.toString();
    }

    public static void main(String[] stringArray) throws Exception {
        UnitTable unitTable = new UnitTable(13);
        unitTable.put(SI.ampere);
        unitTable.put(SI.candela);
        unitTable.put(SI.kelvin);
        unitTable.put(SI.kilogram);
        unitTable.put(SI.meter);
        unitTable.put(SI.mole);
        unitTable.put(SI.second);
        unitTable.put(SI.radian);
        unitTable.putName("amp", SI.ampere);
        unitTable.putName("celsius", new OffsetUnit(273.15, SI.kelvin));
        unitTable.putName("newton", SI.kilogram.multiply(SI.meter).divide(SI.second.pow(2)));
        unitTable.putName("rankine", new ScaledUnit(0.5555555555555556, SI.kelvin));
        unitTable.putName("fahrenheit", new OffsetUnit(459.67, (ScaledUnit)unitTable.get("rankine")));
        System.out.println("db:");
        System.out.println(unitTable.toString());
    }

    public void list() {
        Enumeration enumeration = this.getUnitEnumeration();
        while (enumeration.hasMoreElements()) {
            Unit unit = (Unit)enumeration.nextElement();
            System.out.println(unit.getIdentifier() + " = " + unit.getDefinition());
        }
    }

    static /* synthetic */ SortedSet access$0(UnitTable unitTable) {
        return unitTable.unitSet;
    }

    public UnitTable(int n) throws IllegalArgumentException {
        this(n, 0);
    }

    public UnitTable(int n, int n2) throws IllegalArgumentException {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Negative hashtable size");
        }
        this.nameMap = new Hashtable(n);
        this.symbolMap = new Hashtable(n2);
        this.unitSet = Collections.synchronizedSortedSet(new TreeSet(new Comparator(this){
            private final /* synthetic */ UnitTable this$0;

            public int compare(Object object, Object object2) {
                return ((Unit)object).toString().compareToIgnoreCase(((Unit)object2).toString());
            }
            {
                this.this$0 = unitTable;
                this.constructor$0(unitTable);
            }

            private final void constructor$0(UnitTable unitTable) {
            }
        }));
    }
}

