/*
 * Decompiled with CFR 0.152.
 */
package visad.data.tiff;

import ij.ImagePlus;
import ij.ImageStack;
import ij.io.FileInfo;
import ij.io.FileOpener;
import ij.io.FileSaver;
import ij.io.TiffDecoder;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class TiffForm
extends Form
implements FormFileInformer {
    private static int num = 0;
    private static final String[] suffixes = new String[]{"tif", "tiff"};
    private static final String NO_JAI = "This feature requires JAI, available from Sun at http://java.sun.com/products/java-media/jai/";
    private static boolean noJai = false;
    private static ReflectedUniverse r = TiffForm.createReflectedUniverse();

    private static ReflectedUniverse createReflectedUniverse() {
        ReflectedUniverse reflectedUniverse = null;
        try {
            reflectedUniverse = new ReflectedUniverse();
            reflectedUniverse.exec("import com.sun.media.jai.codec.ImageDecodeParam");
            reflectedUniverse.exec("import com.sun.media.jai.codec.ImageDecoder");
            reflectedUniverse.exec("import com.sun.media.jai.codec.ImageCodec");
        }
        catch (VisADException visADException) {
            noJai = true;
        }
        return reflectedUniverse;
    }

    private static BufferedImage[] jaiGetImages(String string) throws BadFormException, IOException {
        if (noJai) {
            throw new BadFormException(NO_JAI);
        }
        BufferedImage[] bufferedImageArray = null;
        try {
            r.setVar("tiff", "tiff");
            r.setVar("file", new File(string));
            r.exec("id = ImageCodec.createImageDecoder(tiff, file, null)");
            Object object = r.exec("id.getNumPages()");
            int n = (Integer)object;
            bufferedImageArray = new BufferedImage[n];
            int n2 = 0;
            while (n2 < n) {
                r.setVar("i", new Integer(n2));
                RenderedImage renderedImage = (RenderedImage)r.exec("id.decodeAsRenderedImage(i)");
                WritableRaster writableRaster = renderedImage.copyData(null);
                ColorModel colorModel = renderedImage.getColorModel();
                bufferedImageArray[n2] = new BufferedImage(colorModel, writableRaster, false, null);
                ++n2;
            }
        }
        catch (VisADException visADException) {
            throw new BadFormException(visADException.getMessage());
        }
        return bufferedImageArray;
    }

    public boolean isThisType(String string) {
        int n = 0;
        while (n < suffixes.length) {
            if (string.toLowerCase().endsWith(suffixes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isThisType(byte[] byArray) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] stringArray = new String[suffixes.length];
        System.arraycopy(suffixes, 0, stringArray, 0, suffixes.length);
        return stringArray;
    }

    private static ImageProcessor extractImage(FlatField flatField) throws VisADException {
        int n;
        Gridded2DSet gridded2DSet = (Gridded2DSet)flatField.getDomainSet();
        int[] nArray = gridded2DSet.getLengths();
        int n2 = nArray[0];
        int n3 = nArray[1];
        double[][] dArray = flatField.getValues();
        int[] nArray2 = new int[dArray[0].length];
        if (dArray.length == 3) {
            n = 0;
            while (n < dArray[0].length) {
                int n4 = (int)dArray[0][n] & 0xFF;
                int n5 = (int)dArray[1][n] & 0xFF;
                int n6 = (int)dArray[2][n] & 0xFF;
                nArray2[n] = n4 << 16 | n5 << 8 | n6;
                ++n;
            }
        } else if (dArray.length == 1) {
            n = 0;
            while (n < dArray[0].length) {
                int n7 = (int)dArray[0][n] & 0xFF;
                nArray2[n] = n7 << 16 | n7 << 8 | n7;
                ++n;
            }
        }
        ColorProcessor colorProcessor = new ColorProcessor(n2, n3, nArray2);
        return colorProcessor;
    }

    public void save(String string, Data data, boolean bl) throws BadFormException, IOException, RemoteException, VisADException {
        FlatField[] flatFieldArray = DataUtility.getImageFields(data);
        if (flatFieldArray == null) {
            throw new BadFormException("Data type must be image or time sequence of images");
        }
        if (flatFieldArray.length > 1) {
            int n = flatFieldArray.length;
            ImageProcessor[] imageProcessorArray = new ImageProcessor[n];
            int n2 = 0;
            while (n2 < n) {
                imageProcessorArray[n2] = TiffForm.extractImage(flatFieldArray[n2]);
                ++n2;
            }
            ImageStack imageStack = new ImageStack(imageProcessorArray[0].getWidth(), imageProcessorArray[0].getHeight(), imageProcessorArray[0].getColorModel());
            int n3 = 0;
            while (n3 < n) {
                imageStack.addSlice("" + n3, imageProcessorArray[n3]);
                ++n3;
            }
            ImagePlus imagePlus = new ImagePlus(string, imageStack);
            FileSaver fileSaver = new FileSaver(imagePlus);
            fileSaver.saveAsTiffStack(string);
        } else {
            ImageProcessor imageProcessor = TiffForm.extractImage(flatFieldArray[0]);
            ImagePlus imagePlus = new ImagePlus(string, imageProcessor);
            FileSaver fileSaver = new FileSaver(imagePlus);
            fileSaver.saveAsTiff(string);
        }
    }

    public void add(String string, Data data, boolean bl) throws BadFormException {
        throw new BadFormException("TiffForm.add");
    }

    public DataImpl open(String string) throws BadFormException, IOException, VisADException {
        Object object;
        int n;
        Object object2;
        Object object3;
        Data[] dataArray;
        TiffDecoder tiffDecoder = new TiffDecoder("", string);
        FileInfo fileInfo = null;
        boolean bl = true;
        try {
            fileInfo = tiffDecoder.getTiffInfo()[0];
        }
        catch (IOException iOException) {
            dataArray = iOException.getMessage();
            if (dataArray.startsWith("Unsupported BitsPerSample") || dataArray.startsWith("Unsupported SamplesPerPixel") || dataArray.startsWith("ImageJ cannot open compressed TIFF files")) {
                bl = false;
            }
            throw iOException;
        }
        if (bl) {
            object3 = new FileOpener(fileInfo);
            object2 = ((FileOpener)object3).open(false).getStack();
            n = ((ImageStack)object2).getSize();
            dataArray = new FieldImpl[n];
            int n2 = 0;
            while (n2 < n) {
                object = ((ImageStack)object2).getProcessor(n2 + 1);
                dataArray[n2] = DataUtility.makeField(((ImageProcessor)object).createImage());
                ++n2;
            }
        } else {
            object3 = TiffForm.jaiGetImages(string);
            n = ((BufferedImage[])object3).length;
            dataArray = new FieldImpl[n];
            int n3 = 0;
            while (n3 < n) {
                dataArray[n3] = DataUtility.makeField((Image)object3[n3]);
                ++n3;
            }
        }
        if (n < 1) {
            throw new BadFormException("No images in file");
        }
        if (n == 1) {
            return dataArray[0];
        }
        object3 = RealType.getRealType("time");
        object2 = new FunctionType((MathType)object3, dataArray[0].getType());
        Integer1DSet integer1DSet = new Integer1DSet(n);
        object = new FieldImpl((FunctionType)object2, integer1DSet);
        ((FieldImpl)object).setSamples(dataArray, false);
        return object;
    }

    public DataImpl open(URL uRL) throws BadFormException, IOException, VisADException {
        throw new BadFormException("TiffForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray == null || stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("To convert a file to TIFF, run:");
            System.out.println("  java visad.data.tiff.TiffForm in_file out_file");
            System.out.println("To test read a TIFF file, run:");
            System.out.println("  java visad.data.tiff.TiffForm in_file");
            System.exit(2);
        }
        if (stringArray.length == 1) {
            TiffForm tiffForm = new TiffForm();
            System.out.print("Reading " + stringArray[0] + " ");
            DataImpl dataImpl = tiffForm.open(stringArray[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + dataImpl.getType().prettyString());
        } else if (stringArray.length == 2) {
            System.out.print(stringArray[0] + " -> " + stringArray[1] + " ");
            DefaultFamily defaultFamily = new DefaultFamily("loader");
            DataImpl dataImpl = defaultFamily.open(stringArray[0]);
            defaultFamily = null;
            TiffForm tiffForm = new TiffForm();
            tiffForm.save(stringArray[1], dataImpl, true);
            System.out.println("[done]");
        }
        System.exit(0);
    }

    public TiffForm() {
        super("TiffForm" + num++);
    }
}

