/*
 * Decompiled with CFR 0.152.
 */
package visad.data.text;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import visad.Data;
import visad.ErrorEstimate;
import visad.Field;
import visad.FieldException;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Irregular1DSet;
import visad.Irregular2DSet;
import visad.Irregular3DSet;
import visad.Linear1DSet;
import visad.Linear2DSet;
import visad.Linear3DSet;
import visad.LinearNDSet;
import visad.MathType;
import visad.Real;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.units.Parser;
import visad.jmet.DumpType;

public class TextAdapter {
    private FlatField ff = null;
    private Field field = null;
    private boolean debug = false;
    private String DELIM;
    private final String COMMA;
    private final String SEMICOLON;
    private final String TAB;
    private final String BLANK;
    String[] hdrNames;
    Unit[] hdrUnits;
    double[] hdrMissingValues;
    String[] hdrMissingStrings;
    int[] hdrIsInterval;
    double[] hdrErrorEstimates;
    double[] rangeErrorEstimates;
    Unit[] rangeUnits;
    double[] domainErrorEstimates;
    Unit[] domainUnits;
    double[] hdrScales;
    double[] hdrOffsets;
    int[][] hdrColumns;
    int[][] values_to_index;

    void readit(InputStream inputStream, String string, String string2) throws IOException, VisADException {
        BufferedReader bufferedReader;
        block160: {
            int n;
            int n2;
            int n3;
            int n4;
            Data[] dataArray;
            Object object;
            Object object2;
            Object object3;
            Object object4;
            int n5;
            Object object5;
            Object object6;
            Object object7;
            int n6;
            Object object8;
            Object object9;
            int n7;
            Object object10;
            String[] stringArray;
            String string3;
            this.ff = null;
            this.field = null;
            bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string4 = null;
            if (string == null) {
                do {
                    if ((string3 = bufferedReader.readLine()) == null) {
                        return;
                    }
                    if (TextAdapter.isText(string3)) continue;
                    return;
                } while (string3.startsWith("#") || string3.startsWith("!") || string3.startsWith("%") || string3.length() < 1);
                string4 = string3.trim();
            } else {
                string4 = string;
            }
            string4 = this.makeMT(string4);
            System.out.println("Specified MathType = " + string4);
            string3 = null;
            if (string2 == null) {
                while (true) {
                    if ((string3 = bufferedReader.readLine()) == null) {
                        return;
                    }
                    if (!TextAdapter.isText(string3)) {
                        return;
                    }
                    if (string3.startsWith("#") || string3.startsWith("!") || string3.startsWith("%") || string3.length() < 1) {
                        continue;
                    }
                    break;
                }
            } else {
                string3 = string2;
            }
            String string5 = this.DELIM;
            if (this.DELIM == null) {
                if (string3.indexOf(" ") != -1) {
                    string5 = " ";
                }
                if (string3.indexOf(",") != -1) {
                    string5 = ",";
                }
                if (string3.indexOf(";") != -1) {
                    string5 = ";";
                }
                if (string3.indexOf("\t") != -1) {
                    string5 = "\t";
                }
                if (this.debug) {
                    System.out.println("Using header delimiter = " + string5.getBytes()[0]);
                }
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string3, string5);
            int n8 = stringTokenizer.countTokens();
            this.hdrNames = new String[n8];
            this.hdrUnits = new Unit[n8];
            this.hdrMissingValues = new double[n8];
            this.hdrMissingStrings = new String[n8];
            this.hdrIsInterval = new int[n8];
            this.hdrErrorEstimates = new double[n8];
            this.hdrScales = new double[n8];
            this.hdrOffsets = new double[n8];
            this.hdrColumns = new int[2][n8];
            int n9 = 0;
            while (n9 < n8) {
                stringArray = stringTokenizer.nextToken().trim();
                object10 = null;
                this.hdrMissingValues[n9] = Double.NaN;
                this.hdrMissingStrings[n9] = null;
                this.hdrIsInterval[n9] = 0;
                this.hdrScales[n9] = 1.0;
                this.hdrOffsets[n9] = 0.0;
                this.hdrErrorEstimates[n9] = 0.0;
                this.hdrColumns[0][n9] = -1;
                n7 = stringArray.indexOf("[");
                if (n7 == -1) {
                    this.hdrNames[n9] = stringArray;
                    object10 = null;
                } else {
                    int n10 = stringArray.indexOf("]");
                    if (n10 == -1) {
                        throw new VisADException("TextAdapter: Bad [descriptor] named in:" + (String)stringArray);
                    }
                    this.hdrNames[n9] = n10 >= stringArray.length() ? stringArray.substring(0, n7).trim() : (stringArray.substring(0, n7) + stringArray.substring(n10 + 1)).trim();
                    object9 = stringArray.substring(n7 + 1, n10).trim();
                    object8 = new StringTokenizer((String)object9, " ");
                    n6 = ((StringTokenizer)object8).countTokens();
                    if (n6 == 1 && ((String)object9).indexOf("=") == -1) {
                        object10 = object9;
                    } else {
                        int n11 = 0;
                        while (n11 < n6) {
                            object7 = ((StringTokenizer)object8).nextToken().trim();
                            StringTokenizer stringTokenizer2 = new StringTokenizer((String)object7, "=");
                            if (stringTokenizer2.countTokens() != 2) {
                                throw new VisADException("TextAdapter: Invalid clause in: " + (String)object7);
                            }
                            String string6 = stringTokenizer2.nextToken().trim();
                            String string7 = stringTokenizer2.nextToken().trim();
                            if (string6.toLowerCase().startsWith("unit")) {
                                object10 = string7;
                            } else if (string6.toLowerCase().startsWith("mis")) {
                                this.hdrMissingStrings[n9] = string7.trim();
                                try {
                                    this.hdrMissingValues[n9] = Double.parseDouble(string7);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    this.hdrMissingValues[n9] = Double.NaN;
                                }
                            } else if (string6.toLowerCase().startsWith("int")) {
                                this.hdrIsInterval[n9] = -1;
                                if (string7.toLowerCase().startsWith("t")) {
                                    this.hdrIsInterval[n9] = 1;
                                }
                                if (string7.toLowerCase().startsWith("f")) {
                                    this.hdrIsInterval[n9] = 0;
                                }
                                if (this.hdrIsInterval[n9] == -1) {
                                    throw new VisADException("TextAdapter: Value of 'interval' must be 'true' or 'false'");
                                }
                            } else if (string6.toLowerCase().startsWith("err")) {
                                this.hdrErrorEstimates[n9] = Double.parseDouble(string7);
                            } else if (string6.toLowerCase().startsWith("sca")) {
                                this.hdrScales[n9] = Double.parseDouble(string7);
                            } else if (string6.toLowerCase().startsWith("off")) {
                                this.hdrOffsets[n9] = Double.parseDouble(string7);
                            } else if (string6.toLowerCase().startsWith("pos")) {
                                StringTokenizer stringTokenizer3 = new StringTokenizer(string7, ":");
                                if (stringTokenizer3.countTokens() != 2) {
                                    throw new VisADException("TextAdapter: invalid Position parameter in:" + (String)object7);
                                }
                                this.hdrColumns[0][n9] = Integer.parseInt(stringTokenizer3.nextToken().trim());
                                this.hdrColumns[1][n9] = Integer.parseInt(stringTokenizer3.nextToken().trim());
                            } else {
                                throw new VisADException("Invalid token name: " + (String)object7);
                            }
                            ++n11;
                        }
                    }
                }
                if (this.debug) {
                    System.out.println("hdr name = " + this.hdrNames[n9] + " units=" + (String)object10 + " miss=" + this.hdrMissingValues[n9] + " interval=" + this.hdrIsInterval[n9] + " errorest=" + this.hdrErrorEstimates[n9] + " scale=" + this.hdrScales[n9] + " offset=" + this.hdrOffsets[n9] + " pos=" + this.hdrColumns[0][n9] + ":" + this.hdrColumns[1][n9]);
                }
                Unit unit = null;
                if (object10 != null) {
                    try {
                        unit = Parser.parse((String)object10);
                    }
                    catch (Exception exception) {
                        System.out.println("Unit name problem:" + exception + " with: " + (String)object10);
                        unit = null;
                    }
                }
                object9 = RealType.getRealType(this.hdrNames[n9], unit, null, this.hdrIsInterval[n9]);
                this.hdrUnits[n9] = unit;
                ++n9;
            }
            MathType mathType = null;
            try {
                mathType = MathType.stringToType(string4);
                System.out.println("from: " + string4 + " made MathType: " + mathType);
            }
            catch (Exception exception) {
                throw new VisADException("TextAdapter: MathType badly formed or missing: " + string4);
            }
            if (this.debug) {
                System.out.println(mathType);
                new DumpType();
                DumpType.dumpMathType(mathType, System.out);
            }
            stringArray = null;
            object10 = null;
            n7 = 0;
            int n12 = 0;
            if (mathType instanceof FunctionType) {
                object9 = ((FunctionType)mathType).getDomain();
                n7 = ((TupleType)object9).getDimension();
                stringArray = new String[n7];
                n6 = 0;
                while (n6 < n7) {
                    MathType mathType2 = ((TupleType)object9).getComponent(n6);
                    stringArray[n6] = ((RealType)mathType2).toString().trim();
                    if (this.debug) {
                        System.out.println("dom " + n6 + " = " + stringArray[n6]);
                    }
                    ++n6;
                }
                object8 = (TupleType)((FunctionType)mathType).getRange();
                n12 = ((TupleType)object8).getDimension();
                object10 = new String[n12];
                n6 = 0;
                while (n6 < n12) {
                    MathType mathType3 = ((TupleType)object8).getComponent(n6);
                    object10[n6] = mathType3.toString().trim();
                    if (this.debug) {
                        System.out.println("range " + n6 + " = " + object10[n6]);
                    }
                    ++n6;
                }
            } else {
                throw new VisADException("TextAdapter: Math Type is not a simple FunctionType");
            }
            int[] nArray = new int[n7];
            double[][] dArray = new double[3][n7];
            object7 = new boolean[n7];
            this.domainErrorEstimates = new double[n7];
            this.domainUnits = new Unit[n7];
            this.rangeErrorEstimates = new double[n12];
            this.rangeUnits = new Unit[n12];
            int n13 = 0;
            int n14 = 0;
            while (n14 < n7) {
                nArray[n14] = -1;
                object7[n14] = false;
                this.domainErrorEstimates[n14] = Double.NaN;
                this.domainUnits[n14] = null;
                ++n14;
            }
            int[] nArray2 = new int[n12];
            int n15 = 0;
            int n16 = 0;
            while (n16 < n12) {
                nArray2[n16] = -1;
                this.rangeErrorEstimates[n16] = Double.NaN;
                this.rangeUnits[n16] = null;
                ++n16;
            }
            n16 = -1;
            this.values_to_index = new int[3][n8];
            int n17 = 0;
            while (n17 < n8) {
                this.values_to_index[0][n17] = -1;
                this.values_to_index[1][n17] = -1;
                this.values_to_index[2][n17] = -1;
                ++n16;
                object6 = this.hdrNames[n17];
                boolean bl = false;
                object5 = object6;
                int n18 = ((String)object5).indexOf("(");
                if (n18 != -1 && ((String)object5).indexOf("(Text)") == -1) {
                    object5 = ((String)object6).substring(0, n18).trim();
                    --n16;
                    --n13;
                }
                n5 = 0;
                while (n5 < n7) {
                    if (((String)object5).equals(stringArray[n5])) {
                        nArray[n5] = n16;
                        this.domainErrorEstimates[n5] = this.hdrErrorEstimates[n17];
                        this.domainUnits[n5] = this.hdrUnits[n17];
                        bl = true;
                        ++n13;
                        if (n18 != -1) {
                            try {
                                String string8 = ((String)object6).substring(n18 + 1, ((String)object6).length() - 1);
                                object4 = new StringTokenizer(string8, ":");
                                object3 = ((StringTokenizer)object4).nextToken().trim();
                                String string9 = ((StringTokenizer)object4).nextToken().trim();
                                object2 = "1";
                                if (((StringTokenizer)object4).hasMoreTokens()) {
                                    object2 = ((StringTokenizer)object4).nextToken().trim();
                                }
                                dArray[0][n5] = Double.parseDouble((String)object3);
                                dArray[1][n5] = Double.parseDouble(string9);
                                dArray[2][n5] = Double.parseDouble((String)object2);
                                object7[n5] = true;
                                break;
                            }
                            catch (Exception exception) {
                                throw new VisADException("TextAdapter: Error while interpreting min:max values for domain " + (String)object6);
                            }
                        }
                        if (n16 <= -1) break;
                        this.values_to_index[0][n16] = n5;
                        this.values_to_index[2][n16] = n17;
                        break;
                    }
                    ++n5;
                }
                if (!bl) {
                    n5 = 0;
                    while (n5 < n12) {
                        if (((String)object6).equals(object10[n5])) {
                            nArray2[n5] = n16;
                            this.rangeErrorEstimates[n5] = this.hdrErrorEstimates[n17];
                            this.rangeUnits[n5] = this.hdrUnits[n17];
                            ++n15;
                            this.values_to_index[1][n16] = n5;
                            this.values_to_index[2][n16] = n17;
                            bl = true;
                        }
                        ++n5;
                    }
                }
                ++n17;
            }
            if (this.debug) {
                System.out.println("countDom/numDom=" + n13 + " " + n7);
                System.out.println("countRange/numRng=" + n15 + " " + n12);
                System.out.println("Domain info:");
                n17 = 0;
                while (n17 < n7) {
                    System.out.println("Dom name / index = " + stringArray[n17] + "  " + nArray[n17]);
                    if (object7[n17]) {
                        System.out.println("    ..." + dArray[0][n17] + "  " + dArray[1][n17] + "    " + dArray[2][n17]);
                    }
                    ++n17;
                }
                System.out.println("Range info:");
                n17 = 0;
                while (n17 < n12) {
                    System.out.println("Rng name / index / error est = " + object10[n17] + "  " + nArray2[n17] + "  " + this.rangeErrorEstimates[n17] + " " + this.rangeUnits[n17]);
                    ++n17;
                }
                System.out.println("values_to_index pointers = ");
                n17 = 0;
                while (n17 < n8) {
                    System.out.println(" inx / value = " + n17 + " " + this.values_to_index[0][n17] + "    " + this.values_to_index[1][n17] + " " + this.values_to_index[2][n17]);
                    ++n17;
                }
            }
            ArrayList<double[]> arrayList = new ArrayList<double[]>();
            object6 = new ArrayList();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            object5 = null;
            String string10 = this.DELIM;
            n5 = 0;
            int n19 = 1;
            if (n15 == 1 && n12 == 1 && n7 == 2 && n13 < 2) {
                n5 = 1;
            }
            while (true) {
                String string11;
                int n20;
                object4 = bufferedReader.readLine();
                if (this.debug) {
                    System.out.println("read:" + (String)object4);
                }
                if (object4 == null) break;
                if (!TextAdapter.isText((String)object4)) {
                    return;
                }
                if (((String)object4).startsWith("#") || ((String)object4).startsWith("!") || ((String)object4).startsWith("%") || ((String)object4).length() < 1) continue;
                if (string10 == null) {
                    if (((String)object4).indexOf(" ") != -1) {
                        string10 = " ";
                    }
                    if (((String)object4).indexOf(",") != -1) {
                        string10 = ",";
                    }
                    if (((String)object4).indexOf(";") != -1) {
                        string10 = ";";
                    }
                    if (((String)object4).indexOf("\t") != -1) {
                        string10 = "\t";
                    }
                    if (this.debug) {
                        System.out.println("Using data delimiter = " + string10.getBytes()[0]);
                    }
                }
                if ((n20 = ((StringTokenizer)(object3 = new StringTokenizer((String)object4, string10))).countTokens()) < 1) continue;
                object2 = new double[n7];
                object = null;
                dataArray = null;
                if (n5 != 0) {
                    if (this.debug) {
                        System.out.println("probably a raster...");
                    }
                    boolean bl = false;
                    n4 = 0;
                    n3 = 0;
                    n2 = 0;
                    while (n2 < n20) {
                        string11 = ((StringTokenizer)object3).nextToken().trim();
                        if (n2 >= n8) {
                            if (!bl) {
                                throw new VisADException("TextAdapter: Cannot find first raster value");
                            }
                            object[++n4] = (float[])this.getVal(string11, n3);
                        } else {
                            if (this.values_to_index[0][n2] != -1) {
                                object2[this.values_to_index[0][n2]] = this.getVal(string11, n2);
                            }
                            if (bl) {
                                object[++n4] = (float[])this.getVal(string11, n3);
                            } else if (this.values_to_index[1][n2] != -1) {
                                object = new double[n20 - n2];
                                n3 = n2;
                                object[n4] = (float[])this.getVal(string11, n3);
                                bl = true;
                            }
                        }
                        ++n2;
                    }
                } else {
                    dataArray = new Data[n12];
                    if (this.debug) {
                        System.out.println("probably not a raster...");
                    }
                    object = new double[n12];
                    if (n20 > n8) {
                        n20 = n8;
                    }
                    n2 = 0;
                    while (n2 < n20) {
                        string11 = ((StringTokenizer)object3).nextToken().trim();
                        if (this.values_to_index[0][n2] != -1) {
                            object2[this.values_to_index[0][n2]] = this.getVal(string11, n2);
                        } else if (this.values_to_index[1][n2] != -1) {
                            MathType mathType4 = ((TupleType)object8).getComponent(this.values_to_index[1][n2]);
                            if (string11.startsWith("\"")) {
                                StringTokenizer stringTokenizer4 = new StringTokenizer(string11, "\"");
                                String string12 = stringTokenizer4.countTokens() == 0 ? "" : stringTokenizer4.nextToken().trim();
                                try {
                                    dataArray[this.values_to_index[1][n2]] = new Text((TextType)mathType4, string12);
                                    if (this.debug) {
                                        System.out.println("tValues[" + this.values_to_index[1][n2] + "] = " + dataArray[this.values_to_index[1][n2]]);
                                    }
                                }
                                catch (Exception exception) {
                                    System.out.println(" Exception converting " + mathType4 + " to TextType " + exception);
                                }
                            } else {
                                object[this.values_to_index[1][n2]] = (float[])this.getVal(string11, n2);
                                try {
                                    dataArray[this.values_to_index[1][n2]] = new Real((RealType)mathType4, this.getVal(string11, n2));
                                    if (this.debug) {
                                        System.out.println("tValues[" + this.values_to_index[1][n2] + "] = " + dataArray[this.values_to_index[1][n2]]);
                                    }
                                }
                                catch (Exception exception) {
                                    System.out.println(" Exception converting " + mathType4 + " " + exception);
                                }
                            }
                        }
                        ++n2;
                    }
                }
                try {
                    if (dataArray != null) {
                        object5 = new Tuple(dataArray);
                    }
                }
                catch (TypeException typeException) {
                    object5 = null;
                }
                arrayList.add((double[])object2);
                ((ArrayList)object6).add(object);
                if (object5 != null) {
                    arrayList2.add(object5);
                }
                if (n5 == 0) continue;
                n19 = ((float[][])object).length;
            }
            int n21 = ((ArrayList)object6).size();
            if (this.debug) {
                try {
                    System.out.println("domain size = " + arrayList.size());
                    object3 = (double[])arrayList.get(1);
                    System.out.println("domain.array[0] = " + (double)object3[0]);
                    System.out.println("range size = " + ((ArrayList)object6).size());
                    System.out.println("# samples = " + n21);
                }
                catch (Exception exception) {
                    System.out.println("out range");
                }
            }
            object3 = new Linear1DSet[n7];
            int n22 = n12;
            if (n7 == 1) {
                n22 = n21;
            }
            if (n7 == 2 && n12 == 1 && n19 > 1) {
                n22 = n19;
            }
            int n23 = 0;
            while (n23 < n7) {
                if (object7[n23]) {
                    object3[n23] = new Linear1DSet(dArray[0][n23], dArray[1][n23], n22);
                    if (this.debug) {
                        System.out.println("lset from domain = " + object3[n23]);
                    }
                } else if (nArray[n23] == -1) {
                    object3[n23] = new Linear1DSet(0.0, n22 - 1, n22);
                    if (this.debug) {
                        System.out.println("lset from range = " + object3[n23]);
                    }
                } else {
                    object3[n23] = null;
                }
                n22 = n21;
                ++n23;
            }
            Object object11 = null;
            if (n7 == 1) {
                if (object3[0] == null) {
                    object = this.getDomSamples(0, n21, arrayList);
                    object11 = new Irregular1DSet((MathType)object9, (float[][])object);
                } else {
                    object11 = object3[0];
                }
            } else if (n7 == 2) {
                if (object3[0] != null && object3[1] != null) {
                    object11 = new Linear2DSet((MathType)object9, (Linear1DSet[])object3);
                } else {
                    object = new float[2][n21];
                    object[0] = object3[0] == null ? this.getDomSamples(0, n21, arrayList)[0] : ((SampledSet)object3[0]).getSamples()[0];
                    object[1] = object3[1] == null ? this.getDomSamples(1, n21, arrayList)[0] : ((SampledSet)object3[1]).getSamples()[0];
                    object11 = new Irregular2DSet((MathType)object9, (float[][])object);
                }
            } else if (n7 == 3) {
                if (object3[0] != null && object3[1] != null && object3[2] != null) {
                    object11 = new Linear3DSet((MathType)object9, (Linear1DSet[])object3);
                } else {
                    object = new float[3][n21];
                    object[0] = object3[0] == null ? this.getDomSamples(0, n21, arrayList)[0] : ((SampledSet)object3[0]).getSamples()[0];
                    object[1] = object3[1] == null ? this.getDomSamples(1, n21, arrayList)[0] : ((SampledSet)object3[1]).getSamples()[0];
                    object[2] = object3[2] == null ? this.getDomSamples(2, n21, arrayList)[0] : ((SampledSet)object3[2]).getSamples()[0];
                    object11 = new Irregular3DSet((MathType)object9, (float[][])object);
                }
            } else {
                object11 = new LinearNDSet((MathType)object9, (Linear1DSet[])object3);
            }
            try {
                this.ff = new FlatField((FunctionType)mathType, (Set)object11);
            }
            catch (FieldException fieldException) {
                this.field = new FieldImpl((FunctionType)mathType, (Set)object11);
            }
            if (this.debug) {
                if (this.ff != null) {
                    System.out.println("ff.Length " + this.ff.getLength());
                    System.out.println("ff.getType " + this.ff.getType());
                }
                if (this.field != null) {
                    System.out.println("field.Length " + this.field.getLength());
                    System.out.println("field.getType " + this.field.getType());
                }
                System.out.println("domain = " + object11);
                System.out.println("size of a = " + n12 + " x " + n21 * n19);
            }
            object = new float[n12][n21 * n19];
            dataArray = new Tuple[n21];
            if (n5 != 0) {
                n = 0;
                n4 = 0;
                while (n4 < n21) {
                    double[] dArray2 = (double[])((ArrayList)object6).get(n4);
                    n2 = 0;
                    while (n2 < n19) {
                        object[0][n] = (float)dArray2[n2];
                        ++n;
                        ++n2;
                    }
                    ++n4;
                }
            } else {
                n = 0;
                while (n < n21) {
                    double[] dArray3 = (double[])((ArrayList)object6).get(n);
                    n3 = 0;
                    while (n3 < n12) {
                        object[n3][n] = (float)dArray3[n3];
                        ++n3;
                    }
                    if (!arrayList2.isEmpty()) {
                        dataArray[n] = (Tuple)arrayList2.get(n);
                    }
                    ++n;
                }
            }
            if (this.debug) {
                System.out.println("about to field.setSamples");
            }
            if (this.ff != null) {
                this.ff.setSamples((float[][])object);
                this.field = this.ff;
            } else {
                this.field.setSamples(dataArray, false);
            }
            ErrorEstimate[] errorEstimateArray = new ErrorEstimate[n12];
            int n24 = 0;
            while (n24 < n12) {
                errorEstimateArray[n24] = new ErrorEstimate(object[n24], this.rangeErrorEstimates[n24], this.rangeUnits[n24]);
                ++n24;
            }
            try {
                ((FlatField)this.field).setRangeErrors(errorEstimateArray);
            }
            catch (FieldException fieldException) {
                if (this.debug) {
                    System.out.println("caught " + fieldException);
                }
            }
            catch (ClassCastException classCastException) {
                if (!this.debug) break block160;
                System.out.println("caught " + classCastException);
            }
        }
        if (this.debug) {
            new DumpType();
            DumpType.dumpDataType(this.field, System.out);
            System.out.println("field = " + this.field);
        }
        bufferedReader.close();
    }

    private String makeMT(String string) {
        String string2;
        String string3 = "";
        int n = 0;
        while (n < string.length()) {
            string2 = string.substring(n, n + 1);
            if (!(string2.equals(" ") || string2.equals("\t") || string2.equals("\n"))) {
                string3 = string3 + string2;
            }
            ++n;
        }
        n = string3.indexOf("->");
        if (n < 0) {
            System.out.println("Invalid MathType form: -> required:" + n);
            return null;
        }
        if (string3.charAt(n - 1) != ')') {
            string3 = string2 = "(" + string3.substring(0, n) + ")->(" + string3.substring(n + 2) + ")";
        } else if (string3.charAt(n + 2) != '(') {
            string3 = string2 = string3.substring(0, n + 2) + "(" + string3.substring(n + 2) + ")";
        }
        if (!string3.startsWith("((")) {
            string3 = string2 = "(" + string3 + ")";
        }
        return string3;
    }

    private static final boolean isText(String string) {
        int n;
        int n2 = n = string == null ? -1 : string.length();
        if (n <= 0) {
            return true;
        }
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            if (Character.isISOControl(c) && !Character.isWhitespace(c)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    double getVal(String string, int n) {
        int n2 = this.values_to_index[2][n];
        if (n2 < 0 || string == null || string.length() < 1 || string.equals(this.hdrMissingStrings[n2])) {
            return Double.NaN;
        }
        try {
            double d = Double.parseDouble(string);
            if (d == this.hdrMissingValues[n2]) {
                return Double.NaN;
            }
            d = d * this.hdrScales[n2] + this.hdrOffsets[n2];
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Invalid number format for " + string);
            return Double.NaN;
        }
    }

    float[][] getDomSamples(int n, int n2, ArrayList arrayList) {
        float[][] fArray = new float[1][n2];
        int n3 = 0;
        while (n3 < n2) {
            double[] dArray = (double[])arrayList.get(n3);
            fArray[0][n3] = (float)dArray[n];
            ++n3;
        }
        return fArray;
    }

    public Field getData() {
        return this.field;
    }

    public TextAdapter(String string) throws IOException, VisADException {
        this.COMMA = ",";
        this.SEMICOLON = ";";
        this.TAB = "\t";
        this.BLANK = " ";
        FileInputStream fileInputStream = new FileInputStream(string);
        this.DELIM = null;
        if (string.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (string.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (string.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        this.readit(fileInputStream, null, null);
    }

    public TextAdapter(String string, String string2, String string3) throws IOException, VisADException {
        this.COMMA = ",";
        this.SEMICOLON = ";";
        this.TAB = "\t";
        this.BLANK = " ";
        FileInputStream fileInputStream = new FileInputStream(string);
        this.DELIM = null;
        if (string.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (string.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (string.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        this.readit(fileInputStream, string2, string3);
    }

    public TextAdapter(URL uRL) throws IOException, VisADException {
        this.COMMA = ",";
        this.SEMICOLON = ";";
        this.TAB = "\t";
        this.BLANK = " ";
        this.DELIM = null;
        String string = uRL.getFile();
        if (string.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (string.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (string.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        InputStream inputStream = uRL.openStream();
        this.readit(inputStream, null, null);
    }

    public TextAdapter(URL uRL, String string, String string2) throws IOException, VisADException {
        this.COMMA = ",";
        this.SEMICOLON = ";";
        this.TAB = "\t";
        this.BLANK = " ";
        this.DELIM = null;
        String string3 = uRL.getFile();
        if (string3.trim().toLowerCase().endsWith(".csv")) {
            this.DELIM = ",";
        }
        if (string3.trim().toLowerCase().endsWith(".tsv")) {
            this.DELIM = "\t";
        }
        if (string3.trim().toLowerCase().endsWith(".bsv")) {
            this.DELIM = " ";
        }
        InputStream inputStream = uRL.openStream();
        this.readit(inputStream, string, null);
    }
}

