/*
 * Decompiled with CFR 0.152.
 */
package visad.data.qt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Gridded2DSet;
import visad.Integer1DSet;
import visad.MathType;
import visad.RealType;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.DefaultFamily;
import visad.data.Form;
import visad.data.FormFileInformer;
import visad.data.FormNode;
import visad.util.DataUtility;
import visad.util.ReflectedUniverse;

public class QTForm
extends Form
implements FormFileInformer {
    public static final int FRAME_RATE = 60;
    private static int num = 0;
    private static final String[] suffixes = new String[]{"mov"};
    private static final String noQTmsg = "You need to install QuickTime for Java from http://www.apple.com/quicktime/";
    private static boolean noQT = false;
    private static ReflectedUniverse r = QTForm.createReflectedUniverse();

    private static ReflectedUniverse createReflectedUniverse() {
        ReflectedUniverse reflectedUniverse = null;
        try {
            reflectedUniverse = new ReflectedUniverse();
            reflectedUniverse.exec("import quicktime.QTSession");
            reflectedUniverse.exec("import quicktime.app.display.QTCanvas");
            reflectedUniverse.exec("import quicktime.app.image.ImageDataSequence");
            reflectedUniverse.exec("import quicktime.app.image.ImageUtil");
            reflectedUniverse.exec("import quicktime.app.image.JImagePainter");
            reflectedUniverse.exec("import quicktime.app.image.QTImageDrawer");
            reflectedUniverse.exec("import quicktime.app.image.QTImageProducer");
            reflectedUniverse.exec("import quicktime.app.image.Redrawable");
            reflectedUniverse.exec("import quicktime.app.players.MoviePlayer");
            reflectedUniverse.exec("import quicktime.io.OpenMovieFile");
            reflectedUniverse.exec("import quicktime.io.QTFile");
            reflectedUniverse.exec("import quicktime.qd.QDDimension");
            reflectedUniverse.exec("import quicktime.qd.QDGraphics");
            reflectedUniverse.exec("import quicktime.qd.QDRect");
            reflectedUniverse.exec("import quicktime.std.StdQTConstants");
            reflectedUniverse.exec("import quicktime.std.image.CodecComponent");
            reflectedUniverse.exec("import quicktime.std.image.CompressedFrameInfo");
            reflectedUniverse.exec("import quicktime.std.image.CSequence");
            reflectedUniverse.exec("import quicktime.std.image.ImageDescription");
            reflectedUniverse.exec("import quicktime.std.image.QTImage");
            reflectedUniverse.exec("import quicktime.std.movies.Movie");
            reflectedUniverse.exec("import quicktime.std.movies.Track");
            reflectedUniverse.exec("import quicktime.std.movies.media.VideoMedia");
            reflectedUniverse.exec("import quicktime.util.QTHandle");
            reflectedUniverse.exec("import quicktime.util.RawEncodedImage");
        }
        catch (VisADException visADException) {
            noQT = true;
        }
        return reflectedUniverse;
    }

    public boolean isThisType(String string) {
        if (noQT) {
            return false;
        }
        int n = 0;
        while (n < suffixes.length) {
            if (string.toLowerCase().endsWith(suffixes[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isThisType(byte[] byArray) {
        return false;
    }

    public String[] getDefaultSuffixes() {
        String[] stringArray = new String[suffixes.length];
        System.arraycopy(suffixes, 0, stringArray, 0, suffixes.length);
        return stringArray;
    }

    private void setCurrentFrame(int n, BufferedImage bufferedImage, FlatField[] flatFieldArray) {
        Image image = DataUtility.extractImage(flatFieldArray[n], false);
        if (image != null) {
            Graphics graphics = bufferedImage.getGraphics();
            graphics.drawImage(image, 0, 0, null);
            graphics.dispose();
        }
    }

    public void save(String string, Data data, boolean bl) throws BadFormException, IOException, RemoteException, VisADException {
        if (noQT) {
            throw new BadFormException(noQTmsg);
        }
        try {
            FlatField[] flatFieldArray = DataUtility.getImageFields(data);
            int n = flatFieldArray.length;
            Gridded2DSet gridded2DSet = (Gridded2DSet)flatFieldArray[0].getDomainSet();
            int[] nArray = gridded2DSet.getLengths();
            int n2 = nArray[0];
            int n3 = nArray[1];
            r.setVar("numFrames", new Integer(n));
            r.setVar("kWidth", new Integer(n2));
            r.setVar("kHeight", new Integer(n3));
            r.exec("QTSession.open()");
            r.setVar("oneHalf", new Float(0.5f));
            Component component = (Component)r.exec("canv = new QTCanvas(QTCanvas.kInitialSize, oneHalf, oneHalf)");
            JFrame jFrame = new JFrame();
            JPanel jPanel = new JPanel();
            jFrame.setContentPane(jPanel);
            jPanel.add("Center", component);
            BufferedImage bufferedImage = new BufferedImage(n2, n3, 1);
            r.setVar("buffer", bufferedImage);
            r.exec("ip = new JImagePainter(buffer)");
            Dimension dimension = new Dimension(n2, n3);
            r.setVar("dim", dimension);
            r.exec("qid = new QTImageDrawer(ip, dim, Redrawable.kMultiFrame)");
            r.setVar("true", new Boolean(true));
            r.exec("qid.setRedrawing(true)");
            r.exec("canv.setClient(qid, true)");
            jFrame.pack();
            File file = new File(string);
            r.setVar("path", file.getAbsolutePath());
            r.exec("f = new QTFile(path)");
            Integer n4 = (Integer)r.getVar("StdQTConstants.createMovieFileDeleteCurFile");
            Integer n5 = (Integer)r.getVar("StdQTConstants.createMovieFileDontCreateResFile");
            r.setVar("flags", new Integer(n4 | n5));
            r.exec("theMovie = Movie.createMovieFile(f, StdQTConstants.kMoviePlayer, flags)");
            int n6 = 0;
            r.setVar("kNoVolume", new Integer(n6));
            r.setVar("kVidTimeScale", new Integer(600));
            r.setVar("fkWidth", new Float(n2));
            r.setVar("fkHeight", new Float(n3));
            r.setVar("fkNoVolume", new Float(n6));
            r.exec("vidTrack = theMovie.addTrack(fkWidth, fkHeight, fkNoVolume)");
            r.exec("vidMedia = new VideoMedia(vidTrack, kVidTimeScale)");
            r.exec("vidMedia.beginEdits()");
            r.exec("rect = new QDRect(kWidth, kHeight)");
            r.exec("gw = new QDGraphics(rect)");
            r.exec("pixmap = gw.getPixMap()");
            r.exec("pixsize = pixmap.getPixelSize()");
            r.exec("size = QTImage.getMaxCompressionSize(gw, rect, pixsize, StdQTConstants.codecNormalQuality, StdQTConstants.kAnimationCodecType, CodecComponent.anyCodec)");
            r.exec("imageHandle = new QTHandle(size, true)");
            r.exec("imageHandle.lock()");
            r.exec("compressedImage = RawEncodedImage.fromQTHandle(imageHandle)");
            r.setVar("zero", new Integer(0));
            r.exec("seq = new CSequence(gw, rect, pixsize, StdQTConstants.kAnimationCodecType, CodecComponent.bestFidelityCodec, StdQTConstants.codecNormalQuality, StdQTConstants.codecNormalQuality, numFrames, null, zero)");
            r.exec("desc = seq.getDescription()");
            this.setCurrentFrame(0, bufferedImage, flatFieldArray);
            r.exec("qid.redraw(null)");
            r.exec("qid.setGWorld(gw)");
            r.exec("qid.setDisplayBounds(rect)");
            int n7 = 0;
            while (n7 < n) {
                this.setCurrentFrame(n7, bufferedImage, flatFieldArray);
                r.exec("qid.redraw(null)");
                r.exec("info = seq.compressFrame(gw, rect, StdQTConstants.codecFlagUpdatePrevious, compressedImage)");
                Integer n8 = (Integer)r.exec("info.getSimilarity()");
                if (n8 == 0) {
                    r.setVar("keyFrame", new Integer(0));
                } else {
                    r.setVar("keyFrame", r.getVar("StdQTConstants.mediaSampleNotSync"));
                }
                r.exec("dataSize = info.getDataSize()");
                r.setVar("one", new Integer(1));
                r.setVar("frameRate", new Integer(60));
                r.exec("vidMedia.addSample(imageHandle, zero, dataSize, frameRate, desc, one, keyFrame)");
                ++n7;
            }
            r.exec("port = canv.getPort()");
            r.exec("qid.setGWorld(port)");
            r.exec("qid.redraw(null)");
            r.exec("vidMedia.endEdits()");
            r.setVar("kTrackStart", new Integer(0));
            r.setVar("kMediaTime", new Integer(0));
            r.setVar("kMediaRate", new Float(1.0f));
            r.exec("duration = vidMedia.getDuration()");
            r.exec("vidTrack.insertMedia(kTrackStart, kMediaTime, duration, kMediaRate)");
            r.exec("outStream = OpenMovieFile.asWrite(f)");
            r.exec("name = f.getName()");
            r.exec("theMovie.addResource(outStream, StdQTConstants.movieInDataForkResID, name)");
            r.exec("outStream.close()");
            r.exec("QTSession.close()");
        }
        catch (Exception exception) {
            r.exec("QTSession.close()");
            throw new BadFormException("Save movie failed: " + exception.getMessage());
        }
    }

    public void add(String string, Data data, boolean bl) throws BadFormException {
        throw new BadFormException("QTForm.add");
    }

    public DataImpl open(String string) throws BadFormException, IOException, VisADException {
        Data[] dataArray;
        int n;
        Comparable<File> comparable;
        if (noQT) {
            throw new BadFormException(noQTmsg);
        }
        try {
            Integer n2;
            r.exec("QTSession.open()");
            comparable = new File(string);
            r.setVar("path", comparable.getAbsolutePath());
            r.exec("qtf = new QTFile(path)");
            r.exec("openMovieFile = OpenMovieFile.asRead(qtf)");
            r.exec("m = Movie.fromFile(openMovieFile)");
            int n3 = (Integer)r.exec("m.getTrackCount()");
            int n4 = 0;
            int n5 = 0;
            while (++n5 <= n3 && n4 == 0) {
                r.setVar("trackNum", new Integer(n5));
                r.exec("imageTrack = m.getTrack(trackNum)");
                r.exec("d = imageTrack.getSize()");
                n2 = (Integer)r.exec("d.getWidth()");
                if (n2 <= 0) continue;
                n4 = n5;
            }
            r.setVar("trackMostLikely", new Integer(n4));
            r.exec("imageTrack = m.getTrack(trackMostLikely)");
            r.exec("d = imageTrack.getSize()");
            n2 = (Integer)r.exec("d.getWidth()");
            Integer n6 = (Integer)r.exec("d.getHeight()");
            r.exec("seq = ImageUtil.createSequence(imageTrack)");
            n = (Integer)r.exec("seq.size()");
            r.exec("moviePlayer = new MoviePlayer(m)");
            r.setVar("dim", new Dimension(n2, n6));
            ImageProducer imageProducer = (ImageProducer)r.exec("qtip = new QTImageProducer(moviePlayer, dim)");
            Image image = Toolkit.getDefaultToolkit().createImage(imageProducer);
            boolean bl = (Boolean)r.exec("qtip.isRedrawing()");
            int n7 = (Integer)r.exec("m.getDuration()");
            int n8 = n7 / n;
            dataArray = new FlatField[n];
            int n9 = 0;
            while (n9 < n) {
                r.setVar("time", new Integer(n8 * n9));
                r.exec("moviePlayer.setTime(time)");
                if (bl) {
                    r.exec("qtip.redraw(null)");
                }
                r.exec("qtip.updateConsumers(null)");
                dataArray[n9] = DataUtility.makeField(image);
                ++n9;
            }
            r.exec("openMovieFile.close()");
            r.exec("QTSession.close()");
        }
        catch (Exception exception) {
            r.exec("QTSession.close()");
            throw new BadFormException("Open movie failed: " + exception.getMessage());
        }
        if (n == 1) {
            return dataArray[0];
        }
        comparable = RealType.getRealType("time");
        FunctionType functionType = new FunctionType((MathType)((Object)comparable), dataArray[0].getType());
        Integer1DSet integer1DSet = new Integer1DSet(n);
        FieldImpl fieldImpl = new FieldImpl(functionType, integer1DSet);
        fieldImpl.setSamples(dataArray, false);
        return fieldImpl;
    }

    public DataImpl open(URL uRL) throws BadFormException, IOException, VisADException {
        throw new BadFormException("QTForm.open(URL)");
    }

    public FormNode getForms(Data data) {
        return null;
    }

    public static void main(String[] stringArray) throws VisADException, RemoteException, IOException {
        if (stringArray == null || stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("To convert a file to QuickTime, run:");
            System.out.println("  java visad.data.qt.QTForm in_file out_file");
            System.out.println("To test read a QuickTime file, run:");
            System.out.println("  java visad.data.qt.QTForm in_file");
            System.exit(2);
        }
        if (stringArray.length == 1) {
            QTForm qTForm = new QTForm();
            System.out.print("Reading " + stringArray[0] + " ");
            DataImpl dataImpl = qTForm.open(stringArray[0]);
            System.out.println("[done]");
            System.out.println("MathType =\n" + dataImpl.getType().prettyString());
        } else if (stringArray.length == 2) {
            System.out.print(stringArray[0] + " -> " + stringArray[1] + " ");
            DefaultFamily defaultFamily = new DefaultFamily("loader");
            DataImpl dataImpl = defaultFamily.open(stringArray[0]);
            defaultFamily = null;
            QTForm qTForm = new QTForm();
            qTForm.save(stringArray[1], dataImpl, true);
            System.out.println("[done]");
        }
    }

    public QTForm() {
        super("QTForm" + num++);
    }
}

