/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.out;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.RemoteException;
import ucar.multiarray.Accessor;
import ucar.multiarray.IndexIterator;
import ucar.netcdf.AbstractNetcdf;
import ucar.netcdf.Dimension;
import ucar.netcdf.ProtoVariable;
import visad.Data;
import visad.Field;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Linear1DSet;
import visad.LinearSet;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.ScalarType;
import visad.Set;
import visad.SetType;
import visad.Text;
import visad.Tuple;
import visad.UnimplementedException;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.out.CoordVar;
import visad.data.netcdf.out.DependentRealVar;
import visad.data.netcdf.out.DependentTextVar;
import visad.data.netcdf.out.FieldAccessor;
import visad.data.netcdf.out.IndependentVar;
import visad.data.netcdf.out.RealAccessor;
import visad.data.netcdf.out.TextAccessor;
import visad.data.netcdf.out.TrivialAccessor;
import visad.data.netcdf.out.TupleAccessor;
import visad.data.netcdf.out.VisADAccessor;

public class VisADAdapter
extends AbstractNetcdf {
    protected void visit(Data data, VisADAccessor visADAccessor) throws UnimplementedException, BadFormException, VisADException, RemoteException, IOException {
        if (data instanceof Text) {
            this.visit((Text)data, visADAccessor);
        } else if (data instanceof Real) {
            this.visit((Real)data, visADAccessor);
        } else if (data instanceof Tuple) {
            this.visit((Tuple)data, visADAccessor);
        } else if (data instanceof Field) {
            this.visit((Field)data, visADAccessor);
        } else {
            throw new UnimplementedException("VisAD data type not yet supported: " + data.getClass().getName());
        }
    }

    protected void visit(Text text, VisADAccessor visADAccessor) throws BadFormException, IOException {
        int n = 0;
        Object object = new IndexIterator(visADAccessor.getLengths());
        while (((IndexIterator)object).notDone()) {
            int n2 = ((Text)visADAccessor.get(((IndexIterator)object).value())).getValue().length();
            if (n2 > n) {
                n = n2;
            }
            ((IndexIterator)object).incr();
        }
        object = ((ScalarType)text.getType()).getName() + "_len";
        Dimension dimension = new Dimension((String)object, n);
        this.putDimension(dimension);
        DependentTextVar dependentTextVar = new DependentTextVar(text, new TextAccessor(dimension, visADAccessor));
        try {
            this.add(dependentTextVar, dependentTextVar);
        }
        catch (Exception exception) {
            throw new BadFormException(exception.getMessage());
        }
    }

    protected void visit(Real real, VisADAccessor visADAccessor) throws BadFormException, VisADException {
        DependentRealVar dependentRealVar = new DependentRealVar(real, new RealAccessor(visADAccessor));
        try {
            this.add(dependentRealVar, dependentRealVar);
        }
        catch (Exception exception) {
            throw new BadFormException(exception.getMessage());
        }
    }

    protected void visit(Tuple tuple, VisADAccessor visADAccessor) throws VisADException, RemoteException, IOException {
        int n = tuple.getDimension();
        int n2 = 0;
        while (n2 < n) {
            this.visit(tuple.getComponent(n2), (VisADAccessor)new TupleAccessor(n2, visADAccessor));
            ++n2;
        }
    }

    protected void visit(Field field, VisADAccessor visADAccessor) throws RemoteException, VisADException, BadFormException, UnimplementedException, IOException {
        Dimension[] dimensionArray;
        Set set = field.getDomainSet();
        if (set instanceof LinearSet) {
            dimensionArray = this.defineLinearSetDims((GriddedSet)set);
        } else if (set instanceof SampledSet) {
            dimensionArray = new Dimension[]{this.defineSampledSetDim((SampledSet)set)};
        } else {
            throw new BadFormException("Can't handle a " + set.getClass().getName() + " domain set");
        }
        this.visit(field.getSample(0), (VisADAccessor)new FieldAccessor(this.reverse(dimensionArray), visADAccessor));
    }

    protected Dimension[] defineLinearSetDims(GriddedSet griddedSet) throws VisADException, BadFormException {
        int n = griddedSet.getDimension();
        Dimension[] dimensionArray = new Dimension[n];
        RealTupleType realTupleType = ((SetType)griddedSet.getType()).getDomain();
        Unit[] unitArray = griddedSet.getSetUnits();
        int n2 = 0;
        while (n2 < n) {
            Linear1DSet linear1DSet = ((LinearSet)((Object)griddedSet)).getLinear1DComponent(n2);
            int n3 = linear1DSet.getLength(0);
            String string = ((RealType)realTupleType.getComponent(n2)).getName();
            dimensionArray[n2] = new Dimension(string, n3);
            if (linear1DSet.getFirst() != 0.0 || linear1DSet.getStep() != 1.0) {
                CoordVar coordVar = new CoordVar(string, dimensionArray[n2], unitArray[n2], linear1DSet);
                try {
                    this.add(coordVar, coordVar);
                }
                catch (Exception exception) {
                    throw new BadFormException(exception.getMessage());
                }
            }
            ++n2;
        }
        return dimensionArray;
    }

    protected Dimension defineSampledSetDim(SampledSet sampledSet) throws VisADException, BadFormException {
        int n = sampledSet.getManifoldDimension();
        return n == 1 ? this.define1DDim(sampledSet) : this.defineNDDim(sampledSet);
    }

    protected Dimension define1DDim(SampledSet sampledSet) throws VisADException, BadFormException {
        RealTupleType realTupleType = ((SetType)sampledSet.getType()).getDomain();
        String string = ((RealType)realTupleType.getComponent(0)).getName();
        Dimension dimension = new Dimension(string, sampledSet.getLength());
        Unit[] unitArray = sampledSet.getSetUnits();
        if (!(sampledSet instanceof Gridded1DSet)) {
            throw new BadFormException("Domain set not Gridded1DSet");
        }
        CoordVar coordVar = new CoordVar(string, dimension, unitArray[0], (Gridded1DSet)sampledSet);
        try {
            this.add(coordVar, coordVar);
        }
        catch (Exception exception) {
            throw new BadFormException(exception.getMessage());
        }
        return dimension;
    }

    protected Dimension defineNDDim(SampledSet sampledSet) throws VisADException, BadFormException {
        RealTupleType realTupleType = ((SetType)sampledSet.getType()).getDomain();
        int n = realTupleType.getDimension();
        Unit[] unitArray = sampledSet.getSetUnits();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = ((RealType)realTupleType.getComponent(n2)).getName();
            ++n2;
        }
        n2 = stringArray[0].length();
        int n3 = 1;
        while (n3 < n) {
            n2 += 1 + stringArray[n3].length();
            ++n3;
        }
        Serializable serializable = new StringBuffer(n2 += 4);
        serializable.append(stringArray[0]);
        int n4 = 1;
        while (n4 < n) {
            serializable.append("_");
            serializable.append(stringArray[n4]);
            ++n4;
        }
        serializable.append("_ndx");
        Dimension dimension = new Dimension(serializable.toString(), sampledSet.getLength());
        n2 = 0;
        while (n2 < n) {
            serializable = new IndependentVar(stringArray[n2], dimension, unitArray[n2], sampledSet, n2);
            try {
                this.add((ProtoVariable)serializable, (Accessor)((Object)serializable));
            }
            catch (Exception exception) {
                throw new BadFormException(exception.getMessage());
            }
            ++n2;
        }
        return dimension;
    }

    protected Dimension[] reverse(Dimension[] dimensionArray) {
        Dimension[] dimensionArray2 = new Dimension[dimensionArray.length];
        int n = 0;
        while (n < dimensionArray.length) {
            dimensionArray2[n] = dimensionArray[dimensionArray.length - 1 - n];
            ++n;
        }
        return dimensionArray2;
    }

    public Accessor ioFactory(ProtoVariable protoVariable) {
        throw new UnsupportedOperationException();
    }

    public VisADAdapter(Data data) throws BadFormException, VisADException, RemoteException, IOException {
        try {
            this.visit(data, (VisADAccessor)new TrivialAccessor(data));
        }
        catch (UnimplementedException unimplementedException) {
            throw new BadFormException(unimplementedException.getMessage());
        }
    }
}

