/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.out;

import java.io.IOException;
import ucar.netcdf.Attribute;
import visad.DoubleSet;
import visad.FloatSet;
import visad.Real;
import visad.RealType;
import visad.ScalarType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.out.DependentVar;
import visad.data.netcdf.out.VisADAccessor;

class DependentRealVar
extends DependentVar {
    private final Number fillValue;

    protected static Attribute[] myAttributes(Real real) throws VisADException, BadFormException {
        RealType realType = (RealType)real.getType();
        Number number = DependentRealVar.getFillValue(DependentRealVar.getJavaClass(realType.getDefaultSet()));
        Unit unit = real.getUnit();
        Attribute[] attributeArray = unit == null ? new Attribute[]{new Attribute("_FillValue", number)} : new Attribute[]{new Attribute("_FillValue", number), new Attribute("units", unit.toString())};
        return attributeArray;
    }

    protected static Class getJavaClass(Set set) throws VisADException {
        if (set == null || set instanceof DoubleSet) {
            return Double.TYPE;
        }
        if (set instanceof FloatSet) {
            return Float.TYPE;
        }
        int n = set.getLength();
        return n >= 65536 ? Integer.TYPE : (n >= 256 ? Short.TYPE : Byte.TYPE);
    }

    protected static Number getFillValue(Class clazz) throws BadFormException {
        Number number;
        if (clazz.equals(Byte.TYPE)) {
            number = new Byte(-128);
        } else if (clazz.equals(Short.TYPE)) {
            number = new Short(-32767);
        } else if (clazz.equals(Integer.TYPE)) {
            number = new Integer(-2147483647);
        } else if (clazz.equals(Float.TYPE)) {
            number = new Float((double)9.96921E36f);
        } else if (clazz.equals(Double.TYPE)) {
            number = new Double(9.96921E36f);
        } else {
            throw new BadFormException("Unknown netCDF type: " + clazz);
        }
        return number;
    }

    public Object get(int[] nArray) throws IOException {
        Double d = (Double)this.getAccessor().get(nArray);
        return d.isNaN() ? (Number)this.fillValue : (Number)d;
    }

    protected DependentRealVar(Real real, VisADAccessor visADAccessor) throws VisADException, BadFormException {
        super(((ScalarType)real.getType()).getName(), DependentRealVar.getJavaClass(((RealType)real.getType()).getDefaultSet()), visADAccessor.getDimensions(), DependentRealVar.myAttributes(real), visADAccessor);
        this.fillValue = DependentRealVar.getFillValue(DependentRealVar.getJavaClass(((RealType)real.getType()).getDefaultSet()));
    }
}

