/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.out;

import java.io.IOException;
import ucar.netcdf.Dimension;
import visad.data.netcdf.out.VisADAccessor;

abstract class DataAccessor
implements VisADAccessor {
    protected final int localRank;
    protected final Dimension[] localDims;
    protected volatile int[] localIndexes;
    protected final VisADAccessor outerAccessor;
    protected final int outerRank;
    protected volatile int[] outerIndexes;

    public int getRank() {
        return this.outerRank + this.localRank;
    }

    public Dimension[] getDimensions() {
        Dimension[] dimensionArray = new Dimension[this.getRank()];
        System.arraycopy(this.outerAccessor.getDimensions(), 0, dimensionArray, 0, this.outerRank);
        System.arraycopy(this.localDims, 0, dimensionArray, this.outerRank, this.localRank);
        return dimensionArray;
    }

    public int[] getLengths() {
        int[] nArray = new int[this.getRank()];
        Dimension[] dimensionArray = this.getDimensions();
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = dimensionArray[n].getLength();
            ++n;
        }
        return nArray;
    }

    public Object get(int[] nArray) throws IOException {
        System.arraycopy(nArray, 0, this.outerIndexes, 0, this.outerRank);
        System.arraycopy(nArray, this.outerRank, this.localIndexes, 0, this.localRank);
        return this.get();
    }

    protected abstract Object get() throws IOException;

    protected DataAccessor(Dimension[] dimensionArray, VisADAccessor visADAccessor) {
        this.localRank = dimensionArray.length;
        this.outerRank = visADAccessor.getRank();
        this.localDims = dimensionArray;
        this.localIndexes = new int[this.localRank];
        this.outerIndexes = new int[this.outerRank];
        this.outerAccessor = visADAccessor;
    }
}

