/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import java.util.Vector;
import visad.DataImpl;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.TupleType;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.DataFactory;
import visad.data.netcdf.in.VirtualData;

public class VirtualTuple
extends VirtualData {
    private DataFactory dataFactory = DataFactory.instance();
    private final Vector components;
    private MathType mathType = null;
    private boolean isDirty = true;

    public int size() {
        return this.components.size();
    }

    public synchronized void add(VirtualData virtualData) {
        this.components.add(virtualData);
        this.isDirty = true;
    }

    public MathType getType() throws VisADException {
        if (this.isDirty) {
            int n = this.size();
            if (n == 0) {
                this.mathType = null;
            } else if (n == 1) {
                this.mathType = ((VirtualData)this.components.get(0)).getType();
            } else {
                MathType[] mathTypeArray = new MathType[n];
                boolean bl = true;
                int n2 = 0;
                while (n2 < n) {
                    mathTypeArray[n2] = ((VirtualData)this.components.get(n2)).getType();
                    if (!(mathTypeArray[n2] instanceof RealType)) {
                        bl = false;
                    }
                    ++n2;
                }
                if (!bl) {
                    this.mathType = new TupleType(mathTypeArray);
                } else {
                    RealType[] realTypeArray = new RealType[n];
                    int n3 = 0;
                    while (n3 < n) {
                        realTypeArray[n3] = (RealType)mathTypeArray[n3];
                        ++n3;
                    }
                    this.mathType = new RealTupleType(realTypeArray);
                }
            }
            this.isDirty = false;
        }
        return this.mathType;
    }

    public VirtualData get(int n) throws ArrayIndexOutOfBoundsException {
        return (VirtualData)this.components.get(n);
    }

    public synchronized void replace(int n, VirtualData virtualData) throws ArrayIndexOutOfBoundsException {
        this.components.set(n, virtualData);
        this.isDirty = true;
    }

    public DataImpl getData(Context context) throws VisADException, RemoteException, IOException {
        return this.getDataFactory().newData(context, this);
    }

    public synchronized void clear() {
        this.components.clear();
        this.mathType = null;
        this.isDirty = true;
    }

    public synchronized Object clone() {
        int n = this.size();
        VirtualTuple virtualTuple = new VirtualTuple(n);
        int n2 = 0;
        while (n2 < n) {
            virtualTuple.add((VirtualData)this.get(n2).clone());
            ++n2;
        }
        return virtualTuple;
    }

    public void setDataFactory(DataFactory dataFactory) {
        this.dataFactory = dataFactory;
    }

    public DataFactory getDataFactory() {
        return this.dataFactory;
    }

    public VirtualTuple() {
        this(0);
    }

    private VirtualTuple(int n) {
        this.components = new Vector(n);
    }

    public VirtualTuple(VirtualData virtualData) {
        this(1);
        this.add(virtualData);
    }

    public VirtualTuple(VirtualData[] virtualDataArray) {
        this(virtualDataArray.length);
        int n = 0;
        while (n < virtualDataArray.length) {
            this.add(virtualDataArray[n]);
            ++n;
        }
    }
}

