/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.FunctionType;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.SetType;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.DataFactory;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualFlatField;
import visad.data.netcdf.in.VirtualTuple;

public class VirtualField
extends VirtualData {
    private final FunctionType functionType;
    private final SampledSet domainSet;
    private final VirtualTuple rangeTuple;

    public static VirtualField newVirtualField(SampledSet sampledSet, VirtualTuple virtualTuple) throws VisADException {
        return VirtualField.newVirtualField(new FunctionType(((SetType)sampledSet.getType()).getDomain(), virtualTuple.getType()), sampledSet, virtualTuple);
    }

    public static VirtualField newVirtualField(FunctionType functionType, SampledSet sampledSet, VirtualTuple virtualTuple) {
        MathType mathType = functionType.getRange();
        return mathType instanceof RealType || mathType instanceof RealTupleType ? new VirtualFlatField(functionType, sampledSet, virtualTuple) : new VirtualField(functionType, sampledSet, virtualTuple);
    }

    public FunctionType getFunctionType() {
        return this.functionType;
    }

    public MathType getType() {
        return this.getFunctionType();
    }

    public SampledSet getDomainSet() {
        return this.domainSet;
    }

    public VirtualTuple getRangeTuple() {
        return this.rangeTuple;
    }

    public DataImpl getData(Context context) throws VisADException, RemoteException, IOException {
        return this.getDataFactory().newData(context, this);
    }

    public Object clone() {
        return new VirtualField(this.functionType, this.domainSet, (VirtualTuple)this.rangeTuple.clone());
    }

    public void setDataFactory(DataFactory dataFactory) {
        this.rangeTuple.setDataFactory(dataFactory);
    }

    public DataFactory getDataFactory() {
        return this.rangeTuple.getDataFactory();
    }

    protected VirtualField(FunctionType functionType, SampledSet sampledSet, VirtualTuple virtualTuple) {
        this.functionType = functionType;
        this.domainSet = sampledSet;
        this.rangeTuple = virtualTuple;
    }
}

