/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import ucar.netcdf.Attribute;
import ucar.netcdf.Dimension;
import ucar.netcdf.DimensionIterator;
import ucar.netcdf.Netcdf;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.DoubleSet;
import visad.FloatSet;
import visad.Gridded1DDoubleSet;
import visad.Gridded1DSet;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.RealType;
import visad.SI;
import visad.ScalarType;
import visad.SimpleSet;
import visad.TextType;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.in.ArithProg;
import visad.data.in.LonArithProg;
import visad.data.netcdf.Quantity;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.in.CfView;
import visad.data.netcdf.in.DefaultView;
import visad.data.netcdf.in.Vetter;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualDataIterator;
import visad.data.netcdf.in.VirtualField;
import visad.data.netcdf.in.VirtualScalar;
import visad.data.netcdf.in.VirtualTuple;
import visad.data.units.Parser;

public abstract class View {
    private static int nameCount;
    private final Netcdf netcdf;
    private final QuantityDB quantityDB;
    private final Map varToRealType;
    private final Map varToUnit;
    private final Map dimToSet;
    private final Map dimToRealType;
    private final Quantity longitude;
    private final Quantity latitude;

    public static View getInstance(Netcdf netcdf, QuantityDB quantityDB) {
        View view;
        String string = View.getConventionsString(netcdf);
        if (string == null) {
            view = new DefaultView(netcdf, quantityDB);
        } else {
            try {
                if (string.equals("CF-1.0")) {
                    view = new CfView(netcdf, quantityDB);
                } else if (string.equals("COARDS")) {
                    view = new CfView(netcdf, quantityDB);
                } else if (string.equals("COARDS/CF-1.0")) {
                    view = new CfView(netcdf, quantityDB);
                } else {
                    System.err.println("Unknown netCDF conventions attribute (" + string + ").  Using default view...");
                    view = new DefaultView(netcdf, quantityDB);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("netCDF dataset doesn't follow stated conventions (" + string + "): " + illegalArgumentException.getMessage() + "\nUsing default view...");
                view = new DefaultView(netcdf, quantityDB);
            }
        }
        return view;
    }

    public Netcdf getNetcdf() {
        return this.netcdf;
    }

    protected static String getConventionsString(Netcdf netcdf) {
        Attribute attribute = netcdf.getAttribute("Conventions");
        try {
            return attribute != null ? attribute.getStringValue() : null;
        }
        catch (ClassCastException classCastException) {
            System.err.println("The \"Conventions\" attribute (" + attribute + ") isn't a string");
            return null;
        }
    }

    protected Variable getVariable(String string) {
        return this.netcdf.get(string);
    }

    protected boolean isNumeric(String string) {
        Variable variable = this.netcdf.get(string);
        if (variable == null) {
            return false;
        }
        return this.isNumeric(variable);
    }

    protected boolean isNumeric(Variable variable) {
        return !variable.getComponentType().equals(Character.TYPE);
    }

    protected boolean isLongitude(Variable variable) throws VisADException {
        RealType realType = this.getRealType(variable);
        return realType != null && realType.equals(this.longitude);
    }

    protected boolean isLongitude(RealType realType) {
        return realType != null && realType.equals(this.longitude);
    }

    protected boolean isLatitude(RealType realType) {
        return realType != null && realType.equals(this.latitude);
    }

    protected RealType getRealType(Dimension dimension) throws TypeException {
        RealType realType;
        Variable variable = this.getCoordinateVariable(dimension);
        if (variable != null) {
            realType = this.getRealType(variable);
        } else {
            Map map = this.dimToRealType;
            synchronized (map) {
                realType = (RealType)this.dimToRealType.get(dimension);
                if (realType == null) {
                    String string = dimension.getName();
                    realType = this.quantityDB.get(string);
                    if (realType == null) {
                        realType = RealType.getRealType(string);
                    }
                    this.dimToRealType.put(dimension, realType);
                }
            }
        }
        return realType;
    }

    protected RealType getRealType(Variable variable) throws TypeException {
        RealType realType;
        if (variable == null) {
            throw new NullPointerException();
        }
        Map map = this.varToRealType;
        synchronized (map) {
            realType = (RealType)this.varToRealType.get(variable);
            if (realType == null) {
                realType = this.getRealTypeFromLongName(variable);
                if (realType == null) {
                    realType = this.getRealTypeFromName(variable);
                }
                this.varToRealType.put(variable, realType);
            }
        }
        return realType;
    }

    protected RealType getRealTypeFromLongName(Variable variable) {
        RealType realType;
        String string = this.getLongName(variable);
        if (string == null) {
            realType = null;
        } else {
            Unit unit;
            realType = this.quantityDB.get(string);
            if (realType != null && !Unit.canConvert(unit = this.getUnitFromAttribute(variable), realType.getDefaultUnit())) {
                String string2 = this.newName(variable);
                System.err.println("The unit attribute (" + unit + ") " + "of variable \"" + variable.getName() + "\" " + "is incompatible with the unit (" + realType.getDefaultUnit() + ") " + "of the quantity referenced by the long_name attribute " + "(" + string + ").  " + "Attempting to create new quantity \"" + string2 + "\".");
                realType = RealType.getRealType(string2, unit);
            }
        }
        return realType;
    }

    protected RealType getRealTypeFromName(Variable variable) throws TypeException {
        String string = variable.getName();
        Unit unit = this.getUnitFromAttribute(variable);
        RealType realType = this.quantityDB.get(string);
        if (realType != null) {
            if (!Unit.canConvert(unit, realType.getDefaultUnit())) {
                realType = this.newQuantity(variable, unit, realType.getDefaultUnit());
            }
        } else if (unit == null) {
            realType = RealType.getRealType(string);
        } else {
            realType = RealType.getRealType(string, unit);
            if (realType == null) {
                realType = this.newQuantity(variable, unit, RealType.getRealTypeByName(string).getDefaultUnit());
            }
        }
        return realType;
    }

    private RealType newQuantity(Variable variable, Unit unit, Unit unit2) throws TypeException {
        String string = this.newName(variable);
        System.err.println("The unit attribute (" + unit + ") " + "of variable \"" + variable.getName() + "\" " + "is incompatible with the unit (" + unit2 + ") of the RealType of the same name.  " + "Attempting to create new RealType \"" + string + "\".");
        RealType realType = RealType.getRealType(string, unit);
        if (realType == null) {
            throw new TypeException(string);
        }
        return realType;
    }

    protected String newName(Variable variable) {
        return variable.getName() + "_" + nameCount++;
    }

    protected ScalarType getScalarType(Variable variable) throws TypeException, VisADException {
        return this.isNumeric(variable) ? this.getRealType(variable) : this.getTextType(variable);
    }

    protected TextType getTextType(Variable variable) throws VisADException {
        if (this.isNumeric(variable)) {
            throw new IllegalArgumentException(variable.toString());
        }
        return new TextType(variable.getName());
    }

    protected SimpleSet getRangeSet(Variable variable) throws TypeException, VisADException {
        SimpleSet simpleSet;
        Class clazz = variable.getComponentType();
        if (clazz.equals(Character.TYPE)) {
            simpleSet = null;
        } else {
            RealType realType = this.getRealType(variable);
            if (clazz.equals(Byte.TYPE)) {
                simpleSet = new Linear1DSet((MathType)realType, -127.0, 127.0, 255);
            } else if (clazz.equals(Short.TYPE)) {
                simpleSet = new Linear1DSet((MathType)realType, -32767.0, 32767.0, 65535);
            } else if (clazz.equals(Integer.TYPE)) {
                Vetter vetter = this.getVetter(variable);
                long l = (long)vetter.minValid();
                long l2 = (long)vetter.maxValid();
                long l3 = l2 - l + 1L;
                simpleSet = l3 <= Integer.MAX_VALUE ? new Linear1DSet((MathType)realType, l, l2, (int)l3) : new FloatSet(realType, null, new Unit[]{this.getUnitFromAttribute(variable)});
            } else {
                simpleSet = clazz.equals(Float.TYPE) ? new FloatSet(realType, null, new Unit[]{this.getUnitFromAttribute(variable)}) : new DoubleSet(realType, null, new Unit[]{this.getUnitFromAttribute(variable)});
            }
        }
        return simpleSet;
    }

    protected String getAttributeString(String string) {
        return this.getAttributeString(null, string);
    }

    protected String getAttributeString(Variable variable, String string) {
        Attribute attribute = variable == null ? this.netcdf.getAttribute(string) : variable.getAttribute(string);
        try {
            return attribute != null ? attribute.getStringValue() : null;
        }
        catch (ClassCastException classCastException) {
            System.err.println("Non-string attribute: " + variable.getName() + ":" + string);
            return null;
        }
    }

    protected String getLongName(Variable variable) {
        return this.getAttributeString(variable, "long_name");
    }

    protected String getUnitString(Variable variable) {
        String string = this.getAttributeString(variable, "units");
        if (string == null) {
            string = this.getAttributeString(variable, "unit");
        }
        return string;
    }

    protected Unit getUnitFromAttribute(Variable variable) {
        Unit unit;
        Map map = this.varToUnit;
        synchronized (map) {
            unit = (Unit)this.varToUnit.get(variable);
            if (!this.varToUnit.containsKey(variable)) {
                String string = this.getUnitString(variable);
                if (string != null) {
                    try {
                        unit = Parser.parse(string);
                    }
                    catch (Exception exception) {
                        System.err.println("Couldn't decode unit attribute (" + string + ")" + " of variable \"" + variable.getName() + "\": " + exception.getMessage());
                    }
                }
                this.varToUnit.put(variable, unit);
            }
        }
        return unit;
    }

    protected Vetter getVetter(Variable variable) {
        return new Vetter(variable);
    }

    protected Gridded1DSet getDomainSet(Dimension dimension) throws VisADException, IOException {
        Gridded1DSet gridded1DSet = (Gridded1DSet)this.dimToSet.get(dimension);
        if (gridded1DSet == null) {
            Variable variable = this.getCoordinateVariable(dimension);
            if (variable == null) {
                gridded1DSet = new Integer1DSet((MathType)this.getRealType(dimension), dimension.getLength());
            } else {
                Object object;
                ArithProg arithProg = this.isLongitude(variable) ? new LonArithProg() : new ArithProg();
                Class clazz = variable.getComponentType();
                boolean bl = clazz.equals(Double.TYPE);
                if (bl) {
                    object = variable.toArray();
                    arithProg.accumulate((double[])object);
                } else if (clazz.equals(Float.TYPE)) {
                    object = variable.toArray();
                    arithProg.accumulate((float[])object);
                } else {
                    int n = 1;
                    Object[] objectArray = variable.getLengths();
                    int n2 = 0;
                    while (n2 < objectArray.length) {
                        n *= objectArray[n2];
                        ++n2;
                    }
                    objectArray = new float[n];
                    if (clazz.equals(Integer.TYPE)) {
                        int[] nArray = (int[])variable.toArray();
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            objectArray[n3] = (int)((float)nArray[n3]);
                            ++n3;
                        }
                    } else if (clazz.equals(Short.TYPE)) {
                        short[] sArray = (short[])variable.toArray();
                        int n4 = 0;
                        while (n4 < sArray.length) {
                            objectArray[n4] = (int)((float)sArray[n4]);
                            ++n4;
                        }
                    } else {
                        byte[] byArray = (byte[])variable.toArray();
                        int n5 = 0;
                        while (n5 < byArray.length) {
                            objectArray[n5] = (int)((float)byArray[n5]);
                            ++n5;
                        }
                    }
                    arithProg.accumulate((float[])objectArray);
                    object = objectArray;
                }
                gridded1DSet = arithProg.isConsistent() ? new Linear1DSet((MathType)this.getRealType(dimension), arithProg.getFirst(), arithProg.getLast(), (int)arithProg.getNumber(), null, new Unit[]{this.getUnitFromAttribute(variable)}, null) : (bl ? new Gridded1DDoubleSet((MathType)this.getRealType(dimension), new double[][]{(double[])object}, dimension.getLength(), null, new Unit[]{this.getUnitFromAttribute(variable)}, null) : new Gridded1DSet((MathType)this.getRealType(dimension), new float[][]{(float[])object}, dimension.getLength(), null, new Unit[]{this.getUnitFromAttribute(variable)}, null));
            }
            this.dimToSet.put(dimension, gridded1DSet);
        }
        return gridded1DSet;
    }

    protected Variable getCoordinateVariable(Dimension dimension) {
        Variable variable = this.netcdf.get(dimension.getName());
        if (!(variable == null || variable.getRank() == 1 && this.isNumeric(variable))) {
            variable = null;
        }
        return variable;
    }

    protected boolean isTime(Dimension dimension) throws VisADException, IOException {
        return this.isTime(this.getRealType(dimension).getDefaultUnit());
    }

    protected boolean isTime(Unit unit) {
        return unit != null && SI.second.isConvertible(unit.getAbsoluteUnit());
    }

    protected Dimension[] getDimensions(Variable variable) {
        int n = variable.getRank();
        Dimension[] dimensionArray = new Dimension[n];
        DimensionIterator dimensionIterator = variable.getDimensionIterator();
        int n2 = 0;
        while (n2 < n) {
            dimensionArray[n2] = dimensionIterator.next();
            ++n2;
        }
        return dimensionArray;
    }

    protected boolean isCoordinateVariable(Variable variable) {
        if (variable.getRank() != 1 || !this.isNumeric(variable)) {
            return false;
        }
        return this.getDimensions(variable)[0].getName().equals(variable.getName());
    }

    public VirtualDataIterator getVirtualDataIterator() {
        return new DataIterator();
    }

    protected abstract boolean isIgnorable(Variable var1);

    protected abstract Domain getDomain(Variable var1) throws TypeException, IOException;

    public VirtualData getData(String string) throws TypeException, VisADException, IOException {
        if (string == null) {
            throw new NullPointerException();
        }
        return this.getData(this.netcdf.get(string));
    }

    protected VirtualData getData(Variable variable) throws TypeException, VisADException, IOException {
        VirtualScalar virtualScalar = new VirtualScalar(this.getRealType(variable), variable, this.getRangeSet(variable), this.getUnitFromAttribute(variable), this.getVetter(variable));
        return variable.getRank() == 0 ? virtualScalar : this.getDomain(variable).getVirtualField(new VirtualTuple(virtualScalar));
    }

    protected View(Netcdf netcdf, QuantityDB quantityDB) {
        this.netcdf = netcdf;
        this.quantityDB = quantityDB;
        this.varToUnit = new WeakHashMap();
        this.dimToSet = new WeakHashMap();
        this.varToRealType = new WeakHashMap();
        this.dimToRealType = new WeakHashMap();
        this.longitude = quantityDB.get("longitude");
        this.latitude = quantityDB.get("latitude");
    }

    protected class DataIterator
    extends VirtualDataIterator {
        private final VariableIterator varIter;

        protected VirtualData getData() throws TypeException, VisADException, IOException {
            while (this.varIter.hasNext()) {
                Variable variable = this.varIter.next();
                if (!View.this.isNumeric(variable) || View.this.isIgnorable(variable)) continue;
                return View.this.getData(variable);
            }
            return null;
        }

        DataIterator() {
            super(View.this);
            this.varIter = View.this.getNetcdf().iterator();
        }
    }

    protected abstract class Domain {
        protected abstract VirtualField getVirtualField(VirtualTuple var1) throws VisADException, IOException;

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        protected Domain(Variable variable) {
            if (variable.getRank() == 0) {
                throw new IllegalArgumentException(variable.toString());
            }
        }
    }
}

