/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import ucar.netcdf.Attribute;
import ucar.netcdf.Variable;
import visad.data.in.OffsetUnpacker;
import visad.data.in.ScaleAndOffsetUnpacker;
import visad.data.in.ScaleUnpacker;
import visad.data.in.ValueRanger;
import visad.data.in.ValueUnpacker;
import visad.data.in.ValueVetter;

final class Vetter {
    private ValueVetter vetter;
    private ValueUnpacker unpacker;
    private ValueRanger ranger;
    private Class type;
    private double minValid;
    private double maxValid;
    private double fill;

    double minValid() {
        return this.minValid;
    }

    double maxValid() {
        return this.maxValid;
    }

    public void vet(float[] fArray) {
        this.ranger.process(this.unpacker.process(this.vetter.process(fArray)));
    }

    public void vet(double[] dArray) {
        this.ranger.process(this.unpacker.process(this.vetter.process(dArray)));
    }

    protected Vetter() {
    }

    Vetter(Class clazz) {
        this.type = clazz;
        if (clazz.equals(Byte.TYPE)) {
            this.fill = Double.NaN;
            this.minValid = -128.0;
            this.maxValid = 127.0;
        } else if (clazz.equals(Short.TYPE)) {
            this.fill = -32767.0;
            this.minValid = -32768.0;
            this.maxValid = 32767.0;
        } else if (clazz.equals(Integer.TYPE)) {
            this.fill = -2.147483647E9;
            this.minValid = -2.147483648E9;
            this.maxValid = 2.147483647E9;
        } else if (clazz.equals(Float.TYPE)) {
            this.fill = 9.96921E36f;
            this.minValid = Double.NEGATIVE_INFINITY;
            this.maxValid = Double.POSITIVE_INFINITY;
        } else if (clazz.equals(Double.TYPE)) {
            this.fill = 9.96921E36f;
            this.minValid = Double.NEGATIVE_INFINITY;
            this.maxValid = Double.POSITIVE_INFINITY;
        } else {
            this.fill = 0.0;
            this.minValid = 0.0;
            this.maxValid = 0.0;
        }
    }

    Vetter(Variable variable) {
        this(variable.getComponentType());
        double d;
        double d2 = Double.NaN;
        double d3 = Double.NEGATIVE_INFINITY;
        double d4 = Double.POSITIVE_INFINITY;
        Attribute attribute = variable.getAttribute("_FillValue");
        if (attribute != null) {
            this.fill = attribute.getNumericValue().doubleValue();
            if (this.fill < 0.0) {
                d3 = this.type.equals(Float.TYPE) || this.type.equals(Double.TYPE) ? this.fill / 2.0 : this.fill + 1.0;
            } else if (this.fill > 0.0) {
                double d5 = d4 = this.type.equals(Float.TYPE) || this.type.equals(Double.TYPE) ? this.fill / 2.0 : this.fill - 1.0;
            }
        }
        if ((attribute = variable.getAttribute("missing_value")) != null) {
            d2 = attribute.getNumericValue().doubleValue();
        }
        this.vetter = ValueVetter.valueVetter(new double[]{this.fill, d2});
        attribute = variable.getAttribute("scale_factor");
        double d6 = attribute == null ? 1.0 : attribute.getNumericValue().doubleValue();
        attribute = variable.getAttribute("add_offset");
        double d7 = d = attribute == null ? 0.0 : attribute.getNumericValue().doubleValue();
        this.unpacker = d6 == d6 && d6 != 1.0 && d == d && d != 0.0 ? ScaleAndOffsetUnpacker.scaleAndOffsetUnpacker(d6, d) : (d6 == d6 && d6 != 1.0 ? ScaleUnpacker.scaleUnpacker(d6) : (d == d && d != 0.0 ? OffsetUnpacker.offsetUnpacker(d) : ValueUnpacker.valueUnpacker()));
        attribute = variable.getAttribute("valid_range");
        if (attribute != null) {
            d3 = attribute.getNumericValue(0).doubleValue();
            d4 = attribute.getNumericValue(1).doubleValue();
        }
        if ((attribute = variable.getAttribute("valid_min")) != null) {
            d3 = attribute.getNumericValue().doubleValue();
        }
        if ((attribute = variable.getAttribute("valid_max")) != null) {
            d4 = attribute.getNumericValue().doubleValue();
        }
        this.ranger = ValueRanger.valueRanger(d3, d4);
        if (this.minValid < d3) {
            this.minValid = d3;
        }
        if (this.maxValid > d4) {
            this.maxValid = d4;
        }
    }
}

