/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import ucar.netcdf.Netcdf;
import ucar.netcdf.NetcdfFile;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.QuantityDBManager;
import visad.data.netcdf.in.DataFactory;
import visad.data.netcdf.in.Merger;
import visad.data.netcdf.in.Strategy;
import visad.data.netcdf.in.View;
import visad.data.netcdf.in.VirtualDataIterator;
import visad.data.netcdf.in.VirtualTuple;

public class NetcdfAdapter {
    public static final String IMPORT_STRATEGY_PROPERTY = "visad.data.netcdf.in.Strategy";
    private static Strategy strategy;
    private View view;
    private DataImpl data;

    static {
        String string = System.getProperty(IMPORT_STRATEGY_PROPERTY);
        try {
            strategy = string == null ? Strategy.DEFAULT : (Strategy)Class.forName(string).getMethod("instance", new Class[0]).invoke(null, new Object[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new Error("Import strategy \"" + string + "\" doesn't have an " + "\"instance()\" method");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error("Import strategy \"" + string + "\" not found");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Permission to access import strategy \"" + string + "\" denied");
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error("Import strategy's \"" + string + "\" \"instance()\" method threw exception: " + invocationTargetException.getMessage());
        }
    }

    public NetcdfAdapter(Netcdf netcdf, QuantityDB quantityDB) throws VisADException, RemoteException, IOException, BadFormException {
        this(View.getInstance(netcdf, quantityDB));
    }

    public NetcdfAdapter(View view) {
        this.view = view;
    }

    public synchronized DataImpl getData() throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            DataImpl dataImpl = this.getData(strategy);
            Object var3_3 = null;
            return dataImpl;
        }
    }

    public synchronized DataImpl getData(Strategy strategy) throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        if (this.data == null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                this.data = strategy.getData(this);
            }
        }
        return this.data;
    }

    public static synchronized Strategy getDefaultStrategy() {
        return strategy;
    }

    public DataImpl getProxy() throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        return this.getData();
    }

    protected View getView() {
        return this.view;
    }

    protected static DataImpl importData(View view, Merger merger, DataFactory dataFactory) throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        VirtualTuple virtualTuple = new VirtualTuple();
        VirtualDataIterator virtualDataIterator = view.getVirtualDataIterator();
        while (virtualDataIterator.hasNext()) {
            merger.merge(virtualTuple, virtualDataIterator.next());
        }
        virtualTuple.setDataFactory(dataFactory);
        return virtualTuple.getData();
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = stringArray.length == 0 ? new String[]{"test.nc"} : stringArray;
        int n = 0;
        while (n < stringArray2.length) {
            NetcdfFile netcdfFile;
            Object object;
            try {
                object = new URL(stringArray2[n]);
                netcdfFile = new NetcdfFile((URL)object);
            }
            catch (MalformedURLException malformedURLException) {
                netcdfFile = new NetcdfFile(stringArray2[n], true);
            }
            object = new NetcdfAdapter(netcdfFile, QuantityDBManager.instance());
            DataImpl dataImpl = ((NetcdfAdapter)object).getData();
            System.out.println("data.getClass().getName() = " + dataImpl.getClass().getName());
            System.out.println("data.getType().prettyString():\n" + dataImpl.getType().prettyString());
            ++n;
        }
    }

    public static synchronized Strategy setDefaultStrategy(Strategy strategy) {
        if (strategy == null) {
            throw new NullPointerException();
        }
        Strategy strategy2 = NetcdfAdapter.strategy;
        NetcdfAdapter.strategy = strategy;
        return strategy2;
    }
}

