/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import ucar.netcdf.Dimension;
import ucar.netcdf.Netcdf;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.Gridded1DSet;
import visad.GriddedSet;
import visad.Integer1DSet;
import visad.IntegerNDSet;
import visad.Linear1DSet;
import visad.LinearLatLonSet;
import visad.LinearNDSet;
import visad.LinearSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.in.View;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualDataIterator;
import visad.data.netcdf.in.VirtualField;
import visad.data.netcdf.in.VirtualScalar;
import visad.data.netcdf.in.VirtualTuple;

public class DefaultView
extends View {
    private final DimsToSet dimsToSet = new DimsToSet();

    protected boolean isIgnorable(Variable variable) {
        return this.isCoordinateVariable(variable);
    }

    protected View.Domain getDomain(Variable variable) throws TypeException, IOException {
        return new DefaultDomain(this, variable);
    }

    protected SampledSet getDomainSet(Dimension[] dimensionArray) throws IOException, VisADException {
        GriddedSet griddedSet;
        if (dimensionArray.length == 0) {
            return this.getDomainSet(dimensionArray[0]);
        }
        DimsToSet dimsToSet = this.dimsToSet;
        synchronized (dimsToSet) {
            griddedSet = this.dimsToSet.get(dimensionArray);
            if (griddedSet == null) {
                Gridded1DSet[] gridded1DSetArray = new Gridded1DSet[dimensionArray.length];
                int n = dimensionArray.length;
                int n2 = 0;
                while (n2 < dimensionArray.length) {
                    gridded1DSetArray[--n] = this.getDomainSet(dimensionArray[n2]);
                    ++n2;
                }
                n2 = 1;
                int n3 = 0;
                while (n2 != 0 && n3 < gridded1DSetArray.length) {
                    n2 = gridded1DSetArray[n3] instanceof Integer1DSet;
                    ++n3;
                }
                MathType mathType = this.getDomainType(dimensionArray);
                if (n2 != 0) {
                    griddedSet = DefaultView.getIntegerSet(gridded1DSetArray, mathType);
                } else {
                    boolean bl = true;
                    int n4 = 0;
                    while (bl && n4 < gridded1DSetArray.length) {
                        bl = gridded1DSetArray[n4] instanceof Linear1DSet;
                        ++n4;
                    }
                    griddedSet = bl ? (GriddedSet)((Object)this.getLinearSet(gridded1DSetArray, mathType)) : DefaultView.getGriddedSet(gridded1DSetArray, mathType);
                }
                this.dimsToSet.put(dimensionArray, griddedSet);
            }
        }
        return griddedSet;
    }

    private static GriddedSet getIntegerSet(Gridded1DSet[] gridded1DSetArray, MathType mathType) throws VisADException {
        int n = gridded1DSetArray.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = ((Integer1DSet)gridded1DSetArray[n2]).getLength(0);
            ++n2;
        }
        return IntegerNDSet.create(mathType, nArray, null, null, null);
    }

    private LinearSet getLinearSet(Gridded1DSet[] gridded1DSetArray, MathType mathType) throws VisADException {
        RealType[] realTypeArray;
        LinearSet linearSet = null;
        int n = gridded1DSetArray.length;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int[] nArray = new int[n];
        Unit[] unitArray = new Unit[n];
        int n2 = 0;
        while (n2 < n) {
            Linear1DSet linear1DSet = (Linear1DSet)gridded1DSetArray[n2];
            dArray[n2] = linear1DSet.getFirst();
            nArray[n2] = linear1DSet.getLength(0);
            dArray2[n2] = linear1DSet.getLast();
            unitArray[n2] = linear1DSet.getSetUnits()[0];
            ++n2;
        }
        if (n == 2 && (this.isLongitude((realTypeArray = ((RealTupleType)mathType).getRealComponents())[0]) && this.isLatitude(realTypeArray[1]) || this.isLongitude(realTypeArray[1]) && this.isLatitude(realTypeArray[0]))) {
            linearSet = new LinearLatLonSet(mathType, dArray[0], dArray2[0], nArray[0], dArray[1], dArray2[1], nArray[1], null, unitArray, null);
        }
        if (linearSet == null) {
            linearSet = LinearNDSet.create(mathType, dArray, dArray2, nArray, null, unitArray, null);
        }
        return linearSet;
    }

    private static GriddedSet getGriddedSet(Gridded1DSet[] gridded1DSetArray, MathType mathType) throws VisADException, IOException {
        int n = gridded1DSetArray.length;
        int[] nArray = new int[n];
        float[][] fArray = new float[n][];
        int n2 = 1;
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = gridded1DSetArray[n3].getLength(0);
            n2 *= nArray[n3];
            ++n3;
        }
        n3 = 1;
        int n4 = 1;
        int n5 = 0;
        while (n5 < n) {
            float[] fArray2 = gridded1DSetArray[n5].getSamples(false)[0];
            fArray[n5] = new float[n2];
            n3 *= nArray[n5];
            int n6 = 0;
            while (n6 < nArray[n5]) {
                int n7 = n6 * n4;
                int n8 = 0;
                while (n8 < n2) {
                    int n9 = 0;
                    while (n9 < n4) {
                        fArray[n5][n7 + n8 + n9] = fArray2[n6];
                        ++n9;
                    }
                    n8 += n3;
                }
                ++n6;
            }
            n4 = n3;
            ++n5;
        }
        Unit[] unitArray = new Unit[n];
        int n10 = 0;
        while (n10 < n) {
            unitArray[n10] = gridded1DSetArray[n10].getSetUnits()[0];
            ++n10;
        }
        return GriddedSet.create(mathType, fArray, nArray, null, unitArray, null);
    }

    protected MathType getDomainType(Dimension[] dimensionArray) throws VisADException {
        MathType mathType;
        int n = dimensionArray.length;
        if (n == 0) {
            mathType = null;
        } else if (n == 1) {
            mathType = this.getRealType(dimensionArray[0]);
        } else {
            RealType[] realTypeArray = new RealType[dimensionArray.length];
            int n2 = dimensionArray.length;
            int n3 = 0;
            while (n3 < dimensionArray.length) {
                realTypeArray[--n2] = this.getRealType(dimensionArray[n3]);
                ++n3;
            }
            mathType = new RealTupleType(realTypeArray);
        }
        return mathType;
    }

    public DefaultView(Netcdf netcdf, QuantityDB quantityDB) {
        super(netcdf, quantityDB);
    }

    final class DefaultDataIterator
    extends VirtualDataIterator {
        private final VariableIterator varIter;

        protected VirtualData getData() throws TypeException, VisADException, IOException {
            while (this.varIter.hasNext()) {
                Variable variable = this.varIter.next();
                if (!DefaultView.this.isNumeric(variable) || DefaultView.this.isCoordinateVariable(variable)) continue;
                VirtualScalar virtualScalar = new VirtualScalar(DefaultView.this.getRealType(variable), variable, DefaultView.this.getRangeSet(variable), DefaultView.this.getUnitFromAttribute(variable), DefaultView.this.getVetter(variable));
                return variable.getRank() == 0 ? virtualScalar : DefaultView.this.getDomain(variable).getVirtualField(new VirtualTuple(virtualScalar));
            }
            return null;
        }

        DefaultDataIterator() {
            super(DefaultView.this);
            this.varIter = DefaultView.this.getNetcdf().iterator();
        }
    }

    private final class DefaultDomain
    extends View.Domain {
        private final Dimension[] dims;
        private volatile int hashCode;
        private volatile SampledSet domainSet;
        private final /* synthetic */ DefaultView this$0;

        protected VirtualField getVirtualField(VirtualTuple virtualTuple) throws VisADException, IOException {
            VirtualField virtualField;
            int n = this.dims.length;
            if (n == 1 || !this.this$0.isTime(this.dims[0])) {
                virtualField = VirtualField.newVirtualField(this.this$0.getDomainSet(this.dims), virtualTuple);
            } else {
                Dimension[] dimensionArray = new Dimension[n - 1];
                System.arraycopy(this.dims, 1, dimensionArray, 0, dimensionArray.length);
                virtualField = VirtualField.newVirtualField(this.this$0.getDomainSet(this.dims[0]), new VirtualTuple(VirtualField.newVirtualField(this.this$0.getDomainSet(dimensionArray), virtualTuple)));
            }
            return virtualField;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DefaultDomain)) {
                return false;
            }
            return Arrays.equals(this.dims, ((DefaultDomain)object).dims);
        }

        public int hashCode() {
            int n = this.hashCode;
            if (n == 0) {
                n = 1;
                int n2 = 0;
                while (n2 < this.dims.length) {
                    n = n * 31 + this.dims[n2].hashCode();
                    ++n2;
                }
                this.hashCode = n;
            }
            return n;
        }

        DefaultDomain(DefaultView defaultView, Variable variable) throws TypeException {
            DefaultView defaultView2 = defaultView;
            if (defaultView2 == null) {
                throw null;
            }
            super(defaultView2, variable);
            this.this$0 = defaultView;
            this.dims = this.this$0.getDimensions(variable);
        }
    }

    private static class DimsToSet {
        private Map map = Collections.synchronizedMap(new WeakHashMap());

        void put(Dimension[] dimensionArray, GriddedSet griddedSet) {
            if (dimensionArray.length == 1) {
                this.map.put(dimensionArray[0], griddedSet);
            } else {
                this.map.put(new DimArray(dimensionArray), griddedSet);
            }
        }

        GriddedSet get(Dimension[] dimensionArray) {
            return dimensionArray.length == 1 ? (GriddedSet)this.map.get(dimensionArray[0]) : (GriddedSet)this.map.get(new DimArray(dimensionArray));
        }

        DimsToSet() {
        }

        private static class DimArray {
            private Dimension[] dims;
            private volatile int hashCode;

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof DimArray)) {
                    return false;
                }
                return Arrays.equals(this.dims, ((DimArray)object).dims);
            }

            public int hashCode() {
                int n = this.hashCode;
                if (n == 0) {
                    n = 1;
                    int n2 = 0;
                    while (n2 < this.dims.length) {
                        n = n * 31 + this.dims[n2].hashCode();
                        ++n2;
                    }
                    this.hashCode = n;
                }
                return n;
            }

            DimArray(Dimension[] dimensionArray) {
                this.dims = (Dimension[])dimensionArray.clone();
            }
        }
    }
}

