/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.SampledSet;
import visad.Set;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.in.Context;
import visad.data.netcdf.in.InvalidContextException;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualField;
import visad.data.netcdf.in.VirtualFlatField;
import visad.data.netcdf.in.VirtualScalar;
import visad.data.netcdf.in.VirtualTuple;

public class DataFactory {
    private static DataFactory instance = new DataFactory();

    public static DataFactory instance() {
        return instance;
    }

    public DataImpl newData(Context context, VirtualData virtualData) throws RemoteException, VisADException, InvalidContextException, IOException {
        return virtualData instanceof VirtualScalar ? this.newData(context, (VirtualScalar)virtualData) : (virtualData instanceof VirtualFlatField ? this.newData(context, (VirtualFlatField)virtualData) : (virtualData instanceof VirtualField ? this.newData(context, (VirtualField)virtualData) : this.newData(context, (VirtualTuple)virtualData)));
    }

    public Real newData(Context context, VirtualScalar virtualScalar) throws VisADException, InvalidContextException, IOException {
        double[] dArray = virtualScalar.getDoubles(context);
        if (dArray.length != 1) {
            throw new InvalidContextException(context);
        }
        return new Real((RealType)virtualScalar.getScalarType(), dArray[0], virtualScalar.getUnit());
    }

    public FlatField newData(Context context, VirtualFlatField virtualFlatField) throws VisADException, RemoteException, IOException {
        Object object;
        FunctionType functionType = virtualFlatField.getFunctionType();
        SampledSet sampledSet = virtualFlatField.getDomainSet();
        VirtualTuple virtualTuple = virtualFlatField.getRangeTuple();
        int n = virtualTuple.size();
        Set[] setArray = new Set[n];
        Unit[] unitArray = new Unit[n];
        int n2 = 0;
        while (n2 < n) {
            object = (VirtualScalar)virtualTuple.get(n2);
            setArray[n2] = ((VirtualScalar)object).getRangeSet();
            unitArray[n2] = ((VirtualScalar)object).getUnit();
            ++n2;
        }
        FlatField flatField = new FlatField(functionType, (Set)sampledSet, null, setArray, unitArray);
        object = new double[n][];
        int n3 = 0;
        while (n3 < n) {
            object[n3] = ((VirtualScalar)virtualTuple.get(n3)).getDoubles(context);
            ++n3;
        }
        flatField.setSamples((double[][])object, false);
        return flatField;
    }

    public FieldImpl newData(Context context, VirtualField virtualField) throws VisADException, RemoteException, IOException {
        FieldImpl fieldImpl;
        if (virtualField instanceof VirtualFlatField) {
            fieldImpl = this.newData(context, (VirtualFlatField)virtualField);
        } else {
            FunctionType functionType = virtualField.getFunctionType();
            SampledSet sampledSet = virtualField.getDomainSet();
            VirtualTuple virtualTuple = virtualField.getRangeTuple();
            int n = sampledSet.getLength();
            fieldImpl = new FieldImpl(functionType, sampledSet);
            context = context.newSubContext();
            int n2 = 0;
            while (n2 < n) {
                context.setSubContext(n2);
                fieldImpl.setSample(n2, (Data)this.newData(context, virtualTuple), false);
                ++n2;
            }
        }
        return fieldImpl;
    }

    public DataImpl newData(Context context, VirtualTuple virtualTuple) throws RemoteException, VisADException, IOException {
        DataImpl dataImpl = null;
        int n = virtualTuple.size();
        if (n == 1) {
            dataImpl = this.newData(context, virtualTuple.get(0));
        } else if (n > 1) {
            MathType mathType = virtualTuple.getType();
            if (mathType instanceof RealTupleType) {
                Real[] realArray = new Real[n];
                int n2 = 0;
                while (n2 < n) {
                    realArray[n2] = this.newData(context, (VirtualScalar)virtualTuple.get(n2));
                    ++n2;
                }
                dataImpl = new RealTuple((RealTupleType)mathType, realArray, null);
            } else if (mathType instanceof TupleType) {
                Data[] dataArray = new DataImpl[n];
                int n3 = 0;
                while (n3 < dataArray.length) {
                    dataArray[n3] = this.newData(context, virtualTuple.get(n3));
                    ++n3;
                }
                dataImpl = new Tuple((TupleType)mathType, dataArray, false);
            }
        }
        return dataImpl;
    }

    protected DataFactory() {
    }
}

