/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.netcdf.in.NetcdfAdapter;
import visad.data.netcdf.in.Strategy;

public final class CompositeStrategy
extends Strategy {
    private final Strategy[] strategies;

    public static Strategy instance(Strategy[] strategyArray) {
        return strategyArray.length == 1 ? strategyArray[0] : new CompositeStrategy(strategyArray);
    }

    public DataImpl getData(NetcdfAdapter netcdfAdapter) throws IOException, VisADException, RemoteException, BadFormException, OutOfMemoryError {
        int n = 0;
        while (n < this.strategies.length - 1) {
            System.gc();
            try {
                return this.strategies[n].getData(netcdfAdapter);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                System.err.println("Couldn't import netCDF dataset due to insufficient memory.  Using different strategy...");
                ++n;
            }
        }
        return this.strategies[this.strategies.length - 1].getData(netcdfAdapter);
    }

    private CompositeStrategy(Strategy[] strategyArray) {
        if (strategyArray.length < 2) {
            throw new IllegalArgumentException();
        }
        this.strategies = (Strategy[])strategyArray.clone();
    }
}

