/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf.in;

import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.WeakHashMap;
import ucar.netcdf.Dimension;
import ucar.netcdf.Netcdf;
import ucar.netcdf.Variable;
import ucar.netcdf.VariableIterator;
import visad.CommonUnit;
import visad.GriddedSet;
import visad.OffsetUnit;
import visad.ProductSet;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.SampledSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.QuantityDBImpl;
import visad.data.netcdf.in.View;
import visad.data.netcdf.in.VirtualData;
import visad.data.netcdf.in.VirtualDataIterator;
import visad.data.netcdf.in.VirtualField;
import visad.data.netcdf.in.VirtualScalar;
import visad.data.netcdf.in.VirtualTuple;

final class CfView
extends View {
    private static String[] CF_CONVENTIONS_STRINGS = new String[]{"CF-1.0", "COARDS/CF-1.0", "COARDS"};
    private static QuantityDBImpl cfQuantityDB;
    private static Variable[] nilVarArray;
    private static Comparator varComparator;
    private SortedSet auxCoordVars;
    private SortedSet boundaryVars;
    private Map varToRealType;
    private Map dimsToDomain;
    private Map varToAuxCoordVars;
    private Map varToUnitString;

    private String getAuxCoordVarString(Variable variable) {
        return this.getAttributeString(variable, "coordinates");
    }

    private boolean isAuxCoordVar(Variable variable) {
        return this.auxCoordVars.contains(variable);
    }

    private boolean hasAuxCoordVars(Variable variable) {
        return this.getAuxCoordVars(variable).length > 0;
    }

    private Variable[] getAuxCoordVars(Variable variable) {
        if (variable == null) {
            throw new NullPointerException();
        }
        Map map = this.varToAuxCoordVars;
        synchronized (map) {
            Variable[] variableArray = (Variable[])this.varToAuxCoordVars.get(variable);
            if (variableArray == null) {
                String string = this.getAuxCoordVarString(variable);
                if (string == null) {
                    variableArray = nilVarArray;
                } else {
                    ArrayList<Variable> arrayList = new ArrayList<Variable>(7);
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (!this.isNumeric(string2)) continue;
                        arrayList.add(this.getVariable(string2));
                    }
                    variableArray = arrayList.toArray(nilVarArray);
                }
                this.varToAuxCoordVars.put(variable, variableArray);
            }
            Variable[] variableArray2 = (Variable[])variableArray.clone();
            Object var3_9 = null;
            return variableArray2;
        }
    }

    private Variable getBoundaryVar(Variable variable) {
        if (variable == null) {
            throw new NullPointerException();
        }
        String string = this.getAttributeString(variable, "bounds");
        if (string == null) {
            return null;
        }
        Variable variable2 = this.getVariable(string);
        if (variable2 == null) {
            System.err.println("WARNING: The boundary variable of variable \"" + variable.getName() + "\" doesn't exist");
        }
        return variable2;
    }

    private boolean isBoundaryVar(Variable variable) {
        return this.boundaryVars.contains(variable);
    }

    private String getStandardName(Variable variable) {
        return this.getAttributeString(variable, "standard_name");
    }

    protected String getUnitString(Variable variable) {
        String string;
        Map map = this.varToUnitString;
        synchronized (map) {
            string = (String)this.varToUnitString.get(variable);
            if (!this.varToUnitString.containsKey(variable)) {
                string = super.getUnitString(variable);
                if (string == null) {
                    System.err.println("WARNING: Variable \"" + variable.getName() + "\" doesn't have a unit attribute.");
                }
                this.varToUnitString.put(variable, string);
            }
        }
        return string;
    }

    protected Unit getUnitFromAttribute(Variable variable) {
        String string = this.getUnitString(variable);
        if (string == null) {
            return null;
        }
        if (string.equals("level") || string.equals("layer") || string.equals("sigma_level")) {
            return CommonUnit.dimensionless;
        }
        return super.getUnitFromAttribute(variable);
    }

    protected RealType getRealType(Variable variable) throws TypeException {
        RealType realType;
        Map map = this.varToRealType;
        synchronized (map) {
            realType = (RealType)this.varToRealType.get(variable);
            if (realType == null) {
                String string;
                realType = this.getRealTypeFromStandardName(variable);
                if (realType != null) {
                    this.varToRealType.put(variable, realType);
                } else {
                    realType = super.getRealType(variable);
                }
                Unit unit = realType.getDefaultUnit();
                if (unit instanceof OffsetUnit && unit.getAbsoluteUnit().isConvertible(SI.second) && (string = this.getAttributeString(variable, "calendar")) != null && !string.equals("gregorian") && !string.equals("standard")) {
                    String string2 = this.newName(variable);
                    System.err.println("WARNING: No support for \"" + string + "\" calendar of variable \"" + variable + "\".  " + "Attempting to create new quantity \"" + string2 + "\" with non-timescale unit.");
                    realType = RealType.getRealType(string2, unit.getAbsoluteUnit());
                    this.varToRealType.put(variable, realType);
                }
            }
        }
        return realType;
    }

    private RealType getRealTypeFromStandardName(Variable variable) {
        RealType realType;
        String string = this.getStandardName(variable);
        if (string == null) {
            realType = null;
        } else {
            Unit unit;
            realType = cfQuantityDB.get(string);
            if (realType != null && (unit = this.getUnitFromAttribute(variable)) != null && !Unit.canConvert(unit, realType.getDefaultUnit())) {
                String string2 = this.newName(variable);
                System.err.println("WARNING: The units attribute of variable " + variable.getName() + " is incompatible with the unit of the quantity" + " referenced by the standard-name attribute.  " + "Attempting to create new quantity \"" + string2 + "\".");
                realType = RealType.getRealType(string2, unit);
            }
        }
        return realType;
    }

    public VirtualDataIterator getVirtualDataIterator() {
        return new DataIterator();
    }

    protected boolean isIgnorable(Variable variable) {
        return this.isCoordinateVariable(variable) || this.isAuxCoordVar(variable) || this.isBoundaryVar(variable);
    }

    protected View.Domain getDomain(Variable variable) throws TypeException, IOException {
        DimensionList dimensionList;
        ArrayList<CfDimension> arrayList = new ArrayList<CfDimension>(7);
        ArrayList<Variable> arrayList2 = new ArrayList<Variable>(7);
        Variable[] variableArray = this.getAuxCoordVars(variable);
        Dimension[] dimensionArray = this.getDimensions(variable);
        arrayList = new ArrayList(dimensionArray.length + variableArray.length);
        int n = 0;
        while (n < dimensionArray.length) {
            arrayList.add(new SimpleDimension(this, dimensionArray[n]));
            ++n;
        }
        int n2 = 0;
        while (n2 < variableArray.length) {
            Variable variable2 = variableArray[n2];
            Object[] objectArray = this.getDimensions(variable2);
            arrayList2.add(variable2);
            boolean bl = true;
            int n3 = n2 + 1;
            while (n3 < variableArray.length && Arrays.equals(objectArray, this.getDimensions(variableArray[n3]))) {
                arrayList2.add(variableArray[n3]);
                bl &= this.getRealType(variableArray[n3]).getDefaultUnit() != null;
                ++n3;
            }
            n3 = 1;
            int n4 = 0;
            while (n4 < objectArray.length) {
                n3 &= this.getRealType((Dimension)objectArray[n4]).getDefaultUnit() == null ? 0 : 1;
                ++n4;
            }
            if (n3 == 0 || bl) {
                n4 = arrayList.indexOf(new SimpleDimension(this, (Dimension)objectArray[0]));
                try {
                    int n5 = 0;
                    while (n5 < objectArray.length) {
                        arrayList.remove(arrayList.indexOf(new SimpleDimension(this, (Dimension)objectArray[n5])));
                        ++n5;
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IllegalArgumentException("Invalid dimensional structure: variable \"" + variable.getName() + "\"");
                }
                arrayList.add(n4, new AuxCoordVarsDimension(this, arrayList2.toArray(nilVarArray)));
            }
            n2 += arrayList2.size();
            arrayList2.clear();
        }
        Map map = this.dimsToDomain;
        synchronized (map) {
            dimensionList = (DimensionList)this.dimsToDomain.get(arrayList);
            if (dimensionList == null) {
                dimensionList = new DimensionList(this, variable, arrayList);
                this.dimsToDomain.put(arrayList.clone(), dimensionList);
            }
        }
        return dimensionList;
    }

    CfView(Netcdf netcdf, QuantityDB quantityDB) {
        super(netcdf, quantityDB);
        Object object = View.getConventionsString(netcdf);
        if (object == null) {
            throw new IllegalArgumentException("No \"Conventions\" attribute in netCDF dataset");
        }
        int n = 0;
        while (n < CF_CONVENTIONS_STRINGS.length) {
            if (((String)object).equals(CF_CONVENTIONS_STRINGS[n])) break;
            ++n;
        }
        if (n >= CF_CONVENTIONS_STRINGS.length) {
            throw new IllegalArgumentException("Illegal \"Conventions\" attribute: \"" + (String)object + "\"");
        }
        this.varToRealType = new WeakHashMap();
        this.varToUnitString = new WeakHashMap();
        this.dimsToDomain = new WeakHashMap();
        this.varToAuxCoordVars = new WeakHashMap();
        this.auxCoordVars = new TreeSet(varComparator);
        this.boundaryVars = new TreeSet();
        object = this.getNetcdf().iterator();
        while (object.hasNext()) {
            Variable variable = object.next();
            Variable[] variableArray = this.getAuxCoordVars(variable);
            int n2 = 0;
            while (n2 < variableArray.length) {
                this.auxCoordVars.add(variableArray[n2]);
                ++n2;
            }
            Variable variable2 = this.getBoundaryVar(variable);
            if (variable2 == null) continue;
            this.boundaryVars.add(variable2);
        }
    }

    static {
        nilVarArray = new Variable[0];
        cfQuantityDB = new QuantityDBImpl(null);
        varComparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return ((Variable)object).getName().compareTo(((Variable)object2).getName());
            }
            {
                this.constructor$0();
            }

            private final void constructor$0() {
            }
        };
        try {
            cfQuantityDB.add(new String[]{"pressure", "Pa", "stress", "Pa", "mass", "kg", "area", "m2", "volume", "m3", "temperature", "K", "thickness", "m", "height", "m", "altitude", "m", "depth", "m", "mass_fraction", "1", "mass_mixing_ratio", "1", "volume_fraction", "1", "area_fraction", "1", "heat_flux_density", "W m-2", "heat_flux", "W", "power", "W", "mass_flux_density", "kg m-2 s-1", "mass_flux", "kg s-1", "volume_flux_density", "m s-1", "volume_flux", "m3 s-1", "energy", "J", "energy_content", "J m-2", "energy_density", "J m-3", "content", "kg m-2", "amount", "kg m-2", "speed", "m s-1", "velocity", "m s-1", "mass", "kg", "time", "s", "period", "s", "density", "kg m-3", "longitude", "degrees_E", "latitude", "degrees_N", "binary_mask", "1", "data_mask", "1", "frequency", "s-1", "frequency_of_occurrence", "s-1", "probability", "1", "sigma", "1", "hybrid_sigma_pressure", "1", "sigma_term_in_hybrid_sigma_pressure", "1", "pressure_fraction_term_in_hybrid_sigma_pressure", "1", "pressure_term_in_hybrid_sigma_pressure", "Pa", "hybrid_height", "m", "height_term_in_hybrid_height", "1", "altitude_term_in_hybrid_height", "1", "model_level_number", "1", "forecast_reference_time", "s", "forecast_period", "s", "specific_eddy_kinetic_energy", "m2 s-2", "sea_floor_depth", "m", "partial_pressure", "Pa", "surface_air_pressure", "Pa", "air_pressure", "Pa", "air_pressure_anomaly", "Pa", "rate_of_change_of_air_pressure", "Pa s-1", "air_density", "kg m-3", "sea_water_density", "kg m-3", "sea_water_potential_density", "kg m-3", "wind_speed", "m s-1", "eastward_wind", "m s-1", "northward_wind", "m s-1", "wind_direction", "degree", "grid_eastward_wind", "m s-1", "grid_northward_wind", "m s-1", "air_potential_temperature", "K", "soil_water_content", "kg m-2", "specific_humidity", "1", "mass_fraction_of_water_in_air", "1", "cloud_area_fraction", "1", "convective_cloud_area_fraction", "1", "low_cloud_area_fraction", "1", "medium_cloud_area_fraction", "1", "high_cloud_area_fraction", "1", "altitude_at_cloud_base", "m", "air_pressure_at_cloud_base", "Pa", "altitude_at_cloud_top", "m", "air_pressure_at_cloud_top", "Pa", "cloud_condensed_water_content", "kg m-2", "atmosphere_water_content", "kg m-2", "soil_temperature", "K", "canopy_water_amount", "kg m-2", "LWE_thickness_of_canopy_water_amount", "m", "surface_snow_amount", "kg m-2", "surface_snow_thickness", "m", "LWE_thickness_of_surface_snow_amount", "m", "surface_snow_area_fraction", "1", "surface_temperature", "K", "atmosphere_boundary_layer_thickness", "m", "surface_roughness_length", "m", "eastward_sea_water_velocity", "m s-1", "northward_sea_water_velocity", "m s-1", "sea_water_speed", "m s-1", "direction_of_sea_water_velocity", "degree", "land_binary_mask", "1", "sea_ice_area_fraction", "1", "sea_ice_thickness", "m", "sea_ice_amount", "kg m-2", "sea_ice_mass", "kg", "sea_ice_area", "m2", "sea_ice_extent", "m2", "sea_ice_volume", "m3", "sea_ice_freeboard", "m", "sea_ice_draft", "m", "surface_altitude", "m", "surface_temperature_anomaly", "K", "LWE_thickness_of_soil_water_content", "m", "soil_water_content_at_field_capacity", "kg m-2", "ratio_of_soil_water_content_to_soil_water_content_at_field_capacity", "1", "vegetation_area_fraction", "1", "root_depth", "m", "surface_albedo", "1", "surface_albedo_assuming_no_snow", "1", "surface_albedo_assuming_deep_snow", "1", "mass_fraction_of_O3_in_air", "1", "molar_fraction_of_O3_in_air", "1", "upward_wind", "m s-1", "upward_wind_expressed_as_rate_of_change_of_sigma", "s-1", "atmosphere_SO4_content", "kg m-2", "land_area_fraction", "1", "sea_area_fraction", "1", "land_ice_area_fraction", "1", "leaf_area_index", "1", "canopy_height", "m", "mass_fraction_of_unfrozen_water_in_soil_water", "1", "mass_fraction_of_frozen_water_in_soil_water", "1", "soil_frozen_water_content", "kg m-2", "soil_albedo", "1", "snow_soot_content", "kg m-2", "atmosphere_energy_content", "J m-2", "soil_carbon_content", "kg m-2", "snow_grain_size", "m", "snow_temperature", "K", "air_temperature", "K", "air_temperature_anomaly", "K", "TOA_downward_radiative_heat_flux_density", "W m-2", "surface_downward_shortwave_heat_flux_density", "W m-2", "downward_shortwave_heat_flux_density", "W m-2", "downward_longwave_heat_flux_density", "W m-2", "TOA_downward_shortwave_heat_flux_density", "W m-2", "TOA_incoming_shortwave_heat_flux_density", "W m-2", "TOA_outgoing_shortwave_heat_flux_density", "W m-2", "TOA_outgoing_shortwave_heat_flux_density_assuming_clear_sky", "W m-2", "surface_incident_shortwave_heat_flux_density_assuming_clear_sky", "W m-2", "surface_reflected_shortwave_heat_flux_density_assuming_clear_sky", "W m-2", "surface_reflected_shortwave_heat_flux_density", "W m-2", "large_scale_cloud_area_fraction", "1", "rate_of_change_of_air_temperature_due_to_shortwave_heating", "K s-1", "rate_of_change_of_air_temperature_due_to_shortwave_heating_assuming_clear_sky", "K s-1", "surface_incident_shortwave_heat_flux_density", "W m-2", "tropopause_downward_shortwave_heat_flux_density", "W m-2", "tropopause_upward_shortwave_heat_flux_density_from_below", "W m-2", "surface_downward_longwave_heat_flux_density", "W m-2", "surface_emitted_longwave_heat_flux_density", "W m-2", "surface_emitted_longwave_heat_flux_density_assuming_clear_sky", "W m-2", "TOA_upward_longwave_heat_flux_density", "W m-2", "TOA_downward_longwave_heat_flux_density", "W m-2", "TOA_upward_longwave_heat_flux_density_assuming_clear_sky", "W m-2", "surface_incident_longwave_heat_flux_density", "W m-2", "surface_incident_longwave_heat_flux_density_assuming_clear_sky", "W m-2", "rate_of_change_of_air_temperature_due_to_longwave_heating", "K s-1", "rate_of_change_of_air_temperature_due_to_longwave_heating_assuming_clear_sky", "K s-1", "tropopause_downward_longwave_heat_flux_density", "W m-2", "tropopause_downward_longwave_heat_flux_density_from_above", "W m-2", "downward_heat_flux_density_in_sea_ice", "W m-2", "downward_heat_flux_density_in_soil", "W m-2", "drag_coefficient", "1", "derivative_of_wind_speed_wrt_altitude_in_constant_flux_layer", "s-1", "downward_stress_in_constant_flux_layer", "Pa", "bulk_Richardson_number", "1", "upward_sensible_heat_flux_density_in_air", "W m-2", "downward_eastward_stress_in_air", "Pa", "downward_northward_stress_in_air", "Pa", "upward_water_vapour_mass_flux_density_in_air", "kg m-2 s-1", "wind_mixing_energy_flux_density_into_sea", "W m-2", "surface_upward_sensible_heat_flux_density", "W m-2", "surface_downward_sensible_heat_flux_density", "W m-2", "surface_upward_sensible_heat_flux_density_from_sea", "W m-2", "surface_upward_water_vapour_mass_flux_density", "kg m-2 s-1", "surface_upward_latent_heat_flux_density", "W m-2", "surface_downward_latent_heat_flux_density", "W m-2", "mass_fraction_of_cloud_ice_in_air", "1", "atmosphere_cloud_ice_content", "kg m-2", "mass_fraction_of_cloud_liquid_water_in_air", "1", "atmosphere_cloud_liquid_water_content", "kg m-2", "visibility", "m", "dew_point_temperature", "K", "freezing_temperature_of_sea_water", "K", "surface_snow_melt_amount", "kg m-2", "surface_snow_melt_heat_flux_density", "W m-2", "transpiration_amount", "kg m-2", "transpiration_mass_flux_density", "kg m-2 s-1", "gross_primary_productivity_of_carbon_amount", "kg m-2 s-1", "net_primary_productivity_of_carbon_amount", "kg m-2 s-1", "plant_respiration_mass_flux_density", "kg m-2 s-1", "large_scale_rainfall_amount", "kg m-2", "large_scale_snowfall_amount", "kg m-2", "large_scale_rainfall_mass_flux_density", "kg m-2 s-1", "large_scale_snowfall_mass_flux_density", "kg m-2 s-1", "relative_humidity", "1", "convective_rainfall_amount", "kg m-2", "convective_snowfall_amount", "kg m-2", "rate_of_change_of_specific_humidity_due_to_convection", "s-1", "convective_rainfall_mass_flux_density", "kg m-2 s-1", "convective_snowfall_mass_flux_density", "kg m-2 s-1", "air_pressure_at_convective_cloud_base", "Pa", "air_pressure_at_convective_cloud_top", "Pa", "mass_fraction_of_convective_condensed_water_in_air", "1", "rainfall_mass_flux_density", "kg m-2 s-1", "snowfall_mass_flux_density", "kg m-2 s-1", "precipitation_mass_flux_density", "kg m-2 s-1", "specific_potential_energy", "J kg-1", "specific_convectively_available_potential_energy", "J kg-1", "precipitation_amount", "kg m-2", "large_scale_precipitation_amount", "kg m-2", "convective_precipitation_amount", "kg m-2", "convective_precipitation_mass_flux_density", "kg m-2 s-1", "rate_of_change_of_wind_due_to_convention", "m s-2", "rate_of_change_of_specific_humidity_due_to_diabatic_processes", "s-1", "rate_of_change_of_air_temperature_due_to_diabatic_processes", "s-1", "rate_of_change_of_air_temperature_due_to_large_scale_precipitation", "s-1", "rate_of_change_of_air_temperature_due_to_moist_convection", "s-1", "rate_of_change_of_air_temperature_due_to_dry_convection", "s-1", "surface_eastward_gravity_wave_stress", "Pa", "surface_northward_gravity_wave_stress", "Pa", "rate_of_change_of_wind_due_to_gravity_wave_drag", "m s-2", "rate_of_change_of_eastward_wind_due_to_gravity_wave_drag", "m s-2", "rate_of_change_of_northward_wind_due_to_gravity_wave_drag", "m s-2", "surface_runoff_amount", "kg m-2", "subsurface_runoff_amount", "kg m-2", "surface_runoff_mass_flux_density", "kg m-2 s-1", "subsurface_runoff_mass_flux_density", "kg m-2 s-1", "runoff_mass_flux_density", "kg m-2 s-1", "wet_bulb_temperature", "K", "omega", "Pa s-1", "Ertel_potential_vorticity", "K m2 kg-1 s-1", "product_of_eastward_wind_and_northward_wind", "m2 s-2", "product_of_air_temperature_and_eastwind_wind", "K m s-1", "product_of_air_temperature_and_northward_wind", "K m s-1", "square_of_air_temperature", "K2", "square_of_eastward_wind", "m2 s-2", "square_of_northward_wind", "m2 s-2", "product_of_eastward_wind_and_omega", "Pa m s-2", "product_of_northward_wind_and_omega", "Pa m s-2", "product_of_eastward_wind_and_specific_humidity", "m s-1", "product_of_northward_wind_and_specific_humidity", "m s-1", "product_of_air_temperature_and_omega", "K Pa s-1", "atmosphere_kinetic_energy_content", "J m-2", "geopotential_height", "m", "geopotential_height_anomaly", "m", "product_of_eastward_wind_and_geopotential_height", "m2 s-1", "product_of_northward_wind_and_geopotential_height", "m2 s-1", "freezing_level_altitude", "m", "freezing_level_air_pressure", "Pa", "tropopause_air_pressure", "Pa", "tropopause_air_temperature", "K", "tropopause_altitude", "m", "sea_level_air_pressure", "Pa", "vegetation_carbon_content", "kg m-2", "litter_carbon_mass_flux_density", "kg m-2 s-1", "sea_water_temperature", "K", "sea_water_potential_temperature", "K", "sea_water_salinity", "1", "baroclinic_eastward_sea_water_velocity", "m s-1", "baroclinic_northward_sea_water_velocity", "m s-1", "ocean_barotropic_streamfunction", "m3 s-1", "rate_of_change_of_ocean_barotropic_streamfunction", "m3 s-2", "sea_surface_elevation", "m", "sea_surface_elevation_anomaly", "m", "barotropic_eastward_sea_water_velocity", "m s-1", "barotropic_northward_sea_water_velocity", "m s-1", "ocean_mixed_layer_thickness", "m", "eastward_stress_of_sea_ice_on_ocean", "Pa", "northward_stress_of_sea_ice_on_ocean", "Pa", "surface_snow_thickness_on_sea_ice", "m", "upward_sensible_heat_flux_density_in_sea_water_at_sea_ice_base", "W m-2", "sea_ice_speed", "m s-1", "sea_ice_eastward_velocity", "m s-1", "sea_ice_northward_velocity", "m s-1", "direction_of_sea_ice_velocity", "degree", "divergence_of_sea_ice_velocity", "s-1", "rate_of_change_of_sea_ice_thickness_due_to_thermodynamics", "m s-1", "surface_downward_eastward_stress", "Pa", "surface_downward_northward_stress", "Pa", "heat_flux_correction", "W m-2", "water_flux_correction", "kg m-2 s-1", "ocean_isopycnal_layer_thickness_diffusivity", "m2 s-1", "sea_water_upward_velocity", "m s-1", "northward_heat_flux_in_ocean", "W", "northward_salt_mass_flux_in_ocean", "kg s-1", "northward_fresh_water_mass_flux_in_ocean", "kg s-1", "significant_height_of_wind_waves_and_swell_waves", "m", "direction_of_wind_wave_velocity", "degree", "significant_height_of_wind_waves", "m", "wind_wave_period", "s", "direction_of_swell_wave_velocity", "degree", "significant_height_of_swell_waves", "m", "swell_wave_period", "s"}, new String[0]);
        }
        catch (Exception exception) {
            System.err.println("ERROR: Couldn't initialize class visad.data.netcdf.in.CfView: " + exception);
            System.exit(1);
        }
    }

    final class DataIterator
    extends VirtualDataIterator {
        private final VariableIterator varIter;

        protected VirtualData getData() throws TypeException, VisADException, IOException {
            while (this.varIter.hasNext()) {
                Variable variable = this.varIter.next();
                if (!CfView.this.isNumeric(variable) || CfView.this.isCoordinateVariable(variable) || CfView.this.isAuxCoordVar(variable) || CfView.this.isBoundaryVar(variable)) continue;
                VirtualScalar virtualScalar = new VirtualScalar(CfView.this.getRealType(variable), variable, CfView.this.getRangeSet(variable), CfView.this.getUnitFromAttribute(variable), CfView.this.getVetter(variable));
                return variable.getRank() == 0 ? virtualScalar : CfView.this.getDomain(variable).getVirtualField(new VirtualTuple(virtualScalar));
            }
            return null;
        }

        DataIterator() {
            super(CfView.this);
            this.varIter = CfView.this.getNetcdf().iterator();
        }
    }

    private final class DimensionList
    extends View.Domain {
        private final ArrayList list;
        private volatile int hashCode;
        private volatile SampledSet domain;
        private final /* synthetic */ CfView this$0;

        protected VirtualField getVirtualField(VirtualTuple virtualTuple) throws VisADException, IOException {
            CfDimension cfDimension;
            Unit[] unitArray;
            int n = this.list.size();
            VirtualField virtualField = n == 1 ? VirtualField.newVirtualField(this.getDomainSet(this.list), virtualTuple) : ((unitArray = (cfDimension = (CfDimension)this.list.get(0)).getUnits()).length > 1 || !this.this$0.isTime(unitArray[0]) ? VirtualField.newVirtualField(this.getDomainSet(this.list), virtualTuple) : VirtualField.newVirtualField(this.getDomainSet(((AbstractList)this.list).subList(0, 1)), new VirtualTuple(VirtualField.newVirtualField(this.getDomainSet(((AbstractList)this.list).subList(1, n)), virtualTuple))));
            return virtualField;
        }

        private SampledSet getDomainSet(List list) throws VisADException, IOException {
            SampledSet[] sampledSetArray = new SampledSet[list.size()];
            int n = 0;
            int n2 = sampledSetArray.length;
            while (n < sampledSetArray.length) {
                sampledSetArray[n] = ((CfDimension)list.get(--n2)).getDomainSet();
                ++n;
            }
            return sampledSetArray.length == 1 ? sampledSetArray[0] : new ProductSet(sampledSetArray).product();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DimensionList)) {
                return false;
            }
            return ((AbstractList)this.list).equals(((DimensionList)object).list);
        }

        public int hashCode() {
            int n = this.hashCode;
            if (n == 0) {
                n = this.hashCode = ((AbstractList)this.list).hashCode();
            }
            return n;
        }

        DimensionList(CfView cfView, Variable variable, ArrayList arrayList) throws TypeException {
            CfView cfView2 = cfView;
            if (cfView2 == null) {
                throw null;
            }
            super(cfView2, variable);
            this.this$0 = cfView;
            this.list = arrayList;
        }
    }

    private abstract class CfDimension {
        abstract Unit[] getUnits() throws TypeException;

        abstract SampledSet getDomainSet() throws VisADException, IOException;

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        CfDimension() {
        }
    }

    private final class SimpleDimension
    extends CfDimension {
        private final Dimension dim;
        private volatile transient SampledSet domain;
        private final /* synthetic */ CfView this$0;

        Unit[] getUnits() throws TypeException {
            return new Unit[]{this.this$0.getRealType(this.dim).getDefaultUnit()};
        }

        SampledSet getDomainSet() throws VisADException, IOException {
            SampledSet sampledSet = this.domain;
            if (sampledSet == null) {
                sampledSet = this.domain = this.this$0.getDomainSet(this.dim);
            }
            return sampledSet;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof SimpleDimension)) {
                return false;
            }
            return this.dim.equals(((SimpleDimension)object).dim);
        }

        public int hashCode() {
            return this.dim.hashCode();
        }

        SimpleDimension(CfView cfView, Dimension dimension) {
            CfView cfView2 = cfView;
            if (cfView2 == null) {
                throw null;
            }
            this.this$0 = cfView;
            this.dim = dimension;
        }
    }

    private final class AuxCoordVarsDimension
    extends CfDimension {
        private final Variable[] vars;
        private volatile transient int hashCode;
        private volatile transient SampledSet domain;
        private final /* synthetic */ CfView this$0;

        Unit[] getUnits() throws TypeException {
            Unit[] unitArray = new Unit[this.vars.length];
            int n = 0;
            while (n < unitArray.length) {
                unitArray[n] = this.this$0.getRealType(this.vars[n]).getDefaultUnit();
                ++n;
            }
            return unitArray;
        }

        SampledSet getDomainSet() throws IOException, TypeException, VisADException {
            SampledSet sampledSet = this.domain;
            if (sampledSet == null) {
                Variable variable = this.vars[0];
                int n = variable.getRank();
                int[] nArray = variable.getLengths();
                int n2 = 0;
                int n3 = n;
                while (n2 < n / 2) {
                    int n4 = nArray[--n3];
                    nArray[n3] = nArray[n2];
                    nArray[n2] = n4;
                    ++n2;
                }
                n2 = this.vars.length;
                RealType[] realTypeArray = new RealType[n2];
                Unit[] unitArray = new Unit[n2];
                float[][] fArray = new float[n2][];
                int n5 = 0;
                int n6 = n2;
                while (n5 < n2) {
                    Variable variable2 = this.vars[--n6];
                    realTypeArray[n5] = this.this$0.getRealType(variable2);
                    fArray[n5] = this.toFloat(variable2.toArray());
                    unitArray[n5] = this.this$0.getUnitFromAttribute(variable2);
                    ++n5;
                }
                sampledSet = this.domain = GriddedSet.create(n2 == 1 ? realTypeArray[0] : new RealTupleType(realTypeArray), fArray, nArray, null, unitArray, null);
            }
            return sampledSet;
        }

        private float[] toFloat(Object object) {
            if (object instanceof byte[]) {
                return this.toFloat((byte[])object);
            }
            if (object instanceof short[]) {
                return this.toFloat((short[])object);
            }
            if (object instanceof int[]) {
                return this.toFloat((int[])object);
            }
            if (object instanceof float[]) {
                return this.toFloat((float[])object);
            }
            return this.toFloat((double[])object);
        }

        private float[] toFloat(byte[] byArray) {
            float[] fArray = new float[byArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = byArray[n];
                ++n;
            }
            return fArray;
        }

        private float[] toFloat(short[] sArray) {
            float[] fArray = new float[sArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = sArray[n];
                ++n;
            }
            return fArray;
        }

        private float[] toFloat(int[] nArray) {
            float[] fArray = new float[nArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = nArray[n];
                ++n;
            }
            return fArray;
        }

        private float[] toFloat(float[] fArray) {
            return fArray;
        }

        private float[] toFloat(double[] dArray) {
            float[] fArray = new float[dArray.length];
            int n = 0;
            while (n < fArray.length) {
                fArray[n] = (float)dArray[n];
                ++n;
            }
            return fArray;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof AuxCoordVarsDimension)) {
                return false;
            }
            AuxCoordVarsDimension auxCoordVarsDimension = (AuxCoordVarsDimension)object;
            if (this.vars == auxCoordVarsDimension.vars) {
                return true;
            }
            if (this.vars.length != auxCoordVarsDimension.vars.length) {
                return false;
            }
            int n = 0;
            while (n < this.vars.length) {
                if (!this.vars[n].getName().equals(auxCoordVarsDimension.vars[n].getName())) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public int hashCode() {
            int n = this.hashCode;
            if (n == 0) {
                n = 0;
                int n2 = 0;
                while (n2 < this.vars.length) {
                    n ^= this.vars[n2].getName().hashCode();
                    ++n2;
                }
                this.hashCode = n;
            }
            return n;
        }

        AuxCoordVarsDimension(CfView cfView, Variable[] variableArray) {
            CfView cfView2 = cfView;
            if (cfView2 == null) {
                throw null;
            }
            this.this$0 = cfView;
            if (variableArray.length < 1) {
                throw new IllegalArgumentException();
            }
            this.vars = variableArray;
        }
    }
}

