/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.io.Serializable;
import java.util.Iterator;
import visad.VisADError;
import visad.VisADException;
import visad.data.netcdf.Quantity;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.StandardQuantityDB;

public final class QuantityDBManager
implements Serializable {
    private static QuantityDB db;

    protected static QuantityDB defaultInstance() throws VisADException {
        return StandardQuantityDB.instance();
    }

    public static synchronized QuantityDB instance() {
        return db;
    }

    public static synchronized void setInstance(QuantityDB quantityDB) throws VisADException {
        db = quantityDB == null ? QuantityDBManager.defaultInstance() : quantityDB;
    }

    public static void main(String[] stringArray) throws Exception {
        QuantityDB quantityDB = QuantityDBManager.instance();
        Iterator iterator = quantityDB.nameIterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Quantity quantity = quantityDB.get(string);
            System.out.println(string + " (" + quantity.getName() + ") in " + quantity.getDefaultUnitString());
        }
    }

    private QuantityDBManager() {
    }

    static {
        try {
            db = QuantityDBManager.defaultInstance();
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new VisADError("visad.data.netcdf.QuantityDBManager.<clinit>: Couldn't initialize class" + exception);
        }
    }
}

