/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import java.io.Serializable;
import java.text.CollationKey;
import java.text.Collator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import visad.DerivedUnit;
import visad.PromiscuousUnit;
import visad.QuantityDimension;
import visad.RealType;
import visad.TypeException;
import visad.Unit;
import visad.UnitException;
import visad.VisADException;
import visad.data.netcdf.Quantity;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.UnsupportedOperationException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public class QuantityDBImpl
extends QuantityDB
implements Serializable {
    private static final String minName = "";
    private static final String maxName = "zzz";
    private static final Unit minUnit = new DerivedUnit();
    private static final Unit maxUnit = new DerivedUnit();
    private final SortedSet quantitySet = new TreeSet();
    private final TreeMap nameMap = new TreeMap();
    private final TreeMap unitMap = new TreeMap();
    private QuantityDB nextDB;

    public QuantityDB add(String[] stringArray, String[] stringArray2) throws ParseException, TypeException, VisADException {
        int n = 0;
        while (n < stringArray.length) {
            this.add(stringArray[n], stringArray[n + 1]);
            n += 2;
        }
        n = 0;
        while (n < stringArray2.length) {
            this.add(stringArray2[n], this.get(stringArray2[n + 1]));
            n += 2;
        }
        return this;
    }

    public synchronized void add(String string, Quantity quantity) throws VisADException {
        if (string == null || quantity == null) {
            throw new VisADException("add(): null argument");
        }
        Unit unit = quantity.getDefaultUnit();
        this.quantitySet.add(quantity);
        this.nameMap.put(new NameKey(string), quantity);
        this.unitMap.put(new UnitKey(unit, quantity.getName()), quantity);
    }

    public QuantityDB add(Quantity[] quantityArray) throws VisADException {
        int n = 0;
        while (n < quantityArray.length) {
            Quantity quantity = quantityArray[n];
            this.add(quantity);
            ++n;
        }
        return this;
    }

    protected synchronized void add(String string, String string2) throws ParseException, TypeException, VisADException {
        block3: {
            try {
                this.add(string, new Quantity(string, string2));
            }
            catch (VisADException visADException) {
                if (!(visADException instanceof TypeException)) {
                    throw visADException;
                }
                RealType realType = RealType.getRealTypeByName(string);
                if (realType != null && Unit.canConvert(realType.getDefaultUnit(), Parser.parse(string2))) break block3;
                throw (TypeException)visADException;
            }
        }
    }

    public java.util.Iterator quantityIterator() {
        return new QuantityIterator(this);
    }

    public java.util.Iterator nameIterator() {
        return new NameIterator(this);
    }

    public synchronized Quantity get(String string) {
        Quantity quantity = (Quantity)this.nameMap.get(new NameKey(string));
        return quantity != null ? quantity : (this.nextDB == null ? null : this.nextDB.get(string));
    }

    public synchronized Quantity[] get(Unit unit) {
        Quantity[] quantityArray = this.unitMap.subMap(new UnitKey(unit, minName), new UnitKey(unit, maxName)).values().toArray(new Quantity[0]);
        Quantity[] quantityArray2 = this.nextDB == null ? new Quantity[]{} : this.nextDB.get(unit);
        Quantity[] quantityArray3 = new Quantity[quantityArray.length + quantityArray2.length];
        System.arraycopy(quantityArray, 0, quantityArray3, 0, quantityArray.length);
        System.arraycopy(quantityArray2, 0, quantityArray3, quantityArray.length, quantityArray2.length);
        quantityArray = null;
        quantityArray2 = null;
        return quantityArray3;
    }

    public QuantityDBImpl(QuantityDB quantityDB) {
        this.nextDB = quantityDB;
    }

    protected abstract class Iterator
    implements java.util.Iterator {
        protected java.util.Iterator iterator;
        private boolean canSwitch;

        public boolean hasNext() {
            boolean bl = this.iterator.hasNext();
            if (!bl && this.doSwitch()) {
                bl = this.hasNext();
            }
            return bl;
        }

        protected abstract Object nextObject();

        public Object next() {
            Object object;
            try {
                object = this.nextObject();
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!this.doSwitch()) {
                    throw noSuchElementException;
                }
                object = this.next();
            }
            return object;
        }

        protected abstract java.util.Iterator nextIterator();

        protected boolean doSwitch() {
            boolean bl;
            if (!this.canSwitch) {
                bl = false;
            } else {
                this.iterator = this.nextIterator();
                this.canSwitch = false;
                bl = true;
            }
            return bl;
        }

        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("remove(): Can't remove elements from quantity database");
        }

        Iterator() {
            this.canSwitch = QuantityDBImpl.this.nextDB != null;
        }
    }

    protected class QuantityIterator
    extends Iterator {
        private final /* synthetic */ QuantityDBImpl this$0;

        protected Object nextObject() {
            return this.iterator.next();
        }

        protected java.util.Iterator nextIterator() {
            return this.this$0.nextDB.quantityIterator();
        }

        protected QuantityIterator(QuantityDBImpl quantityDBImpl) {
            QuantityDBImpl quantityDBImpl2 = quantityDBImpl;
            if (quantityDBImpl2 == null) {
                throw null;
            }
            this.this$0 = quantityDBImpl;
            this.iterator = this.this$0.quantitySet.iterator();
        }
    }

    protected class NameIterator
    extends Iterator {
        private final /* synthetic */ QuantityDBImpl this$0;

        protected Object nextObject() {
            return ((NameKey)this.iterator.next()).getName();
        }

        protected java.util.Iterator nextIterator() {
            return this.this$0.nextDB.nameIterator();
        }

        protected NameIterator(QuantityDBImpl quantityDBImpl) {
            QuantityDBImpl quantityDBImpl2 = quantityDBImpl;
            if (quantityDBImpl2 == null) {
                throw null;
            }
            this.this$0 = quantityDBImpl;
            this.iterator = this.this$0.nameMap.keySet().iterator();
        }
    }

    protected static class NameKey
    implements Serializable,
    Comparable {
        private static final Collator collator = Collator.getInstance();
        private final String name;
        private final CollationKey nameCookie;

        public int compareTo(Object object) throws ClassCastException {
            return this.nameCookie.compareTo(((NameKey)object).nameCookie);
        }

        public String getName() {
            return this.name;
        }

        protected NameKey(String string) {
            this.name = string;
            this.nameCookie = collator.getCollationKey(string);
        }

        static {
            collator.setStrength(0);
        }
    }

    protected static final class UnitKey
    extends NameKey {
        protected final Unit unit;

        public int compareTo(Object object) throws ClassCastException {
            UnitKey unitKey = (UnitKey)object;
            int n = this.compare(this.unit, unitKey.unit);
            return n != 0 ? n : super.compareTo(unitKey);
        }

        private int compare(Unit unit, Unit unit2) throws ClassCastException {
            int n;
            if (unit instanceof PromiscuousUnit || unit2 instanceof PromiscuousUnit) {
                n = 0;
            } else if (unit == null || unit2 == null) {
                n = unit == null && unit2 == null ? 0 : (unit == null ? -1 : 1);
            } else {
                try {
                    n = unit == unit2 ? 0 : (unit == minUnit || unit2 == maxUnit ? -1 : (unit == maxUnit || unit2 == minUnit ? 1 : new QuantityDimension(unit).compareTo(new QuantityDimension(unit2))));
                }
                catch (UnitException unitException) {
                    throw new ClassCastException(unitException.getMessage());
                }
            }
            return n;
        }

        protected UnitKey(Unit unit, String string) {
            super(string);
            this.unit = unit;
        }
    }
}

