/*
 * Decompiled with CFR 0.152.
 */
package visad.data.netcdf;

import visad.RealType;
import visad.SimpleSet;
import visad.TypeException;
import visad.Unit;
import visad.VisADException;
import visad.data.units.ParseException;
import visad.data.units.Parser;

public class Quantity
extends RealType {
    protected final String unitSpec;

    public String getDefaultUnitString() {
        return this.unitSpec;
    }

    public static Quantity getQuantity(String string, String string2, SimpleSet simpleSet) throws ParseException {
        try {
            return new Quantity(string, string2, simpleSet);
        }
        catch (TypeException typeException) {
            return Quantity.getQuantityByName(string);
        }
        catch (VisADException visADException) {
            return null;
        }
    }

    public static Quantity getQuantity(String string, String string2) throws ParseException {
        return Quantity.getQuantity(string, string2, null);
    }

    public static Quantity getQuantityByName(String string) {
        RealType realType = RealType.getRealTypeByName(string);
        if (!(realType instanceof Quantity)) {
            try {
                return new Quantity(realType);
            }
            catch (VisADException visADException) {
                return null;
            }
        }
        return (Quantity)realType;
    }

    public Quantity(String string, String string2, SimpleSet simpleSet) throws VisADException, ParseException {
        super(string, Parser.parse(string2), simpleSet);
        this.unitSpec = string2;
    }

    public Quantity(String string, String string2) throws VisADException, ParseException {
        this(string, string2, null);
    }

    Quantity(RealType realType) throws VisADException {
        super(realType.getName(), realType.getDefaultUnit(), true);
        Unit unit = realType.getDefaultUnit();
        this.unitSpec = unit == null ? null : unit.toString();
    }
}

