/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;
import visad.ColorControl;
import visad.ConstantMap;
import visad.DataReferenceImpl;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Linear2DSet;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.data.mcidas.AreaAdapter;
import visad.data.mcidas.BaseMapAdapter;
import visad.java2d.DefaultRendererJ2D;
import visad.java2d.DisplayImplJ2D;
import visad.java3d.DefaultRendererJ3D;
import visad.java3d.DisplayImplJ3D;

public class TestArea {
    static boolean use2D = false;
    static String imageSource = "AREA0007";
    static String band = "1";
    static String mapfile = "OUTLUSAM";

    private static boolean getOptions(String[] stringArray) {
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        int n = 0;
        boolean bl4 = true;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].charAt(0) == '-') {
                switch (stringArray[n2].charAt(1)) {
                    case '2': {
                        use2D = true;
                        break;
                    }
                    case '3': {
                        use2D = false;
                        break;
                    }
                    case 'f': {
                        imageSource = stringArray[++n2];
                        bl = false;
                        break;
                    }
                    case 'b': {
                        band = stringArray[++n2];
                        bl2 = false;
                        break;
                    }
                    case 'm': {
                        mapfile = stringArray[++n2];
                        bl3 = false;
                        break;
                    }
                    default: {
                        System.err.println("Unknown option \"" + stringArray[n2] + "\"");
                        bl4 = true;
                        break;
                    }
                }
            } else {
                switch (n) {
                    case 0: {
                        imageSource = stringArray[n2];
                        bl = false;
                        break;
                    }
                    case 1: {
                        band = stringArray[n2];
                        bl2 = false;
                        break;
                    }
                    case 2: {
                        mapfile = stringArray[n2];
                        bl3 = false;
                        break;
                    }
                    default: {
                        System.err.println("Unknown keyword \"" + stringArray[n2] + "\"");
                        bl4 = true;
                        break;
                    }
                }
                ++n;
            }
            ++n2;
        }
        if (!bl4) {
            System.err.print("Usage: java TestArea ");
            System.err.print(" <AREAfilename>");
            System.err.print(" <band#>");
            System.err.print(" <mapfilename>");
            System.err.println("");
            System.err.print("  or : java TestArea");
            System.err.print(" [-2(D)|-3(D)]");
            System.err.print(" [-f AREAfilename]");
            System.err.print(" [-b band#]");
            System.err.print(" [-m mapfilename]");
            System.err.println("");
            System.err.println("\t(filenames may also be URLs)");
        }
        if (bl || bl2 || bl3) {
            n2 = 0;
            System.out.print("Using default");
            if (bl) {
                System.out.print((n2 != 0 ? "," : "") + " file " + imageSource);
            }
            if (bl2) {
                System.out.print((n2 != 0 ? "," : "") + " band " + band);
            }
            if (bl3) {
                System.out.print((n2 != 0 ? "," : "") + " map " + mapfile);
            }
            System.out.println("");
        }
        return bl4;
    }

    public static void main(String[] stringArray) {
        if (!TestArea.getOptions(stringArray)) {
            System.exit(1);
            return;
        }
        FlatField flatField = null;
        System.out.println("Reading AREA file \"" + imageSource + "\"");
        AreaAdapter areaAdapter = null;
        try {
            areaAdapter = new AreaAdapter(imageSource);
        }
        catch (Exception exception) {
            System.err.println("Caught IOException for \"" + imageSource + "\": " + exception.getMessage());
            System.exit(1);
        }
        flatField = areaAdapter.getData();
        if (flatField == null) {
            System.out.println("\tNULL FlatField!");
        } else {
            System.out.println("\t" + flatField.getType());
        }
        int n = Integer.parseInt(band.trim());
        try {
            System.out.println("DateTime= " + areaAdapter.getNominalTime());
            System.out.println("imaget.getDomainSet()=" + flatField.getDomainSet());
            System.out.println("imaget.getDomain.getType=" + flatField.getDomainSet().getType());
            int[] nArray = areaAdapter.getDimensions();
            int n2 = nArray[1];
            int n3 = nArray[2];
            System.out.println("Creating basemap overlay from \"" + mapfile + "\"");
            BaseMapAdapter baseMapAdapter = mapfile.indexOf("://") > 0 ? new BaseMapAdapter(new URL(mapfile)) : new BaseMapAdapter(mapfile);
            baseMapAdapter.setDomainSet((Linear2DSet)flatField.getDomainSet());
            DataReferenceImpl dataReferenceImpl = new DataReferenceImpl("MapLines");
            dataReferenceImpl.setData(baseMapAdapter.getData());
            DisplayImpl displayImpl = use2D ? new DisplayImplJ2D("display1") : new DisplayImplJ3D("display1");
            System.out.println("Starting to render display");
            FunctionType functionType = (FunctionType)flatField.getType();
            RealTupleType realTupleType = functionType.getDomain();
            RealTupleType realTupleType2 = (RealTupleType)functionType.getRange();
            ScalarMap scalarMap = new ScalarMap((RealType)realTupleType.getComponent(0), Display.XAxis);
            scalarMap.setRange(0.0, n2);
            ScalarMap scalarMap2 = new ScalarMap((RealType)realTupleType.getComponent(1), Display.YAxis);
            scalarMap2.setRange(0.0, n3);
            displayImpl.addMap(scalarMap);
            displayImpl.addMap(scalarMap2);
            ScalarMap scalarMap3 = new ScalarMap((RealType)realTupleType2.getComponent(n - 1), Display.RGB);
            displayImpl.addMap(scalarMap3);
            ColorControl colorControl = (ColorControl)scalarMap3.getControl();
            colorControl.initGreyWedge();
            DataReferenceImpl dataReferenceImpl2 = new DataReferenceImpl("ref_image");
            dataReferenceImpl2.setData(flatField);
            displayImpl.addReference(dataReferenceImpl2, null);
            ConstantMap[] constantMapArray = use2D ? new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green)} : new ConstantMap[]{new ConstantMap(0.0, Display.Blue), new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.01, Display.ZAxis)};
            DataRenderer dataRenderer = use2D ? new DefaultRendererJ2D() : new DefaultRendererJ3D();
            displayImpl.addReferences(dataRenderer, dataReferenceImpl, constantMapArray);
            JFrame jFrame = new JFrame("McIDAS AREA in Java 3D");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    System.exit(0);
                }
                {
                    this.constructor$0();
                }

                private final void constructor$0() {
                }
            });
            jFrame.setContentPane((JPanel)displayImpl.getComponent());
            ((Component)jFrame).setSize(n2, n3);
            ((Component)jFrame).setVisible(true);
        }
        catch (Exception exception) {
            System.out.println("Ex: " + exception);
            System.exit(1);
        }
        while (true) {
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (Exception exception) {
                System.exit(0);
                continue;
            }
            break;
        }
    }
}

