/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeException;
import edu.wisc.ssec.mcidas.adde.AddePointDataReader;
import java.rmi.RemoteException;
import visad.Data;
import visad.DataImpl;
import visad.Field;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.Scalar;
import visad.ScalarType;
import visad.Text;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.Unit;
import visad.VisADException;
import visad.data.units.NoSuchUnitException;
import visad.data.units.ParseException;
import visad.data.units.Parser;
import visad.jmet.MetUnits;
import visad.python.JPythonMethods;

public class PointDataAdapter {
    AddePointDataReader reader;
    FieldImpl field = null;
    private boolean debug = false;

    private void makeField() throws VisADException {
        TupleType tupleType;
        Object object;
        int[] nArray;
        String[] stringArray;
        String[] stringArray2;
        int[][] nArray2;
        try {
            nArray2 = this.reader.getData();
            stringArray2 = this.reader.getUnits();
            stringArray = this.reader.getParams();
            nArray = this.reader.getScales();
        }
        catch (AddeException addeException) {
            throw new VisADException("Error retrieving data info");
        }
        int n = nArray2[0].length;
        if (n == 0) {
            throw new VisADException("No data available");
        }
        if (this.debug) {
            System.out.println("Number of observations = " + n);
        }
        RealType realType = RealType.getRealType("index");
        Integer1DSet integer1DSet = new Integer1DSet((MathType)realType, n);
        MetUnits metUnits = new MetUnits();
        int n2 = stringArray.length;
        if (this.debug) {
            System.out.println("Number of parameters = " + n2);
        }
        MathType[] mathTypeArray = new ScalarType[n2];
        Unit[] unitArray = new Unit[n2];
        boolean bl = true;
        int n3 = 0;
        while (n3 < n2) {
            object = stringArray[n3];
            if (stringArray2[n3].equalsIgnoreCase("CHAR")) {
                bl = false;
                mathTypeArray[n3] = TextType.getTextType(stringArray[n3]);
            } else {
                Unit unit = null;
                try {
                    unit = !((String)object).equalsIgnoreCase("LON") ? Parser.parse(metUnits.makeSymbol(stringArray2[n3])) : Parser.parse("degrees_west");
                }
                catch (NoSuchUnitException noSuchUnitException) {
                    System.out.println("Unknown unit: " + stringArray2[n3] + " for " + (String)object);
                    unit = null;
                }
                catch (ParseException parseException) {
                    unit = null;
                }
                unitArray[n3] = unit;
                if (this.debug) {
                    System.out.println(stringArray[n3] + " has units " + unit);
                    System.out.println("scaling factor = " + nArray[n3]);
                }
                mathTypeArray[n3] = this.getQuantity(stringArray[n3], unit);
            }
            ++n3;
        }
        if (bl) {
            object = new RealType[mathTypeArray.length];
            int n4 = 0;
            while (n4 < mathTypeArray.length) {
                object[n4] = (RealType)mathTypeArray[n4];
                ++n4;
            }
            tupleType = new RealTupleType((RealType[])object);
        } else {
            tupleType = new TupleType(mathTypeArray);
        }
        object = new FunctionType(realType, tupleType);
        this.field = bl ? new FlatField((FunctionType)object, integer1DSet) : new FieldImpl((FunctionType)object, integer1DSet);
        int n5 = 0;
        while (n5 < n) {
            Data[] dataArray = bl ? new Real[n2] : new Scalar[n2];
            int n6 = 0;
            while (n6 < n2) {
                if (mathTypeArray[n6] instanceof TextType) {
                    try {
                        dataArray[n6] = new Text((TextType)mathTypeArray[n6], McIDASUtil.intBitsToString(nArray2[n6][n5]));
                    }
                    catch (VisADException visADException) {}
                } else {
                    double d = nArray2[n6][n5] == -2139062144 ? Double.NaN : (double)nArray2[n6][n5] / Math.pow(10.0, nArray[n6]);
                    try {
                        dataArray[n6] = new Real((RealType)mathTypeArray[n6], d, unitArray[n6]);
                    }
                    catch (VisADException visADException) {
                        dataArray[n6] = new Real((RealType)mathTypeArray[n6], d);
                    }
                }
                ++n6;
            }
            try {
                this.field.setSample(n5, (Data)(bl ? new RealTuple((Real[])dataArray) : new Tuple(dataArray)));
            }
            catch (VisADException visADException) {
                visADException.printStackTrace();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            ++n5;
        }
    }

    public DataImpl getData() {
        return this.field;
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.out.println("You must specify an ADDE Point Data URL");
            System.exit(-1);
        }
        try {
            PointDataAdapter pointDataAdapter = new PointDataAdapter(stringArray[0]);
            Field field = (Field)((Object)pointDataAdapter.getData());
            JPythonMethods.dumpTypes(field);
        }
        catch (VisADException visADException) {
            System.out.println("Error reading data");
        }
    }

    private RealType getQuantity(String string, Unit unit) throws VisADException {
        RealType realType = null;
        if (string.equalsIgnoreCase("lat")) {
            realType = RealType.Latitude;
        } else if (string.equalsIgnoreCase("lon")) {
            realType = RealType.Longitude;
        } else if (string.equalsIgnoreCase("z")) {
            realType = RealType.Altitude;
        } else {
            realType = RealType.getRealType(string, unit);
            if (realType == null) {
                System.err.println("Problem creating RealType with name " + string + " and unit " + unit);
                realType = RealType.getRealTypeByName(string);
                if (realType == null) {
                    throw new VisADException("getQuantity(): Couldn't create RealType for " + string);
                }
                System.err.println("Using RealType with name " + string);
            }
        }
        if (RealType.getRealTypeByName(string) == null) {
            realType.alias(string);
        } else if (!RealType.getRealTypeByName(string).equals(realType)) {
            throw new VisADException("getQuanity(): Two different variables can't have the same alias");
        }
        return realType;
    }

    public PointDataAdapter(String string) throws VisADException {
        try {
            this.reader = new AddePointDataReader(string);
            this.debug = string.indexOf("debug=true") > 0;
        }
        catch (AddeException addeException) {
            throw new VisADException("Problem accessing data");
        }
        this.makeField();
    }
}

