/*
 * Decompiled with CFR 0.152.
 */
package visad.data.mcidas;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import visad.CoordinateSystem;
import visad.data.mcidas.McIDASGridDirectory;

public class McIDASGridReader {
    ArrayList gridH = null;
    ArrayList gridD = null;
    int[] entry;
    RandomAccessFile fn;

    public ArrayList getGridData(String string) {
        try {
            this.fn = new RandomAccessFile(string, "r");
            this.fn.seek(0L);
            int[] nArray = new int[10];
            int n = 0;
            while (n < 10) {
                nArray[n] = this.fn.readInt();
                System.out.println("head=" + nArray[n]);
                ++n;
            }
            n = Math.abs(this.fn.readInt());
            System.out.println("number entries=" + n);
            this.entry = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.entry[n2] = this.fn.readInt();
                ++n2;
            }
            this.readEntry(0);
        }
        catch (Exception exception) {
            System.out.println("exp=" + exception);
        }
        return this.gridD;
    }

    private void readEntry(int n) {
        try {
            int n2 = this.entry[n] * 4;
            System.out.println("Entry 0 = " + n2);
            byte[] byArray = new byte[256];
            this.fn.seek(n2);
            this.fn.readFully(byArray);
            McIDASGridDirectory mcIDASGridDirectory = new McIDASGridDirectory(byArray);
            System.out.println("grid header =" + mcIDASGridDirectory.toString());
            CoordinateSystem coordinateSystem = mcIDASGridDirectory.getCoordinateSystem();
            int n3 = mcIDASGridDirectory.getRows();
            int n4 = mcIDASGridDirectory.getColumns();
            System.out.println("# rows & cols = " + n3 + " " + n4);
            double d = mcIDASGridDirectory.getParamScale();
            double[] dArray = new double[n3 * n4];
            boolean bl = false;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = 0;
                while (n6 < n3) {
                    int n7 = this.fn.readInt();
                    dArray[(n3 - n6 - 1) * n4 + n5] = n7 == -2139062144 ? Double.NaN : (double)n7 / d;
                    ++n6;
                }
                ++n5;
            }
            this.gridH = new ArrayList();
            this.gridD = new ArrayList();
            this.gridH.add(mcIDASGridDirectory);
            this.gridD.add(dArray);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public ArrayList getGrid(int n) {
        this.readEntry(n);
        return this.gridD;
    }

    public ArrayList getGridHeaders() {
        return this.gridH;
    }

    public static void main(String[] stringArray) {
        McIDASGridReader mcIDASGridReader = new McIDASGridReader();
        mcIDASGridReader.getGridData("/src/visad/data/mcidas/GRID1715");
    }
}

